/* fontreq.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fontreq.cc,v 1.5 2002/04/06 22:32:26 ralf Exp $ */

#include "fontreq.h"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/button.h>
#include <aguix/text.h>
#include <aguix/message.h>
#include <aguix/stringgadget.h>
#include <aguix/listview.h>
#include "locale.h"
#include <aguix/util.h>
#include <aguix/request.h>

FontRequester::FontRequester(AGUIX *parent)
{
  int nr_of_fonts=sizeof(use_fonts)/sizeof(struct request_fonts);
  struct request_fonts *font1;
  int i;
  
  aguix=parent;
  fontlist=new List();
  for(i=0;i<nr_of_fonts;i++) {
    font1=(struct request_fonts*)_allocsafe(sizeof(struct request_fonts));
    font1->name=dupstring(use_fonts[i].name);
    font1->type=use_fonts[i].type;
    font1->xname=dupstring(use_fonts[i].xname);
    font1->size=use_fonts[i].size;
    fontlist->addElement(font1);
  }
}

FontRequester::~FontRequester()
{
  struct request_fonts *font1;
  font1=(struct request_fonts*)fontlist->getFirstElement();
  while(font1!=NULL) {
    _freesafe(font1->name);
    _freesafe(font1->xname);
    _freesafe(font1);
    fontlist->removeFirstElement();
    font1=(struct request_fonts*)fontlist->getFirstElement();
  }
  delete fontlist;
}

int FontRequester::request(char *xname,char**return_xname)
{
  char *rstr;
  int act_font=0,act_fontsize=0;
  struct request_fonts *font1;
  int id;
  char buffer[4+sizeof(int)+1];
  int w,h;
  int i,ty,tw,tx,t1,t2;
  ListViewContent *tlvc,*tlvc2;
  Requester *req;
  int nr_of_sfonts=sizeof(use_fonts)/sizeof(struct request_fonts);
  int ni,nj;
  char *buttonstr;

  w=h=10;
  ty=5;
  win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(204));

  Text *ttext=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(380),1));
  ty+=ttext->getHeight()+5;
  tw=ttext->getWidth();
  if(tw>w) w=tw;

  lv=(ListView*)win->add(new ListView(aguix,
                                      5,
                                      ty,
                                      aguix->getCharWidth()*30,
                                      aguix->getCharHeight()*10,
                                      0));
  tx=5+lv->getWidth()+5;
  lv2=(ListView*)win->add(new ListView(aguix,
                                       tx,
                                       ty,
                                       aguix->getCharWidth()*6,
                                       aguix->getCharHeight()*10,
                                       1));
  ty+=lv->getHeight()+5;
  tw=lv2->getX()+lv2->getWidth()-5;
  if(tw>w) w=tw;

  etext=(Text*)win->add(new Text(aguix,10,ty,catalog.getLocale(382),1));
  ty+=etext->getHeight()+5;
  tw=etext->getWidth();
  if(tw>w) w=tw;

  text1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(383),1));
  tx=5+text1->getWidth()+5;
  ftext=(Text*)win->add(new Text(aguix,tx,ty,"",1));
  ty+=text1->getHeight()+5;
  tw=ftext->getX()+ftext->getWidth()-5;
  if(tw>w) w=tw;
  w+=10;

  tw=(strlen(catalog.getLocale(381))+2);
  tw*=aguix->getCharWidth();
  if(tw>(w-10)) w=tw+10;
  xb=(Button*)win->add(new Button(aguix,5,ty,tw,catalog.getLocale(381),1,0,0));
  ty+=xb->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
				   5,
				   ty,
				   t1,
				   catalog.getLocale(11),
				   1,
				   0,
				   0));
  cb=(Button*)win->add(new Button(aguix,
				  w-5-t2,
				  ty,
				  t2,
				  catalog.getLocale(8),
				  1,
				  0,
				  0));
  ty+=okb->getHeight()+5;

  lv->setHBarState(2);
  lv->setVBarState(2);
  lv2->setHBarState(2);
  lv2->setVBarState(2);

  if(aguix->getFont(xname)!=NULL) {
    // search for existing entry
    if(findfont(xname,&ni,&nj)==0) {
      act_font=ni;
      act_fontsize=nj;
    } else {
      // add new font
      sprintf(buffer,"font%d",fontlist->size()-nr_of_sfonts+1);
      font1=(struct request_fonts*)_allocsafe(sizeof(struct request_fonts));
      font1->name=dupstring(buffer);
      font1->type=request_fonts::FIXED;
      font1->xname=dupstring(xname);
      font1->size=-1;
      fontlist->addElement(font1);
      act_font=fontlist->size()-1;
      act_fontsize=0;
    }
  }

  id=fontlist->initEnum();
  font1=(struct request_fonts*)fontlist->getFirstElement(id);
  i=0;
  while(font1!=NULL) {
    tlvc=(ListViewContent*)lv->add(new ListViewContent(font1->name,1,1,2,2,0,0,1,1,0));
    if(i==act_font) {
      tlvc->setActive(true);
      showsizes(i);
      tlvc=lv2->get(act_fontsize);
      if(tlvc!=NULL) {
        tlvc->setActive(true);
      }
    }    
    font1=(struct request_fonts*)fontlist->getNextElement(id);
    i++;
  }
  fontlist->closeEnum(id);

  h=ty;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();

  updatefont();
  lv->showActive();
  lv2->showActive();

  req=new Requester(aguix);

  AGMessage *msg;
  int endmode=-1,pos;
  bool firstkey=true;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_LISTVIEW_ONESELECT:
        case AG_LISTVIEW_MULTISELECT:
          if(msg->listview.lv==lv) {
            tlvc=lv->getActiveLVC();
            if(tlvc!=NULL) {
              pos=lv->getPos(tlvc);
              showsizes(pos);
              updatefont();
            }
          } else if(msg->listview.lv==lv2) {
            updatefont();
          }
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
	    endmode=0;
          } else if(msg->button.button==cb) {
            endmode=1;
          } else if(msg->button.button==xb) {
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                        strlen(catalog.getLocale(8))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                      catalog.getLocale(8));
            if(req->string_request(catalog.getLocale(123),catalog.getLocale(381),"",buttonstr,&rstr)==0) {
              if(aguix->getFont(rstr)!=NULL) {
                // search for existing entry
                if(findfont(rstr,&ni,&nj)==0) {
                  tlvc=lv->get(ni);
                  if(tlvc!=NULL) {
                    tlvc->setActive(true);
                    showsizes(ni);
                    tlvc2=lv2->get(nj);
                    if(tlvc2!=NULL) {
                      tlvc2->setActive(true);
                      updatefont();
                    }
                  }
                  _freesafe(rstr);
                } else {
                  // add new font

                  sprintf(buffer,"font%d",fontlist->size()-nr_of_sfonts+1);
                  font1=(struct request_fonts*)_allocsafe(sizeof(struct request_fonts));
                  font1->name=dupstring(buffer);
                  font1->type=request_fonts::FIXED;
                  font1->xname=rstr;
                  font1->size=-1;
                  fontlist->addElement(font1);

                  tlvc=(ListViewContent*)lv->add(new ListViewContent(font1->name,1,1,2,2,0,0,1,1,0));
                  tlvc->setActive(true);
                  showsizes(fontlist->size()-1);
                  updatefont();
                }
              } else {
                req->request(catalog.getLocale(124),catalog.getLocale(365),catalog.getLocale(11));
                _freesafe(rstr);
              }
            } else _freesafe(rstr);
            _freesafe(buttonstr);
          }
          break;
	case AG_KEYRELEASED:
	  if((win->isParent(msg->key.window,false)==true)&&(firstkey==false)) {
	    // key release only accept when not first key we get
	    // means a key is pressed when we started and if we use this
	    // key it could confuse the user
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
	        endmode=0;
		break;
	      case XK_Escape:
	        endmode=1;
		break;
	    }
	  }
	  break;
        case AG_KEYPRESSED:
	  firstkey=false;
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }

  if(endmode==0) {
    endmode=1;
    tlvc=lv->getActiveLVC();
    if(tlvc!=NULL) {
      pos=lv->getPos(tlvc);
      font1=(struct request_fonts*)fontlist->getElementAt(pos);
      if(font1!=NULL) {  
        if(font1->type==request_fonts::FIXED) {
          endmode=0;
          if(return_xname!=NULL) {
            *return_xname=dupstring(font1->xname);
          }
        } else {
          tlvc=lv2->getActiveLVC();
          if(tlvc!=NULL) nj=lv2->getPos(tlvc);
          else nj=0;
          if(return_xname!=NULL) {
            rstr=(char*)_allocsafe(strlen(font1->xname)+sizeof(int)+1);
            sprintf(rstr,font1->xname,getsize(pos,nj));
            *return_xname=rstr;
          }
          endmode=0;
        }
      }
    }
  }

  win->close();
  delete win;
  
  delete req;
  
  return endmode;
}

void FontRequester::showsizes(int i)
{
  ListViewContent *tlvc,*flvc=NULL;
  char buffer[sizeof(int)+1];
  int j,oj;
  struct request_fonts *font1;

  font1=(struct request_fonts*)fontlist->getElementAt(i);
  if(font1!=NULL) {  
    if(font1->type==request_fonts::FIXED) {
      lv2->setSize(1);
      lv2->finish();
      tlvc=lv2->get(0);
      sprintf(buffer,"%d",font1->size);
      tlvc->setText(buffer);
      tlvc->setFG(0,1);
      tlvc->setFG(1,1);
      tlvc->setFG(2,2);
      tlvc->setFG(3,2);
      tlvc->setBG(0,0);
      tlvc->setBG(1,0);
      tlvc->setBG(2,1);
      tlvc->setBG(3,1);
      tlvc->setActive(true);
    } else {
      tlvc=lv2->getActiveLVC();
      if(tlvc!=NULL) oj=lv2->getPos(tlvc);
      else oj=0;
      lv2->setSize(FONTREQ_STEPS);
      lv2->finish();
      for(j=0;j<FONTREQ_STEPS;j++) {
        tlvc=lv2->get(j);
        sprintf(buffer,"%d",getsize(i,j));
        tlvc->setText(buffer);
        tlvc->setFG(0,1);
        tlvc->setFG(1,1);
        tlvc->setFG(2,2);
        tlvc->setFG(3,2);
        tlvc->setBG(0,0);
        tlvc->setBG(1,0);
        tlvc->setBG(2,1);
        tlvc->setBG(3,1);
        
        if(j==0) flvc=tlvc;
        else if(j==oj) flvc=tlvc;
      }
      if(flvc!=NULL) flvc->setActive(true);
    }
  }
}

void FontRequester::updatefont()
{
  ListViewContent *tlvc;
  int i,j,nw,nh,ty,tw,ow,oh;
  char *tstr,*buffer;
  struct request_fonts *font1;
  
  tlvc=lv->getActiveLVC();
  if(tlvc!=NULL) {
    i=lv->getPos(tlvc);
    tlvc=lv2->getActiveLVC();
    if(tlvc!=NULL) {
      j=lv2->getPos(tlvc);

      font1=(struct request_fonts*)fontlist->getElementAt(i);
      if(font1!=NULL) {  
        tstr=font1->xname;
        if(font1->type==request_fonts::SCALEABLE) {
          buffer=(char*)_allocsafe(strlen(tstr)+sizeof(int)+1);
          sprintf(buffer,tstr,getsize(i,j));
          etext->setFont(buffer);
          etext->redraw();
          ftext->setText(buffer);
          _freesafe(buffer);
        } else {
          etext->setFont(tstr);
          etext->redraw();
          ftext->setText(tstr);
        }
        
        // now resize the window if needed
        ty=etext->getY()+etext->getHeight()+5;
        ty+=ftext->getHeight()+5;
        ty+=xb->getHeight()+5;
        ty+=okb->getHeight()+5;
        
        nw=lv2->getX()+lv2->getWidth()+5;
        tw=etext->getX()+etext->getWidth()+5;
        if(tw>nw) nw=tw;
        tw=ftext->getX()+ftext->getWidth()+5;
        if(tw>nw) nw=tw;
  
        nh=ty;
        ow=win->getWidth();
        oh=win->getHeight();
        if((nw>ow)||(nh>oh)) {
          nw=a_max(nw,ow);
          nh=a_max(nh,oh);
  
          okb->move(okb->getX(),nh-5-okb->getHeight());
          cb->move(nw-5-cb->getWidth(),nh-5-okb->getHeight());
  
          xb->resize(nw-10,xb->getHeight());
          xb->move(xb->getX(),okb->getY()-5-xb->getHeight());
  
          text1->move(text1->getX(),xb->getY()-5-text1->getHeight());
          ftext->move(ftext->getX(),xb->getY()-5-text1->getHeight());
  
          win->resize(nw,nh);
        }
      }
    }
  }
}

int FontRequester::getsize(int i,int j)
{
  return FONTREQ_MINSIZE+FONTREQ_STEPSIZE*j;
}

int FontRequester::findfont(const char *xn,int *return_i, int *return_j)
{
  struct request_fonts *font1;
  int id;
  char *tstr,*buffer;
  bool found=false;
  int i=0,j=0;
  
  id=fontlist->initEnum();
  
  font1=(struct request_fonts*)fontlist->getFirstElement(id);
  i=0;
  while(font1!=NULL) {  
    tstr=font1->xname;
    if(font1->type==request_fonts::SCALEABLE) {
      buffer=(char*)_allocsafe(strlen(tstr)+sizeof(int)+1);

      for(j=0;j<FONTREQ_STEPS;j++) {
        sprintf(buffer,tstr,getsize(i,j));
        if(strcmp(buffer,xn)==0) {
          found=true;
          break;
        }
      }

      _freesafe(buffer);
      if(found==true) break;
    } else {
      if(strcmp(tstr,xn)==0) {
        found=true;
        j=0;
        break;
      }
    }
    font1=(struct request_fonts*)fontlist->getNextElement(id);
    i++;
  }
  fontlist->closeEnum(id);
  if(found==true) {
    *return_i=i;
    *return_j=j;
    return 0;
  } else return -1;
}

