/* wconfig.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wconfig.h,v 1.28 2002/02/28 00:05:59 ralf Exp $ */

#ifndef WCONFIG_H
#define WCONFIG_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/stringgadget.h>
#include <aguix/bevelbox.h>
#include <aguix/listview.h>
#include <aguix/solidbutton.h>
#include <aguix/choosebutton.h>
#include <aguix/cyclebutton.h>
#include "locale.h"
#include "functionproto.h"
#include "datei.h"

class Worker;
class WCPath;
class WCHotkey;
class WCButton;
class WCFiletype;
class WCGlobalFlags;

class WC_Color
{
public:
  WC_Color();
  WC_Color(int,int,int);
  WC_Color *duplicate();
  void save(Datei*);
  bool load(Datei *);
  int red,green,blue;
};

class WCShortkey
{
public:
  WCShortkey();
  ~WCShortkey();
  WCShortkey *duplicate();
  void setShortkey(KeySym);
  void setMod(unsigned int);
  KeySym getShortkey();
  unsigned int getMod();
  bool isShortkey(KeySym,unsigned int);
  bool save(Datei*);
  bool load(Datei*);
  bool isReal();
protected:
  KeySym shortkey;
  unsigned int mod;
};

class WConfig
{
public:
  typedef enum {CLOCKBAR_MODE_TIMERAM=0,CLOCKBAR_MODE_TIME,CLOCKBAR_MODE_VERSION,CLOCKBAR_MODE_EXTERN} clockbar_mode_t;

  WConfig(Worker *);
  ~WConfig();
  WConfig *duplicate();
  void setLang(char*);
  void setTerminalBin(const char*);
  void setRows(unsigned int);
  void setColumns(unsigned int);
  void setCacheSize(unsigned int);
  void setHBarTop(int,bool);
  void setVBarLeft(int,bool);
  void setHBarHeight(int,unsigned int);
  void setVBarWidth(int,unsigned int);
  void setDisplay(int,int*);
  char *getLang();
  char *getTerminalBin();
  unsigned int getRows();
  unsigned int getColumns();
  unsigned int getCacheSize();
  bool getHBarTop(int);
  bool getVBarLeft(int);
  unsigned int getHBarHeight(int);
  unsigned int getVBarWidth(int);
  int *getDisplay(int);
  void setStatusbar(int,int);
  void setSelLVB(int,int);
  void setUnselLVB(int,int);
  void setSelDir(int,int);
  void setUnselDir(int,int);
  void setSelFile(int,int);
  void setUnselFile(int,int);
  void setSelDirAct(int,int);
  void setUnselDirAct(int,int);
  void setSelFileAct(int,int);
  void setUnselFileAct(int,int);
  void setClockbar(int,int);
  void setRequest(int,int);
  int getStatusbar(int);
  int getSelLVB(int);
  int getUnselLVB(int);
  int getSelDir(int);
  int getUnselDir(int);
  int getSelFile(int);
  int getUnselFile(int);
  int getSelDirAct(int);
  int getUnselDirAct(int);
  int getSelFileAct(int);
  int getUnselFileAct(int);
  int getClockbar(int);
  int getRequest(int);
  void setStartDir(int,const char*);
  char *getStartDir(int);
  void setFont(int,const char*);
  char *getFont(int);
  void setPaths(List*);
  List *getPaths();
  void setFiletypes(List*);
  List *getFiletypes();
  void setHotkeys(List*);
  List *getHotkeys();
  void setButtons(List*);
  List *getButtons();
  void setColors(List*);
  List *getColors();
  void cleanUpPaths();
  void cleanUpButtons();
  void setOwnerstringtype(int);
  int getOwnerstringtype();
  void setClockbarMode(clockbar_mode_t);
  clockbar_mode_t getClockbarMode();
  void setClockbarUpdatetime(int);
  int getClockbarUpdatetime();
  void setClockbarCommand(const char *);
  const char *getClockbarCommand();
  void setDontCheckDirs(List*);
  List *getDontCheckDirs();
  void setShowStringForDirSize(bool nv);
  bool getShowStringForDirSize();
  void setStringForDirSize(const char *nv);
  const char *getStringForDirSize();

  void applyColorList(List *);

  bool configure();
  int palette();
  int palette(int);
  bool save();
  bool saveas(char*);
  bool load();
  bool loadfrom(char*);
  int getMaxFiletypeLen();
  
  const char *getHome();
  WCFiletype *getnotyettype();
  WCFiletype *getdirtype();
  void applyLanguage();
  
  int savesize(int w,int h);
  int loadsize(int *w,int *h);
  
  const char *getTerminalStr();
  void setListerBG(int);
  int getListerBG();
  int getStringForDirSizeLen();

  void setDateFormat( int nv );
  int getDateFormat();
  void setDateFormatString( const char *nv );
  const char *getDateFormatString();
  void setDateSubst( bool nv );
  bool getDateSubst();
  void setTimeFormat( int nv );
  int getTimeFormat();
  void setTimeFormatString( const char *nv );
  const char *getTimeFormatString();
  void setDateBeforeTime( bool nv );
  bool getDateBeforeTime();

  int getDatelen( const struct tm *timeptr );
  int writeDateToString( char *buf, int maxlen, struct tm *timeptr );
protected:
  char *lang;
  unsigned int rows,columns;
  unsigned int cachesize;
  List *colors;
  bool hbar_top[2];
  bool vbar_left[2];
  unsigned int hbar_height[2];
  unsigned int vbar_width[2];
  int display[2][9];   /* Name,Size,Type,Perm,Owner,Dest,Mod,Acc,Change */
  int statusbar[2];
  int sel_lvb[2];
  int unsel_lvb[2];
  int sel_dir[2];
  int unsel_dir[2];
  int sel_file[2];
  int unsel_file[2];
  int sel_dir_act[2];
  int unsel_dir_act[2];
  int sel_file_act[2];
  int unsel_file_act[2];
  int clockbar[2];
  int request[2];
  char *dir[2];  // left=0, right=1
  char *fonts[4];  // global, buttons, left lister, right lister
  List *paths;  // Elemente sind WCPath
  List *filetypes; // Elemente sind WCFiletype
  List *hotkeys; // Elemente sind WCHotkey
  List *buttons; // Elemente sind WCButton
  clockbar_mode_t clockbar_mode;
  int clockbar_updatetime;
  char *clockbar_command;
  List *dontcheckdirs;
  
  char *terminalbin;
  
  int ownerstringtype;
  
  bool showStringForDirSize;
  char *stringForDirSize;
  int stringForDirSizeLen;
  
  int maxfiletypelen;
  #define NORMALTYPE 0
  #define NOTYETTYPE 1
  #define UNKNOWNTYPE 2
  #define VOIDTYPE 3
  #define DIRTYPE 4
  WCFiletype *notyettype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *dirtype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  
  char *home;
  Worker *worker;

  bool changeTypes();
  bool changeTypes(bool onlyFiletypes);
  bool changeTypes( bool onlyFiletypes, bool allowRemoveUnique );
  bool changeHotkeys();
  bool changeFont();
  bool changeGlobal();
  bool changeColorDefs();
  bool changeStartup();
  bool changeButtons();
  bool changePaths();
  bool changePalette();
  bool changeLanguage();
  bool changeFileSets();
  bool changeDisplaySets(int);
  bool changeClockbarSets();
  void showPathBank(int,Button**);
  void showButtonBank(int,Button*[][2]);
  
  bool configurePath(WCPath*);
  int getShortkey(const WCShortkey *ignore_sk, WCShortkey **return_sk);
  bool configureHotkey(WCHotkey*);
  FunctionProto *requestCommand();
  static int requestCommand_sf(void*,void*);

  bool configureButton(WCButton*);
  bool configureFiletype(WCFiletype*);
  void showFTActions(char*,WCFiletype*,ListView*,ListView*,List**,WCGlobalFlags**);
  void applyGlobalFlags(ListView *,WCGlobalFlags *);
  bool changeFiledesc(WCFiletype*);
  char *getStr4Char(int,short);
  int WCEditByte(int ch);
  bool FTautocreate(WCFiletype *);
  void recalcMaxFiletypeLen();
  void initFixTypes(List*);
  void setDefaultConfig();
  int configureDCD(List *);

  // for loading the old config
  int parseChunk(Datei *fp);
  int read1Config(Datei *fp);
  void getFunctionProtoOldStyle(const unsigned long comnr,
                                const unsigned long flag1,
                                const unsigned long flag2,
                                const char *usercomstr,
                                List *l2);
  void changeRS(const char *,char **);
  bool showOldRequest;
  
  int findShortkey(WCShortkey*,WCButton**,WCPath**,WCHotkey**);
  static bool isCorrectTerminalBin(const char*);
  int listerbg;
  
  int cfg_export();
  int im_export();
  int export2file( bool export_buttons,
                   bool export_hotkeys,
                   bool export_types,
                   const char *filename );
  int cfg_import1();
  int cfg_import2( const char *filename );
  int cfg_import3( WConfig *importconfig, int nrb );
  int cfg_import4( WConfig *importconfig, bool apply_b, bool apply_h, bool apply_f );
  
  int date_format;  // -1 = user-defined
                    // >=0 any of the predefined
  char *date_formatstring;
  bool date_subst;
  
  int time_format; // as above
  char *time_formatstring;
  
  bool date_before_time;
  int configureDateTime();
};

class WCPath
{
public:
  WCPath();
  ~WCPath();
  WCPath *duplicate();
  void setName(const char*);
  void setFG(int);
  void setBG(int);
  void setPath(const char*);
  char *getName();
  int getFG();
  int getBG();
  char *getPath();
  WCShortkey *getKey();
  void setKey(WCShortkey*);
  void setCheck(bool);
  bool getCheck();
  bool configure(AGUIX*);
  bool save(Datei*);
  bool load(Worker*,Datei*);
protected:
  char *name;
  int fg,bg;
  char *path;
  WCShortkey *key;
  bool check;
};

class WCGlobalFlags
{
public:
  WCGlobalFlags();
  ~WCGlobalFlags();
  WCGlobalFlags *duplicate();
  unsigned long getFlags();
  void setFlags(unsigned long);
  bool save(Datei*);
  bool load(Datei*);

  static List* getNameOfFlags();
  static void freeNameOfFlags(List*);
protected:
  unsigned long flags;
};

class WCFiletype
{
public:
  WCFiletype();
  ~WCFiletype();
  WCFiletype *duplicate();
  void setName(const char*);
  void setPattern(const char*);
  void setUsePattern(bool);
  void setFiledesc(short*);
  void setUseFiledesc(bool);
  char *getName();
  char *getPattern();
  bool getUsePattern();
  short *getFiledesc();
  bool getUseFiledesc();
  List *getDNDActions();
  List *getDoubleClickActions();
  List *getShowActions();
  List *getRawShowActions();
  List *getUserActions(int);
  void setDNDActions(List*);
  void setDoubleClickActions(List*);
  void setShowActions(List*);
  void setRawShowActions(List*);
  void setUserActions(int,List*);
  WCGlobalFlags *getDNDActionsGF();
  WCGlobalFlags *getDoubleClickActionsGF();
  WCGlobalFlags *getShowActionsGF();
  WCGlobalFlags *getRawShowActionsGF();
  WCGlobalFlags *getUserActionsGF(int);
  void setDNDActionsGF(WCGlobalFlags*);
  void setDoubleClickActionsGF(WCGlobalFlags*);
  void setShowActionsGF(WCGlobalFlags*);
  void setRawShowActionsGF(WCGlobalFlags*);
  void setUserActionsGF(int,WCGlobalFlags*);
  bool save(Datei*);
  bool load(Worker*,Datei*);
  int getinternID();
  void setinternID(int);
  int getNameLen();

  void setFileExp( const char* );
  const char *getFileExp();
  void setUseFileExp( bool );
  bool getUseFileExp();
  bool fileExpMatchString( const char * );
protected:
  char *name;
  char *pattern;
  bool usepattern;
  short filedesc[64];  // 0-255 ASCII-Code, -1 dont care, -2 end
  bool usefiledesc;
  List *dndaction;
  WCGlobalFlags *dndactiongf;
  List *doubleclickaction;
  WCGlobalFlags *doubleclickactiongf;
  List *showaction;
  WCGlobalFlags *showactiongf;
  List *rawshowaction;
  WCGlobalFlags *rawshowactiongf;
  List *useraction[10];
  WCGlobalFlags *useractiongf[10];
  int internID;
  int namelen;
  
  bool usefileexp;
  char *fileexp;

#if 0  // for filetype checking with file
  regex_t preg;
  bool regex_compiled;
  void free_compexp();
  void compile_exp();
#endif
};

class WCHotkey
{
public:
  WCHotkey();
  ~WCHotkey();
  WCHotkey *duplicate();
  void setName(const char*);
  char *getName();
  WCShortkey *getKey();
  List *getComs();
  void setKey(WCShortkey*);
  void setComs(List*);
  WCGlobalFlags *getComsGF();
  void setComsGF(WCGlobalFlags*);
  bool save(Datei*);
  bool load(Worker*,Datei*);
protected:
  char *name;
  WCShortkey *key;
  List *com;
  WCGlobalFlags *flags;
};

class WCButton
{
public:
  WCButton();
  ~WCButton();
  WCButton *duplicate();
  void setText(const char*);
  void setFG(int);
  void setBG(int);
  char *getText();
  int getFG();
  int getBG();
  WCShortkey *getKey();
  void setKey(WCShortkey*);
  List *getComs();
  void setComs(List*);
  void setCheck(bool);
  bool getCheck();
  WCGlobalFlags *getComsGF();
  void setComsGF(WCGlobalFlags*);
  bool save(Datei*);
  bool load(Worker*,Datei*);
protected:
  char *text;
  int fg,bg;
  WCShortkey *key;
  List *com;
  WCGlobalFlags *flags;
  bool check;
};

void freecoms(List*);

extern WConfig *wconfig;

#endif

