/* fieldlistviewdnd.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fieldlistviewdnd.h,v 1.1 2002/03/09 00:13:34 ralf Exp $ */

#ifndef FIELDLISTVIEWDND_H
#define FIELDLISTVIEWDND_H

#include "aguixdefs.h"
#include "fieldlistview.h"

class FieldListViewDND:public FieldListView
{
public:
  FieldListViewDND( AGUIX *aguix, int x, int y, int width, int height, int data );
  virtual ~FieldListViewDND();
  virtual const char *getType();
  virtual bool isType(const char *type);
  void removealldndtexts();
  void removedndtextat(int);
  void replacedndtext(int,char*);
  void insertdndtext(int,char*);
  void adddndtext(char*);
  
  void setSizeDNDText(int);
private:
  static const char *type;
  virtual void handleSelect(Message *msg);
  ArrayList *dndtexts;
};

#endif
