/* button.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: button.h,v 1.6 2002/01/29 00:51:53 ralf Exp $ */

#ifndef BUTTON_H
#define BUTTON_H

#include "aguixdefs.h"
#include "guielement.h"

class AWindow;
class AGUIXFont;

class Button:public GUIElement {
public:
  Button(AGUIX *aguix);
  Button(AGUIX *aguix,int x,int y,int width,
         const char *text,int fg,int bg,int data);
  Button(AGUIX *aguix,int x,int y,
         const char *text,int fg,int bg,int data);
  Button(AGUIX *aguix,int x,int y,int width,int height,
         const char *text,int fg,int bg,int data);
  Button(AGUIX *aguix,int x,int y,int width,
         const char *text_normal,const char *text_high,
         int fg_normal,int fg_high,
         int bg_normal,int bg_high,int data);
  virtual ~Button();
  const char *getText(int);
  void setText(int,const char *);
  bool getDualState();
  void setDualState(bool);
  void setFG(int,int);
  int getFG(int);
  void setBG(int,int);
  int getBG(int);
  int getData();
  void setData(int);
  void setState(int);
  int getState();
  virtual void redraw();
  virtual void flush();
  bool isInside(int x,int y);
  virtual bool handleMessage(XEvent *E,Message *msg);
  bool getShowDual();
  void setShowDual(bool);
  int setFont(char*);
  virtual const char *getType();
  virtual bool isType(const char *type);

  void deactivate();
  void activate();
  void deactivate(int mode);
  void activate(int mode);
private:
  char *text[2];
  int fg[2];
  int bg[2];
  int lastbg;
  bool dual;
  int data;
  int state;
  int instate;
  bool showdual;
  AGUIXFont *font;
  bool active[2];

  static const char *type;
};

#endif
