
#include "wizard_manager.h"
#include "wizard_babylon.h"
#include "intern.h"

WizardManager::WizardManager() {
	babylon_wizard = new WizardBabylon();

	connect(babylon_wizard, SIGNAL(message(const QString&)),
            this, SLOT(slot_message(const QString&)) );
}

WizardManager::~WizardManager() {
	delete babylon_wizard;
}

DiccionarioBase * WizardManager::examine(const QString& file) {
	DiccionarioBase *dic = babylon_wizard->examine(file);

	if (dic==0) emit result( _("<b>Sorry, all tests failed.</b>") );
	return dic;
}

void WizardManager::slot_message(const QString & mensaje) {
	//qDebug("slot_message: %s", mensaje.latin1());
	emit message(mensaje);
}

#include "wizard_manager.moc.cpp"

