#!/usr/bin/python

#
# Interface class (and dummy interface) for woody.
#

############################################################
# Interface class:
#
# All woody interfaces should inherit from this, and override
# the functions defined with their own...
#
def is_iface(obj):
  return hasattr(obj,'is_iface') and obj.is_iface

class iface:
  is_iface = 1


  #
  # Each interface must provide the following:
  #

  # - init: should create windows, set colors, etc...
  def __init__(self, cfg):
    pass

  # - introduction screen function
  def intro(self, text):
    pass

  # - handles pretty much all user interaction
  def main_loop(self, cfg, wood):
    pass

  # - Shows a message and waits for a keypress
  def message(self, text):
    pass

  # - Shows a message but returns immediately
  def note(self, text):
    pass

  # - Ask the user a question...
  def dialog_box(self, title, text, buttons, default):
    pass

  # - shutdown: should restore screen state, etc..
  def shutdown(self):
    pass

  def callback(self, what, data):
    pass
