#!/bin/sh -e
# $Id: autogen.sh,v 1.6 2006/04/16 08:03:55 godisch Exp $
#
# Copyright (c) 2002-2006 Martin A. Godisch <martin@godisch.de>

test -e wmpuzzle.c
umask 022
aclocal
autoheader -Wall
autoconf -Wall
./configure
make distclean
rm -rf autom4te.cache
cd ..
chmod -R go=u-w .
version="`pwd`"
version="${version##*-}"
tarname="wmpuzzle-${version}.tar.gz"
cd ..
fakeroot tar cvzf $tarname --exclude CVS --exclude .cvsignore --exclude debian wmpuzzle-$version
ln -sf $tarname wmpuzzle_$version.orig.tar.gz
echo -n "Sign $tarname? [y/N] "
read sign
if test "$sign" = y; then
	gpg -ab $tarname
else
	echo "No."
fi
cd wmpuzzle-$version
if ! grep -iq "AC_INIT.*[${version}]" src/configure.ac; then
	echo "*** WARNING: version in configure.ac out of date  ***"
fi
if grep -iq "not yet released" CHANGES; then
	echo "*** WARNING: release date in CHANGES file missing ***"
fi
