// This module is used by wiplc.
//
// As input it is given
//   * The user suplied expressions for each colum
//   * Each ServerMem structure read from wipld
// As output it gives:
//   * The value of all the colums that should be displayed.
//     (excluding colums with IP and MAC adresses, though).
//
// It works internally only with floating point numbers.
//
// Terminologi:
//   A server colum is one maintained by wipld in a ServerMem area
//   A client colum is a colum displayed by wiplc.
//   The sets of server and client colums are disjoint.

class ValueServer;
class FloatExpr;

// Currently only one instance of this class may exists.
class WiplcExpr {
  public:
  // All these are private to this module:
  
  // From wipld:
  int maxcardc; 
  int servercolc;
  card_id_type cit;  
  int cardcntc;
    
  // Other data:
  int clientcolc,totalcolc; // Information about number of colums 
  ValueServer* vs;          // All data is stored here
  int timebackdep;          // Parameter to constructor.
  
  static WiplcExpr* instance; // Current instance of this class or 0
                              // The user should not modify this variabel
  
  // This array contains expressions for the client colums.
  // Before noMoreExpressions is called it is indexed by colum number
  // After noMoreExpressions is called it has the expressions in the
  // order they should be evaluated and are 0-terminated.
  FloatExpr** colums; 
  
  // After noMoreExpressions is called this is columnums[i] is the colum number
  // corrosponding to the expression colums[i].
  int* colnums;
  
  public:  
  // Interface to this module:

  // Initializes. Se below for timebackdep
  WiplcExpr(int clientcols,int servercols,  // Colum information
            int maxcardc, card_id_type cit, // From daemon
	    int timebackdep                 // Se below.
	    );            
  ~WiplcExpr();
  
  // Sets the expression corresponding to a given client colum.
  // It is not neccesarry to set an expression for every client colum.
  // Returns an error message or 0.
  char* setExpression(int colum, char* program);
  
  // When finished calling setExpression this one should be called.
  // Returns 0 or an error message (i.e. on cyclic references).
  char* noMoreExpressions();
  
  // This should be called for every new ServerMem object we read:
  void nextIteration(const ServerMem*, Time t);
  
  // After calling nextIteration this should be called - it will
  // evaluate all the expressions:
  void updateValues();
  
  // All the following might change after each call to updateValues:
  
  // This function return the time it was a given number of iterations
  // back. The argument can be as big as the timebackdep parameter given
  // to the constructor.
  Time getTimeBack(int);
  
  // The following are used to retreview the information about the values
  // that should be displayed:
  const double* getColum(int n); // Returns the nth colum
  const mac_addr* getMacColum(); // Returns the colum with MAC adresses
  const ip_addr*  getIpColum();  // Returns the comlum of IP adresses
};
