if {[catch {package require Tcl 8.3} ErrMsg]} {
  error "Unable to load Tcl package: $ErrMsg"
}

if {[catch {package require Tk 8.3} ErrMsg]} {
  error "Unable to load Tk package: $ErrMsg"
}

if {[catch {package require Itcl 3.1} ErrMsg]} {
  error "Unable to load Itcl package: $ErrMsg"
}

if {[catch {package require Itk 3.1} ErrMsg]} {
  error "Unable to load Itk package: $ErrMsg"
}
namespace import -force itcl::*

if {[catch {package require Iwidgets 3.1} ErrMsg]} {
  error "Unable to load Iwidgets package: $ErrMsg"
}

# ------------------------------------------------------------------------
# There's bug in the _display() method of iwidgets::feedback widget.
# Border width cannot be considered.
# ------------------------------------------------------------------------
namespace eval iwidgets::Feedback {
  body iwidgets::Feedback::_display {} {
    set troughwidth [winfo width $itk_component(trough)]

    # FIX
    incr troughwidth -[expr [$itk_component(trough) cget -borderwidth] * 2]

    set _barwidth [expr $troughwidth.0/$itk_option(-steps)]
    set fraction [expr int((1.0*$_stepval)/$itk_option(-steps)*100.0)]

    $itk_component(percentage) config -text "$fraction%"
    $itk_component(bar) config -width [expr $_barwidth*$_stepval]

    # we don't want this update, it causes problems when positioning dialog
    # windows
    #update
  }
}

##################################
# set some variables we depend on
##################################
set ::gFontFixed "Fixed -13"
set ::gFontProp "Helvetica -12"

# tmp directory
set ::gTmpDir ""
if {[info exists ::env(TMPDIR)]} {
  set ::gTmpDir "$::env(TMPDIR)"
}
if {$::gTmpDir == ""} {
  set ::gTmpDir "/tmp"
}

# home
if {[info exists ::env(HOME)] && [file readable $::env(HOME)]} {
  set ::gHome $::env(HOME)
} else {
  set ::gHome /
}

# whoami
if {[catch {exec whoami} Tmp]} {
  set Tmp unknown_user
}
set ::gWhoami $Tmp


###########################################################################

namespace eval ::cwdialog {
  namespace export *

  variable ngLibPath [file dirname [info script]]
  variable ngLibVersion 0.1.0
  variable ngLibDataDir $ngLibPath/data

  variable ngWineFakeWinRoot $::env(HOME)/.wine/fake_windows
}

lappend auto_path [file join $cwdialog::ngLibPath scripts]
package provide Cwdialog $cwdialog::ngLibVersion
