/*
 *  Output sequence map for rtf2text
 * 
 *  Field 1 is the standard character name.  Field 2 is the output sequence
 *  to produce for that character.
 * 
 *  The output sequence is simply a string of characters.  If it contains
 *  whitespace, it may be quoted.  If it contains quotes, it may be quoted
 *  with a different quote character.
 * 
 *  characters in ASCII range (32-127
 */

char *text_map[] = {
  "space"	      ," ",
  "exclam"	      ,"!",
  "quotedbl"	      ,"\"",
  "numbersign"        ,"#",
  "dollar"	      ,"$",
  "percent"	      ,"%",
  "ampersand"	      ,"&",
  "quoteright"        ,"'",
  "parenleft"	      ,"(",
  "parenright"        ,")",
  "asterisk"	      ,"*",
  "plus"	      ,"+",
  "comma"	      ,",",
  "hyphen"	      ,"-",
  "period"	      ,".",
  "slash"	      ,"/",
  "zero"	      ,"0",
  "one" 	      ,"1",
  "two" 	      ,"2",
  "three"	      ,"3",
  "four"	      ,"4",
  "five"	      ,"5",
  "six" 	      ,"6",
  "seven"	      ,"7",
  "eight"	      ,"8",
  "nine"	      ,"9",
  "colon"	      ,":",
  "semicolon"	      ,";",
  "less"	      ,"<",
  "equal"	      ,"=",
  "greater"	      ,">",
  "question"	      ,"?",
  "at"  	      ,"@",
  "A"		      ,"A",
  "B"		      ,"B",
  "C"		      ,"C",
  "D"		      ,"D",
  "E"		      ,"E",
  "F"		      ,"F",
  "G"		      ,"G",
  "H"		      ,"H",
  "I"		      ,"I",
  "J"		      ,"J",
  "K"		      ,"K",
  "L"		      ,"L",
  "M"		      ,"M",
  "N"		      ,"N",
  "O"		      ,"O",
  "P"		      ,"P",
  "Q"		      ,"Q",
  "R"		      ,"R",
  "S"		      ,"S",
  "T"		      ,"T",
  "U"		      ,"U",
  "V"		      ,"V",
  "W"		      ,"W",
  "X"		      ,"X",
  "Y"		      ,"Y",
  "Z"		      ,"Z",
  "bracketleft"       ,"[",
  "backslash"	      ,"\\",
  "bracketright"      ,"]",
  "asciicircum"       ,"^",
  "underscore"        ,"_",
  "quoteleft"	      ,"`",
  "a"		      ,"a",
  "b"		      ,"b",
  "c"		      ,"c",
  "d"		      ,"d",
  "e"		      ,"e",
  "f"		      ,"f",
  "g"		      ,"g",
  "h"		      ,"h",
  "i"		      ,"i",
  "j"		      ,"j",
  "k"		      ,"k",
  "l"		      ,"l",
  "m"		      ,"m",
  "n"		      ,"n",
  "o"		      ,"o",
  "p"		      ,"p",
  "q"		      ,"q",
  "r"		      ,"r",
  "s"		      ,"s",
  "t"		      ,"t",
  "u"		      ,"u",
  "v"		      ,"v",
  "w"		      ,"w",
  "x"		      ,"x",
  "y"		      ,"y",
  "z"		      ,"z",
  "braceleft"	      ,"{",
  "bar" 	      ,"|",
  "braceright"        ,"}",
  "asciitilde"        ,"~",
  "AE"  	      ,"AE",
  "OE"  	      ,"OE",
  "acute"	      ,"'",
  "ae"  	      ,"ae",
  "angleleft"	      ,"<",
  "angleright"        ,">",
  "arrowboth"	      ,"<->",
  "arrowdblboth"      ,"<=>",
  "arrowdblleft"      ,"<=",
  "arrowdblright"     ,"=>",
  "arrowleft"	      ,"<-",
  "arrowright"        ,"->",
  "bullet"	      ,"o",
  "cent"	      ,"cent",
  "circumflex"        ,"^",
  "copyright"	      ,"(c)",
  "copyrightsans"     ,"(c)",
  "degree"	      ,"deg.",
  "divide"	      ,"/",
  "dotlessi"	      ,"i",
  "ellipsis"	      ,"...",
  "emdash"	      ,"--",
  "endash"	      ,"-",
  "fi"  	      ,"fi",
  "fl"  	      ,"fl",
  "fraction"	      ,"/",
  "germandbls"        ,"ss",
  "grave"	      ,"`",
  "greaterequal"      ,">=",
  "guillemotleft"     ,"<<",
  "guillemotright"    ,">>",
  "guilsinglleft"     ,"<",
  "guilsinglright"    ,">",
  "lessequal"	      ,"<=",
  "logicalnot"        ,"~",
  "mathasterisk"      ,"*",
  "mathequal"	      ,"=",
  "mathminus"	      ,"-",
  "mathnumbersign"    ,"#",
  "mathplus"	      ,"+",
  "mathtilde"	      ,"~",
  "minus"	      ,"-",
  "mu"  	      ,"u",
  "multiply"	      ,"x",
  "nobrkhyphen"       ,"-",
  "nobrkspace"        ," ",
  "notequal"	      ,"!=",
  "oe"  	      ,"oe",
  "onehalf"	      ,"1/2",
  "onequarter"        ,"1/4",
  "periodcentered"    ,".",
  "plusminus"	      ,"+/-",
  "quotedblbase"      ,",,",
  "quotedblleft"      ,"\"",
  "quotedblright"     ,"\"",
  "quotesinglbase"    ,",",
  "registered"        ,"reg.",
  "registersans"      ,"reg.",
  "threequarters"     ,"3/4",
  "tilde"	      ,"~",
  "trademark"	      ,"(TM)",
  "trademarksans"     ,"(TM)"
};
