/* File generated automatically from tools/winapi/tests.dat; do not edit! */
/* This file can be copied, modified and distributed without restriction. */

/*
 * Unit tests for data structure packing
 */

#define WINVER 0x0501
#define _WIN32_IE 0x0501
#define _WIN32_WINNT 0x0501

#define WINE_NOWINSOCK

#include "ntdll_test.h"

#include "wine/test.h"

/***********************************************************************
 * Compatibility macros
 */

#define DWORD_PTR UINT_PTR
#define LONG_PTR INT_PTR
#define ULONG_PTR UINT_PTR

/***********************************************************************
 * Windows API extension
 */

#if defined(_MSC_VER) && (_MSC_VER >= 1300) && defined(__cplusplus)
# define _TYPE_ALIGNMENT(type) __alignof(type)
#elif defined(__GNUC__)
# define _TYPE_ALIGNMENT(type) __alignof__(type)
#else
/*
 * FIXME: May not be possible without a compiler extension
 *        (if type is not just a name that is, otherwise the normal
 *         TYPE_ALIGNMENT can be used)
 */
#endif

#if defined(TYPE_ALIGNMENT) && defined(_MSC_VER) && _MSC_VER >= 800 && !defined(__cplusplus)
#pragma warning(disable:4116)
#endif

#if !defined(TYPE_ALIGNMENT) && defined(_TYPE_ALIGNMENT)
# define TYPE_ALIGNMENT _TYPE_ALIGNMENT
#endif

/***********************************************************************
 * Test helper macros
 */

#define TEST_TYPE_SIZE(type, size)             C_ASSERT(sizeof(type) == size);

#ifdef TYPE_ALIGNMENT
# define TEST_TYPE_ALIGN(type, align)          C_ASSERT(TYPE_ALIGNMENT(type) == align);
#else
# define TEST_TYPE_ALIGN(type, align)
#endif

#ifdef _TYPE_ALIGNMENT
# define TEST_TARGET_ALIGN(type, align)        C_ASSERT(_TYPE_ALIGNMENT(*(type)0) == align);
# define TEST_FIELD_ALIGN(type, field, align)  C_ASSERT(_TYPE_ALIGNMENT(((type*)0)->field) == align);
#else
# define TEST_TARGET_ALIGN(type, align)
# define TEST_FIELD_ALIGN(type, field, align)
#endif

#define TEST_FIELD_OFFSET(type, field, offset) C_ASSERT(FIELD_OFFSET(type, field) == offset);

#define TEST_TARGET_SIZE(type, size)            TEST_TYPE_SIZE(*(type)0, size)
#define TEST_FIELD_SIZE(type, field, size)      TEST_TYPE_SIZE((((type*)0)->field), size)
#define TEST_TYPE_SIGNED(type)                  C_ASSERT((type) -1 < 0);
#define TEST_TYPE_UNSIGNED(type)                C_ASSERT((type) -1 > 0);


#ifdef _WIN64

static void test_pack_DWORD32(void)
{
    /* DWORD32 */
    TEST_TYPE_SIZE   (DWORD32, 4)
    TEST_TYPE_ALIGN  (DWORD32, 4)
    TEST_TYPE_UNSIGNED(DWORD32)
}

static void test_pack_DWORD64(void)
{
    /* DWORD64 */
    TEST_TYPE_SIZE   (DWORD64, 8)
    TEST_TYPE_ALIGN  (DWORD64, 8)
    TEST_TYPE_UNSIGNED(DWORD64)
}

static void test_pack_DWORD_PTR(void)
{
    /* DWORD_PTR */
    TEST_TYPE_SIZE   (DWORD_PTR, 8)
    TEST_TYPE_ALIGN  (DWORD_PTR, 8)
}

static void test_pack_HALF_PTR(void)
{
    /* HALF_PTR */
    TEST_TYPE_SIZE   (HALF_PTR, 4)
    TEST_TYPE_ALIGN  (HALF_PTR, 4)
    TEST_TYPE_SIGNED(HALF_PTR)
}

static void test_pack_INT16(void)
{
    /* INT16 */
    TEST_TYPE_SIZE   (INT16, 2)
    TEST_TYPE_ALIGN  (INT16, 2)
    TEST_TYPE_SIGNED(INT16)
}

static void test_pack_INT32(void)
{
    /* INT32 */
    TEST_TYPE_SIZE   (INT32, 4)
    TEST_TYPE_ALIGN  (INT32, 4)
    TEST_TYPE_SIGNED(INT32)
}

static void test_pack_INT64(void)
{
    /* INT64 */
    TEST_TYPE_SIZE   (INT64, 8)
    TEST_TYPE_ALIGN  (INT64, 8)
    TEST_TYPE_SIGNED(INT64)
}

static void test_pack_INT8(void)
{
    /* INT8 */
    TEST_TYPE_SIZE   (INT8, 1)
    TEST_TYPE_ALIGN  (INT8, 1)
    TEST_TYPE_SIGNED(INT8)
}

static void test_pack_INT_PTR(void)
{
    /* INT_PTR */
    TEST_TYPE_SIZE   (INT_PTR, 8)
    TEST_TYPE_ALIGN  (INT_PTR, 8)
    TEST_TYPE_SIGNED(INT_PTR)
}

static void test_pack_LONG32(void)
{
    /* LONG32 */
    TEST_TYPE_SIZE   (LONG32, 4)
    TEST_TYPE_ALIGN  (LONG32, 4)
    TEST_TYPE_SIGNED(LONG32)
}

static void test_pack_LONG64(void)
{
    /* LONG64 */
    TEST_TYPE_SIZE   (LONG64, 8)
    TEST_TYPE_ALIGN  (LONG64, 8)
    TEST_TYPE_SIGNED(LONG64)
}

static void test_pack_LONG_PTR(void)
{
    /* LONG_PTR */
    TEST_TYPE_SIZE   (LONG_PTR, 8)
    TEST_TYPE_ALIGN  (LONG_PTR, 8)
    TEST_TYPE_SIGNED(LONG_PTR)
}

static void test_pack_SIZE_T(void)
{
    /* SIZE_T */
    TEST_TYPE_SIZE   (SIZE_T, 8)
    TEST_TYPE_ALIGN  (SIZE_T, 8)
}

static void test_pack_SSIZE_T(void)
{
    /* SSIZE_T */
    TEST_TYPE_SIZE   (SSIZE_T, 8)
    TEST_TYPE_ALIGN  (SSIZE_T, 8)
}

static void test_pack_UHALF_PTR(void)
{
    /* UHALF_PTR */
    TEST_TYPE_SIZE   (UHALF_PTR, 4)
    TEST_TYPE_ALIGN  (UHALF_PTR, 4)
    TEST_TYPE_UNSIGNED(UHALF_PTR)
}

static void test_pack_UINT16(void)
{
    /* UINT16 */
    TEST_TYPE_SIZE   (UINT16, 2)
    TEST_TYPE_ALIGN  (UINT16, 2)
    TEST_TYPE_UNSIGNED(UINT16)
}

static void test_pack_UINT32(void)
{
    /* UINT32 */
    TEST_TYPE_SIZE   (UINT32, 4)
    TEST_TYPE_ALIGN  (UINT32, 4)
    TEST_TYPE_UNSIGNED(UINT32)
}

static void test_pack_UINT64(void)
{
    /* UINT64 */
    TEST_TYPE_SIZE   (UINT64, 8)
    TEST_TYPE_ALIGN  (UINT64, 8)
    TEST_TYPE_UNSIGNED(UINT64)
}

static void test_pack_UINT8(void)
{
    /* UINT8 */
    TEST_TYPE_SIZE   (UINT8, 1)
    TEST_TYPE_ALIGN  (UINT8, 1)
    TEST_TYPE_UNSIGNED(UINT8)
}

static void test_pack_UINT_PTR(void)
{
    /* UINT_PTR */
    TEST_TYPE_SIZE   (UINT_PTR, 8)
    TEST_TYPE_ALIGN  (UINT_PTR, 8)
    TEST_TYPE_UNSIGNED(UINT_PTR)
}

static void test_pack_ULONG32(void)
{
    /* ULONG32 */
    TEST_TYPE_SIZE   (ULONG32, 4)
    TEST_TYPE_ALIGN  (ULONG32, 4)
    TEST_TYPE_UNSIGNED(ULONG32)
}

static void test_pack_ULONG64(void)
{
    /* ULONG64 */
    TEST_TYPE_SIZE   (ULONG64, 8)
    TEST_TYPE_ALIGN  (ULONG64, 8)
    TEST_TYPE_UNSIGNED(ULONG64)
}

static void test_pack_ULONG_PTR(void)
{
    /* ULONG_PTR */
    TEST_TYPE_SIZE   (ULONG_PTR, 8)
    TEST_TYPE_ALIGN  (ULONG_PTR, 8)
    TEST_TYPE_UNSIGNED(ULONG_PTR)
}

static void test_pack_ACCESS_ALLOWED_ACE(void)
{
    /* ACCESS_ALLOWED_ACE */
    TEST_TYPE_SIZE   (ACCESS_ALLOWED_ACE, 12)
    TEST_TYPE_ALIGN  (ACCESS_ALLOWED_ACE, 4)
    TEST_FIELD_SIZE  (ACCESS_ALLOWED_ACE, Header, 4)
    TEST_FIELD_ALIGN (ACCESS_ALLOWED_ACE, Header, 2)
    TEST_FIELD_OFFSET(ACCESS_ALLOWED_ACE, Header, 0)
    TEST_FIELD_SIZE  (ACCESS_ALLOWED_ACE, Mask, 4)
    TEST_FIELD_ALIGN (ACCESS_ALLOWED_ACE, Mask, 4)
    TEST_FIELD_OFFSET(ACCESS_ALLOWED_ACE, Mask, 4)
    TEST_FIELD_SIZE  (ACCESS_ALLOWED_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (ACCESS_ALLOWED_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(ACCESS_ALLOWED_ACE, SidStart, 8)
}

static void test_pack_ACCESS_DENIED_ACE(void)
{
    /* ACCESS_DENIED_ACE */
    TEST_TYPE_SIZE   (ACCESS_DENIED_ACE, 12)
    TEST_TYPE_ALIGN  (ACCESS_DENIED_ACE, 4)
    TEST_FIELD_SIZE  (ACCESS_DENIED_ACE, Header, 4)
    TEST_FIELD_ALIGN (ACCESS_DENIED_ACE, Header, 2)
    TEST_FIELD_OFFSET(ACCESS_DENIED_ACE, Header, 0)
    TEST_FIELD_SIZE  (ACCESS_DENIED_ACE, Mask, 4)
    TEST_FIELD_ALIGN (ACCESS_DENIED_ACE, Mask, 4)
    TEST_FIELD_OFFSET(ACCESS_DENIED_ACE, Mask, 4)
    TEST_FIELD_SIZE  (ACCESS_DENIED_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (ACCESS_DENIED_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(ACCESS_DENIED_ACE, SidStart, 8)
}

static void test_pack_ACCESS_MASK(void)
{
    /* ACCESS_MASK */
    TEST_TYPE_SIZE   (ACCESS_MASK, 4)
    TEST_TYPE_ALIGN  (ACCESS_MASK, 4)
    TEST_TYPE_UNSIGNED(ACCESS_MASK)
}

static void test_pack_ACE_HEADER(void)
{
    /* ACE_HEADER */
    TEST_TYPE_SIZE   (ACE_HEADER, 4)
    TEST_TYPE_ALIGN  (ACE_HEADER, 2)
    TEST_FIELD_SIZE  (ACE_HEADER, AceType, 1)
    TEST_FIELD_ALIGN (ACE_HEADER, AceType, 1)
    TEST_FIELD_OFFSET(ACE_HEADER, AceType, 0)
    TEST_FIELD_SIZE  (ACE_HEADER, AceFlags, 1)
    TEST_FIELD_ALIGN (ACE_HEADER, AceFlags, 1)
    TEST_FIELD_OFFSET(ACE_HEADER, AceFlags, 1)
    TEST_FIELD_SIZE  (ACE_HEADER, AceSize, 2)
    TEST_FIELD_ALIGN (ACE_HEADER, AceSize, 2)
    TEST_FIELD_OFFSET(ACE_HEADER, AceSize, 2)
}

static void test_pack_ACL(void)
{
    /* ACL */
    TEST_TYPE_SIZE   (ACL, 8)
    TEST_TYPE_ALIGN  (ACL, 2)
    TEST_FIELD_SIZE  (ACL, AclRevision, 1)
    TEST_FIELD_ALIGN (ACL, AclRevision, 1)
    TEST_FIELD_OFFSET(ACL, AclRevision, 0)
    TEST_FIELD_SIZE  (ACL, Sbz1, 1)
    TEST_FIELD_ALIGN (ACL, Sbz1, 1)
    TEST_FIELD_OFFSET(ACL, Sbz1, 1)
    TEST_FIELD_SIZE  (ACL, AclSize, 2)
    TEST_FIELD_ALIGN (ACL, AclSize, 2)
    TEST_FIELD_OFFSET(ACL, AclSize, 2)
    TEST_FIELD_SIZE  (ACL, AceCount, 2)
    TEST_FIELD_ALIGN (ACL, AceCount, 2)
    TEST_FIELD_OFFSET(ACL, AceCount, 4)
    TEST_FIELD_SIZE  (ACL, Sbz2, 2)
    TEST_FIELD_ALIGN (ACL, Sbz2, 2)
    TEST_FIELD_OFFSET(ACL, Sbz2, 6)
}

static void test_pack_ACL_REVISION_INFORMATION(void)
{
    /* ACL_REVISION_INFORMATION */
    TEST_TYPE_SIZE   (ACL_REVISION_INFORMATION, 4)
    TEST_TYPE_ALIGN  (ACL_REVISION_INFORMATION, 4)
    TEST_FIELD_SIZE  (ACL_REVISION_INFORMATION, AclRevision, 4)
    TEST_FIELD_ALIGN (ACL_REVISION_INFORMATION, AclRevision, 4)
    TEST_FIELD_OFFSET(ACL_REVISION_INFORMATION, AclRevision, 0)
}

static void test_pack_ACL_SIZE_INFORMATION(void)
{
    /* ACL_SIZE_INFORMATION */
    TEST_TYPE_SIZE   (ACL_SIZE_INFORMATION, 12)
    TEST_TYPE_ALIGN  (ACL_SIZE_INFORMATION, 4)
    TEST_FIELD_SIZE  (ACL_SIZE_INFORMATION, AceCount, 4)
    TEST_FIELD_ALIGN (ACL_SIZE_INFORMATION, AceCount, 4)
    TEST_FIELD_OFFSET(ACL_SIZE_INFORMATION, AceCount, 0)
    TEST_FIELD_SIZE  (ACL_SIZE_INFORMATION, AclBytesInUse, 4)
    TEST_FIELD_ALIGN (ACL_SIZE_INFORMATION, AclBytesInUse, 4)
    TEST_FIELD_OFFSET(ACL_SIZE_INFORMATION, AclBytesInUse, 4)
    TEST_FIELD_SIZE  (ACL_SIZE_INFORMATION, AclBytesFree, 4)
    TEST_FIELD_ALIGN (ACL_SIZE_INFORMATION, AclBytesFree, 4)
    TEST_FIELD_OFFSET(ACL_SIZE_INFORMATION, AclBytesFree, 8)
}

static void test_pack_BOOLEAN(void)
{
    /* BOOLEAN */
    TEST_TYPE_SIZE   (BOOLEAN, 1)
    TEST_TYPE_ALIGN  (BOOLEAN, 1)
    TEST_TYPE_UNSIGNED(BOOLEAN)
}

static void test_pack_CCHAR(void)
{
    /* CCHAR */
    TEST_TYPE_SIZE   (CCHAR, 1)
    TEST_TYPE_ALIGN  (CCHAR, 1)
}

static void test_pack_CHAR(void)
{
    /* CHAR */
    TEST_TYPE_SIZE   (CHAR, 1)
    TEST_TYPE_ALIGN  (CHAR, 1)
}

static void test_pack_DWORDLONG(void)
{
    /* DWORDLONG */
    TEST_TYPE_SIZE   (DWORDLONG, 8)
    TEST_TYPE_ALIGN  (DWORDLONG, 8)
    TEST_TYPE_UNSIGNED(DWORDLONG)
}

static void test_pack_EXCEPTION_POINTERS(void)
{
    /* EXCEPTION_POINTERS */
    TEST_TYPE_SIZE   (EXCEPTION_POINTERS, 16)
    TEST_TYPE_ALIGN  (EXCEPTION_POINTERS, 8)
    TEST_FIELD_SIZE  (EXCEPTION_POINTERS, ExceptionRecord, 8)
    TEST_FIELD_ALIGN (EXCEPTION_POINTERS, ExceptionRecord, 8)
    TEST_FIELD_OFFSET(EXCEPTION_POINTERS, ExceptionRecord, 0)
    TEST_FIELD_SIZE  (EXCEPTION_POINTERS, ContextRecord, 8)
    TEST_FIELD_ALIGN (EXCEPTION_POINTERS, ContextRecord, 8)
    TEST_FIELD_OFFSET(EXCEPTION_POINTERS, ContextRecord, 8)
}

static void test_pack_EXCEPTION_RECORD(void)
{
    /* EXCEPTION_RECORD */
    TEST_TYPE_SIZE   (EXCEPTION_RECORD, 152)
    TEST_TYPE_ALIGN  (EXCEPTION_RECORD, 8)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionCode, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionCode, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionCode, 0)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionFlags, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionFlags, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionFlags, 4)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionRecord, 8)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionRecord, 8)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionRecord, 8)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionAddress, 8)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionAddress, 8)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionAddress, 16)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, NumberParameters, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, NumberParameters, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, NumberParameters, 24)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionInformation, 120)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionInformation, 8)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionInformation, 32)
}

static void test_pack_EXECUTION_STATE(void)
{
    /* EXECUTION_STATE */
    TEST_TYPE_SIZE   (EXECUTION_STATE, 4)
    TEST_TYPE_ALIGN  (EXECUTION_STATE, 4)
    TEST_TYPE_UNSIGNED(EXECUTION_STATE)
}

static void test_pack_FPO_DATA(void)
{
    /* FPO_DATA */
    TEST_TYPE_SIZE   (FPO_DATA, 16)
    TEST_TYPE_ALIGN  (FPO_DATA, 4)
    TEST_FIELD_SIZE  (FPO_DATA, ulOffStart, 4)
    TEST_FIELD_ALIGN (FPO_DATA, ulOffStart, 4)
    TEST_FIELD_OFFSET(FPO_DATA, ulOffStart, 0)
    TEST_FIELD_SIZE  (FPO_DATA, cbProcSize, 4)
    TEST_FIELD_ALIGN (FPO_DATA, cbProcSize, 4)
    TEST_FIELD_OFFSET(FPO_DATA, cbProcSize, 4)
    TEST_FIELD_SIZE  (FPO_DATA, cdwLocals, 4)
    TEST_FIELD_ALIGN (FPO_DATA, cdwLocals, 4)
    TEST_FIELD_OFFSET(FPO_DATA, cdwLocals, 8)
    TEST_FIELD_SIZE  (FPO_DATA, cdwParams, 2)
    TEST_FIELD_ALIGN (FPO_DATA, cdwParams, 2)
    TEST_FIELD_OFFSET(FPO_DATA, cdwParams, 12)
}

static void test_pack_GENERIC_MAPPING(void)
{
    /* GENERIC_MAPPING */
    TEST_TYPE_SIZE   (GENERIC_MAPPING, 16)
    TEST_TYPE_ALIGN  (GENERIC_MAPPING, 4)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericRead, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericRead, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericRead, 0)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericWrite, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericWrite, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericWrite, 4)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericExecute, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericExecute, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericExecute, 8)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericAll, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericAll, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericAll, 12)
}

static void test_pack_HANDLE(void)
{
    /* HANDLE */
    TEST_TYPE_SIZE   (HANDLE, 8)
    TEST_TYPE_ALIGN  (HANDLE, 8)
}

static void test_pack_HRESULT(void)
{
    /* HRESULT */
    TEST_TYPE_SIZE   (HRESULT, 4)
    TEST_TYPE_ALIGN  (HRESULT, 4)
}

static void test_pack_IMAGE_ARCHIVE_MEMBER_HEADER(void)
{
    /* IMAGE_ARCHIVE_MEMBER_HEADER */
    TEST_TYPE_SIZE   (IMAGE_ARCHIVE_MEMBER_HEADER, 60)
    TEST_TYPE_ALIGN  (IMAGE_ARCHIVE_MEMBER_HEADER, 1)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Name, 16)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Name, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Name, 0)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Date, 12)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Date, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Date, 16)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, UserID, 6)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, UserID, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, UserID, 28)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, GroupID, 6)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, GroupID, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, GroupID, 34)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Mode, 8)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Mode, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Mode, 40)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Size, 10)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Size, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Size, 48)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, EndHeader, 2)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, EndHeader, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, EndHeader, 58)
}

static void test_pack_IMAGE_AUX_SYMBOL(void)
{
    /* IMAGE_AUX_SYMBOL (pack 2) */
}

static void test_pack_IMAGE_BASE_RELOCATION(void)
{
    /* IMAGE_BASE_RELOCATION */
    TEST_TYPE_SIZE   (IMAGE_BASE_RELOCATION, 8)
    TEST_TYPE_ALIGN  (IMAGE_BASE_RELOCATION, 4)
    TEST_FIELD_SIZE  (IMAGE_BASE_RELOCATION, VirtualAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_BASE_RELOCATION, VirtualAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_BASE_RELOCATION, VirtualAddress, 0)
    TEST_FIELD_SIZE  (IMAGE_BASE_RELOCATION, SizeOfBlock, 4)
    TEST_FIELD_ALIGN (IMAGE_BASE_RELOCATION, SizeOfBlock, 4)
    TEST_FIELD_OFFSET(IMAGE_BASE_RELOCATION, SizeOfBlock, 4)
}

static void test_pack_IMAGE_BOUND_FORWARDER_REF(void)
{
    /* IMAGE_BOUND_FORWARDER_REF */
    TEST_TYPE_SIZE   (IMAGE_BOUND_FORWARDER_REF, 8)
    TEST_TYPE_ALIGN  (IMAGE_BOUND_FORWARDER_REF, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_FORWARDER_REF, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_BOUND_FORWARDER_REF, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_BOUND_FORWARDER_REF, TimeDateStamp, 0)
    TEST_FIELD_SIZE  (IMAGE_BOUND_FORWARDER_REF, OffsetModuleName, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_FORWARDER_REF, OffsetModuleName, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_FORWARDER_REF, OffsetModuleName, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_FORWARDER_REF, Reserved, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_FORWARDER_REF, Reserved, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_FORWARDER_REF, Reserved, 6)
}

static void test_pack_IMAGE_BOUND_IMPORT_DESCRIPTOR(void)
{
    /* IMAGE_BOUND_IMPORT_DESCRIPTOR */
    TEST_TYPE_SIZE   (IMAGE_BOUND_IMPORT_DESCRIPTOR, 8)
    TEST_TYPE_ALIGN  (IMAGE_BOUND_IMPORT_DESCRIPTOR, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_IMPORT_DESCRIPTOR, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_BOUND_IMPORT_DESCRIPTOR, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_BOUND_IMPORT_DESCRIPTOR, TimeDateStamp, 0)
    TEST_FIELD_SIZE  (IMAGE_BOUND_IMPORT_DESCRIPTOR, OffsetModuleName, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_IMPORT_DESCRIPTOR, OffsetModuleName, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_IMPORT_DESCRIPTOR, OffsetModuleName, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_IMPORT_DESCRIPTOR, NumberOfModuleForwarderRefs, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_IMPORT_DESCRIPTOR, NumberOfModuleForwarderRefs, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_IMPORT_DESCRIPTOR, NumberOfModuleForwarderRefs, 6)
}

static void test_pack_IMAGE_COFF_SYMBOLS_HEADER(void)
{
    /* IMAGE_COFF_SYMBOLS_HEADER */
    TEST_TYPE_SIZE   (IMAGE_COFF_SYMBOLS_HEADER, 32)
    TEST_TYPE_ALIGN  (IMAGE_COFF_SYMBOLS_HEADER, 4)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, NumberOfSymbols, 0)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstSymbol, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstSymbol, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstSymbol, 4)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, NumberOfLinenumbers, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, NumberOfLinenumbers, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, NumberOfLinenumbers, 8)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstLinenumber, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstLinenumber, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstLinenumber, 12)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfCode, 16)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfCode, 20)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfData, 24)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfData, 28)
}

static void test_pack_IMAGE_DATA_DIRECTORY(void)
{
    /* IMAGE_DATA_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_DATA_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (IMAGE_DATA_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_DATA_DIRECTORY, VirtualAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_DATA_DIRECTORY, VirtualAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_DATA_DIRECTORY, VirtualAddress, 0)
    TEST_FIELD_SIZE  (IMAGE_DATA_DIRECTORY, Size, 4)
    TEST_FIELD_ALIGN (IMAGE_DATA_DIRECTORY, Size, 4)
    TEST_FIELD_OFFSET(IMAGE_DATA_DIRECTORY, Size, 4)
}

static void test_pack_IMAGE_DEBUG_DIRECTORY(void)
{
    /* IMAGE_DEBUG_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_DEBUG_DIRECTORY, 28)
    TEST_TYPE_ALIGN  (IMAGE_DEBUG_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, Characteristics, 0)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, Type, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, Type, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, Type, 12)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, SizeOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, SizeOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, SizeOfData, 16)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, AddressOfRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, AddressOfRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, AddressOfRawData, 20)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, PointerToRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, PointerToRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, PointerToRawData, 24)
}

static void test_pack_IMAGE_DEBUG_MISC(void)
{
    /* IMAGE_DEBUG_MISC */
    TEST_TYPE_SIZE   (IMAGE_DEBUG_MISC, 16)
    TEST_TYPE_ALIGN  (IMAGE_DEBUG_MISC, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, DataType, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, DataType, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, DataType, 0)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Length, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Length, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Length, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Unicode, 1)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Unicode, 1)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Unicode, 8)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Reserved, 3)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Reserved, 1)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Reserved, 9)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Data, 1)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Data, 1)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Data, 12)
}

static void test_pack_IMAGE_DOS_HEADER(void)
{
    /* IMAGE_DOS_HEADER (pack 2) */
    TEST_TYPE_SIZE   (IMAGE_DOS_HEADER, 64)
    TEST_TYPE_ALIGN  (IMAGE_DOS_HEADER, 2)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_magic, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_magic, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_magic, 0)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cblp, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cblp, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cblp, 2)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cp, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cp, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cp, 4)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_crlc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_crlc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_crlc, 6)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cparhdr, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cparhdr, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cparhdr, 8)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_minalloc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_minalloc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_minalloc, 10)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_maxalloc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_maxalloc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_maxalloc, 12)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_ss, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_ss, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_ss, 14)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_sp, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_sp, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_sp, 16)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_csum, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_csum, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_csum, 18)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_ip, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_ip, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_ip, 20)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cs, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cs, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cs, 22)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_lfarlc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_lfarlc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_lfarlc, 24)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_ovno, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_ovno, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_ovno, 26)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_res, 8)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_res, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_res, 28)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_oemid, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_oemid, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_oemid, 36)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_oeminfo, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_oeminfo, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_oeminfo, 38)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_res2, 20)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_res2, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_res2, 40)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_lfanew, 4)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_lfanew, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_lfanew, 60)
}

static void test_pack_IMAGE_EXPORT_DIRECTORY(void)
{
    /* IMAGE_EXPORT_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_EXPORT_DIRECTORY, 40)
    TEST_TYPE_ALIGN  (IMAGE_EXPORT_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, Characteristics, 0)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, Name, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, Name, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, Name, 12)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, Base, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, Base, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, Base, 16)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, NumberOfFunctions, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, NumberOfFunctions, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, NumberOfFunctions, 20)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, NumberOfNames, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, NumberOfNames, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, NumberOfNames, 24)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, AddressOfFunctions, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, AddressOfFunctions, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, AddressOfFunctions, 28)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, AddressOfNames, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, AddressOfNames, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, AddressOfNames, 32)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, AddressOfNameOrdinals, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, AddressOfNameOrdinals, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, AddressOfNameOrdinals, 36)
}

static void test_pack_IMAGE_FILE_HEADER(void)
{
    /* IMAGE_FILE_HEADER */
    TEST_TYPE_SIZE   (IMAGE_FILE_HEADER, 20)
    TEST_TYPE_ALIGN  (IMAGE_FILE_HEADER, 4)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, Machine, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, Machine, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, Machine, 0)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, NumberOfSections, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, NumberOfSections, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, NumberOfSections, 2)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, PointerToSymbolTable, 4)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, PointerToSymbolTable, 4)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, PointerToSymbolTable, 8)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, NumberOfSymbols, 12)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, SizeOfOptionalHeader, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, SizeOfOptionalHeader, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, SizeOfOptionalHeader, 16)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, Characteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, Characteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, Characteristics, 18)
}

static void test_pack_IMAGE_FUNCTION_ENTRY(void)
{
    /* IMAGE_FUNCTION_ENTRY */
    TEST_TYPE_SIZE   (IMAGE_FUNCTION_ENTRY, 12)
    TEST_TYPE_ALIGN  (IMAGE_FUNCTION_ENTRY, 4)
    TEST_FIELD_SIZE  (IMAGE_FUNCTION_ENTRY, StartingAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_FUNCTION_ENTRY, StartingAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_FUNCTION_ENTRY, StartingAddress, 0)
    TEST_FIELD_SIZE  (IMAGE_FUNCTION_ENTRY, EndingAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_FUNCTION_ENTRY, EndingAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_FUNCTION_ENTRY, EndingAddress, 4)
    TEST_FIELD_SIZE  (IMAGE_FUNCTION_ENTRY, EndOfPrologue, 4)
    TEST_FIELD_ALIGN (IMAGE_FUNCTION_ENTRY, EndOfPrologue, 4)
    TEST_FIELD_OFFSET(IMAGE_FUNCTION_ENTRY, EndOfPrologue, 8)
}

static void test_pack_IMAGE_IMPORT_BY_NAME(void)
{
    /* IMAGE_IMPORT_BY_NAME */
    TEST_TYPE_SIZE   (IMAGE_IMPORT_BY_NAME, 4)
    TEST_TYPE_ALIGN  (IMAGE_IMPORT_BY_NAME, 2)
    TEST_FIELD_SIZE  (IMAGE_IMPORT_BY_NAME, Hint, 2)
    TEST_FIELD_ALIGN (IMAGE_IMPORT_BY_NAME, Hint, 2)
    TEST_FIELD_OFFSET(IMAGE_IMPORT_BY_NAME, Hint, 0)
    TEST_FIELD_SIZE  (IMAGE_IMPORT_BY_NAME, Name, 1)
    TEST_FIELD_ALIGN (IMAGE_IMPORT_BY_NAME, Name, 1)
    TEST_FIELD_OFFSET(IMAGE_IMPORT_BY_NAME, Name, 2)
}

static void test_pack_IMAGE_IMPORT_DESCRIPTOR(void)
{
    /* IMAGE_IMPORT_DESCRIPTOR */
}

static void test_pack_IMAGE_LINENUMBER(void)
{
    /* IMAGE_LINENUMBER (pack 2) */
}

static void test_pack_IMAGE_LOAD_CONFIG_DIRECTORY(void)
{
    /* IMAGE_LOAD_CONFIG_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_LOAD_CONFIG_DIRECTORY, 88)
    TEST_TYPE_ALIGN  (IMAGE_LOAD_CONFIG_DIRECTORY, 8)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, Size, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, Size, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, Size, 0)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsClear, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsClear, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsClear, 12)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsSet, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsSet, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsSet, 16)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, CriticalSectionDefaultTimeout, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, CriticalSectionDefaultTimeout, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, CriticalSectionDefaultTimeout, 20)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitFreeBlockThreshold, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitFreeBlockThreshold, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitFreeBlockThreshold, 24)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitTotalFreeThreshold, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitTotalFreeThreshold, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitTotalFreeThreshold, 28)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, LockPrefixTable, 8)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, LockPrefixTable, 8)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, LockPrefixTable, 32)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, MaximumAllocationSize, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, MaximumAllocationSize, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, MaximumAllocationSize, 40)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, VirtualMemoryThreshold, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, VirtualMemoryThreshold, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, VirtualMemoryThreshold, 44)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessHeapFlags, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessHeapFlags, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, ProcessHeapFlags, 48)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessAffinityMask, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessAffinityMask, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, ProcessAffinityMask, 52)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, CSDVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, CSDVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, CSDVersion, 56)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, Reserved1, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, Reserved1, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, Reserved1, 58)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, EditList, 8)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, EditList, 8)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, EditList, 64)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, SecurityCookie, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, SecurityCookie, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, SecurityCookie, 72)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerTable, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerTable, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerTable, 76)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerCount, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerCount, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerCount, 80)
}

static void test_pack_IMAGE_NT_HEADERS(void)
{
    /* IMAGE_NT_HEADERS */
    TEST_TYPE_SIZE   (IMAGE_NT_HEADERS, 264)
    TEST_TYPE_ALIGN  (IMAGE_NT_HEADERS, 8)
}

static void test_pack_IMAGE_NT_HEADERS32(void)
{
    /* IMAGE_NT_HEADERS32 */
    TEST_TYPE_SIZE   (IMAGE_NT_HEADERS32, 248)
    TEST_TYPE_ALIGN  (IMAGE_NT_HEADERS32, 4)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS32, Signature, 4)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS32, Signature, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS32, Signature, 0)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS32, FileHeader, 20)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS32, FileHeader, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS32, FileHeader, 4)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS32, OptionalHeader, 224)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS32, OptionalHeader, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS32, OptionalHeader, 24)
}

static void test_pack_IMAGE_NT_HEADERS64(void)
{
    /* IMAGE_NT_HEADERS64 */
    TEST_TYPE_SIZE   (IMAGE_NT_HEADERS64, 264)
    TEST_TYPE_ALIGN  (IMAGE_NT_HEADERS64, 8)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS64, Signature, 4)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS64, Signature, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS64, Signature, 0)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS64, FileHeader, 20)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS64, FileHeader, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS64, FileHeader, 4)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS64, OptionalHeader, 240)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS64, OptionalHeader, 8)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS64, OptionalHeader, 24)
}

static void test_pack_IMAGE_OPTIONAL_HEADER(void)
{
    /* IMAGE_OPTIONAL_HEADER */
    TEST_TYPE_SIZE   (IMAGE_OPTIONAL_HEADER, 240)
    TEST_TYPE_ALIGN  (IMAGE_OPTIONAL_HEADER, 8)
}

static void test_pack_IMAGE_OPTIONAL_HEADER32(void)
{
    /* IMAGE_OPTIONAL_HEADER32 */
    TEST_TYPE_SIZE   (IMAGE_OPTIONAL_HEADER32, 224)
    TEST_TYPE_ALIGN  (IMAGE_OPTIONAL_HEADER32, 4)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, Magic, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, Magic, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, Magic, 0)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorLinkerVersion, 2)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorLinkerVersion, 3)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfCode, 4)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfInitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfInitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfInitializedData, 8)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfUninitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfUninitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfUninitializedData, 12)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, AddressOfEntryPoint, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, AddressOfEntryPoint, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, AddressOfEntryPoint, 16)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, BaseOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, BaseOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, BaseOfCode, 20)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, BaseOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, BaseOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, BaseOfData, 24)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, ImageBase, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, ImageBase, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, ImageBase, 28)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SectionAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SectionAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SectionAlignment, 32)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, FileAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, FileAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, FileAlignment, 36)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorOperatingSystemVersion, 40)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorOperatingSystemVersion, 42)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorImageVersion, 44)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorImageVersion, 46)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorSubsystemVersion, 48)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorSubsystemVersion, 50)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, Win32VersionValue, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, Win32VersionValue, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, Win32VersionValue, 52)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfImage, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfImage, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfImage, 56)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfHeaders, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfHeaders, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfHeaders, 60)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, CheckSum, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, CheckSum, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, CheckSum, 64)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, Subsystem, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, Subsystem, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, Subsystem, 68)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, DllCharacteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, DllCharacteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, DllCharacteristics, 70)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfStackReserve, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfStackReserve, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfStackReserve, 72)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfStackCommit, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfStackCommit, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfStackCommit, 76)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfHeapReserve, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfHeapReserve, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfHeapReserve, 80)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfHeapCommit, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfHeapCommit, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfHeapCommit, 84)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, LoaderFlags, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, LoaderFlags, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, LoaderFlags, 88)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, NumberOfRvaAndSizes, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, NumberOfRvaAndSizes, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, NumberOfRvaAndSizes, 92)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, DataDirectory, 128)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, DataDirectory, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, DataDirectory, 96)
}

static void test_pack_IMAGE_OPTIONAL_HEADER64(void)
{
    /* IMAGE_OPTIONAL_HEADER64 */
    TEST_TYPE_SIZE   (IMAGE_OPTIONAL_HEADER64, 240)
    TEST_TYPE_ALIGN  (IMAGE_OPTIONAL_HEADER64, 8)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, Magic, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, Magic, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, Magic, 0)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorLinkerVersion, 2)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorLinkerVersion, 3)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfCode, 4)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfInitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfInitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfInitializedData, 8)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfUninitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfUninitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfUninitializedData, 12)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, AddressOfEntryPoint, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, AddressOfEntryPoint, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, AddressOfEntryPoint, 16)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, BaseOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, BaseOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, BaseOfCode, 20)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, ImageBase, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, ImageBase, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, ImageBase, 24)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SectionAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SectionAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SectionAlignment, 32)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, FileAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, FileAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, FileAlignment, 36)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorOperatingSystemVersion, 40)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorOperatingSystemVersion, 42)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorImageVersion, 44)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorImageVersion, 46)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorSubsystemVersion, 48)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorSubsystemVersion, 50)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, Win32VersionValue, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, Win32VersionValue, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, Win32VersionValue, 52)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfImage, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfImage, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfImage, 56)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfHeaders, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfHeaders, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfHeaders, 60)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, CheckSum, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, CheckSum, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, CheckSum, 64)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, Subsystem, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, Subsystem, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, Subsystem, 68)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, DllCharacteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, DllCharacteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, DllCharacteristics, 70)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfStackReserve, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfStackReserve, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfStackReserve, 72)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfStackCommit, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfStackCommit, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfStackCommit, 80)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfHeapReserve, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfHeapReserve, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfHeapReserve, 88)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfHeapCommit, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfHeapCommit, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfHeapCommit, 96)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, LoaderFlags, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, LoaderFlags, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, LoaderFlags, 104)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, NumberOfRvaAndSizes, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, NumberOfRvaAndSizes, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, NumberOfRvaAndSizes, 108)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, DataDirectory, 128)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, DataDirectory, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, DataDirectory, 112)
}

static void test_pack_IMAGE_OS2_HEADER(void)
{
    /* IMAGE_OS2_HEADER (pack 2) */
    TEST_TYPE_SIZE   (IMAGE_OS2_HEADER, 64)
    TEST_TYPE_ALIGN  (IMAGE_OS2_HEADER, 2)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_magic, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_magic, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_magic, 0)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_ver, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_ver, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_ver, 2)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_rev, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_rev, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_rev, 3)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_enttab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_enttab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_enttab, 4)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cbenttab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cbenttab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cbenttab, 6)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_crc, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_crc, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_crc, 8)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_flags, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_flags, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_flags, 12)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_autodata, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_autodata, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_autodata, 14)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_heap, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_heap, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_heap, 16)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_stack, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_stack, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_stack, 18)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_csip, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_csip, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_csip, 20)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_sssp, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_sssp, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_sssp, 24)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cseg, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cseg, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cseg, 28)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cmod, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cmod, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cmod, 30)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cbnrestab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cbnrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cbnrestab, 32)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_segtab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_segtab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_segtab, 34)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_rsrctab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_rsrctab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_rsrctab, 36)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_restab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_restab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_restab, 38)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_modtab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_modtab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_modtab, 40)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_imptab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_imptab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_imptab, 42)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_nrestab, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_nrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_nrestab, 44)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cmovent, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cmovent, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cmovent, 48)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_align, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_align, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_align, 50)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cres, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cres, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cres, 52)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_exetyp, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_exetyp, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_exetyp, 54)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_flagsothers, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_flagsothers, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_flagsothers, 55)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_pretthunks, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_pretthunks, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_pretthunks, 56)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_psegrefbytes, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_psegrefbytes, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_psegrefbytes, 58)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_swaparea, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_swaparea, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_swaparea, 60)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_expver, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_expver, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_expver, 62)
}

static void test_pack_IMAGE_RELOCATION(void)
{
    /* IMAGE_RELOCATION (pack 2) */
}

static void test_pack_IMAGE_RESOURCE_DATA_ENTRY(void)
{
    /* IMAGE_RESOURCE_DATA_ENTRY */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DATA_ENTRY, 16)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DATA_ENTRY, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, OffsetToData, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, OffsetToData, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, OffsetToData, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, Size, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, Size, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, Size, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, CodePage, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, CodePage, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, CodePage, 8)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, Reserved, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, Reserved, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, Reserved, 12)
}

static void test_pack_IMAGE_RESOURCE_DIRECTORY(void)
{
    /* IMAGE_RESOURCE_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DIRECTORY, 16)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, Characteristics, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, NumberOfNamedEntries, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, NumberOfNamedEntries, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, NumberOfNamedEntries, 12)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, NumberOfIdEntries, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, NumberOfIdEntries, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, NumberOfIdEntries, 14)
}

static void test_pack_IMAGE_RESOURCE_DIRECTORY_ENTRY(void)
{
    /* IMAGE_RESOURCE_DIRECTORY_ENTRY */
}

static void test_pack_IMAGE_RESOURCE_DIRECTORY_STRING(void)
{
    /* IMAGE_RESOURCE_DIRECTORY_STRING */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DIRECTORY_STRING, 4)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DIRECTORY_STRING, 2)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY_STRING, Length, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY_STRING, Length, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY_STRING, Length, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY_STRING, NameString, 1)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY_STRING, NameString, 1)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY_STRING, NameString, 2)
}

static void test_pack_IMAGE_RESOURCE_DIR_STRING_U(void)
{
    /* IMAGE_RESOURCE_DIR_STRING_U */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DIR_STRING_U, 4)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DIR_STRING_U, 2)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIR_STRING_U, Length, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIR_STRING_U, Length, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIR_STRING_U, Length, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIR_STRING_U, NameString, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIR_STRING_U, NameString, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIR_STRING_U, NameString, 2)
}

static void test_pack_IMAGE_SECTION_HEADER(void)
{
    /* IMAGE_SECTION_HEADER */
    TEST_FIELD_SIZE  (IMAGE_SECTION_HEADER, Name, 8)
    TEST_FIELD_ALIGN (IMAGE_SECTION_HEADER, Name, 1)
    TEST_FIELD_OFFSET(IMAGE_SECTION_HEADER, Name, 0)
}

static void test_pack_IMAGE_SEPARATE_DEBUG_HEADER(void)
{
    /* IMAGE_SEPARATE_DEBUG_HEADER */
    TEST_TYPE_SIZE   (IMAGE_SEPARATE_DEBUG_HEADER, 48)
    TEST_TYPE_ALIGN  (IMAGE_SEPARATE_DEBUG_HEADER, 4)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Signature, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Signature, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Signature, 0)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Flags, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Flags, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Flags, 2)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Machine, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Machine, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Machine, 4)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Characteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Characteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Characteristics, 6)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, TimeDateStamp, 8)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, CheckSum, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, CheckSum, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, CheckSum, 12)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, ImageBase, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, ImageBase, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, ImageBase, 16)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, SizeOfImage, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, SizeOfImage, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, SizeOfImage, 20)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, NumberOfSections, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, NumberOfSections, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, NumberOfSections, 24)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, ExportedNamesSize, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, ExportedNamesSize, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, ExportedNamesSize, 28)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, DebugDirectorySize, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, DebugDirectorySize, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, DebugDirectorySize, 32)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, SectionAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, SectionAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, SectionAlignment, 36)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Reserved, 8)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Reserved, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Reserved, 40)
}

static void test_pack_IMAGE_SYMBOL(void)
{
    /* IMAGE_SYMBOL (pack 2) */
}

static void test_pack_IMAGE_THUNK_DATA(void)
{
    /* IMAGE_THUNK_DATA */
}

static void test_pack_IMAGE_TLS_DIRECTORY(void)
{
    /* IMAGE_TLS_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_TLS_DIRECTORY, 40)
    TEST_TYPE_ALIGN  (IMAGE_TLS_DIRECTORY, 8)
}

static void test_pack_IMAGE_TLS_DIRECTORY32(void)
{
    /* IMAGE_TLS_DIRECTORY32 */
    TEST_TYPE_SIZE   (IMAGE_TLS_DIRECTORY32, 24)
    TEST_TYPE_ALIGN  (IMAGE_TLS_DIRECTORY32, 4)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, StartAddressOfRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, StartAddressOfRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, StartAddressOfRawData, 0)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, EndAddressOfRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, EndAddressOfRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, EndAddressOfRawData, 4)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, AddressOfIndex, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, AddressOfIndex, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, AddressOfIndex, 8)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, AddressOfCallBacks, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, AddressOfCallBacks, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, AddressOfCallBacks, 12)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, SizeOfZeroFill, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, SizeOfZeroFill, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, SizeOfZeroFill, 16)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, Characteristics, 20)
}

static void test_pack_IMAGE_TLS_DIRECTORY64(void)
{
    /* IMAGE_TLS_DIRECTORY64 */
    TEST_TYPE_SIZE   (IMAGE_TLS_DIRECTORY64, 40)
    TEST_TYPE_ALIGN  (IMAGE_TLS_DIRECTORY64, 8)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, StartAddressOfRawData, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, StartAddressOfRawData, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, StartAddressOfRawData, 0)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, EndAddressOfRawData, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, EndAddressOfRawData, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, EndAddressOfRawData, 8)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, AddressOfIndex, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, AddressOfIndex, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, AddressOfIndex, 16)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, AddressOfCallBacks, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, AddressOfCallBacks, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, AddressOfCallBacks, 24)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, SizeOfZeroFill, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, SizeOfZeroFill, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, SizeOfZeroFill, 32)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, Characteristics, 36)
}

static void test_pack_IMAGE_VXD_HEADER(void)
{
    /* IMAGE_VXD_HEADER (pack 2) */
    TEST_TYPE_SIZE   (IMAGE_VXD_HEADER, 196)
    TEST_TYPE_ALIGN  (IMAGE_VXD_HEADER, 2)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_magic, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_magic, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_magic, 0)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_border, 1)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_border, 1)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_border, 2)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_worder, 1)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_worder, 1)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_worder, 3)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_level, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_level, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_level, 4)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_cpu, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_cpu, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_cpu, 8)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_os, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_os, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_os, 10)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ver, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ver, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ver, 12)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_mflags, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_mflags, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_mflags, 16)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_mpages, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_mpages, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_mpages, 20)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_startobj, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_startobj, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_startobj, 24)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_eip, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_eip, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_eip, 28)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_stackobj, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_stackobj, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_stackobj, 32)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_esp, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_esp, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_esp, 36)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_pagesize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_pagesize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_pagesize, 40)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_lastpagesize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_lastpagesize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_lastpagesize, 44)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_fixupsize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_fixupsize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_fixupsize, 48)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_fixupsum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_fixupsum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_fixupsum, 52)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ldrsize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ldrsize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ldrsize, 56)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ldrsum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ldrsum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ldrsum, 60)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_objtab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_objtab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_objtab, 64)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_objcnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_objcnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_objcnt, 68)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_objmap, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_objmap, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_objmap, 72)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_itermap, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_itermap, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_itermap, 76)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_rsrctab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_rsrctab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_rsrctab, 80)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_rsrccnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_rsrccnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_rsrccnt, 84)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_restab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_restab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_restab, 88)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_enttab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_enttab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_enttab, 92)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_dirtab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_dirtab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_dirtab, 96)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_dircnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_dircnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_dircnt, 100)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_fpagetab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_fpagetab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_fpagetab, 104)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_frectab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_frectab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_frectab, 108)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_impmod, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_impmod, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_impmod, 112)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_impmodcnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_impmodcnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_impmodcnt, 116)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_impproc, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_impproc, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_impproc, 120)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_pagesum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_pagesum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_pagesum, 124)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_datapage, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_datapage, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_datapage, 128)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_preload, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_preload, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_preload, 132)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_nrestab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_nrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_nrestab, 136)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_cbnrestab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_cbnrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_cbnrestab, 140)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_nressum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_nressum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_nressum, 144)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_autodata, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_autodata, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_autodata, 148)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_debuginfo, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_debuginfo, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_debuginfo, 152)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_debuglen, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_debuglen, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_debuglen, 156)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_instpreload, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_instpreload, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_instpreload, 160)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_instdemand, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_instdemand, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_instdemand, 164)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_heapsize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_heapsize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_heapsize, 168)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_res3, 12)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_res3, 1)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_res3, 172)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_winresoff, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_winresoff, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_winresoff, 184)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_winreslen, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_winreslen, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_winreslen, 188)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_devid, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_devid, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_devid, 192)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ddkver, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ddkver, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ddkver, 194)
}

static void test_pack_IO_COUNTERS(void)
{
    /* IO_COUNTERS (pack 8) */
    TEST_TYPE_SIZE   (IO_COUNTERS, 48)
    TEST_TYPE_ALIGN  (IO_COUNTERS, 8)
    TEST_FIELD_SIZE  (IO_COUNTERS, ReadOperationCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, ReadOperationCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, ReadOperationCount, 0)
    TEST_FIELD_SIZE  (IO_COUNTERS, WriteOperationCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, WriteOperationCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, WriteOperationCount, 8)
    TEST_FIELD_SIZE  (IO_COUNTERS, OtherOperationCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, OtherOperationCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, OtherOperationCount, 16)
    TEST_FIELD_SIZE  (IO_COUNTERS, ReadTransferCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, ReadTransferCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, ReadTransferCount, 24)
    TEST_FIELD_SIZE  (IO_COUNTERS, WriteTransferCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, WriteTransferCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, WriteTransferCount, 32)
    TEST_FIELD_SIZE  (IO_COUNTERS, OtherTransferCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, OtherTransferCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, OtherTransferCount, 40)
}

static void test_pack_LANGID(void)
{
    /* LANGID */
    TEST_TYPE_SIZE   (LANGID, 2)
    TEST_TYPE_ALIGN  (LANGID, 2)
    TEST_TYPE_UNSIGNED(LANGID)
}

static void test_pack_LARGE_INTEGER(void)
{
    /* LARGE_INTEGER */
}

static void test_pack_LCID(void)
{
    /* LCID */
    TEST_TYPE_SIZE   (LCID, 4)
    TEST_TYPE_ALIGN  (LCID, 4)
    TEST_TYPE_UNSIGNED(LCID)
}

static void test_pack_LIST_ENTRY(void)
{
    /* LIST_ENTRY */
    TEST_TYPE_SIZE   (LIST_ENTRY, 16)
    TEST_TYPE_ALIGN  (LIST_ENTRY, 8)
    TEST_FIELD_SIZE  (LIST_ENTRY, Flink, 8)
    TEST_FIELD_ALIGN (LIST_ENTRY, Flink, 8)
    TEST_FIELD_OFFSET(LIST_ENTRY, Flink, 0)
    TEST_FIELD_SIZE  (LIST_ENTRY, Blink, 8)
    TEST_FIELD_ALIGN (LIST_ENTRY, Blink, 8)
    TEST_FIELD_OFFSET(LIST_ENTRY, Blink, 8)
}

static void test_pack_LONG(void)
{
    /* LONG */
    TEST_TYPE_SIZE   (LONG, 4)
    TEST_TYPE_ALIGN  (LONG, 4)
    TEST_TYPE_SIGNED(LONG)
}

static void test_pack_LONGLONG(void)
{
    /* LONGLONG */
    TEST_TYPE_SIZE   (LONGLONG, 8)
    TEST_TYPE_ALIGN  (LONGLONG, 8)
    TEST_TYPE_SIGNED(LONGLONG)
}

static void test_pack_LUID(void)
{
    /* LUID */
    TEST_TYPE_SIZE   (LUID, 8)
    TEST_TYPE_ALIGN  (LUID, 4)
    TEST_FIELD_SIZE  (LUID, LowPart, 4)
    TEST_FIELD_ALIGN (LUID, LowPart, 4)
    TEST_FIELD_OFFSET(LUID, LowPart, 0)
    TEST_FIELD_SIZE  (LUID, HighPart, 4)
    TEST_FIELD_ALIGN (LUID, HighPart, 4)
    TEST_FIELD_OFFSET(LUID, HighPart, 4)
}

static void test_pack_LUID_AND_ATTRIBUTES(void)
{
    /* LUID_AND_ATTRIBUTES (pack 4) */
    TEST_TYPE_SIZE   (LUID_AND_ATTRIBUTES, 12)
    TEST_TYPE_ALIGN  (LUID_AND_ATTRIBUTES, 4)
    TEST_FIELD_SIZE  (LUID_AND_ATTRIBUTES, Luid, 8)
    TEST_FIELD_ALIGN (LUID_AND_ATTRIBUTES, Luid, 4)
    TEST_FIELD_OFFSET(LUID_AND_ATTRIBUTES, Luid, 0)
    TEST_FIELD_SIZE  (LUID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_ALIGN (LUID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_OFFSET(LUID_AND_ATTRIBUTES, Attributes, 8)
}

static void test_pack_MEMORY_BASIC_INFORMATION(void)
{
    /* MEMORY_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (MEMORY_BASIC_INFORMATION, 48)
    TEST_TYPE_ALIGN  (MEMORY_BASIC_INFORMATION, 8)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, BaseAddress, 8)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, BaseAddress, 8)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, BaseAddress, 0)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, AllocationBase, 8)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, AllocationBase, 8)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, AllocationBase, 8)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, AllocationProtect, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, AllocationProtect, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, AllocationProtect, 16)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, RegionSize, 8)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, RegionSize, 8)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, RegionSize, 24)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, State, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, State, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, State, 32)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, Protect, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, Protect, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, Protect, 36)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, Type, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, Type, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, Type, 40)
}

static void test_pack_MESSAGE_RESOURCE_BLOCK(void)
{
    /* MESSAGE_RESOURCE_BLOCK */
    TEST_TYPE_SIZE   (MESSAGE_RESOURCE_BLOCK, 12)
    TEST_TYPE_ALIGN  (MESSAGE_RESOURCE_BLOCK, 4)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_BLOCK, LowId, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_BLOCK, LowId, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_BLOCK, LowId, 0)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_BLOCK, HighId, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_BLOCK, HighId, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_BLOCK, HighId, 4)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_BLOCK, OffsetToEntries, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_BLOCK, OffsetToEntries, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_BLOCK, OffsetToEntries, 8)
}

static void test_pack_MESSAGE_RESOURCE_DATA(void)
{
    /* MESSAGE_RESOURCE_DATA */
    TEST_TYPE_SIZE   (MESSAGE_RESOURCE_DATA, 16)
    TEST_TYPE_ALIGN  (MESSAGE_RESOURCE_DATA, 4)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_DATA, NumberOfBlocks, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_DATA, NumberOfBlocks, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_DATA, NumberOfBlocks, 0)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_DATA, Blocks, 12)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_DATA, Blocks, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_DATA, Blocks, 4)
}

static void test_pack_MESSAGE_RESOURCE_ENTRY(void)
{
    /* MESSAGE_RESOURCE_ENTRY */
    TEST_TYPE_SIZE   (MESSAGE_RESOURCE_ENTRY, 6)
    TEST_TYPE_ALIGN  (MESSAGE_RESOURCE_ENTRY, 2)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_ENTRY, Length, 2)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_ENTRY, Length, 2)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_ENTRY, Length, 0)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_ENTRY, Flags, 2)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_ENTRY, Flags, 2)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_ENTRY, Flags, 2)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_ENTRY, Text, 1)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_ENTRY, Text, 1)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_ENTRY, Text, 4)
}

static void test_pack_NT_TIB(void)
{
    /* NT_TIB */
    TEST_FIELD_SIZE  (NT_TIB, ExceptionList, 8)
    TEST_FIELD_ALIGN (NT_TIB, ExceptionList, 8)
    TEST_FIELD_OFFSET(NT_TIB, ExceptionList, 0)
    TEST_FIELD_SIZE  (NT_TIB, StackBase, 8)
    TEST_FIELD_ALIGN (NT_TIB, StackBase, 8)
    TEST_FIELD_OFFSET(NT_TIB, StackBase, 8)
    TEST_FIELD_SIZE  (NT_TIB, StackLimit, 8)
    TEST_FIELD_ALIGN (NT_TIB, StackLimit, 8)
    TEST_FIELD_OFFSET(NT_TIB, StackLimit, 16)
    TEST_FIELD_SIZE  (NT_TIB, SubSystemTib, 8)
    TEST_FIELD_ALIGN (NT_TIB, SubSystemTib, 8)
    TEST_FIELD_OFFSET(NT_TIB, SubSystemTib, 24)
}

static void test_pack_OBJECT_TYPE_LIST(void)
{
    /* OBJECT_TYPE_LIST */
    TEST_TYPE_SIZE   (OBJECT_TYPE_LIST, 16)
    TEST_TYPE_ALIGN  (OBJECT_TYPE_LIST, 8)
    TEST_FIELD_SIZE  (OBJECT_TYPE_LIST, Level, 2)
    TEST_FIELD_ALIGN (OBJECT_TYPE_LIST, Level, 2)
    TEST_FIELD_OFFSET(OBJECT_TYPE_LIST, Level, 0)
    TEST_FIELD_SIZE  (OBJECT_TYPE_LIST, Sbz, 2)
    TEST_FIELD_ALIGN (OBJECT_TYPE_LIST, Sbz, 2)
    TEST_FIELD_OFFSET(OBJECT_TYPE_LIST, Sbz, 2)
    TEST_FIELD_SIZE  (OBJECT_TYPE_LIST, ObjectType, 8)
    TEST_FIELD_ALIGN (OBJECT_TYPE_LIST, ObjectType, 8)
    TEST_FIELD_OFFSET(OBJECT_TYPE_LIST, ObjectType, 8)
}

static void test_pack_PACCESS_ALLOWED_ACE(void)
{
    /* PACCESS_ALLOWED_ACE */
    TEST_TYPE_SIZE   (PACCESS_ALLOWED_ACE, 8)
    TEST_TYPE_ALIGN  (PACCESS_ALLOWED_ACE, 8)
    TEST_TARGET_SIZE (PACCESS_ALLOWED_ACE, 12)
    TEST_TARGET_ALIGN(PACCESS_ALLOWED_ACE, 4)
}

static void test_pack_PACCESS_DENIED_ACE(void)
{
    /* PACCESS_DENIED_ACE */
    TEST_TYPE_SIZE   (PACCESS_DENIED_ACE, 8)
    TEST_TYPE_ALIGN  (PACCESS_DENIED_ACE, 8)
    TEST_TARGET_SIZE (PACCESS_DENIED_ACE, 12)
    TEST_TARGET_ALIGN(PACCESS_DENIED_ACE, 4)
}

static void test_pack_PACCESS_TOKEN(void)
{
    /* PACCESS_TOKEN */
    TEST_TYPE_SIZE   (PACCESS_TOKEN, 8)
    TEST_TYPE_ALIGN  (PACCESS_TOKEN, 8)
}

static void test_pack_PACE_HEADER(void)
{
    /* PACE_HEADER */
    TEST_TYPE_SIZE   (PACE_HEADER, 8)
    TEST_TYPE_ALIGN  (PACE_HEADER, 8)
    TEST_TARGET_SIZE (PACE_HEADER, 4)
    TEST_TARGET_ALIGN(PACE_HEADER, 2)
}

static void test_pack_PACL(void)
{
    /* PACL */
    TEST_TYPE_SIZE   (PACL, 8)
    TEST_TYPE_ALIGN  (PACL, 8)
    TEST_TARGET_SIZE (PACL, 8)
    TEST_TARGET_ALIGN(PACL, 2)
}

static void test_pack_PACL_REVISION_INFORMATION(void)
{
    /* PACL_REVISION_INFORMATION */
    TEST_TYPE_SIZE   (PACL_REVISION_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PACL_REVISION_INFORMATION, 8)
    TEST_TARGET_SIZE (PACL_REVISION_INFORMATION, 4)
    TEST_TARGET_ALIGN(PACL_REVISION_INFORMATION, 4)
}

static void test_pack_PACL_SIZE_INFORMATION(void)
{
    /* PACL_SIZE_INFORMATION */
    TEST_TYPE_SIZE   (PACL_SIZE_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PACL_SIZE_INFORMATION, 8)
    TEST_TARGET_SIZE (PACL_SIZE_INFORMATION, 12)
    TEST_TARGET_ALIGN(PACL_SIZE_INFORMATION, 4)
}

static void test_pack_PCCH(void)
{
    /* PCCH */
    TEST_TYPE_SIZE   (PCCH, 8)
    TEST_TYPE_ALIGN  (PCCH, 8)
    TEST_TARGET_SIZE (PCCH, 1)
    TEST_TARGET_ALIGN(PCCH, 1)
}

static void test_pack_PCH(void)
{
    /* PCH */
    TEST_TYPE_SIZE   (PCH, 8)
    TEST_TYPE_ALIGN  (PCH, 8)
    TEST_TARGET_SIZE (PCH, 1)
    TEST_TARGET_ALIGN(PCH, 1)
}

static void test_pack_PCSTR(void)
{
    /* PCSTR */
    TEST_TYPE_SIZE   (PCSTR, 8)
    TEST_TYPE_ALIGN  (PCSTR, 8)
    TEST_TARGET_SIZE (PCSTR, 1)
    TEST_TARGET_ALIGN(PCSTR, 1)
}

static void test_pack_PCWCH(void)
{
    /* PCWCH */
    TEST_TYPE_SIZE   (PCWCH, 8)
    TEST_TYPE_ALIGN  (PCWCH, 8)
    TEST_TARGET_SIZE (PCWCH, 2)
    TEST_TARGET_ALIGN(PCWCH, 2)
}

static void test_pack_PCWSTR(void)
{
    /* PCWSTR */
    TEST_TYPE_SIZE   (PCWSTR, 8)
    TEST_TYPE_ALIGN  (PCWSTR, 8)
    TEST_TARGET_SIZE (PCWSTR, 2)
    TEST_TARGET_ALIGN(PCWSTR, 2)
}

static void test_pack_PEXCEPTION_POINTERS(void)
{
    /* PEXCEPTION_POINTERS */
    TEST_TYPE_SIZE   (PEXCEPTION_POINTERS, 8)
    TEST_TYPE_ALIGN  (PEXCEPTION_POINTERS, 8)
    TEST_TARGET_SIZE (PEXCEPTION_POINTERS, 16)
    TEST_TARGET_ALIGN(PEXCEPTION_POINTERS, 8)
}

static void test_pack_PEXCEPTION_RECORD(void)
{
    /* PEXCEPTION_RECORD */
    TEST_TYPE_SIZE   (PEXCEPTION_RECORD, 8)
    TEST_TYPE_ALIGN  (PEXCEPTION_RECORD, 8)
    TEST_TARGET_SIZE (PEXCEPTION_RECORD, 152)
    TEST_TARGET_ALIGN(PEXCEPTION_RECORD, 8)
}

static void test_pack_PFPO_DATA(void)
{
    /* PFPO_DATA */
    TEST_TYPE_SIZE   (PFPO_DATA, 8)
    TEST_TYPE_ALIGN  (PFPO_DATA, 8)
    TEST_TARGET_SIZE (PFPO_DATA, 16)
    TEST_TARGET_ALIGN(PFPO_DATA, 4)
}

static void test_pack_PGENERIC_MAPPING(void)
{
    /* PGENERIC_MAPPING */
    TEST_TYPE_SIZE   (PGENERIC_MAPPING, 8)
    TEST_TYPE_ALIGN  (PGENERIC_MAPPING, 8)
    TEST_TARGET_SIZE (PGENERIC_MAPPING, 16)
    TEST_TARGET_ALIGN(PGENERIC_MAPPING, 4)
}

static void test_pack_PHANDLE(void)
{
    /* PHANDLE */
    TEST_TYPE_SIZE   (PHANDLE, 8)
    TEST_TYPE_ALIGN  (PHANDLE, 8)
    TEST_TARGET_SIZE (PHANDLE, 8)
    TEST_TARGET_ALIGN(PHANDLE, 8)
}

static void test_pack_PIMAGE_ARCHIVE_MEMBER_HEADER(void)
{
    /* PIMAGE_ARCHIVE_MEMBER_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_ARCHIVE_MEMBER_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_ARCHIVE_MEMBER_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_ARCHIVE_MEMBER_HEADER, 60)
    TEST_TARGET_ALIGN(PIMAGE_ARCHIVE_MEMBER_HEADER, 1)
}

static void test_pack_PIMAGE_AUX_SYMBOL(void)
{
    /* PIMAGE_AUX_SYMBOL */
    TEST_TYPE_SIZE   (PIMAGE_AUX_SYMBOL, 8)
    TEST_TYPE_ALIGN  (PIMAGE_AUX_SYMBOL, 8)
}

static void test_pack_PIMAGE_BASE_RELOCATION(void)
{
    /* PIMAGE_BASE_RELOCATION */
    TEST_TYPE_SIZE   (PIMAGE_BASE_RELOCATION, 8)
    TEST_TYPE_ALIGN  (PIMAGE_BASE_RELOCATION, 8)
    TEST_TARGET_SIZE (PIMAGE_BASE_RELOCATION, 8)
    TEST_TARGET_ALIGN(PIMAGE_BASE_RELOCATION, 4)
}

static void test_pack_PIMAGE_BOUND_FORWARDER_REF(void)
{
    /* PIMAGE_BOUND_FORWARDER_REF */
    TEST_TYPE_SIZE   (PIMAGE_BOUND_FORWARDER_REF, 8)
    TEST_TYPE_ALIGN  (PIMAGE_BOUND_FORWARDER_REF, 8)
    TEST_TARGET_SIZE (PIMAGE_BOUND_FORWARDER_REF, 8)
    TEST_TARGET_ALIGN(PIMAGE_BOUND_FORWARDER_REF, 4)
}

static void test_pack_PIMAGE_BOUND_IMPORT_DESCRIPTOR(void)
{
    /* PIMAGE_BOUND_IMPORT_DESCRIPTOR */
    TEST_TYPE_SIZE   (PIMAGE_BOUND_IMPORT_DESCRIPTOR, 8)
    TEST_TYPE_ALIGN  (PIMAGE_BOUND_IMPORT_DESCRIPTOR, 8)
    TEST_TARGET_SIZE (PIMAGE_BOUND_IMPORT_DESCRIPTOR, 8)
    TEST_TARGET_ALIGN(PIMAGE_BOUND_IMPORT_DESCRIPTOR, 4)
}

static void test_pack_PIMAGE_COFF_SYMBOLS_HEADER(void)
{
    /* PIMAGE_COFF_SYMBOLS_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_COFF_SYMBOLS_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_COFF_SYMBOLS_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_COFF_SYMBOLS_HEADER, 32)
    TEST_TARGET_ALIGN(PIMAGE_COFF_SYMBOLS_HEADER, 4)
}

static void test_pack_PIMAGE_DATA_DIRECTORY(void)
{
    /* PIMAGE_DATA_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_DATA_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_DATA_DIRECTORY, 8)
    TEST_TARGET_SIZE (PIMAGE_DATA_DIRECTORY, 8)
    TEST_TARGET_ALIGN(PIMAGE_DATA_DIRECTORY, 4)
}

static void test_pack_PIMAGE_DEBUG_DIRECTORY(void)
{
    /* PIMAGE_DEBUG_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_DEBUG_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_DEBUG_DIRECTORY, 8)
    TEST_TARGET_SIZE (PIMAGE_DEBUG_DIRECTORY, 28)
    TEST_TARGET_ALIGN(PIMAGE_DEBUG_DIRECTORY, 4)
}

static void test_pack_PIMAGE_DEBUG_MISC(void)
{
    /* PIMAGE_DEBUG_MISC */
    TEST_TYPE_SIZE   (PIMAGE_DEBUG_MISC, 8)
    TEST_TYPE_ALIGN  (PIMAGE_DEBUG_MISC, 8)
    TEST_TARGET_SIZE (PIMAGE_DEBUG_MISC, 16)
    TEST_TARGET_ALIGN(PIMAGE_DEBUG_MISC, 4)
}

static void test_pack_PIMAGE_DOS_HEADER(void)
{
    /* PIMAGE_DOS_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_DOS_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_DOS_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_DOS_HEADER, 64)
    TEST_TARGET_ALIGN(PIMAGE_DOS_HEADER, 2)
}

static void test_pack_PIMAGE_EXPORT_DIRECTORY(void)
{
    /* PIMAGE_EXPORT_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_EXPORT_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_EXPORT_DIRECTORY, 8)
    TEST_TARGET_SIZE (PIMAGE_EXPORT_DIRECTORY, 40)
    TEST_TARGET_ALIGN(PIMAGE_EXPORT_DIRECTORY, 4)
}

static void test_pack_PIMAGE_FILE_HEADER(void)
{
    /* PIMAGE_FILE_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_FILE_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_FILE_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_FILE_HEADER, 20)
    TEST_TARGET_ALIGN(PIMAGE_FILE_HEADER, 4)
}

static void test_pack_PIMAGE_FUNCTION_ENTRY(void)
{
    /* PIMAGE_FUNCTION_ENTRY */
    TEST_TYPE_SIZE   (PIMAGE_FUNCTION_ENTRY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_FUNCTION_ENTRY, 8)
    TEST_TARGET_SIZE (PIMAGE_FUNCTION_ENTRY, 12)
    TEST_TARGET_ALIGN(PIMAGE_FUNCTION_ENTRY, 4)
}

static void test_pack_PIMAGE_IMPORT_BY_NAME(void)
{
    /* PIMAGE_IMPORT_BY_NAME */
    TEST_TYPE_SIZE   (PIMAGE_IMPORT_BY_NAME, 8)
    TEST_TYPE_ALIGN  (PIMAGE_IMPORT_BY_NAME, 8)
    TEST_TARGET_SIZE (PIMAGE_IMPORT_BY_NAME, 4)
    TEST_TARGET_ALIGN(PIMAGE_IMPORT_BY_NAME, 2)
}

static void test_pack_PIMAGE_IMPORT_DESCRIPTOR(void)
{
    /* PIMAGE_IMPORT_DESCRIPTOR */
    TEST_TYPE_SIZE   (PIMAGE_IMPORT_DESCRIPTOR, 8)
    TEST_TYPE_ALIGN  (PIMAGE_IMPORT_DESCRIPTOR, 8)
}

static void test_pack_PIMAGE_LINENUMBER(void)
{
    /* PIMAGE_LINENUMBER */
    TEST_TYPE_SIZE   (PIMAGE_LINENUMBER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_LINENUMBER, 8)
}

static void test_pack_PIMAGE_LOAD_CONFIG_DIRECTORY(void)
{
    /* PIMAGE_LOAD_CONFIG_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_LOAD_CONFIG_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_LOAD_CONFIG_DIRECTORY, 8)
    TEST_TARGET_SIZE (PIMAGE_LOAD_CONFIG_DIRECTORY, 88)
    TEST_TARGET_ALIGN(PIMAGE_LOAD_CONFIG_DIRECTORY, 8)
}

static void test_pack_PIMAGE_NT_HEADERS(void)
{
    /* PIMAGE_NT_HEADERS */
    TEST_TYPE_SIZE   (PIMAGE_NT_HEADERS, 8)
    TEST_TYPE_ALIGN  (PIMAGE_NT_HEADERS, 8)
}

static void test_pack_PIMAGE_NT_HEADERS32(void)
{
    /* PIMAGE_NT_HEADERS32 */
    TEST_TYPE_SIZE   (PIMAGE_NT_HEADERS32, 8)
    TEST_TYPE_ALIGN  (PIMAGE_NT_HEADERS32, 8)
    TEST_TARGET_SIZE (PIMAGE_NT_HEADERS32, 248)
    TEST_TARGET_ALIGN(PIMAGE_NT_HEADERS32, 4)
}

static void test_pack_PIMAGE_NT_HEADERS64(void)
{
    /* PIMAGE_NT_HEADERS64 */
    TEST_TYPE_SIZE   (PIMAGE_NT_HEADERS64, 8)
    TEST_TYPE_ALIGN  (PIMAGE_NT_HEADERS64, 8)
    TEST_TARGET_SIZE (PIMAGE_NT_HEADERS64, 264)
    TEST_TARGET_ALIGN(PIMAGE_NT_HEADERS64, 8)
}

static void test_pack_PIMAGE_OPTIONAL_HEADER(void)
{
    /* PIMAGE_OPTIONAL_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_OPTIONAL_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_OPTIONAL_HEADER, 8)
}

static void test_pack_PIMAGE_OPTIONAL_HEADER32(void)
{
    /* PIMAGE_OPTIONAL_HEADER32 */
    TEST_TYPE_SIZE   (PIMAGE_OPTIONAL_HEADER32, 8)
    TEST_TYPE_ALIGN  (PIMAGE_OPTIONAL_HEADER32, 8)
    TEST_TARGET_SIZE (PIMAGE_OPTIONAL_HEADER32, 224)
    TEST_TARGET_ALIGN(PIMAGE_OPTIONAL_HEADER32, 4)
}

static void test_pack_PIMAGE_OPTIONAL_HEADER64(void)
{
    /* PIMAGE_OPTIONAL_HEADER64 */
    TEST_TYPE_SIZE   (PIMAGE_OPTIONAL_HEADER64, 8)
    TEST_TYPE_ALIGN  (PIMAGE_OPTIONAL_HEADER64, 8)
    TEST_TARGET_SIZE (PIMAGE_OPTIONAL_HEADER64, 240)
    TEST_TARGET_ALIGN(PIMAGE_OPTIONAL_HEADER64, 8)
}

static void test_pack_PIMAGE_OS2_HEADER(void)
{
    /* PIMAGE_OS2_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_OS2_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_OS2_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_OS2_HEADER, 64)
    TEST_TARGET_ALIGN(PIMAGE_OS2_HEADER, 2)
}

static void test_pack_PIMAGE_RELOCATION(void)
{
    /* PIMAGE_RELOCATION */
    TEST_TYPE_SIZE   (PIMAGE_RELOCATION, 8)
    TEST_TYPE_ALIGN  (PIMAGE_RELOCATION, 8)
}

static void test_pack_PIMAGE_RESOURCE_DATA_ENTRY(void)
{
    /* PIMAGE_RESOURCE_DATA_ENTRY */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DATA_ENTRY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DATA_ENTRY, 8)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DATA_ENTRY, 16)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DATA_ENTRY, 4)
}

static void test_pack_PIMAGE_RESOURCE_DIRECTORY(void)
{
    /* PIMAGE_RESOURCE_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIRECTORY, 8)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DIRECTORY, 16)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DIRECTORY, 4)
}

static void test_pack_PIMAGE_RESOURCE_DIRECTORY_ENTRY(void)
{
    /* PIMAGE_RESOURCE_DIRECTORY_ENTRY */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIRECTORY_ENTRY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIRECTORY_ENTRY, 8)
}

static void test_pack_PIMAGE_RESOURCE_DIRECTORY_STRING(void)
{
    /* PIMAGE_RESOURCE_DIRECTORY_STRING */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIRECTORY_STRING, 8)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIRECTORY_STRING, 8)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DIRECTORY_STRING, 4)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DIRECTORY_STRING, 2)
}

static void test_pack_PIMAGE_RESOURCE_DIR_STRING_U(void)
{
    /* PIMAGE_RESOURCE_DIR_STRING_U */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIR_STRING_U, 8)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIR_STRING_U, 8)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DIR_STRING_U, 4)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DIR_STRING_U, 2)
}

static void test_pack_PIMAGE_SECTION_HEADER(void)
{
    /* PIMAGE_SECTION_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_SECTION_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_SECTION_HEADER, 8)
}

static void test_pack_PIMAGE_SEPARATE_DEBUG_HEADER(void)
{
    /* PIMAGE_SEPARATE_DEBUG_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_SEPARATE_DEBUG_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_SEPARATE_DEBUG_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_SEPARATE_DEBUG_HEADER, 48)
    TEST_TARGET_ALIGN(PIMAGE_SEPARATE_DEBUG_HEADER, 4)
}

static void test_pack_PIMAGE_SYMBOL(void)
{
    /* PIMAGE_SYMBOL */
    TEST_TYPE_SIZE   (PIMAGE_SYMBOL, 8)
    TEST_TYPE_ALIGN  (PIMAGE_SYMBOL, 8)
}

static void test_pack_PIMAGE_THUNK_DATA(void)
{
    /* PIMAGE_THUNK_DATA */
    TEST_TYPE_SIZE   (PIMAGE_THUNK_DATA, 8)
    TEST_TYPE_ALIGN  (PIMAGE_THUNK_DATA, 8)
}

static void test_pack_PIMAGE_TLS_CALLBACK(void)
{
    /* PIMAGE_TLS_CALLBACK */
    TEST_TYPE_SIZE   (PIMAGE_TLS_CALLBACK, 8)
    TEST_TYPE_ALIGN  (PIMAGE_TLS_CALLBACK, 8)
}

static void test_pack_PIMAGE_TLS_DIRECTORY(void)
{
    /* PIMAGE_TLS_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_TLS_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (PIMAGE_TLS_DIRECTORY, 8)
}

static void test_pack_PIMAGE_VXD_HEADER(void)
{
    /* PIMAGE_VXD_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_VXD_HEADER, 8)
    TEST_TYPE_ALIGN  (PIMAGE_VXD_HEADER, 8)
    TEST_TARGET_SIZE (PIMAGE_VXD_HEADER, 196)
    TEST_TARGET_ALIGN(PIMAGE_VXD_HEADER, 2)
}

static void test_pack_PIO_COUNTERS(void)
{
    /* PIO_COUNTERS */
    TEST_TYPE_SIZE   (PIO_COUNTERS, 8)
    TEST_TYPE_ALIGN  (PIO_COUNTERS, 8)
    TEST_TARGET_SIZE (PIO_COUNTERS, 48)
    TEST_TARGET_ALIGN(PIO_COUNTERS, 8)
}

static void test_pack_PISECURITY_DESCRIPTOR(void)
{
    /* PISECURITY_DESCRIPTOR */
    TEST_TYPE_SIZE   (PISECURITY_DESCRIPTOR, 8)
    TEST_TYPE_ALIGN  (PISECURITY_DESCRIPTOR, 8)
    TEST_TARGET_SIZE (PISECURITY_DESCRIPTOR, 40)
    TEST_TARGET_ALIGN(PISECURITY_DESCRIPTOR, 8)
}

static void test_pack_PISECURITY_DESCRIPTOR_RELATIVE(void)
{
    /* PISECURITY_DESCRIPTOR_RELATIVE */
    TEST_TYPE_SIZE   (PISECURITY_DESCRIPTOR_RELATIVE, 8)
    TEST_TYPE_ALIGN  (PISECURITY_DESCRIPTOR_RELATIVE, 8)
    TEST_TARGET_SIZE (PISECURITY_DESCRIPTOR_RELATIVE, 20)
    TEST_TARGET_ALIGN(PISECURITY_DESCRIPTOR_RELATIVE, 4)
}

static void test_pack_PISID(void)
{
    /* PISID */
    TEST_TYPE_SIZE   (PISID, 8)
    TEST_TYPE_ALIGN  (PISID, 8)
    TEST_TARGET_SIZE (PISID, 12)
    TEST_TARGET_ALIGN(PISID, 4)
}

static void test_pack_PLARGE_INTEGER(void)
{
    /* PLARGE_INTEGER */
    TEST_TYPE_SIZE   (PLARGE_INTEGER, 8)
    TEST_TYPE_ALIGN  (PLARGE_INTEGER, 8)
}

static void test_pack_PLIST_ENTRY(void)
{
    /* PLIST_ENTRY */
    TEST_TYPE_SIZE   (PLIST_ENTRY, 8)
    TEST_TYPE_ALIGN  (PLIST_ENTRY, 8)
    TEST_TARGET_SIZE (PLIST_ENTRY, 16)
    TEST_TARGET_ALIGN(PLIST_ENTRY, 8)
}

static void test_pack_PLUID(void)
{
    /* PLUID */
    TEST_TYPE_SIZE   (PLUID, 8)
    TEST_TYPE_ALIGN  (PLUID, 8)
    TEST_TARGET_SIZE (PLUID, 8)
    TEST_TARGET_ALIGN(PLUID, 4)
}

static void test_pack_PLUID_AND_ATTRIBUTES(void)
{
    /* PLUID_AND_ATTRIBUTES */
    TEST_TYPE_SIZE   (PLUID_AND_ATTRIBUTES, 8)
    TEST_TYPE_ALIGN  (PLUID_AND_ATTRIBUTES, 8)
    TEST_TARGET_SIZE (PLUID_AND_ATTRIBUTES, 12)
    TEST_TARGET_ALIGN(PLUID_AND_ATTRIBUTES, 4)
}

static void test_pack_PMEMORY_BASIC_INFORMATION(void)
{
    /* PMEMORY_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (PMEMORY_BASIC_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PMEMORY_BASIC_INFORMATION, 8)
    TEST_TARGET_SIZE (PMEMORY_BASIC_INFORMATION, 48)
    TEST_TARGET_ALIGN(PMEMORY_BASIC_INFORMATION, 8)
}

static void test_pack_PMESSAGE_RESOURCE_BLOCK(void)
{
    /* PMESSAGE_RESOURCE_BLOCK */
    TEST_TYPE_SIZE   (PMESSAGE_RESOURCE_BLOCK, 8)
    TEST_TYPE_ALIGN  (PMESSAGE_RESOURCE_BLOCK, 8)
    TEST_TARGET_SIZE (PMESSAGE_RESOURCE_BLOCK, 12)
    TEST_TARGET_ALIGN(PMESSAGE_RESOURCE_BLOCK, 4)
}

static void test_pack_PMESSAGE_RESOURCE_DATA(void)
{
    /* PMESSAGE_RESOURCE_DATA */
    TEST_TYPE_SIZE   (PMESSAGE_RESOURCE_DATA, 8)
    TEST_TYPE_ALIGN  (PMESSAGE_RESOURCE_DATA, 8)
    TEST_TARGET_SIZE (PMESSAGE_RESOURCE_DATA, 16)
    TEST_TARGET_ALIGN(PMESSAGE_RESOURCE_DATA, 4)
}

static void test_pack_PMESSAGE_RESOURCE_ENTRY(void)
{
    /* PMESSAGE_RESOURCE_ENTRY */
    TEST_TYPE_SIZE   (PMESSAGE_RESOURCE_ENTRY, 8)
    TEST_TYPE_ALIGN  (PMESSAGE_RESOURCE_ENTRY, 8)
    TEST_TARGET_SIZE (PMESSAGE_RESOURCE_ENTRY, 6)
    TEST_TARGET_ALIGN(PMESSAGE_RESOURCE_ENTRY, 2)
}

static void test_pack_PNT_TIB(void)
{
    /* PNT_TIB */
    TEST_TYPE_SIZE   (PNT_TIB, 8)
    TEST_TYPE_ALIGN  (PNT_TIB, 8)
}

static void test_pack_POBJECT_TYPE_LIST(void)
{
    /* POBJECT_TYPE_LIST */
    TEST_TYPE_SIZE   (POBJECT_TYPE_LIST, 8)
    TEST_TYPE_ALIGN  (POBJECT_TYPE_LIST, 8)
    TEST_TARGET_SIZE (POBJECT_TYPE_LIST, 16)
    TEST_TARGET_ALIGN(POBJECT_TYPE_LIST, 8)
}

static void test_pack_PPRIVILEGE_SET(void)
{
    /* PPRIVILEGE_SET */
    TEST_TYPE_SIZE   (PPRIVILEGE_SET, 8)
    TEST_TYPE_ALIGN  (PPRIVILEGE_SET, 8)
    TEST_TARGET_SIZE (PPRIVILEGE_SET, 20)
    TEST_TARGET_ALIGN(PPRIVILEGE_SET, 4)
}

static void test_pack_PRIVILEGE_SET(void)
{
    /* PRIVILEGE_SET */
    TEST_TYPE_SIZE   (PRIVILEGE_SET, 20)
    TEST_TYPE_ALIGN  (PRIVILEGE_SET, 4)
    TEST_FIELD_SIZE  (PRIVILEGE_SET, PrivilegeCount, 4)
    TEST_FIELD_ALIGN (PRIVILEGE_SET, PrivilegeCount, 4)
    TEST_FIELD_OFFSET(PRIVILEGE_SET, PrivilegeCount, 0)
    TEST_FIELD_SIZE  (PRIVILEGE_SET, Control, 4)
    TEST_FIELD_ALIGN (PRIVILEGE_SET, Control, 4)
    TEST_FIELD_OFFSET(PRIVILEGE_SET, Control, 4)
    TEST_FIELD_SIZE  (PRIVILEGE_SET, Privilege, 12)
    TEST_FIELD_ALIGN (PRIVILEGE_SET, Privilege, 4)
    TEST_FIELD_OFFSET(PRIVILEGE_SET, Privilege, 8)
}

static void test_pack_PRLIST_ENTRY(void)
{
    /* PRLIST_ENTRY */
    TEST_TYPE_SIZE   (PRLIST_ENTRY, 8)
    TEST_TYPE_ALIGN  (PRLIST_ENTRY, 8)
    TEST_TARGET_SIZE (PRLIST_ENTRY, 16)
    TEST_TARGET_ALIGN(PRLIST_ENTRY, 8)
}

static void test_pack_PRTL_CRITICAL_SECTION(void)
{
    /* PRTL_CRITICAL_SECTION */
    TEST_TYPE_SIZE   (PRTL_CRITICAL_SECTION, 8)
    TEST_TYPE_ALIGN  (PRTL_CRITICAL_SECTION, 8)
    TEST_TARGET_SIZE (PRTL_CRITICAL_SECTION, 40)
    TEST_TARGET_ALIGN(PRTL_CRITICAL_SECTION, 8)
}

static void test_pack_PRTL_CRITICAL_SECTION_DEBUG(void)
{
    /* PRTL_CRITICAL_SECTION_DEBUG */
    TEST_TYPE_SIZE   (PRTL_CRITICAL_SECTION_DEBUG, 8)
    TEST_TYPE_ALIGN  (PRTL_CRITICAL_SECTION_DEBUG, 8)
}

static void test_pack_PRTL_OSVERSIONINFOEXW(void)
{
    /* PRTL_OSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (PRTL_OSVERSIONINFOEXW, 8)
    TEST_TYPE_ALIGN  (PRTL_OSVERSIONINFOEXW, 8)
    TEST_TARGET_SIZE (PRTL_OSVERSIONINFOEXW, 284)
    TEST_TARGET_ALIGN(PRTL_OSVERSIONINFOEXW, 4)
}

static void test_pack_PRTL_OSVERSIONINFOW(void)
{
    /* PRTL_OSVERSIONINFOW */
    TEST_TYPE_SIZE   (PRTL_OSVERSIONINFOW, 8)
    TEST_TYPE_ALIGN  (PRTL_OSVERSIONINFOW, 8)
    TEST_TARGET_SIZE (PRTL_OSVERSIONINFOW, 276)
    TEST_TARGET_ALIGN(PRTL_OSVERSIONINFOW, 4)
}

static void test_pack_PRTL_RESOURCE_DEBUG(void)
{
    /* PRTL_RESOURCE_DEBUG */
    TEST_TYPE_SIZE   (PRTL_RESOURCE_DEBUG, 8)
    TEST_TYPE_ALIGN  (PRTL_RESOURCE_DEBUG, 8)
}

static void test_pack_PSECURITY_DESCRIPTOR(void)
{
    /* PSECURITY_DESCRIPTOR */
    TEST_TYPE_SIZE   (PSECURITY_DESCRIPTOR, 8)
    TEST_TYPE_ALIGN  (PSECURITY_DESCRIPTOR, 8)
}

static void test_pack_PSECURITY_QUALITY_OF_SERVICE(void)
{
    /* PSECURITY_QUALITY_OF_SERVICE */
    TEST_TYPE_SIZE   (PSECURITY_QUALITY_OF_SERVICE, 8)
    TEST_TYPE_ALIGN  (PSECURITY_QUALITY_OF_SERVICE, 8)
}

static void test_pack_PSID(void)
{
    /* PSID */
    TEST_TYPE_SIZE   (PSID, 8)
    TEST_TYPE_ALIGN  (PSID, 8)
}

static void test_pack_PSID_IDENTIFIER_AUTHORITY(void)
{
    /* PSID_IDENTIFIER_AUTHORITY */
    TEST_TYPE_SIZE   (PSID_IDENTIFIER_AUTHORITY, 8)
    TEST_TYPE_ALIGN  (PSID_IDENTIFIER_AUTHORITY, 8)
    TEST_TARGET_SIZE (PSID_IDENTIFIER_AUTHORITY, 6)
    TEST_TARGET_ALIGN(PSID_IDENTIFIER_AUTHORITY, 1)
}

static void test_pack_PSINGLE_LIST_ENTRY(void)
{
    /* PSINGLE_LIST_ENTRY */
    TEST_TYPE_SIZE   (PSINGLE_LIST_ENTRY, 8)
    TEST_TYPE_ALIGN  (PSINGLE_LIST_ENTRY, 8)
    TEST_TARGET_SIZE (PSINGLE_LIST_ENTRY, 8)
    TEST_TARGET_ALIGN(PSINGLE_LIST_ENTRY, 8)
}

static void test_pack_PSTR(void)
{
    /* PSTR */
    TEST_TYPE_SIZE   (PSTR, 8)
    TEST_TYPE_ALIGN  (PSTR, 8)
    TEST_TARGET_SIZE (PSTR, 1)
    TEST_TARGET_ALIGN(PSTR, 1)
}

static void test_pack_PSYSTEM_ALARM_ACE(void)
{
    /* PSYSTEM_ALARM_ACE */
    TEST_TYPE_SIZE   (PSYSTEM_ALARM_ACE, 8)
    TEST_TYPE_ALIGN  (PSYSTEM_ALARM_ACE, 8)
    TEST_TARGET_SIZE (PSYSTEM_ALARM_ACE, 12)
    TEST_TARGET_ALIGN(PSYSTEM_ALARM_ACE, 4)
}

static void test_pack_PSYSTEM_AUDIT_ACE(void)
{
    /* PSYSTEM_AUDIT_ACE */
    TEST_TYPE_SIZE   (PSYSTEM_AUDIT_ACE, 8)
    TEST_TYPE_ALIGN  (PSYSTEM_AUDIT_ACE, 8)
    TEST_TARGET_SIZE (PSYSTEM_AUDIT_ACE, 12)
    TEST_TARGET_ALIGN(PSYSTEM_AUDIT_ACE, 4)
}

static void test_pack_PTOKEN_GROUPS(void)
{
    /* PTOKEN_GROUPS */
    TEST_TYPE_SIZE   (PTOKEN_GROUPS, 8)
    TEST_TYPE_ALIGN  (PTOKEN_GROUPS, 8)
    TEST_TARGET_SIZE (PTOKEN_GROUPS, 24)
    TEST_TARGET_ALIGN(PTOKEN_GROUPS, 8)
}

static void test_pack_PTOKEN_PRIVILEGES(void)
{
    /* PTOKEN_PRIVILEGES */
    TEST_TYPE_SIZE   (PTOKEN_PRIVILEGES, 8)
    TEST_TYPE_ALIGN  (PTOKEN_PRIVILEGES, 8)
    TEST_TARGET_SIZE (PTOKEN_PRIVILEGES, 16)
    TEST_TARGET_ALIGN(PTOKEN_PRIVILEGES, 4)
}

static void test_pack_PTOKEN_USER(void)
{
    /* PTOKEN_USER */
    TEST_TYPE_SIZE   (PTOKEN_USER, 8)
    TEST_TYPE_ALIGN  (PTOKEN_USER, 8)
    TEST_TARGET_SIZE (PTOKEN_USER, 16)
    TEST_TARGET_ALIGN(PTOKEN_USER, 8)
}

static void test_pack_PULARGE_INTEGER(void)
{
    /* PULARGE_INTEGER */
    TEST_TYPE_SIZE   (PULARGE_INTEGER, 8)
    TEST_TYPE_ALIGN  (PULARGE_INTEGER, 8)
}

static void test_pack_PVECTORED_EXCEPTION_HANDLER(void)
{
    /* PVECTORED_EXCEPTION_HANDLER */
    TEST_TYPE_SIZE   (PVECTORED_EXCEPTION_HANDLER, 8)
    TEST_TYPE_ALIGN  (PVECTORED_EXCEPTION_HANDLER, 8)
}

static void test_pack_PVOID(void)
{
    /* PVOID */
    TEST_TYPE_SIZE   (PVOID, 8)
    TEST_TYPE_ALIGN  (PVOID, 8)
}

static void test_pack_PWCH(void)
{
    /* PWCH */
    TEST_TYPE_SIZE   (PWCH, 8)
    TEST_TYPE_ALIGN  (PWCH, 8)
    TEST_TARGET_SIZE (PWCH, 2)
    TEST_TARGET_ALIGN(PWCH, 2)
}

static void test_pack_PWSTR(void)
{
    /* PWSTR */
    TEST_TYPE_SIZE   (PWSTR, 8)
    TEST_TYPE_ALIGN  (PWSTR, 8)
    TEST_TARGET_SIZE (PWSTR, 2)
    TEST_TARGET_ALIGN(PWSTR, 2)
}

static void test_pack_RTL_CRITICAL_SECTION(void)
{
    /* RTL_CRITICAL_SECTION */
    TEST_TYPE_SIZE   (RTL_CRITICAL_SECTION, 40)
    TEST_TYPE_ALIGN  (RTL_CRITICAL_SECTION, 8)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, DebugInfo, 8)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, DebugInfo, 8)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, DebugInfo, 0)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, LockCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, LockCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, LockCount, 8)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, RecursionCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, RecursionCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, RecursionCount, 12)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, OwningThread, 8)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, OwningThread, 8)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, OwningThread, 16)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, LockSemaphore, 8)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, LockSemaphore, 8)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, LockSemaphore, 24)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, SpinCount, 8)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, SpinCount, 8)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, SpinCount, 32)
}

static void test_pack_RTL_CRITICAL_SECTION_DEBUG(void)
{
    /* RTL_CRITICAL_SECTION_DEBUG */
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, Type, 2)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, Type, 2)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, Type, 0)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, CriticalSection, 8)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, CriticalSection, 8)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, CriticalSection, 8)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, ProcessLocksList, 16)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, ProcessLocksList, 8)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, ProcessLocksList, 16)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, EntryCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, EntryCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, EntryCount, 32)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, ContentionCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, ContentionCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, ContentionCount, 36)
}

static void test_pack_RTL_OSVERSIONINFOEXW(void)
{
    /* RTL_OSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (RTL_OSVERSIONINFOEXW, 284)
    TEST_TYPE_ALIGN  (RTL_OSVERSIONINFOEXW, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, szCSDVersion, 20)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wServicePackMajor, 276)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wServicePackMinor, 278)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wSuiteMask, 280)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wProductType, 282)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wReserved, 283)
}

static void test_pack_RTL_OSVERSIONINFOW(void)
{
    /* RTL_OSVERSIONINFOW */
    TEST_TYPE_SIZE   (RTL_OSVERSIONINFOW, 276)
    TEST_TYPE_ALIGN  (RTL_OSVERSIONINFOW, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, szCSDVersion, 20)
}

static void test_pack_RTL_RESOURCE_DEBUG(void)
{
    /* RTL_RESOURCE_DEBUG */
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, Type, 2)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, Type, 2)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, Type, 0)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, CriticalSection, 8)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, CriticalSection, 8)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, CriticalSection, 8)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, ProcessLocksList, 16)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, ProcessLocksList, 8)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, ProcessLocksList, 16)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, EntryCount, 4)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, EntryCount, 4)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, EntryCount, 32)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, ContentionCount, 4)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, ContentionCount, 4)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, ContentionCount, 36)
}

static void test_pack_SECURITY_CONTEXT_TRACKING_MODE(void)
{
    /* SECURITY_CONTEXT_TRACKING_MODE */
    TEST_TYPE_SIZE   (SECURITY_CONTEXT_TRACKING_MODE, 1)
    TEST_TYPE_ALIGN  (SECURITY_CONTEXT_TRACKING_MODE, 1)
}

static void test_pack_SECURITY_DESCRIPTOR(void)
{
    /* SECURITY_DESCRIPTOR */
    TEST_TYPE_SIZE   (SECURITY_DESCRIPTOR, 40)
    TEST_TYPE_ALIGN  (SECURITY_DESCRIPTOR, 8)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Revision, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Revision, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Revision, 0)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Sbz1, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Sbz1, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Sbz1, 1)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Control, 2)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Control, 2)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Control, 2)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Owner, 8)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Owner, 8)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Owner, 8)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Group, 8)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Group, 8)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Group, 16)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Sacl, 8)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Sacl, 8)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Sacl, 24)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Dacl, 8)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Dacl, 8)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Dacl, 32)
}

static void test_pack_SECURITY_DESCRIPTOR_CONTROL(void)
{
    /* SECURITY_DESCRIPTOR_CONTROL */
    TEST_TYPE_SIZE   (SECURITY_DESCRIPTOR_CONTROL, 2)
    TEST_TYPE_ALIGN  (SECURITY_DESCRIPTOR_CONTROL, 2)
    TEST_TYPE_UNSIGNED(SECURITY_DESCRIPTOR_CONTROL)
}

static void test_pack_SECURITY_DESCRIPTOR_RELATIVE(void)
{
    /* SECURITY_DESCRIPTOR_RELATIVE */
    TEST_TYPE_SIZE   (SECURITY_DESCRIPTOR_RELATIVE, 20)
    TEST_TYPE_ALIGN  (SECURITY_DESCRIPTOR_RELATIVE, 4)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Revision, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Revision, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Revision, 0)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Sbz1, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Sbz1, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Sbz1, 1)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Control, 2)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Control, 2)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Control, 2)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Owner, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Owner, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Owner, 4)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Group, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Group, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Group, 8)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Sacl, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Sacl, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Sacl, 12)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Dacl, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Dacl, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Dacl, 16)
}

static void test_pack_SECURITY_INFORMATION(void)
{
    /* SECURITY_INFORMATION */
    TEST_TYPE_SIZE   (SECURITY_INFORMATION, 4)
    TEST_TYPE_ALIGN  (SECURITY_INFORMATION, 4)
    TEST_TYPE_UNSIGNED(SECURITY_INFORMATION)
}

static void test_pack_SECURITY_QUALITY_OF_SERVICE(void)
{
    /* SECURITY_QUALITY_OF_SERVICE */
    TEST_FIELD_SIZE  (SECURITY_QUALITY_OF_SERVICE, Length, 4)
    TEST_FIELD_ALIGN (SECURITY_QUALITY_OF_SERVICE, Length, 4)
    TEST_FIELD_OFFSET(SECURITY_QUALITY_OF_SERVICE, Length, 0)
}

static void test_pack_SHORT(void)
{
    /* SHORT */
    TEST_TYPE_SIZE   (SHORT, 2)
    TEST_TYPE_ALIGN  (SHORT, 2)
    TEST_TYPE_SIGNED(SHORT)
}

static void test_pack_SID(void)
{
    /* SID */
    TEST_TYPE_SIZE   (SID, 12)
    TEST_TYPE_ALIGN  (SID, 4)
    TEST_FIELD_SIZE  (SID, Revision, 1)
    TEST_FIELD_ALIGN (SID, Revision, 1)
    TEST_FIELD_OFFSET(SID, Revision, 0)
    TEST_FIELD_SIZE  (SID, SubAuthorityCount, 1)
    TEST_FIELD_ALIGN (SID, SubAuthorityCount, 1)
    TEST_FIELD_OFFSET(SID, SubAuthorityCount, 1)
    TEST_FIELD_SIZE  (SID, IdentifierAuthority, 6)
    TEST_FIELD_ALIGN (SID, IdentifierAuthority, 1)
    TEST_FIELD_OFFSET(SID, IdentifierAuthority, 2)
    TEST_FIELD_SIZE  (SID, SubAuthority, 4)
    TEST_FIELD_ALIGN (SID, SubAuthority, 4)
    TEST_FIELD_OFFSET(SID, SubAuthority, 8)
}

static void test_pack_SID_AND_ATTRIBUTES(void)
{
    /* SID_AND_ATTRIBUTES */
    TEST_TYPE_SIZE   (SID_AND_ATTRIBUTES, 16)
    TEST_TYPE_ALIGN  (SID_AND_ATTRIBUTES, 8)
    TEST_FIELD_SIZE  (SID_AND_ATTRIBUTES, Sid, 8)
    TEST_FIELD_ALIGN (SID_AND_ATTRIBUTES, Sid, 8)
    TEST_FIELD_OFFSET(SID_AND_ATTRIBUTES, Sid, 0)
    TEST_FIELD_SIZE  (SID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_ALIGN (SID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_OFFSET(SID_AND_ATTRIBUTES, Attributes, 8)
}

static void test_pack_SID_IDENTIFIER_AUTHORITY(void)
{
    /* SID_IDENTIFIER_AUTHORITY */
    TEST_TYPE_SIZE   (SID_IDENTIFIER_AUTHORITY, 6)
    TEST_TYPE_ALIGN  (SID_IDENTIFIER_AUTHORITY, 1)
    TEST_FIELD_SIZE  (SID_IDENTIFIER_AUTHORITY, Value, 6)
    TEST_FIELD_ALIGN (SID_IDENTIFIER_AUTHORITY, Value, 1)
    TEST_FIELD_OFFSET(SID_IDENTIFIER_AUTHORITY, Value, 0)
}

static void test_pack_SINGLE_LIST_ENTRY(void)
{
    /* SINGLE_LIST_ENTRY */
    TEST_TYPE_SIZE   (SINGLE_LIST_ENTRY, 8)
    TEST_TYPE_ALIGN  (SINGLE_LIST_ENTRY, 8)
    TEST_FIELD_SIZE  (SINGLE_LIST_ENTRY, Next, 8)
    TEST_FIELD_ALIGN (SINGLE_LIST_ENTRY, Next, 8)
    TEST_FIELD_OFFSET(SINGLE_LIST_ENTRY, Next, 0)
}

static void test_pack_SYSTEM_ALARM_ACE(void)
{
    /* SYSTEM_ALARM_ACE */
    TEST_TYPE_SIZE   (SYSTEM_ALARM_ACE, 12)
    TEST_TYPE_ALIGN  (SYSTEM_ALARM_ACE, 4)
    TEST_FIELD_SIZE  (SYSTEM_ALARM_ACE, Header, 4)
    TEST_FIELD_ALIGN (SYSTEM_ALARM_ACE, Header, 2)
    TEST_FIELD_OFFSET(SYSTEM_ALARM_ACE, Header, 0)
    TEST_FIELD_SIZE  (SYSTEM_ALARM_ACE, Mask, 4)
    TEST_FIELD_ALIGN (SYSTEM_ALARM_ACE, Mask, 4)
    TEST_FIELD_OFFSET(SYSTEM_ALARM_ACE, Mask, 4)
    TEST_FIELD_SIZE  (SYSTEM_ALARM_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (SYSTEM_ALARM_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(SYSTEM_ALARM_ACE, SidStart, 8)
}

static void test_pack_SYSTEM_AUDIT_ACE(void)
{
    /* SYSTEM_AUDIT_ACE */
    TEST_TYPE_SIZE   (SYSTEM_AUDIT_ACE, 12)
    TEST_TYPE_ALIGN  (SYSTEM_AUDIT_ACE, 4)
    TEST_FIELD_SIZE  (SYSTEM_AUDIT_ACE, Header, 4)
    TEST_FIELD_ALIGN (SYSTEM_AUDIT_ACE, Header, 2)
    TEST_FIELD_OFFSET(SYSTEM_AUDIT_ACE, Header, 0)
    TEST_FIELD_SIZE  (SYSTEM_AUDIT_ACE, Mask, 4)
    TEST_FIELD_ALIGN (SYSTEM_AUDIT_ACE, Mask, 4)
    TEST_FIELD_OFFSET(SYSTEM_AUDIT_ACE, Mask, 4)
    TEST_FIELD_SIZE  (SYSTEM_AUDIT_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (SYSTEM_AUDIT_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(SYSTEM_AUDIT_ACE, SidStart, 8)
}

static void test_pack_TOKEN_DEFAULT_DACL(void)
{
    /* TOKEN_DEFAULT_DACL */
    TEST_TYPE_SIZE   (TOKEN_DEFAULT_DACL, 8)
    TEST_TYPE_ALIGN  (TOKEN_DEFAULT_DACL, 8)
    TEST_FIELD_SIZE  (TOKEN_DEFAULT_DACL, DefaultDacl, 8)
    TEST_FIELD_ALIGN (TOKEN_DEFAULT_DACL, DefaultDacl, 8)
    TEST_FIELD_OFFSET(TOKEN_DEFAULT_DACL, DefaultDacl, 0)
}

static void test_pack_TOKEN_GROUPS(void)
{
    /* TOKEN_GROUPS */
    TEST_TYPE_SIZE   (TOKEN_GROUPS, 24)
    TEST_TYPE_ALIGN  (TOKEN_GROUPS, 8)
    TEST_FIELD_SIZE  (TOKEN_GROUPS, GroupCount, 4)
    TEST_FIELD_ALIGN (TOKEN_GROUPS, GroupCount, 4)
    TEST_FIELD_OFFSET(TOKEN_GROUPS, GroupCount, 0)
    TEST_FIELD_SIZE  (TOKEN_GROUPS, Groups, 16)
    TEST_FIELD_ALIGN (TOKEN_GROUPS, Groups, 8)
    TEST_FIELD_OFFSET(TOKEN_GROUPS, Groups, 8)
}

static void test_pack_TOKEN_OWNER(void)
{
    /* TOKEN_OWNER */
    TEST_TYPE_SIZE   (TOKEN_OWNER, 8)
    TEST_TYPE_ALIGN  (TOKEN_OWNER, 8)
    TEST_FIELD_SIZE  (TOKEN_OWNER, Owner, 8)
    TEST_FIELD_ALIGN (TOKEN_OWNER, Owner, 8)
    TEST_FIELD_OFFSET(TOKEN_OWNER, Owner, 0)
}

static void test_pack_TOKEN_PRIMARY_GROUP(void)
{
    /* TOKEN_PRIMARY_GROUP */
    TEST_TYPE_SIZE   (TOKEN_PRIMARY_GROUP, 8)
    TEST_TYPE_ALIGN  (TOKEN_PRIMARY_GROUP, 8)
    TEST_FIELD_SIZE  (TOKEN_PRIMARY_GROUP, PrimaryGroup, 8)
    TEST_FIELD_ALIGN (TOKEN_PRIMARY_GROUP, PrimaryGroup, 8)
    TEST_FIELD_OFFSET(TOKEN_PRIMARY_GROUP, PrimaryGroup, 0)
}

static void test_pack_TOKEN_PRIVILEGES(void)
{
    /* TOKEN_PRIVILEGES */
    TEST_TYPE_SIZE   (TOKEN_PRIVILEGES, 16)
    TEST_TYPE_ALIGN  (TOKEN_PRIVILEGES, 4)
    TEST_FIELD_SIZE  (TOKEN_PRIVILEGES, PrivilegeCount, 4)
    TEST_FIELD_ALIGN (TOKEN_PRIVILEGES, PrivilegeCount, 4)
    TEST_FIELD_OFFSET(TOKEN_PRIVILEGES, PrivilegeCount, 0)
    TEST_FIELD_SIZE  (TOKEN_PRIVILEGES, Privileges, 12)
    TEST_FIELD_ALIGN (TOKEN_PRIVILEGES, Privileges, 4)
    TEST_FIELD_OFFSET(TOKEN_PRIVILEGES, Privileges, 4)
}

static void test_pack_TOKEN_SOURCE(void)
{
    /* TOKEN_SOURCE */
    TEST_TYPE_SIZE   (TOKEN_SOURCE, 16)
    TEST_TYPE_ALIGN  (TOKEN_SOURCE, 4)
    TEST_FIELD_SIZE  (TOKEN_SOURCE, SourceName, 8)
    TEST_FIELD_ALIGN (TOKEN_SOURCE, SourceName, 1)
    TEST_FIELD_OFFSET(TOKEN_SOURCE, SourceName, 0)
    TEST_FIELD_SIZE  (TOKEN_SOURCE, SourceIdentifier, 8)
    TEST_FIELD_ALIGN (TOKEN_SOURCE, SourceIdentifier, 4)
    TEST_FIELD_OFFSET(TOKEN_SOURCE, SourceIdentifier, 8)
}

static void test_pack_TOKEN_STATISTICS(void)
{
    /* TOKEN_STATISTICS (pack 4) */
    TEST_FIELD_SIZE  (TOKEN_STATISTICS, TokenId, 8)
    TEST_FIELD_ALIGN (TOKEN_STATISTICS, TokenId, 4)
    TEST_FIELD_OFFSET(TOKEN_STATISTICS, TokenId, 0)
    TEST_FIELD_SIZE  (TOKEN_STATISTICS, AuthenticationId, 8)
    TEST_FIELD_ALIGN (TOKEN_STATISTICS, AuthenticationId, 4)
    TEST_FIELD_OFFSET(TOKEN_STATISTICS, AuthenticationId, 8)
    TEST_FIELD_SIZE  (TOKEN_STATISTICS, ExpirationTime, 8)
    TEST_FIELD_ALIGN (TOKEN_STATISTICS, ExpirationTime, 4)
    TEST_FIELD_OFFSET(TOKEN_STATISTICS, ExpirationTime, 16)
}

static void test_pack_TOKEN_USER(void)
{
    /* TOKEN_USER */
    TEST_TYPE_SIZE   (TOKEN_USER, 16)
    TEST_TYPE_ALIGN  (TOKEN_USER, 8)
    TEST_FIELD_SIZE  (TOKEN_USER, User, 16)
    TEST_FIELD_ALIGN (TOKEN_USER, User, 8)
    TEST_FIELD_OFFSET(TOKEN_USER, User, 0)
}

static void test_pack_ULARGE_INTEGER(void)
{
    /* ULARGE_INTEGER */
}

static void test_pack_ULONGLONG(void)
{
    /* ULONGLONG */
    TEST_TYPE_SIZE   (ULONGLONG, 8)
    TEST_TYPE_ALIGN  (ULONGLONG, 8)
    TEST_TYPE_UNSIGNED(ULONGLONG)
}

static void test_pack_WAITORTIMERCALLBACKFUNC(void)
{
    /* WAITORTIMERCALLBACKFUNC */
    TEST_TYPE_SIZE   (WAITORTIMERCALLBACKFUNC, 8)
    TEST_TYPE_ALIGN  (WAITORTIMERCALLBACKFUNC, 8)
}

static void test_pack_WCHAR(void)
{
    /* WCHAR */
    TEST_TYPE_SIZE   (WCHAR, 2)
    TEST_TYPE_ALIGN  (WCHAR, 2)
    TEST_TYPE_UNSIGNED(WCHAR)
}

static void test_pack_ATOM(void)
{
    /* ATOM */
    TEST_TYPE_SIZE   (ATOM, 2)
    TEST_TYPE_ALIGN  (ATOM, 2)
    TEST_TYPE_UNSIGNED(ATOM)
}

static void test_pack_BOOL(void)
{
    /* BOOL */
    TEST_TYPE_SIZE   (BOOL, 4)
    TEST_TYPE_ALIGN  (BOOL, 4)
    TEST_TYPE_SIGNED(BOOL)
}

static void test_pack_BYTE(void)
{
    /* BYTE */
    TEST_TYPE_SIZE   (BYTE, 1)
    TEST_TYPE_ALIGN  (BYTE, 1)
    TEST_TYPE_UNSIGNED(BYTE)
}

static void test_pack_COLORREF(void)
{
    /* COLORREF */
    TEST_TYPE_SIZE   (COLORREF, 4)
    TEST_TYPE_ALIGN  (COLORREF, 4)
    TEST_TYPE_UNSIGNED(COLORREF)
}

static void test_pack_DWORD(void)
{
    /* DWORD */
    TEST_TYPE_SIZE   (DWORD, 4)
    TEST_TYPE_ALIGN  (DWORD, 4)
    TEST_TYPE_UNSIGNED(DWORD)
}

static void test_pack_FARPROC(void)
{
    /* FARPROC */
    TEST_TYPE_SIZE   (FARPROC, 8)
    TEST_TYPE_ALIGN  (FARPROC, 8)
}

static void test_pack_FLOAT(void)
{
    /* FLOAT */
    TEST_TYPE_SIZE   (FLOAT, 4)
    TEST_TYPE_ALIGN  (FLOAT, 4)
}

static void test_pack_GLOBALHANDLE(void)
{
    /* GLOBALHANDLE */
    TEST_TYPE_SIZE   (GLOBALHANDLE, 8)
    TEST_TYPE_ALIGN  (GLOBALHANDLE, 8)
}

static void test_pack_HCURSOR(void)
{
    /* HCURSOR */
    TEST_TYPE_SIZE   (HCURSOR, 8)
    TEST_TYPE_ALIGN  (HCURSOR, 8)
}

static void test_pack_HFILE(void)
{
    /* HFILE */
    TEST_TYPE_SIZE   (HFILE, 4)
    TEST_TYPE_ALIGN  (HFILE, 4)
    TEST_TYPE_SIGNED(HFILE)
}

static void test_pack_HGDIOBJ(void)
{
    /* HGDIOBJ */
    TEST_TYPE_SIZE   (HGDIOBJ, 8)
    TEST_TYPE_ALIGN  (HGDIOBJ, 8)
}

static void test_pack_HGLOBAL(void)
{
    /* HGLOBAL */
    TEST_TYPE_SIZE   (HGLOBAL, 8)
    TEST_TYPE_ALIGN  (HGLOBAL, 8)
}

static void test_pack_HLOCAL(void)
{
    /* HLOCAL */
    TEST_TYPE_SIZE   (HLOCAL, 8)
    TEST_TYPE_ALIGN  (HLOCAL, 8)
}

static void test_pack_HMODULE(void)
{
    /* HMODULE */
    TEST_TYPE_SIZE   (HMODULE, 8)
    TEST_TYPE_ALIGN  (HMODULE, 8)
}

static void test_pack_INT(void)
{
    /* INT */
    TEST_TYPE_SIZE   (INT, 4)
    TEST_TYPE_ALIGN  (INT, 4)
    TEST_TYPE_SIGNED(INT)
}

static void test_pack_LOCALHANDLE(void)
{
    /* LOCALHANDLE */
    TEST_TYPE_SIZE   (LOCALHANDLE, 8)
    TEST_TYPE_ALIGN  (LOCALHANDLE, 8)
}

static void test_pack_LPARAM(void)
{
    /* LPARAM */
    TEST_TYPE_SIZE   (LPARAM, 8)
    TEST_TYPE_ALIGN  (LPARAM, 8)
}

static void test_pack_LPCRECT(void)
{
    /* LPCRECT */
    TEST_TYPE_SIZE   (LPCRECT, 8)
    TEST_TYPE_ALIGN  (LPCRECT, 8)
    TEST_TARGET_SIZE (LPCRECT, 16)
    TEST_TARGET_ALIGN(LPCRECT, 4)
}

static void test_pack_LPCRECTL(void)
{
    /* LPCRECTL */
    TEST_TYPE_SIZE   (LPCRECTL, 8)
    TEST_TYPE_ALIGN  (LPCRECTL, 8)
    TEST_TARGET_SIZE (LPCRECTL, 16)
    TEST_TARGET_ALIGN(LPCRECTL, 4)
}

static void test_pack_LPCVOID(void)
{
    /* LPCVOID */
    TEST_TYPE_SIZE   (LPCVOID, 8)
    TEST_TYPE_ALIGN  (LPCVOID, 8)
}

static void test_pack_LPPOINT(void)
{
    /* LPPOINT */
    TEST_TYPE_SIZE   (LPPOINT, 8)
    TEST_TYPE_ALIGN  (LPPOINT, 8)
    TEST_TARGET_SIZE (LPPOINT, 8)
    TEST_TARGET_ALIGN(LPPOINT, 4)
}

static void test_pack_LPRECT(void)
{
    /* LPRECT */
    TEST_TYPE_SIZE   (LPRECT, 8)
    TEST_TYPE_ALIGN  (LPRECT, 8)
    TEST_TARGET_SIZE (LPRECT, 16)
    TEST_TARGET_ALIGN(LPRECT, 4)
}

static void test_pack_LPRECTL(void)
{
    /* LPRECTL */
    TEST_TYPE_SIZE   (LPRECTL, 8)
    TEST_TYPE_ALIGN  (LPRECTL, 8)
    TEST_TARGET_SIZE (LPRECTL, 16)
    TEST_TARGET_ALIGN(LPRECTL, 4)
}

static void test_pack_LPSIZE(void)
{
    /* LPSIZE */
    TEST_TYPE_SIZE   (LPSIZE, 8)
    TEST_TYPE_ALIGN  (LPSIZE, 8)
    TEST_TARGET_SIZE (LPSIZE, 8)
    TEST_TARGET_ALIGN(LPSIZE, 4)
}

static void test_pack_LRESULT(void)
{
    /* LRESULT */
    TEST_TYPE_SIZE   (LRESULT, 8)
    TEST_TYPE_ALIGN  (LRESULT, 8)
}

static void test_pack_POINT(void)
{
    /* POINT */
    TEST_TYPE_SIZE   (POINT, 8)
    TEST_TYPE_ALIGN  (POINT, 4)
    TEST_FIELD_SIZE  (POINT, x, 4)
    TEST_FIELD_ALIGN (POINT, x, 4)
    TEST_FIELD_OFFSET(POINT, x, 0)
    TEST_FIELD_SIZE  (POINT, y, 4)
    TEST_FIELD_ALIGN (POINT, y, 4)
    TEST_FIELD_OFFSET(POINT, y, 4)
}

static void test_pack_POINTL(void)
{
    /* POINTL */
    TEST_TYPE_SIZE   (POINTL, 8)
    TEST_TYPE_ALIGN  (POINTL, 4)
    TEST_FIELD_SIZE  (POINTL, x, 4)
    TEST_FIELD_ALIGN (POINTL, x, 4)
    TEST_FIELD_OFFSET(POINTL, x, 0)
    TEST_FIELD_SIZE  (POINTL, y, 4)
    TEST_FIELD_ALIGN (POINTL, y, 4)
    TEST_FIELD_OFFSET(POINTL, y, 4)
}

static void test_pack_PPOINT(void)
{
    /* PPOINT */
    TEST_TYPE_SIZE   (PPOINT, 8)
    TEST_TYPE_ALIGN  (PPOINT, 8)
    TEST_TARGET_SIZE (PPOINT, 8)
    TEST_TARGET_ALIGN(PPOINT, 4)
}

static void test_pack_PPOINTL(void)
{
    /* PPOINTL */
    TEST_TYPE_SIZE   (PPOINTL, 8)
    TEST_TYPE_ALIGN  (PPOINTL, 8)
    TEST_TARGET_SIZE (PPOINTL, 8)
    TEST_TARGET_ALIGN(PPOINTL, 4)
}

static void test_pack_PRECT(void)
{
    /* PRECT */
    TEST_TYPE_SIZE   (PRECT, 8)
    TEST_TYPE_ALIGN  (PRECT, 8)
    TEST_TARGET_SIZE (PRECT, 16)
    TEST_TARGET_ALIGN(PRECT, 4)
}

static void test_pack_PRECTL(void)
{
    /* PRECTL */
    TEST_TYPE_SIZE   (PRECTL, 8)
    TEST_TYPE_ALIGN  (PRECTL, 8)
    TEST_TARGET_SIZE (PRECTL, 16)
    TEST_TARGET_ALIGN(PRECTL, 4)
}

static void test_pack_PROC(void)
{
    /* PROC */
    TEST_TYPE_SIZE   (PROC, 8)
    TEST_TYPE_ALIGN  (PROC, 8)
}

static void test_pack_PSIZE(void)
{
    /* PSIZE */
    TEST_TYPE_SIZE   (PSIZE, 8)
    TEST_TYPE_ALIGN  (PSIZE, 8)
    TEST_TARGET_SIZE (PSIZE, 8)
    TEST_TARGET_ALIGN(PSIZE, 4)
}

static void test_pack_PSZ(void)
{
    /* PSZ */
    TEST_TYPE_SIZE   (PSZ, 8)
    TEST_TYPE_ALIGN  (PSZ, 8)
}

static void test_pack_RECT(void)
{
    /* RECT */
    TEST_TYPE_SIZE   (RECT, 16)
    TEST_TYPE_ALIGN  (RECT, 4)
    TEST_FIELD_SIZE  (RECT, left, 4)
    TEST_FIELD_ALIGN (RECT, left, 4)
    TEST_FIELD_OFFSET(RECT, left, 0)
    TEST_FIELD_SIZE  (RECT, top, 4)
    TEST_FIELD_ALIGN (RECT, top, 4)
    TEST_FIELD_OFFSET(RECT, top, 4)
    TEST_FIELD_SIZE  (RECT, right, 4)
    TEST_FIELD_ALIGN (RECT, right, 4)
    TEST_FIELD_OFFSET(RECT, right, 8)
    TEST_FIELD_SIZE  (RECT, bottom, 4)
    TEST_FIELD_ALIGN (RECT, bottom, 4)
    TEST_FIELD_OFFSET(RECT, bottom, 12)
}

static void test_pack_RECTL(void)
{
    /* RECTL */
    TEST_TYPE_SIZE   (RECTL, 16)
    TEST_TYPE_ALIGN  (RECTL, 4)
    TEST_FIELD_SIZE  (RECTL, left, 4)
    TEST_FIELD_ALIGN (RECTL, left, 4)
    TEST_FIELD_OFFSET(RECTL, left, 0)
    TEST_FIELD_SIZE  (RECTL, top, 4)
    TEST_FIELD_ALIGN (RECTL, top, 4)
    TEST_FIELD_OFFSET(RECTL, top, 4)
    TEST_FIELD_SIZE  (RECTL, right, 4)
    TEST_FIELD_ALIGN (RECTL, right, 4)
    TEST_FIELD_OFFSET(RECTL, right, 8)
    TEST_FIELD_SIZE  (RECTL, bottom, 4)
    TEST_FIELD_ALIGN (RECTL, bottom, 4)
    TEST_FIELD_OFFSET(RECTL, bottom, 12)
}

static void test_pack_SIZE(void)
{
    /* SIZE */
    TEST_TYPE_SIZE   (SIZE, 8)
    TEST_TYPE_ALIGN  (SIZE, 4)
    TEST_FIELD_SIZE  (SIZE, cx, 4)
    TEST_FIELD_ALIGN (SIZE, cx, 4)
    TEST_FIELD_OFFSET(SIZE, cx, 0)
    TEST_FIELD_SIZE  (SIZE, cy, 4)
    TEST_FIELD_ALIGN (SIZE, cy, 4)
    TEST_FIELD_OFFSET(SIZE, cy, 4)
}

static void test_pack_SIZEL(void)
{
    /* SIZEL */
    TEST_TYPE_SIZE   (SIZEL, 8)
    TEST_TYPE_ALIGN  (SIZEL, 4)
}

static void test_pack_UCHAR(void)
{
    /* UCHAR */
    TEST_TYPE_SIZE   (UCHAR, 1)
    TEST_TYPE_ALIGN  (UCHAR, 1)
    TEST_TYPE_UNSIGNED(UCHAR)
}

static void test_pack_UINT(void)
{
    /* UINT */
    TEST_TYPE_SIZE   (UINT, 4)
    TEST_TYPE_ALIGN  (UINT, 4)
    TEST_TYPE_UNSIGNED(UINT)
}

static void test_pack_ULONG(void)
{
    /* ULONG */
    TEST_TYPE_SIZE   (ULONG, 4)
    TEST_TYPE_ALIGN  (ULONG, 4)
    TEST_TYPE_UNSIGNED(ULONG)
}

static void test_pack_USHORT(void)
{
    /* USHORT */
    TEST_TYPE_SIZE   (USHORT, 2)
    TEST_TYPE_ALIGN  (USHORT, 2)
    TEST_TYPE_UNSIGNED(USHORT)
}

static void test_pack_WORD(void)
{
    /* WORD */
    TEST_TYPE_SIZE   (WORD, 2)
    TEST_TYPE_ALIGN  (WORD, 2)
    TEST_TYPE_UNSIGNED(WORD)
}

static void test_pack_WPARAM(void)
{
    /* WPARAM */
    TEST_TYPE_SIZE   (WPARAM, 8)
    TEST_TYPE_ALIGN  (WPARAM, 8)
}

#else /* _WIN64 */

static void test_pack_DWORD32(void)
{
    /* DWORD32 */
    TEST_TYPE_SIZE   (DWORD32, 4)
    TEST_TYPE_ALIGN  (DWORD32, 4)
    TEST_TYPE_UNSIGNED(DWORD32)
}

static void test_pack_DWORD64(void)
{
    /* DWORD64 */
    TEST_TYPE_SIZE   (DWORD64, 8)
    TEST_TYPE_ALIGN  (DWORD64, 8)
    TEST_TYPE_UNSIGNED(DWORD64)
}

static void test_pack_DWORD_PTR(void)
{
    /* DWORD_PTR */
    TEST_TYPE_SIZE   (DWORD_PTR, 4)
    TEST_TYPE_ALIGN  (DWORD_PTR, 4)
}

static void test_pack_HALF_PTR(void)
{
    /* HALF_PTR */
    TEST_TYPE_SIZE   (HALF_PTR, 2)
    TEST_TYPE_ALIGN  (HALF_PTR, 2)
    TEST_TYPE_SIGNED(HALF_PTR)
}

static void test_pack_INT16(void)
{
    /* INT16 */
    TEST_TYPE_SIZE   (INT16, 2)
    TEST_TYPE_ALIGN  (INT16, 2)
    TEST_TYPE_SIGNED(INT16)
}

static void test_pack_INT32(void)
{
    /* INT32 */
    TEST_TYPE_SIZE   (INT32, 4)
    TEST_TYPE_ALIGN  (INT32, 4)
    TEST_TYPE_SIGNED(INT32)
}

static void test_pack_INT64(void)
{
    /* INT64 */
    TEST_TYPE_SIZE   (INT64, 8)
    TEST_TYPE_ALIGN  (INT64, 8)
    TEST_TYPE_SIGNED(INT64)
}

static void test_pack_INT8(void)
{
    /* INT8 */
    TEST_TYPE_SIZE   (INT8, 1)
    TEST_TYPE_ALIGN  (INT8, 1)
    TEST_TYPE_SIGNED(INT8)
}

static void test_pack_INT_PTR(void)
{
    /* INT_PTR */
    TEST_TYPE_SIZE   (INT_PTR, 4)
    TEST_TYPE_ALIGN  (INT_PTR, 4)
    TEST_TYPE_SIGNED(INT_PTR)
}

static void test_pack_LONG32(void)
{
    /* LONG32 */
    TEST_TYPE_SIZE   (LONG32, 4)
    TEST_TYPE_ALIGN  (LONG32, 4)
    TEST_TYPE_SIGNED(LONG32)
}

static void test_pack_LONG64(void)
{
    /* LONG64 */
    TEST_TYPE_SIZE   (LONG64, 8)
    TEST_TYPE_ALIGN  (LONG64, 8)
    TEST_TYPE_SIGNED(LONG64)
}

static void test_pack_LONG_PTR(void)
{
    /* LONG_PTR */
    TEST_TYPE_SIZE   (LONG_PTR, 4)
    TEST_TYPE_ALIGN  (LONG_PTR, 4)
    TEST_TYPE_SIGNED(LONG_PTR)
}

static void test_pack_SIZE_T(void)
{
    /* SIZE_T */
    TEST_TYPE_SIZE   (SIZE_T, 4)
    TEST_TYPE_ALIGN  (SIZE_T, 4)
}

static void test_pack_SSIZE_T(void)
{
    /* SSIZE_T */
    TEST_TYPE_SIZE   (SSIZE_T, 4)
    TEST_TYPE_ALIGN  (SSIZE_T, 4)
}

static void test_pack_UHALF_PTR(void)
{
    /* UHALF_PTR */
    TEST_TYPE_SIZE   (UHALF_PTR, 2)
    TEST_TYPE_ALIGN  (UHALF_PTR, 2)
    TEST_TYPE_UNSIGNED(UHALF_PTR)
}

static void test_pack_UINT16(void)
{
    /* UINT16 */
    TEST_TYPE_SIZE   (UINT16, 2)
    TEST_TYPE_ALIGN  (UINT16, 2)
    TEST_TYPE_UNSIGNED(UINT16)
}

static void test_pack_UINT32(void)
{
    /* UINT32 */
    TEST_TYPE_SIZE   (UINT32, 4)
    TEST_TYPE_ALIGN  (UINT32, 4)
    TEST_TYPE_UNSIGNED(UINT32)
}

static void test_pack_UINT64(void)
{
    /* UINT64 */
    TEST_TYPE_SIZE   (UINT64, 8)
    TEST_TYPE_ALIGN  (UINT64, 8)
    TEST_TYPE_UNSIGNED(UINT64)
}

static void test_pack_UINT8(void)
{
    /* UINT8 */
    TEST_TYPE_SIZE   (UINT8, 1)
    TEST_TYPE_ALIGN  (UINT8, 1)
    TEST_TYPE_UNSIGNED(UINT8)
}

static void test_pack_UINT_PTR(void)
{
    /* UINT_PTR */
    TEST_TYPE_SIZE   (UINT_PTR, 4)
    TEST_TYPE_ALIGN  (UINT_PTR, 4)
    TEST_TYPE_UNSIGNED(UINT_PTR)
}

static void test_pack_ULONG32(void)
{
    /* ULONG32 */
    TEST_TYPE_SIZE   (ULONG32, 4)
    TEST_TYPE_ALIGN  (ULONG32, 4)
    TEST_TYPE_UNSIGNED(ULONG32)
}

static void test_pack_ULONG64(void)
{
    /* ULONG64 */
    TEST_TYPE_SIZE   (ULONG64, 8)
    TEST_TYPE_ALIGN  (ULONG64, 8)
    TEST_TYPE_UNSIGNED(ULONG64)
}

static void test_pack_ULONG_PTR(void)
{
    /* ULONG_PTR */
    TEST_TYPE_SIZE   (ULONG_PTR, 4)
    TEST_TYPE_ALIGN  (ULONG_PTR, 4)
    TEST_TYPE_UNSIGNED(ULONG_PTR)
}

static void test_pack_ACCESS_ALLOWED_ACE(void)
{
    /* ACCESS_ALLOWED_ACE */
    TEST_TYPE_SIZE   (ACCESS_ALLOWED_ACE, 12)
    TEST_TYPE_ALIGN  (ACCESS_ALLOWED_ACE, 4)
    TEST_FIELD_SIZE  (ACCESS_ALLOWED_ACE, Header, 4)
    TEST_FIELD_ALIGN (ACCESS_ALLOWED_ACE, Header, 2)
    TEST_FIELD_OFFSET(ACCESS_ALLOWED_ACE, Header, 0)
    TEST_FIELD_SIZE  (ACCESS_ALLOWED_ACE, Mask, 4)
    TEST_FIELD_ALIGN (ACCESS_ALLOWED_ACE, Mask, 4)
    TEST_FIELD_OFFSET(ACCESS_ALLOWED_ACE, Mask, 4)
    TEST_FIELD_SIZE  (ACCESS_ALLOWED_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (ACCESS_ALLOWED_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(ACCESS_ALLOWED_ACE, SidStart, 8)
}

static void test_pack_ACCESS_DENIED_ACE(void)
{
    /* ACCESS_DENIED_ACE */
    TEST_TYPE_SIZE   (ACCESS_DENIED_ACE, 12)
    TEST_TYPE_ALIGN  (ACCESS_DENIED_ACE, 4)
    TEST_FIELD_SIZE  (ACCESS_DENIED_ACE, Header, 4)
    TEST_FIELD_ALIGN (ACCESS_DENIED_ACE, Header, 2)
    TEST_FIELD_OFFSET(ACCESS_DENIED_ACE, Header, 0)
    TEST_FIELD_SIZE  (ACCESS_DENIED_ACE, Mask, 4)
    TEST_FIELD_ALIGN (ACCESS_DENIED_ACE, Mask, 4)
    TEST_FIELD_OFFSET(ACCESS_DENIED_ACE, Mask, 4)
    TEST_FIELD_SIZE  (ACCESS_DENIED_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (ACCESS_DENIED_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(ACCESS_DENIED_ACE, SidStart, 8)
}

static void test_pack_ACCESS_MASK(void)
{
    /* ACCESS_MASK */
    TEST_TYPE_SIZE   (ACCESS_MASK, 4)
    TEST_TYPE_ALIGN  (ACCESS_MASK, 4)
    TEST_TYPE_UNSIGNED(ACCESS_MASK)
}

static void test_pack_ACE_HEADER(void)
{
    /* ACE_HEADER */
    TEST_TYPE_SIZE   (ACE_HEADER, 4)
    TEST_TYPE_ALIGN  (ACE_HEADER, 2)
    TEST_FIELD_SIZE  (ACE_HEADER, AceType, 1)
    TEST_FIELD_ALIGN (ACE_HEADER, AceType, 1)
    TEST_FIELD_OFFSET(ACE_HEADER, AceType, 0)
    TEST_FIELD_SIZE  (ACE_HEADER, AceFlags, 1)
    TEST_FIELD_ALIGN (ACE_HEADER, AceFlags, 1)
    TEST_FIELD_OFFSET(ACE_HEADER, AceFlags, 1)
    TEST_FIELD_SIZE  (ACE_HEADER, AceSize, 2)
    TEST_FIELD_ALIGN (ACE_HEADER, AceSize, 2)
    TEST_FIELD_OFFSET(ACE_HEADER, AceSize, 2)
}

static void test_pack_ACL(void)
{
    /* ACL */
    TEST_TYPE_SIZE   (ACL, 8)
    TEST_TYPE_ALIGN  (ACL, 2)
    TEST_FIELD_SIZE  (ACL, AclRevision, 1)
    TEST_FIELD_ALIGN (ACL, AclRevision, 1)
    TEST_FIELD_OFFSET(ACL, AclRevision, 0)
    TEST_FIELD_SIZE  (ACL, Sbz1, 1)
    TEST_FIELD_ALIGN (ACL, Sbz1, 1)
    TEST_FIELD_OFFSET(ACL, Sbz1, 1)
    TEST_FIELD_SIZE  (ACL, AclSize, 2)
    TEST_FIELD_ALIGN (ACL, AclSize, 2)
    TEST_FIELD_OFFSET(ACL, AclSize, 2)
    TEST_FIELD_SIZE  (ACL, AceCount, 2)
    TEST_FIELD_ALIGN (ACL, AceCount, 2)
    TEST_FIELD_OFFSET(ACL, AceCount, 4)
    TEST_FIELD_SIZE  (ACL, Sbz2, 2)
    TEST_FIELD_ALIGN (ACL, Sbz2, 2)
    TEST_FIELD_OFFSET(ACL, Sbz2, 6)
}

static void test_pack_ACL_REVISION_INFORMATION(void)
{
    /* ACL_REVISION_INFORMATION */
    TEST_TYPE_SIZE   (ACL_REVISION_INFORMATION, 4)
    TEST_TYPE_ALIGN  (ACL_REVISION_INFORMATION, 4)
    TEST_FIELD_SIZE  (ACL_REVISION_INFORMATION, AclRevision, 4)
    TEST_FIELD_ALIGN (ACL_REVISION_INFORMATION, AclRevision, 4)
    TEST_FIELD_OFFSET(ACL_REVISION_INFORMATION, AclRevision, 0)
}

static void test_pack_ACL_SIZE_INFORMATION(void)
{
    /* ACL_SIZE_INFORMATION */
    TEST_TYPE_SIZE   (ACL_SIZE_INFORMATION, 12)
    TEST_TYPE_ALIGN  (ACL_SIZE_INFORMATION, 4)
    TEST_FIELD_SIZE  (ACL_SIZE_INFORMATION, AceCount, 4)
    TEST_FIELD_ALIGN (ACL_SIZE_INFORMATION, AceCount, 4)
    TEST_FIELD_OFFSET(ACL_SIZE_INFORMATION, AceCount, 0)
    TEST_FIELD_SIZE  (ACL_SIZE_INFORMATION, AclBytesInUse, 4)
    TEST_FIELD_ALIGN (ACL_SIZE_INFORMATION, AclBytesInUse, 4)
    TEST_FIELD_OFFSET(ACL_SIZE_INFORMATION, AclBytesInUse, 4)
    TEST_FIELD_SIZE  (ACL_SIZE_INFORMATION, AclBytesFree, 4)
    TEST_FIELD_ALIGN (ACL_SIZE_INFORMATION, AclBytesFree, 4)
    TEST_FIELD_OFFSET(ACL_SIZE_INFORMATION, AclBytesFree, 8)
}

static void test_pack_BOOLEAN(void)
{
    /* BOOLEAN */
    TEST_TYPE_SIZE   (BOOLEAN, 1)
    TEST_TYPE_ALIGN  (BOOLEAN, 1)
    TEST_TYPE_UNSIGNED(BOOLEAN)
}

static void test_pack_CCHAR(void)
{
    /* CCHAR */
    TEST_TYPE_SIZE   (CCHAR, 1)
    TEST_TYPE_ALIGN  (CCHAR, 1)
}

static void test_pack_CHAR(void)
{
    /* CHAR */
    TEST_TYPE_SIZE   (CHAR, 1)
    TEST_TYPE_ALIGN  (CHAR, 1)
}

static void test_pack_DWORDLONG(void)
{
    /* DWORDLONG */
    TEST_TYPE_SIZE   (DWORDLONG, 8)
    TEST_TYPE_ALIGN  (DWORDLONG, 8)
    TEST_TYPE_UNSIGNED(DWORDLONG)
}

static void test_pack_EXCEPTION_POINTERS(void)
{
    /* EXCEPTION_POINTERS */
    TEST_TYPE_SIZE   (EXCEPTION_POINTERS, 8)
    TEST_TYPE_ALIGN  (EXCEPTION_POINTERS, 4)
    TEST_FIELD_SIZE  (EXCEPTION_POINTERS, ExceptionRecord, 4)
    TEST_FIELD_ALIGN (EXCEPTION_POINTERS, ExceptionRecord, 4)
    TEST_FIELD_OFFSET(EXCEPTION_POINTERS, ExceptionRecord, 0)
    TEST_FIELD_SIZE  (EXCEPTION_POINTERS, ContextRecord, 4)
    TEST_FIELD_ALIGN (EXCEPTION_POINTERS, ContextRecord, 4)
    TEST_FIELD_OFFSET(EXCEPTION_POINTERS, ContextRecord, 4)
}

static void test_pack_EXCEPTION_RECORD(void)
{
    /* EXCEPTION_RECORD */
    TEST_TYPE_SIZE   (EXCEPTION_RECORD, 80)
    TEST_TYPE_ALIGN  (EXCEPTION_RECORD, 4)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionCode, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionCode, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionCode, 0)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionFlags, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionFlags, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionFlags, 4)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionRecord, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionRecord, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionRecord, 8)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionAddress, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionAddress, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionAddress, 12)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, NumberParameters, 4)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, NumberParameters, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, NumberParameters, 16)
    TEST_FIELD_SIZE  (EXCEPTION_RECORD, ExceptionInformation, 60)
    TEST_FIELD_ALIGN (EXCEPTION_RECORD, ExceptionInformation, 4)
    TEST_FIELD_OFFSET(EXCEPTION_RECORD, ExceptionInformation, 20)
}

static void test_pack_EXECUTION_STATE(void)
{
    /* EXECUTION_STATE */
    TEST_TYPE_SIZE   (EXECUTION_STATE, 4)
    TEST_TYPE_ALIGN  (EXECUTION_STATE, 4)
    TEST_TYPE_UNSIGNED(EXECUTION_STATE)
}

static void test_pack_FPO_DATA(void)
{
    /* FPO_DATA */
    TEST_TYPE_SIZE   (FPO_DATA, 16)
    TEST_TYPE_ALIGN  (FPO_DATA, 4)
    TEST_FIELD_SIZE  (FPO_DATA, ulOffStart, 4)
    TEST_FIELD_ALIGN (FPO_DATA, ulOffStart, 4)
    TEST_FIELD_OFFSET(FPO_DATA, ulOffStart, 0)
    TEST_FIELD_SIZE  (FPO_DATA, cbProcSize, 4)
    TEST_FIELD_ALIGN (FPO_DATA, cbProcSize, 4)
    TEST_FIELD_OFFSET(FPO_DATA, cbProcSize, 4)
    TEST_FIELD_SIZE  (FPO_DATA, cdwLocals, 4)
    TEST_FIELD_ALIGN (FPO_DATA, cdwLocals, 4)
    TEST_FIELD_OFFSET(FPO_DATA, cdwLocals, 8)
    TEST_FIELD_SIZE  (FPO_DATA, cdwParams, 2)
    TEST_FIELD_ALIGN (FPO_DATA, cdwParams, 2)
    TEST_FIELD_OFFSET(FPO_DATA, cdwParams, 12)
}

static void test_pack_GENERIC_MAPPING(void)
{
    /* GENERIC_MAPPING */
    TEST_TYPE_SIZE   (GENERIC_MAPPING, 16)
    TEST_TYPE_ALIGN  (GENERIC_MAPPING, 4)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericRead, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericRead, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericRead, 0)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericWrite, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericWrite, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericWrite, 4)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericExecute, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericExecute, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericExecute, 8)
    TEST_FIELD_SIZE  (GENERIC_MAPPING, GenericAll, 4)
    TEST_FIELD_ALIGN (GENERIC_MAPPING, GenericAll, 4)
    TEST_FIELD_OFFSET(GENERIC_MAPPING, GenericAll, 12)
}

static void test_pack_HANDLE(void)
{
    /* HANDLE */
    TEST_TYPE_SIZE   (HANDLE, 4)
    TEST_TYPE_ALIGN  (HANDLE, 4)
}

static void test_pack_HRESULT(void)
{
    /* HRESULT */
    TEST_TYPE_SIZE   (HRESULT, 4)
    TEST_TYPE_ALIGN  (HRESULT, 4)
}

static void test_pack_IMAGE_ARCHIVE_MEMBER_HEADER(void)
{
    /* IMAGE_ARCHIVE_MEMBER_HEADER */
    TEST_TYPE_SIZE   (IMAGE_ARCHIVE_MEMBER_HEADER, 60)
    TEST_TYPE_ALIGN  (IMAGE_ARCHIVE_MEMBER_HEADER, 1)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Name, 16)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Name, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Name, 0)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Date, 12)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Date, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Date, 16)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, UserID, 6)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, UserID, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, UserID, 28)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, GroupID, 6)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, GroupID, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, GroupID, 34)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Mode, 8)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Mode, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Mode, 40)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, Size, 10)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, Size, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, Size, 48)
    TEST_FIELD_SIZE  (IMAGE_ARCHIVE_MEMBER_HEADER, EndHeader, 2)
    TEST_FIELD_ALIGN (IMAGE_ARCHIVE_MEMBER_HEADER, EndHeader, 1)
    TEST_FIELD_OFFSET(IMAGE_ARCHIVE_MEMBER_HEADER, EndHeader, 58)
}

static void test_pack_IMAGE_AUX_SYMBOL(void)
{
    /* IMAGE_AUX_SYMBOL (pack 2) */
}

static void test_pack_IMAGE_BASE_RELOCATION(void)
{
    /* IMAGE_BASE_RELOCATION */
    TEST_TYPE_SIZE   (IMAGE_BASE_RELOCATION, 8)
    TEST_TYPE_ALIGN  (IMAGE_BASE_RELOCATION, 4)
    TEST_FIELD_SIZE  (IMAGE_BASE_RELOCATION, VirtualAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_BASE_RELOCATION, VirtualAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_BASE_RELOCATION, VirtualAddress, 0)
    TEST_FIELD_SIZE  (IMAGE_BASE_RELOCATION, SizeOfBlock, 4)
    TEST_FIELD_ALIGN (IMAGE_BASE_RELOCATION, SizeOfBlock, 4)
    TEST_FIELD_OFFSET(IMAGE_BASE_RELOCATION, SizeOfBlock, 4)
}

static void test_pack_IMAGE_BOUND_FORWARDER_REF(void)
{
    /* IMAGE_BOUND_FORWARDER_REF */
    TEST_TYPE_SIZE   (IMAGE_BOUND_FORWARDER_REF, 8)
    TEST_TYPE_ALIGN  (IMAGE_BOUND_FORWARDER_REF, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_FORWARDER_REF, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_BOUND_FORWARDER_REF, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_BOUND_FORWARDER_REF, TimeDateStamp, 0)
    TEST_FIELD_SIZE  (IMAGE_BOUND_FORWARDER_REF, OffsetModuleName, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_FORWARDER_REF, OffsetModuleName, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_FORWARDER_REF, OffsetModuleName, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_FORWARDER_REF, Reserved, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_FORWARDER_REF, Reserved, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_FORWARDER_REF, Reserved, 6)
}

static void test_pack_IMAGE_BOUND_IMPORT_DESCRIPTOR(void)
{
    /* IMAGE_BOUND_IMPORT_DESCRIPTOR */
    TEST_TYPE_SIZE   (IMAGE_BOUND_IMPORT_DESCRIPTOR, 8)
    TEST_TYPE_ALIGN  (IMAGE_BOUND_IMPORT_DESCRIPTOR, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_IMPORT_DESCRIPTOR, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_BOUND_IMPORT_DESCRIPTOR, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_BOUND_IMPORT_DESCRIPTOR, TimeDateStamp, 0)
    TEST_FIELD_SIZE  (IMAGE_BOUND_IMPORT_DESCRIPTOR, OffsetModuleName, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_IMPORT_DESCRIPTOR, OffsetModuleName, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_IMPORT_DESCRIPTOR, OffsetModuleName, 4)
    TEST_FIELD_SIZE  (IMAGE_BOUND_IMPORT_DESCRIPTOR, NumberOfModuleForwarderRefs, 2)
    TEST_FIELD_ALIGN (IMAGE_BOUND_IMPORT_DESCRIPTOR, NumberOfModuleForwarderRefs, 2)
    TEST_FIELD_OFFSET(IMAGE_BOUND_IMPORT_DESCRIPTOR, NumberOfModuleForwarderRefs, 6)
}

static void test_pack_IMAGE_COFF_SYMBOLS_HEADER(void)
{
    /* IMAGE_COFF_SYMBOLS_HEADER */
    TEST_TYPE_SIZE   (IMAGE_COFF_SYMBOLS_HEADER, 32)
    TEST_TYPE_ALIGN  (IMAGE_COFF_SYMBOLS_HEADER, 4)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, NumberOfSymbols, 0)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstSymbol, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstSymbol, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstSymbol, 4)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, NumberOfLinenumbers, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, NumberOfLinenumbers, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, NumberOfLinenumbers, 8)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstLinenumber, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstLinenumber, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, LvaToFirstLinenumber, 12)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfCode, 16)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfCode, 20)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToFirstByteOfData, 24)
    TEST_FIELD_SIZE  (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_COFF_SYMBOLS_HEADER, RvaToLastByteOfData, 28)
}

static void test_pack_IMAGE_DATA_DIRECTORY(void)
{
    /* IMAGE_DATA_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_DATA_DIRECTORY, 8)
    TEST_TYPE_ALIGN  (IMAGE_DATA_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_DATA_DIRECTORY, VirtualAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_DATA_DIRECTORY, VirtualAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_DATA_DIRECTORY, VirtualAddress, 0)
    TEST_FIELD_SIZE  (IMAGE_DATA_DIRECTORY, Size, 4)
    TEST_FIELD_ALIGN (IMAGE_DATA_DIRECTORY, Size, 4)
    TEST_FIELD_OFFSET(IMAGE_DATA_DIRECTORY, Size, 4)
}

static void test_pack_IMAGE_DEBUG_DIRECTORY(void)
{
    /* IMAGE_DEBUG_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_DEBUG_DIRECTORY, 28)
    TEST_TYPE_ALIGN  (IMAGE_DEBUG_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, Characteristics, 0)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, Type, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, Type, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, Type, 12)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, SizeOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, SizeOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, SizeOfData, 16)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, AddressOfRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, AddressOfRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, AddressOfRawData, 20)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_DIRECTORY, PointerToRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_DIRECTORY, PointerToRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_DIRECTORY, PointerToRawData, 24)
}

static void test_pack_IMAGE_DEBUG_MISC(void)
{
    /* IMAGE_DEBUG_MISC */
    TEST_TYPE_SIZE   (IMAGE_DEBUG_MISC, 16)
    TEST_TYPE_ALIGN  (IMAGE_DEBUG_MISC, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, DataType, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, DataType, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, DataType, 0)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Length, 4)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Length, 4)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Length, 4)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Unicode, 1)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Unicode, 1)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Unicode, 8)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Reserved, 3)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Reserved, 1)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Reserved, 9)
    TEST_FIELD_SIZE  (IMAGE_DEBUG_MISC, Data, 1)
    TEST_FIELD_ALIGN (IMAGE_DEBUG_MISC, Data, 1)
    TEST_FIELD_OFFSET(IMAGE_DEBUG_MISC, Data, 12)
}

static void test_pack_IMAGE_DOS_HEADER(void)
{
    /* IMAGE_DOS_HEADER (pack 2) */
    TEST_TYPE_SIZE   (IMAGE_DOS_HEADER, 64)
    TEST_TYPE_ALIGN  (IMAGE_DOS_HEADER, 2)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_magic, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_magic, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_magic, 0)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cblp, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cblp, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cblp, 2)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cp, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cp, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cp, 4)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_crlc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_crlc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_crlc, 6)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cparhdr, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cparhdr, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cparhdr, 8)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_minalloc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_minalloc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_minalloc, 10)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_maxalloc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_maxalloc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_maxalloc, 12)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_ss, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_ss, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_ss, 14)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_sp, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_sp, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_sp, 16)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_csum, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_csum, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_csum, 18)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_ip, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_ip, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_ip, 20)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_cs, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_cs, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_cs, 22)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_lfarlc, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_lfarlc, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_lfarlc, 24)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_ovno, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_ovno, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_ovno, 26)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_res, 8)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_res, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_res, 28)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_oemid, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_oemid, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_oemid, 36)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_oeminfo, 2)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_oeminfo, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_oeminfo, 38)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_res2, 20)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_res2, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_res2, 40)
    TEST_FIELD_SIZE  (IMAGE_DOS_HEADER, e_lfanew, 4)
    TEST_FIELD_ALIGN (IMAGE_DOS_HEADER, e_lfanew, 2)
    TEST_FIELD_OFFSET(IMAGE_DOS_HEADER, e_lfanew, 60)
}

static void test_pack_IMAGE_EXPORT_DIRECTORY(void)
{
    /* IMAGE_EXPORT_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_EXPORT_DIRECTORY, 40)
    TEST_TYPE_ALIGN  (IMAGE_EXPORT_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, Characteristics, 0)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, Name, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, Name, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, Name, 12)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, Base, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, Base, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, Base, 16)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, NumberOfFunctions, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, NumberOfFunctions, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, NumberOfFunctions, 20)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, NumberOfNames, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, NumberOfNames, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, NumberOfNames, 24)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, AddressOfFunctions, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, AddressOfFunctions, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, AddressOfFunctions, 28)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, AddressOfNames, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, AddressOfNames, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, AddressOfNames, 32)
    TEST_FIELD_SIZE  (IMAGE_EXPORT_DIRECTORY, AddressOfNameOrdinals, 4)
    TEST_FIELD_ALIGN (IMAGE_EXPORT_DIRECTORY, AddressOfNameOrdinals, 4)
    TEST_FIELD_OFFSET(IMAGE_EXPORT_DIRECTORY, AddressOfNameOrdinals, 36)
}

static void test_pack_IMAGE_FILE_HEADER(void)
{
    /* IMAGE_FILE_HEADER */
    TEST_TYPE_SIZE   (IMAGE_FILE_HEADER, 20)
    TEST_TYPE_ALIGN  (IMAGE_FILE_HEADER, 4)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, Machine, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, Machine, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, Machine, 0)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, NumberOfSections, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, NumberOfSections, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, NumberOfSections, 2)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, PointerToSymbolTable, 4)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, PointerToSymbolTable, 4)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, PointerToSymbolTable, 8)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, NumberOfSymbols, 4)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, NumberOfSymbols, 12)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, SizeOfOptionalHeader, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, SizeOfOptionalHeader, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, SizeOfOptionalHeader, 16)
    TEST_FIELD_SIZE  (IMAGE_FILE_HEADER, Characteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_FILE_HEADER, Characteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_FILE_HEADER, Characteristics, 18)
}

static void test_pack_IMAGE_FUNCTION_ENTRY(void)
{
    /* IMAGE_FUNCTION_ENTRY */
    TEST_TYPE_SIZE   (IMAGE_FUNCTION_ENTRY, 12)
    TEST_TYPE_ALIGN  (IMAGE_FUNCTION_ENTRY, 4)
    TEST_FIELD_SIZE  (IMAGE_FUNCTION_ENTRY, StartingAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_FUNCTION_ENTRY, StartingAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_FUNCTION_ENTRY, StartingAddress, 0)
    TEST_FIELD_SIZE  (IMAGE_FUNCTION_ENTRY, EndingAddress, 4)
    TEST_FIELD_ALIGN (IMAGE_FUNCTION_ENTRY, EndingAddress, 4)
    TEST_FIELD_OFFSET(IMAGE_FUNCTION_ENTRY, EndingAddress, 4)
    TEST_FIELD_SIZE  (IMAGE_FUNCTION_ENTRY, EndOfPrologue, 4)
    TEST_FIELD_ALIGN (IMAGE_FUNCTION_ENTRY, EndOfPrologue, 4)
    TEST_FIELD_OFFSET(IMAGE_FUNCTION_ENTRY, EndOfPrologue, 8)
}

static void test_pack_IMAGE_IMPORT_BY_NAME(void)
{
    /* IMAGE_IMPORT_BY_NAME */
    TEST_TYPE_SIZE   (IMAGE_IMPORT_BY_NAME, 4)
    TEST_TYPE_ALIGN  (IMAGE_IMPORT_BY_NAME, 2)
    TEST_FIELD_SIZE  (IMAGE_IMPORT_BY_NAME, Hint, 2)
    TEST_FIELD_ALIGN (IMAGE_IMPORT_BY_NAME, Hint, 2)
    TEST_FIELD_OFFSET(IMAGE_IMPORT_BY_NAME, Hint, 0)
    TEST_FIELD_SIZE  (IMAGE_IMPORT_BY_NAME, Name, 1)
    TEST_FIELD_ALIGN (IMAGE_IMPORT_BY_NAME, Name, 1)
    TEST_FIELD_OFFSET(IMAGE_IMPORT_BY_NAME, Name, 2)
}

static void test_pack_IMAGE_IMPORT_DESCRIPTOR(void)
{
    /* IMAGE_IMPORT_DESCRIPTOR */
}

static void test_pack_IMAGE_LINENUMBER(void)
{
    /* IMAGE_LINENUMBER (pack 2) */
}

static void test_pack_IMAGE_LOAD_CONFIG_DIRECTORY(void)
{
    /* IMAGE_LOAD_CONFIG_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_LOAD_CONFIG_DIRECTORY, 72)
    TEST_TYPE_ALIGN  (IMAGE_LOAD_CONFIG_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, Size, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, Size, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, Size, 0)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsClear, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsClear, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsClear, 12)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsSet, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsSet, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, GlobalFlagsSet, 16)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, CriticalSectionDefaultTimeout, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, CriticalSectionDefaultTimeout, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, CriticalSectionDefaultTimeout, 20)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitFreeBlockThreshold, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitFreeBlockThreshold, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitFreeBlockThreshold, 24)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitTotalFreeThreshold, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitTotalFreeThreshold, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, DeCommitTotalFreeThreshold, 28)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, LockPrefixTable, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, LockPrefixTable, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, LockPrefixTable, 32)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, MaximumAllocationSize, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, MaximumAllocationSize, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, MaximumAllocationSize, 36)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, VirtualMemoryThreshold, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, VirtualMemoryThreshold, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, VirtualMemoryThreshold, 40)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessHeapFlags, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessHeapFlags, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, ProcessHeapFlags, 44)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessAffinityMask, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, ProcessAffinityMask, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, ProcessAffinityMask, 48)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, CSDVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, CSDVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, CSDVersion, 52)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, Reserved1, 2)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, Reserved1, 2)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, Reserved1, 54)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, EditList, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, EditList, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, EditList, 56)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, SecurityCookie, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, SecurityCookie, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, SecurityCookie, 60)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerTable, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerTable, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerTable, 64)
    TEST_FIELD_SIZE  (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerCount, 4)
    TEST_FIELD_ALIGN (IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerCount, 4)
    TEST_FIELD_OFFSET(IMAGE_LOAD_CONFIG_DIRECTORY, SEHandlerCount, 68)
}

static void test_pack_IMAGE_NT_HEADERS(void)
{
    /* IMAGE_NT_HEADERS */
    TEST_TYPE_SIZE   (IMAGE_NT_HEADERS, 248)
    TEST_TYPE_ALIGN  (IMAGE_NT_HEADERS, 4)
}

static void test_pack_IMAGE_NT_HEADERS32(void)
{
    /* IMAGE_NT_HEADERS32 */
    TEST_TYPE_SIZE   (IMAGE_NT_HEADERS32, 248)
    TEST_TYPE_ALIGN  (IMAGE_NT_HEADERS32, 4)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS32, Signature, 4)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS32, Signature, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS32, Signature, 0)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS32, FileHeader, 20)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS32, FileHeader, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS32, FileHeader, 4)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS32, OptionalHeader, 224)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS32, OptionalHeader, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS32, OptionalHeader, 24)
}

static void test_pack_IMAGE_NT_HEADERS64(void)
{
    /* IMAGE_NT_HEADERS64 */
    TEST_TYPE_SIZE   (IMAGE_NT_HEADERS64, 264)
    TEST_TYPE_ALIGN  (IMAGE_NT_HEADERS64, 8)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS64, Signature, 4)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS64, Signature, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS64, Signature, 0)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS64, FileHeader, 20)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS64, FileHeader, 4)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS64, FileHeader, 4)
    TEST_FIELD_SIZE  (IMAGE_NT_HEADERS64, OptionalHeader, 240)
    TEST_FIELD_ALIGN (IMAGE_NT_HEADERS64, OptionalHeader, 8)
    TEST_FIELD_OFFSET(IMAGE_NT_HEADERS64, OptionalHeader, 24)
}

static void test_pack_IMAGE_OPTIONAL_HEADER(void)
{
    /* IMAGE_OPTIONAL_HEADER */
    TEST_TYPE_SIZE   (IMAGE_OPTIONAL_HEADER, 224)
    TEST_TYPE_ALIGN  (IMAGE_OPTIONAL_HEADER, 4)
}

static void test_pack_IMAGE_OPTIONAL_HEADER32(void)
{
    /* IMAGE_OPTIONAL_HEADER32 */
    TEST_TYPE_SIZE   (IMAGE_OPTIONAL_HEADER32, 224)
    TEST_TYPE_ALIGN  (IMAGE_OPTIONAL_HEADER32, 4)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, Magic, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, Magic, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, Magic, 0)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorLinkerVersion, 2)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorLinkerVersion, 3)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfCode, 4)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfInitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfInitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfInitializedData, 8)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfUninitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfUninitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfUninitializedData, 12)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, AddressOfEntryPoint, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, AddressOfEntryPoint, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, AddressOfEntryPoint, 16)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, BaseOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, BaseOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, BaseOfCode, 20)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, BaseOfData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, BaseOfData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, BaseOfData, 24)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, ImageBase, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, ImageBase, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, ImageBase, 28)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SectionAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SectionAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SectionAlignment, 32)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, FileAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, FileAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, FileAlignment, 36)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorOperatingSystemVersion, 40)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorOperatingSystemVersion, 42)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorImageVersion, 44)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorImageVersion, 46)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MajorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MajorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MajorSubsystemVersion, 48)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, MinorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, MinorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, MinorSubsystemVersion, 50)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, Win32VersionValue, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, Win32VersionValue, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, Win32VersionValue, 52)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfImage, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfImage, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfImage, 56)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfHeaders, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfHeaders, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfHeaders, 60)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, CheckSum, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, CheckSum, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, CheckSum, 64)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, Subsystem, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, Subsystem, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, Subsystem, 68)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, DllCharacteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, DllCharacteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, DllCharacteristics, 70)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfStackReserve, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfStackReserve, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfStackReserve, 72)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfStackCommit, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfStackCommit, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfStackCommit, 76)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfHeapReserve, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfHeapReserve, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfHeapReserve, 80)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, SizeOfHeapCommit, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, SizeOfHeapCommit, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, SizeOfHeapCommit, 84)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, LoaderFlags, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, LoaderFlags, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, LoaderFlags, 88)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, NumberOfRvaAndSizes, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, NumberOfRvaAndSizes, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, NumberOfRvaAndSizes, 92)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER32, DataDirectory, 128)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER32, DataDirectory, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER32, DataDirectory, 96)
}

static void test_pack_IMAGE_OPTIONAL_HEADER64(void)
{
    /* IMAGE_OPTIONAL_HEADER64 */
    TEST_TYPE_SIZE   (IMAGE_OPTIONAL_HEADER64, 240)
    TEST_TYPE_ALIGN  (IMAGE_OPTIONAL_HEADER64, 8)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, Magic, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, Magic, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, Magic, 0)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorLinkerVersion, 2)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorLinkerVersion, 1)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorLinkerVersion, 1)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorLinkerVersion, 3)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfCode, 4)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfInitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfInitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfInitializedData, 8)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfUninitializedData, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfUninitializedData, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfUninitializedData, 12)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, AddressOfEntryPoint, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, AddressOfEntryPoint, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, AddressOfEntryPoint, 16)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, BaseOfCode, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, BaseOfCode, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, BaseOfCode, 20)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, ImageBase, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, ImageBase, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, ImageBase, 24)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SectionAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SectionAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SectionAlignment, 32)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, FileAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, FileAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, FileAlignment, 36)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorOperatingSystemVersion, 40)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorOperatingSystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorOperatingSystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorOperatingSystemVersion, 42)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorImageVersion, 44)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorImageVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorImageVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorImageVersion, 46)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MajorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MajorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MajorSubsystemVersion, 48)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, MinorSubsystemVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, MinorSubsystemVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, MinorSubsystemVersion, 50)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, Win32VersionValue, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, Win32VersionValue, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, Win32VersionValue, 52)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfImage, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfImage, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfImage, 56)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfHeaders, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfHeaders, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfHeaders, 60)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, CheckSum, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, CheckSum, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, CheckSum, 64)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, Subsystem, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, Subsystem, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, Subsystem, 68)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, DllCharacteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, DllCharacteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, DllCharacteristics, 70)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfStackReserve, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfStackReserve, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfStackReserve, 72)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfStackCommit, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfStackCommit, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfStackCommit, 80)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfHeapReserve, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfHeapReserve, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfHeapReserve, 88)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, SizeOfHeapCommit, 8)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, SizeOfHeapCommit, 8)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, SizeOfHeapCommit, 96)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, LoaderFlags, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, LoaderFlags, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, LoaderFlags, 104)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, NumberOfRvaAndSizes, 4)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, NumberOfRvaAndSizes, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, NumberOfRvaAndSizes, 108)
    TEST_FIELD_SIZE  (IMAGE_OPTIONAL_HEADER64, DataDirectory, 128)
    TEST_FIELD_ALIGN (IMAGE_OPTIONAL_HEADER64, DataDirectory, 4)
    TEST_FIELD_OFFSET(IMAGE_OPTIONAL_HEADER64, DataDirectory, 112)
}

static void test_pack_IMAGE_OS2_HEADER(void)
{
    /* IMAGE_OS2_HEADER (pack 2) */
    TEST_TYPE_SIZE   (IMAGE_OS2_HEADER, 64)
    TEST_TYPE_ALIGN  (IMAGE_OS2_HEADER, 2)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_magic, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_magic, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_magic, 0)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_ver, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_ver, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_ver, 2)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_rev, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_rev, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_rev, 3)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_enttab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_enttab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_enttab, 4)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cbenttab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cbenttab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cbenttab, 6)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_crc, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_crc, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_crc, 8)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_flags, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_flags, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_flags, 12)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_autodata, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_autodata, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_autodata, 14)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_heap, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_heap, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_heap, 16)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_stack, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_stack, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_stack, 18)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_csip, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_csip, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_csip, 20)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_sssp, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_sssp, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_sssp, 24)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cseg, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cseg, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cseg, 28)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cmod, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cmod, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cmod, 30)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cbnrestab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cbnrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cbnrestab, 32)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_segtab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_segtab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_segtab, 34)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_rsrctab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_rsrctab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_rsrctab, 36)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_restab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_restab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_restab, 38)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_modtab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_modtab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_modtab, 40)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_imptab, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_imptab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_imptab, 42)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_nrestab, 4)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_nrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_nrestab, 44)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cmovent, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cmovent, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cmovent, 48)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_align, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_align, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_align, 50)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_cres, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_cres, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_cres, 52)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_exetyp, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_exetyp, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_exetyp, 54)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_flagsothers, 1)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_flagsothers, 1)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_flagsothers, 55)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_pretthunks, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_pretthunks, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_pretthunks, 56)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_psegrefbytes, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_psegrefbytes, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_psegrefbytes, 58)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_swaparea, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_swaparea, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_swaparea, 60)
    TEST_FIELD_SIZE  (IMAGE_OS2_HEADER, ne_expver, 2)
    TEST_FIELD_ALIGN (IMAGE_OS2_HEADER, ne_expver, 2)
    TEST_FIELD_OFFSET(IMAGE_OS2_HEADER, ne_expver, 62)
}

static void test_pack_IMAGE_RELOCATION(void)
{
    /* IMAGE_RELOCATION (pack 2) */
}

static void test_pack_IMAGE_RESOURCE_DATA_ENTRY(void)
{
    /* IMAGE_RESOURCE_DATA_ENTRY */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DATA_ENTRY, 16)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DATA_ENTRY, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, OffsetToData, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, OffsetToData, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, OffsetToData, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, Size, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, Size, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, Size, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, CodePage, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, CodePage, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, CodePage, 8)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DATA_ENTRY, Reserved, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DATA_ENTRY, Reserved, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DATA_ENTRY, Reserved, 12)
}

static void test_pack_IMAGE_RESOURCE_DIRECTORY(void)
{
    /* IMAGE_RESOURCE_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DIRECTORY, 16)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DIRECTORY, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, Characteristics, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, TimeDateStamp, 4)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, MajorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, MajorVersion, 8)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, MinorVersion, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, MinorVersion, 10)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, NumberOfNamedEntries, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, NumberOfNamedEntries, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, NumberOfNamedEntries, 12)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY, NumberOfIdEntries, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY, NumberOfIdEntries, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY, NumberOfIdEntries, 14)
}

static void test_pack_IMAGE_RESOURCE_DIRECTORY_ENTRY(void)
{
    /* IMAGE_RESOURCE_DIRECTORY_ENTRY */
}

static void test_pack_IMAGE_RESOURCE_DIRECTORY_STRING(void)
{
    /* IMAGE_RESOURCE_DIRECTORY_STRING */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DIRECTORY_STRING, 4)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DIRECTORY_STRING, 2)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY_STRING, Length, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY_STRING, Length, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY_STRING, Length, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIRECTORY_STRING, NameString, 1)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIRECTORY_STRING, NameString, 1)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIRECTORY_STRING, NameString, 2)
}

static void test_pack_IMAGE_RESOURCE_DIR_STRING_U(void)
{
    /* IMAGE_RESOURCE_DIR_STRING_U */
    TEST_TYPE_SIZE   (IMAGE_RESOURCE_DIR_STRING_U, 4)
    TEST_TYPE_ALIGN  (IMAGE_RESOURCE_DIR_STRING_U, 2)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIR_STRING_U, Length, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIR_STRING_U, Length, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIR_STRING_U, Length, 0)
    TEST_FIELD_SIZE  (IMAGE_RESOURCE_DIR_STRING_U, NameString, 2)
    TEST_FIELD_ALIGN (IMAGE_RESOURCE_DIR_STRING_U, NameString, 2)
    TEST_FIELD_OFFSET(IMAGE_RESOURCE_DIR_STRING_U, NameString, 2)
}

static void test_pack_IMAGE_SECTION_HEADER(void)
{
    /* IMAGE_SECTION_HEADER */
    TEST_FIELD_SIZE  (IMAGE_SECTION_HEADER, Name, 8)
    TEST_FIELD_ALIGN (IMAGE_SECTION_HEADER, Name, 1)
    TEST_FIELD_OFFSET(IMAGE_SECTION_HEADER, Name, 0)
}

static void test_pack_IMAGE_SEPARATE_DEBUG_HEADER(void)
{
    /* IMAGE_SEPARATE_DEBUG_HEADER */
    TEST_TYPE_SIZE   (IMAGE_SEPARATE_DEBUG_HEADER, 48)
    TEST_TYPE_ALIGN  (IMAGE_SEPARATE_DEBUG_HEADER, 4)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Signature, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Signature, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Signature, 0)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Flags, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Flags, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Flags, 2)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Machine, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Machine, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Machine, 4)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Characteristics, 2)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Characteristics, 2)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Characteristics, 6)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, TimeDateStamp, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, TimeDateStamp, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, TimeDateStamp, 8)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, CheckSum, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, CheckSum, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, CheckSum, 12)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, ImageBase, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, ImageBase, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, ImageBase, 16)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, SizeOfImage, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, SizeOfImage, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, SizeOfImage, 20)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, NumberOfSections, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, NumberOfSections, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, NumberOfSections, 24)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, ExportedNamesSize, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, ExportedNamesSize, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, ExportedNamesSize, 28)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, DebugDirectorySize, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, DebugDirectorySize, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, DebugDirectorySize, 32)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, SectionAlignment, 4)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, SectionAlignment, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, SectionAlignment, 36)
    TEST_FIELD_SIZE  (IMAGE_SEPARATE_DEBUG_HEADER, Reserved, 8)
    TEST_FIELD_ALIGN (IMAGE_SEPARATE_DEBUG_HEADER, Reserved, 4)
    TEST_FIELD_OFFSET(IMAGE_SEPARATE_DEBUG_HEADER, Reserved, 40)
}

static void test_pack_IMAGE_SYMBOL(void)
{
    /* IMAGE_SYMBOL (pack 2) */
}

static void test_pack_IMAGE_THUNK_DATA(void)
{
    /* IMAGE_THUNK_DATA */
}

static void test_pack_IMAGE_TLS_DIRECTORY(void)
{
    /* IMAGE_TLS_DIRECTORY */
    TEST_TYPE_SIZE   (IMAGE_TLS_DIRECTORY, 24)
    TEST_TYPE_ALIGN  (IMAGE_TLS_DIRECTORY, 4)
}

static void test_pack_IMAGE_TLS_DIRECTORY32(void)
{
    /* IMAGE_TLS_DIRECTORY32 */
    TEST_TYPE_SIZE   (IMAGE_TLS_DIRECTORY32, 24)
    TEST_TYPE_ALIGN  (IMAGE_TLS_DIRECTORY32, 4)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, StartAddressOfRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, StartAddressOfRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, StartAddressOfRawData, 0)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, EndAddressOfRawData, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, EndAddressOfRawData, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, EndAddressOfRawData, 4)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, AddressOfIndex, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, AddressOfIndex, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, AddressOfIndex, 8)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, AddressOfCallBacks, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, AddressOfCallBacks, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, AddressOfCallBacks, 12)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, SizeOfZeroFill, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, SizeOfZeroFill, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, SizeOfZeroFill, 16)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY32, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY32, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY32, Characteristics, 20)
}

static void test_pack_IMAGE_TLS_DIRECTORY64(void)
{
    /* IMAGE_TLS_DIRECTORY64 */
    TEST_TYPE_SIZE   (IMAGE_TLS_DIRECTORY64, 40)
    TEST_TYPE_ALIGN  (IMAGE_TLS_DIRECTORY64, 8)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, StartAddressOfRawData, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, StartAddressOfRawData, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, StartAddressOfRawData, 0)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, EndAddressOfRawData, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, EndAddressOfRawData, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, EndAddressOfRawData, 8)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, AddressOfIndex, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, AddressOfIndex, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, AddressOfIndex, 16)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, AddressOfCallBacks, 8)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, AddressOfCallBacks, 8)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, AddressOfCallBacks, 24)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, SizeOfZeroFill, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, SizeOfZeroFill, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, SizeOfZeroFill, 32)
    TEST_FIELD_SIZE  (IMAGE_TLS_DIRECTORY64, Characteristics, 4)
    TEST_FIELD_ALIGN (IMAGE_TLS_DIRECTORY64, Characteristics, 4)
    TEST_FIELD_OFFSET(IMAGE_TLS_DIRECTORY64, Characteristics, 36)
}

static void test_pack_IMAGE_VXD_HEADER(void)
{
    /* IMAGE_VXD_HEADER (pack 2) */
    TEST_TYPE_SIZE   (IMAGE_VXD_HEADER, 196)
    TEST_TYPE_ALIGN  (IMAGE_VXD_HEADER, 2)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_magic, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_magic, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_magic, 0)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_border, 1)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_border, 1)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_border, 2)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_worder, 1)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_worder, 1)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_worder, 3)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_level, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_level, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_level, 4)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_cpu, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_cpu, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_cpu, 8)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_os, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_os, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_os, 10)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ver, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ver, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ver, 12)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_mflags, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_mflags, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_mflags, 16)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_mpages, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_mpages, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_mpages, 20)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_startobj, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_startobj, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_startobj, 24)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_eip, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_eip, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_eip, 28)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_stackobj, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_stackobj, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_stackobj, 32)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_esp, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_esp, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_esp, 36)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_pagesize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_pagesize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_pagesize, 40)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_lastpagesize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_lastpagesize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_lastpagesize, 44)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_fixupsize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_fixupsize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_fixupsize, 48)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_fixupsum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_fixupsum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_fixupsum, 52)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ldrsize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ldrsize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ldrsize, 56)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ldrsum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ldrsum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ldrsum, 60)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_objtab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_objtab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_objtab, 64)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_objcnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_objcnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_objcnt, 68)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_objmap, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_objmap, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_objmap, 72)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_itermap, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_itermap, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_itermap, 76)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_rsrctab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_rsrctab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_rsrctab, 80)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_rsrccnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_rsrccnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_rsrccnt, 84)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_restab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_restab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_restab, 88)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_enttab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_enttab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_enttab, 92)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_dirtab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_dirtab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_dirtab, 96)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_dircnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_dircnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_dircnt, 100)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_fpagetab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_fpagetab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_fpagetab, 104)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_frectab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_frectab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_frectab, 108)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_impmod, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_impmod, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_impmod, 112)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_impmodcnt, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_impmodcnt, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_impmodcnt, 116)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_impproc, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_impproc, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_impproc, 120)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_pagesum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_pagesum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_pagesum, 124)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_datapage, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_datapage, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_datapage, 128)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_preload, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_preload, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_preload, 132)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_nrestab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_nrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_nrestab, 136)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_cbnrestab, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_cbnrestab, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_cbnrestab, 140)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_nressum, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_nressum, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_nressum, 144)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_autodata, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_autodata, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_autodata, 148)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_debuginfo, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_debuginfo, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_debuginfo, 152)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_debuglen, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_debuglen, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_debuglen, 156)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_instpreload, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_instpreload, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_instpreload, 160)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_instdemand, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_instdemand, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_instdemand, 164)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_heapsize, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_heapsize, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_heapsize, 168)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_res3, 12)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_res3, 1)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_res3, 172)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_winresoff, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_winresoff, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_winresoff, 184)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_winreslen, 4)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_winreslen, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_winreslen, 188)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_devid, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_devid, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_devid, 192)
    TEST_FIELD_SIZE  (IMAGE_VXD_HEADER, e32_ddkver, 2)
    TEST_FIELD_ALIGN (IMAGE_VXD_HEADER, e32_ddkver, 2)
    TEST_FIELD_OFFSET(IMAGE_VXD_HEADER, e32_ddkver, 194)
}

static void test_pack_IO_COUNTERS(void)
{
    /* IO_COUNTERS (pack 8) */
    TEST_TYPE_SIZE   (IO_COUNTERS, 48)
    TEST_TYPE_ALIGN  (IO_COUNTERS, 8)
    TEST_FIELD_SIZE  (IO_COUNTERS, ReadOperationCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, ReadOperationCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, ReadOperationCount, 0)
    TEST_FIELD_SIZE  (IO_COUNTERS, WriteOperationCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, WriteOperationCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, WriteOperationCount, 8)
    TEST_FIELD_SIZE  (IO_COUNTERS, OtherOperationCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, OtherOperationCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, OtherOperationCount, 16)
    TEST_FIELD_SIZE  (IO_COUNTERS, ReadTransferCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, ReadTransferCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, ReadTransferCount, 24)
    TEST_FIELD_SIZE  (IO_COUNTERS, WriteTransferCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, WriteTransferCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, WriteTransferCount, 32)
    TEST_FIELD_SIZE  (IO_COUNTERS, OtherTransferCount, 8)
    TEST_FIELD_ALIGN (IO_COUNTERS, OtherTransferCount, 8)
    TEST_FIELD_OFFSET(IO_COUNTERS, OtherTransferCount, 40)
}

static void test_pack_LANGID(void)
{
    /* LANGID */
    TEST_TYPE_SIZE   (LANGID, 2)
    TEST_TYPE_ALIGN  (LANGID, 2)
    TEST_TYPE_UNSIGNED(LANGID)
}

static void test_pack_LARGE_INTEGER(void)
{
    /* LARGE_INTEGER */
}

static void test_pack_LCID(void)
{
    /* LCID */
    TEST_TYPE_SIZE   (LCID, 4)
    TEST_TYPE_ALIGN  (LCID, 4)
    TEST_TYPE_UNSIGNED(LCID)
}

static void test_pack_LIST_ENTRY(void)
{
    /* LIST_ENTRY */
    TEST_TYPE_SIZE   (LIST_ENTRY, 8)
    TEST_TYPE_ALIGN  (LIST_ENTRY, 4)
    TEST_FIELD_SIZE  (LIST_ENTRY, Flink, 4)
    TEST_FIELD_ALIGN (LIST_ENTRY, Flink, 4)
    TEST_FIELD_OFFSET(LIST_ENTRY, Flink, 0)
    TEST_FIELD_SIZE  (LIST_ENTRY, Blink, 4)
    TEST_FIELD_ALIGN (LIST_ENTRY, Blink, 4)
    TEST_FIELD_OFFSET(LIST_ENTRY, Blink, 4)
}

static void test_pack_LONG(void)
{
    /* LONG */
    TEST_TYPE_SIZE   (LONG, 4)
    TEST_TYPE_ALIGN  (LONG, 4)
    TEST_TYPE_SIGNED(LONG)
}

static void test_pack_LONGLONG(void)
{
    /* LONGLONG */
    TEST_TYPE_SIZE   (LONGLONG, 8)
    TEST_TYPE_ALIGN  (LONGLONG, 8)
    TEST_TYPE_SIGNED(LONGLONG)
}

static void test_pack_LUID(void)
{
    /* LUID */
    TEST_TYPE_SIZE   (LUID, 8)
    TEST_TYPE_ALIGN  (LUID, 4)
    TEST_FIELD_SIZE  (LUID, LowPart, 4)
    TEST_FIELD_ALIGN (LUID, LowPart, 4)
    TEST_FIELD_OFFSET(LUID, LowPart, 0)
    TEST_FIELD_SIZE  (LUID, HighPart, 4)
    TEST_FIELD_ALIGN (LUID, HighPart, 4)
    TEST_FIELD_OFFSET(LUID, HighPart, 4)
}

static void test_pack_LUID_AND_ATTRIBUTES(void)
{
    /* LUID_AND_ATTRIBUTES (pack 4) */
    TEST_TYPE_SIZE   (LUID_AND_ATTRIBUTES, 12)
    TEST_TYPE_ALIGN  (LUID_AND_ATTRIBUTES, 4)
    TEST_FIELD_SIZE  (LUID_AND_ATTRIBUTES, Luid, 8)
    TEST_FIELD_ALIGN (LUID_AND_ATTRIBUTES, Luid, 4)
    TEST_FIELD_OFFSET(LUID_AND_ATTRIBUTES, Luid, 0)
    TEST_FIELD_SIZE  (LUID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_ALIGN (LUID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_OFFSET(LUID_AND_ATTRIBUTES, Attributes, 8)
}

static void test_pack_MEMORY_BASIC_INFORMATION(void)
{
    /* MEMORY_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (MEMORY_BASIC_INFORMATION, 28)
    TEST_TYPE_ALIGN  (MEMORY_BASIC_INFORMATION, 4)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, BaseAddress, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, BaseAddress, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, BaseAddress, 0)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, AllocationBase, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, AllocationBase, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, AllocationBase, 4)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, AllocationProtect, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, AllocationProtect, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, AllocationProtect, 8)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, RegionSize, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, RegionSize, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, RegionSize, 12)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, State, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, State, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, State, 16)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, Protect, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, Protect, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, Protect, 20)
    TEST_FIELD_SIZE  (MEMORY_BASIC_INFORMATION, Type, 4)
    TEST_FIELD_ALIGN (MEMORY_BASIC_INFORMATION, Type, 4)
    TEST_FIELD_OFFSET(MEMORY_BASIC_INFORMATION, Type, 24)
}

static void test_pack_MESSAGE_RESOURCE_BLOCK(void)
{
    /* MESSAGE_RESOURCE_BLOCK */
    TEST_TYPE_SIZE   (MESSAGE_RESOURCE_BLOCK, 12)
    TEST_TYPE_ALIGN  (MESSAGE_RESOURCE_BLOCK, 4)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_BLOCK, LowId, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_BLOCK, LowId, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_BLOCK, LowId, 0)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_BLOCK, HighId, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_BLOCK, HighId, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_BLOCK, HighId, 4)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_BLOCK, OffsetToEntries, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_BLOCK, OffsetToEntries, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_BLOCK, OffsetToEntries, 8)
}

static void test_pack_MESSAGE_RESOURCE_DATA(void)
{
    /* MESSAGE_RESOURCE_DATA */
    TEST_TYPE_SIZE   (MESSAGE_RESOURCE_DATA, 16)
    TEST_TYPE_ALIGN  (MESSAGE_RESOURCE_DATA, 4)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_DATA, NumberOfBlocks, 4)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_DATA, NumberOfBlocks, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_DATA, NumberOfBlocks, 0)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_DATA, Blocks, 12)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_DATA, Blocks, 4)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_DATA, Blocks, 4)
}

static void test_pack_MESSAGE_RESOURCE_ENTRY(void)
{
    /* MESSAGE_RESOURCE_ENTRY */
    TEST_TYPE_SIZE   (MESSAGE_RESOURCE_ENTRY, 6)
    TEST_TYPE_ALIGN  (MESSAGE_RESOURCE_ENTRY, 2)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_ENTRY, Length, 2)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_ENTRY, Length, 2)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_ENTRY, Length, 0)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_ENTRY, Flags, 2)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_ENTRY, Flags, 2)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_ENTRY, Flags, 2)
    TEST_FIELD_SIZE  (MESSAGE_RESOURCE_ENTRY, Text, 1)
    TEST_FIELD_ALIGN (MESSAGE_RESOURCE_ENTRY, Text, 1)
    TEST_FIELD_OFFSET(MESSAGE_RESOURCE_ENTRY, Text, 4)
}

static void test_pack_NT_TIB(void)
{
    /* NT_TIB */
    TEST_FIELD_SIZE  (NT_TIB, ExceptionList, 4)
    TEST_FIELD_ALIGN (NT_TIB, ExceptionList, 4)
    TEST_FIELD_OFFSET(NT_TIB, ExceptionList, 0)
    TEST_FIELD_SIZE  (NT_TIB, StackBase, 4)
    TEST_FIELD_ALIGN (NT_TIB, StackBase, 4)
    TEST_FIELD_OFFSET(NT_TIB, StackBase, 4)
    TEST_FIELD_SIZE  (NT_TIB, StackLimit, 4)
    TEST_FIELD_ALIGN (NT_TIB, StackLimit, 4)
    TEST_FIELD_OFFSET(NT_TIB, StackLimit, 8)
    TEST_FIELD_SIZE  (NT_TIB, SubSystemTib, 4)
    TEST_FIELD_ALIGN (NT_TIB, SubSystemTib, 4)
    TEST_FIELD_OFFSET(NT_TIB, SubSystemTib, 12)
}

static void test_pack_OBJECT_TYPE_LIST(void)
{
    /* OBJECT_TYPE_LIST */
    TEST_TYPE_SIZE   (OBJECT_TYPE_LIST, 8)
    TEST_TYPE_ALIGN  (OBJECT_TYPE_LIST, 4)
    TEST_FIELD_SIZE  (OBJECT_TYPE_LIST, Level, 2)
    TEST_FIELD_ALIGN (OBJECT_TYPE_LIST, Level, 2)
    TEST_FIELD_OFFSET(OBJECT_TYPE_LIST, Level, 0)
    TEST_FIELD_SIZE  (OBJECT_TYPE_LIST, Sbz, 2)
    TEST_FIELD_ALIGN (OBJECT_TYPE_LIST, Sbz, 2)
    TEST_FIELD_OFFSET(OBJECT_TYPE_LIST, Sbz, 2)
    TEST_FIELD_SIZE  (OBJECT_TYPE_LIST, ObjectType, 4)
    TEST_FIELD_ALIGN (OBJECT_TYPE_LIST, ObjectType, 4)
    TEST_FIELD_OFFSET(OBJECT_TYPE_LIST, ObjectType, 4)
}

static void test_pack_PACCESS_ALLOWED_ACE(void)
{
    /* PACCESS_ALLOWED_ACE */
    TEST_TYPE_SIZE   (PACCESS_ALLOWED_ACE, 4)
    TEST_TYPE_ALIGN  (PACCESS_ALLOWED_ACE, 4)
    TEST_TARGET_SIZE (PACCESS_ALLOWED_ACE, 12)
    TEST_TARGET_ALIGN(PACCESS_ALLOWED_ACE, 4)
}

static void test_pack_PACCESS_DENIED_ACE(void)
{
    /* PACCESS_DENIED_ACE */
    TEST_TYPE_SIZE   (PACCESS_DENIED_ACE, 4)
    TEST_TYPE_ALIGN  (PACCESS_DENIED_ACE, 4)
    TEST_TARGET_SIZE (PACCESS_DENIED_ACE, 12)
    TEST_TARGET_ALIGN(PACCESS_DENIED_ACE, 4)
}

static void test_pack_PACCESS_TOKEN(void)
{
    /* PACCESS_TOKEN */
    TEST_TYPE_SIZE   (PACCESS_TOKEN, 4)
    TEST_TYPE_ALIGN  (PACCESS_TOKEN, 4)
}

static void test_pack_PACE_HEADER(void)
{
    /* PACE_HEADER */
    TEST_TYPE_SIZE   (PACE_HEADER, 4)
    TEST_TYPE_ALIGN  (PACE_HEADER, 4)
    TEST_TARGET_SIZE (PACE_HEADER, 4)
    TEST_TARGET_ALIGN(PACE_HEADER, 2)
}

static void test_pack_PACL(void)
{
    /* PACL */
    TEST_TYPE_SIZE   (PACL, 4)
    TEST_TYPE_ALIGN  (PACL, 4)
    TEST_TARGET_SIZE (PACL, 8)
    TEST_TARGET_ALIGN(PACL, 2)
}

static void test_pack_PACL_REVISION_INFORMATION(void)
{
    /* PACL_REVISION_INFORMATION */
    TEST_TYPE_SIZE   (PACL_REVISION_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PACL_REVISION_INFORMATION, 4)
    TEST_TARGET_SIZE (PACL_REVISION_INFORMATION, 4)
    TEST_TARGET_ALIGN(PACL_REVISION_INFORMATION, 4)
}

static void test_pack_PACL_SIZE_INFORMATION(void)
{
    /* PACL_SIZE_INFORMATION */
    TEST_TYPE_SIZE   (PACL_SIZE_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PACL_SIZE_INFORMATION, 4)
    TEST_TARGET_SIZE (PACL_SIZE_INFORMATION, 12)
    TEST_TARGET_ALIGN(PACL_SIZE_INFORMATION, 4)
}

static void test_pack_PCCH(void)
{
    /* PCCH */
    TEST_TYPE_SIZE   (PCCH, 4)
    TEST_TYPE_ALIGN  (PCCH, 4)
    TEST_TARGET_SIZE (PCCH, 1)
    TEST_TARGET_ALIGN(PCCH, 1)
}

static void test_pack_PCH(void)
{
    /* PCH */
    TEST_TYPE_SIZE   (PCH, 4)
    TEST_TYPE_ALIGN  (PCH, 4)
    TEST_TARGET_SIZE (PCH, 1)
    TEST_TARGET_ALIGN(PCH, 1)
}

static void test_pack_PCSTR(void)
{
    /* PCSTR */
    TEST_TYPE_SIZE   (PCSTR, 4)
    TEST_TYPE_ALIGN  (PCSTR, 4)
    TEST_TARGET_SIZE (PCSTR, 1)
    TEST_TARGET_ALIGN(PCSTR, 1)
}

static void test_pack_PCWCH(void)
{
    /* PCWCH */
    TEST_TYPE_SIZE   (PCWCH, 4)
    TEST_TYPE_ALIGN  (PCWCH, 4)
    TEST_TARGET_SIZE (PCWCH, 2)
    TEST_TARGET_ALIGN(PCWCH, 2)
}

static void test_pack_PCWSTR(void)
{
    /* PCWSTR */
    TEST_TYPE_SIZE   (PCWSTR, 4)
    TEST_TYPE_ALIGN  (PCWSTR, 4)
    TEST_TARGET_SIZE (PCWSTR, 2)
    TEST_TARGET_ALIGN(PCWSTR, 2)
}

static void test_pack_PEXCEPTION_POINTERS(void)
{
    /* PEXCEPTION_POINTERS */
    TEST_TYPE_SIZE   (PEXCEPTION_POINTERS, 4)
    TEST_TYPE_ALIGN  (PEXCEPTION_POINTERS, 4)
    TEST_TARGET_SIZE (PEXCEPTION_POINTERS, 8)
    TEST_TARGET_ALIGN(PEXCEPTION_POINTERS, 4)
}

static void test_pack_PEXCEPTION_RECORD(void)
{
    /* PEXCEPTION_RECORD */
    TEST_TYPE_SIZE   (PEXCEPTION_RECORD, 4)
    TEST_TYPE_ALIGN  (PEXCEPTION_RECORD, 4)
    TEST_TARGET_SIZE (PEXCEPTION_RECORD, 80)
    TEST_TARGET_ALIGN(PEXCEPTION_RECORD, 4)
}

static void test_pack_PFPO_DATA(void)
{
    /* PFPO_DATA */
    TEST_TYPE_SIZE   (PFPO_DATA, 4)
    TEST_TYPE_ALIGN  (PFPO_DATA, 4)
    TEST_TARGET_SIZE (PFPO_DATA, 16)
    TEST_TARGET_ALIGN(PFPO_DATA, 4)
}

static void test_pack_PGENERIC_MAPPING(void)
{
    /* PGENERIC_MAPPING */
    TEST_TYPE_SIZE   (PGENERIC_MAPPING, 4)
    TEST_TYPE_ALIGN  (PGENERIC_MAPPING, 4)
    TEST_TARGET_SIZE (PGENERIC_MAPPING, 16)
    TEST_TARGET_ALIGN(PGENERIC_MAPPING, 4)
}

static void test_pack_PHANDLE(void)
{
    /* PHANDLE */
    TEST_TYPE_SIZE   (PHANDLE, 4)
    TEST_TYPE_ALIGN  (PHANDLE, 4)
    TEST_TARGET_SIZE (PHANDLE, 4)
    TEST_TARGET_ALIGN(PHANDLE, 4)
}

static void test_pack_PIMAGE_ARCHIVE_MEMBER_HEADER(void)
{
    /* PIMAGE_ARCHIVE_MEMBER_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_ARCHIVE_MEMBER_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_ARCHIVE_MEMBER_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_ARCHIVE_MEMBER_HEADER, 60)
    TEST_TARGET_ALIGN(PIMAGE_ARCHIVE_MEMBER_HEADER, 1)
}

static void test_pack_PIMAGE_AUX_SYMBOL(void)
{
    /* PIMAGE_AUX_SYMBOL */
    TEST_TYPE_SIZE   (PIMAGE_AUX_SYMBOL, 4)
    TEST_TYPE_ALIGN  (PIMAGE_AUX_SYMBOL, 4)
}

static void test_pack_PIMAGE_BASE_RELOCATION(void)
{
    /* PIMAGE_BASE_RELOCATION */
    TEST_TYPE_SIZE   (PIMAGE_BASE_RELOCATION, 4)
    TEST_TYPE_ALIGN  (PIMAGE_BASE_RELOCATION, 4)
    TEST_TARGET_SIZE (PIMAGE_BASE_RELOCATION, 8)
    TEST_TARGET_ALIGN(PIMAGE_BASE_RELOCATION, 4)
}

static void test_pack_PIMAGE_BOUND_FORWARDER_REF(void)
{
    /* PIMAGE_BOUND_FORWARDER_REF */
    TEST_TYPE_SIZE   (PIMAGE_BOUND_FORWARDER_REF, 4)
    TEST_TYPE_ALIGN  (PIMAGE_BOUND_FORWARDER_REF, 4)
    TEST_TARGET_SIZE (PIMAGE_BOUND_FORWARDER_REF, 8)
    TEST_TARGET_ALIGN(PIMAGE_BOUND_FORWARDER_REF, 4)
}

static void test_pack_PIMAGE_BOUND_IMPORT_DESCRIPTOR(void)
{
    /* PIMAGE_BOUND_IMPORT_DESCRIPTOR */
    TEST_TYPE_SIZE   (PIMAGE_BOUND_IMPORT_DESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (PIMAGE_BOUND_IMPORT_DESCRIPTOR, 4)
    TEST_TARGET_SIZE (PIMAGE_BOUND_IMPORT_DESCRIPTOR, 8)
    TEST_TARGET_ALIGN(PIMAGE_BOUND_IMPORT_DESCRIPTOR, 4)
}

static void test_pack_PIMAGE_COFF_SYMBOLS_HEADER(void)
{
    /* PIMAGE_COFF_SYMBOLS_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_COFF_SYMBOLS_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_COFF_SYMBOLS_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_COFF_SYMBOLS_HEADER, 32)
    TEST_TARGET_ALIGN(PIMAGE_COFF_SYMBOLS_HEADER, 4)
}

static void test_pack_PIMAGE_DATA_DIRECTORY(void)
{
    /* PIMAGE_DATA_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_DATA_DIRECTORY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_DATA_DIRECTORY, 4)
    TEST_TARGET_SIZE (PIMAGE_DATA_DIRECTORY, 8)
    TEST_TARGET_ALIGN(PIMAGE_DATA_DIRECTORY, 4)
}

static void test_pack_PIMAGE_DEBUG_DIRECTORY(void)
{
    /* PIMAGE_DEBUG_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_DEBUG_DIRECTORY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_DEBUG_DIRECTORY, 4)
    TEST_TARGET_SIZE (PIMAGE_DEBUG_DIRECTORY, 28)
    TEST_TARGET_ALIGN(PIMAGE_DEBUG_DIRECTORY, 4)
}

static void test_pack_PIMAGE_DEBUG_MISC(void)
{
    /* PIMAGE_DEBUG_MISC */
    TEST_TYPE_SIZE   (PIMAGE_DEBUG_MISC, 4)
    TEST_TYPE_ALIGN  (PIMAGE_DEBUG_MISC, 4)
    TEST_TARGET_SIZE (PIMAGE_DEBUG_MISC, 16)
    TEST_TARGET_ALIGN(PIMAGE_DEBUG_MISC, 4)
}

static void test_pack_PIMAGE_DOS_HEADER(void)
{
    /* PIMAGE_DOS_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_DOS_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_DOS_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_DOS_HEADER, 64)
    TEST_TARGET_ALIGN(PIMAGE_DOS_HEADER, 2)
}

static void test_pack_PIMAGE_EXPORT_DIRECTORY(void)
{
    /* PIMAGE_EXPORT_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_EXPORT_DIRECTORY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_EXPORT_DIRECTORY, 4)
    TEST_TARGET_SIZE (PIMAGE_EXPORT_DIRECTORY, 40)
    TEST_TARGET_ALIGN(PIMAGE_EXPORT_DIRECTORY, 4)
}

static void test_pack_PIMAGE_FILE_HEADER(void)
{
    /* PIMAGE_FILE_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_FILE_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_FILE_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_FILE_HEADER, 20)
    TEST_TARGET_ALIGN(PIMAGE_FILE_HEADER, 4)
}

static void test_pack_PIMAGE_FUNCTION_ENTRY(void)
{
    /* PIMAGE_FUNCTION_ENTRY */
    TEST_TYPE_SIZE   (PIMAGE_FUNCTION_ENTRY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_FUNCTION_ENTRY, 4)
    TEST_TARGET_SIZE (PIMAGE_FUNCTION_ENTRY, 12)
    TEST_TARGET_ALIGN(PIMAGE_FUNCTION_ENTRY, 4)
}

static void test_pack_PIMAGE_IMPORT_BY_NAME(void)
{
    /* PIMAGE_IMPORT_BY_NAME */
    TEST_TYPE_SIZE   (PIMAGE_IMPORT_BY_NAME, 4)
    TEST_TYPE_ALIGN  (PIMAGE_IMPORT_BY_NAME, 4)
    TEST_TARGET_SIZE (PIMAGE_IMPORT_BY_NAME, 4)
    TEST_TARGET_ALIGN(PIMAGE_IMPORT_BY_NAME, 2)
}

static void test_pack_PIMAGE_IMPORT_DESCRIPTOR(void)
{
    /* PIMAGE_IMPORT_DESCRIPTOR */
    TEST_TYPE_SIZE   (PIMAGE_IMPORT_DESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (PIMAGE_IMPORT_DESCRIPTOR, 4)
}

static void test_pack_PIMAGE_LINENUMBER(void)
{
    /* PIMAGE_LINENUMBER */
    TEST_TYPE_SIZE   (PIMAGE_LINENUMBER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_LINENUMBER, 4)
}

static void test_pack_PIMAGE_LOAD_CONFIG_DIRECTORY(void)
{
    /* PIMAGE_LOAD_CONFIG_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_LOAD_CONFIG_DIRECTORY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_LOAD_CONFIG_DIRECTORY, 4)
    TEST_TARGET_SIZE (PIMAGE_LOAD_CONFIG_DIRECTORY, 72)
    TEST_TARGET_ALIGN(PIMAGE_LOAD_CONFIG_DIRECTORY, 4)
}

static void test_pack_PIMAGE_NT_HEADERS(void)
{
    /* PIMAGE_NT_HEADERS */
    TEST_TYPE_SIZE   (PIMAGE_NT_HEADERS, 4)
    TEST_TYPE_ALIGN  (PIMAGE_NT_HEADERS, 4)
}

static void test_pack_PIMAGE_NT_HEADERS32(void)
{
    /* PIMAGE_NT_HEADERS32 */
    TEST_TYPE_SIZE   (PIMAGE_NT_HEADERS32, 4)
    TEST_TYPE_ALIGN  (PIMAGE_NT_HEADERS32, 4)
    TEST_TARGET_SIZE (PIMAGE_NT_HEADERS32, 248)
    TEST_TARGET_ALIGN(PIMAGE_NT_HEADERS32, 4)
}

static void test_pack_PIMAGE_NT_HEADERS64(void)
{
    /* PIMAGE_NT_HEADERS64 */
    TEST_TYPE_SIZE   (PIMAGE_NT_HEADERS64, 4)
    TEST_TYPE_ALIGN  (PIMAGE_NT_HEADERS64, 4)
    TEST_TARGET_SIZE (PIMAGE_NT_HEADERS64, 264)
    TEST_TARGET_ALIGN(PIMAGE_NT_HEADERS64, 8)
}

static void test_pack_PIMAGE_OPTIONAL_HEADER(void)
{
    /* PIMAGE_OPTIONAL_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_OPTIONAL_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_OPTIONAL_HEADER, 4)
}

static void test_pack_PIMAGE_OPTIONAL_HEADER32(void)
{
    /* PIMAGE_OPTIONAL_HEADER32 */
    TEST_TYPE_SIZE   (PIMAGE_OPTIONAL_HEADER32, 4)
    TEST_TYPE_ALIGN  (PIMAGE_OPTIONAL_HEADER32, 4)
    TEST_TARGET_SIZE (PIMAGE_OPTIONAL_HEADER32, 224)
    TEST_TARGET_ALIGN(PIMAGE_OPTIONAL_HEADER32, 4)
}

static void test_pack_PIMAGE_OPTIONAL_HEADER64(void)
{
    /* PIMAGE_OPTIONAL_HEADER64 */
    TEST_TYPE_SIZE   (PIMAGE_OPTIONAL_HEADER64, 4)
    TEST_TYPE_ALIGN  (PIMAGE_OPTIONAL_HEADER64, 4)
    TEST_TARGET_SIZE (PIMAGE_OPTIONAL_HEADER64, 240)
    TEST_TARGET_ALIGN(PIMAGE_OPTIONAL_HEADER64, 8)
}

static void test_pack_PIMAGE_OS2_HEADER(void)
{
    /* PIMAGE_OS2_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_OS2_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_OS2_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_OS2_HEADER, 64)
    TEST_TARGET_ALIGN(PIMAGE_OS2_HEADER, 2)
}

static void test_pack_PIMAGE_RELOCATION(void)
{
    /* PIMAGE_RELOCATION */
    TEST_TYPE_SIZE   (PIMAGE_RELOCATION, 4)
    TEST_TYPE_ALIGN  (PIMAGE_RELOCATION, 4)
}

static void test_pack_PIMAGE_RESOURCE_DATA_ENTRY(void)
{
    /* PIMAGE_RESOURCE_DATA_ENTRY */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DATA_ENTRY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DATA_ENTRY, 4)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DATA_ENTRY, 16)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DATA_ENTRY, 4)
}

static void test_pack_PIMAGE_RESOURCE_DIRECTORY(void)
{
    /* PIMAGE_RESOURCE_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIRECTORY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIRECTORY, 4)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DIRECTORY, 16)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DIRECTORY, 4)
}

static void test_pack_PIMAGE_RESOURCE_DIRECTORY_ENTRY(void)
{
    /* PIMAGE_RESOURCE_DIRECTORY_ENTRY */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIRECTORY_ENTRY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIRECTORY_ENTRY, 4)
}

static void test_pack_PIMAGE_RESOURCE_DIRECTORY_STRING(void)
{
    /* PIMAGE_RESOURCE_DIRECTORY_STRING */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIRECTORY_STRING, 4)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIRECTORY_STRING, 4)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DIRECTORY_STRING, 4)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DIRECTORY_STRING, 2)
}

static void test_pack_PIMAGE_RESOURCE_DIR_STRING_U(void)
{
    /* PIMAGE_RESOURCE_DIR_STRING_U */
    TEST_TYPE_SIZE   (PIMAGE_RESOURCE_DIR_STRING_U, 4)
    TEST_TYPE_ALIGN  (PIMAGE_RESOURCE_DIR_STRING_U, 4)
    TEST_TARGET_SIZE (PIMAGE_RESOURCE_DIR_STRING_U, 4)
    TEST_TARGET_ALIGN(PIMAGE_RESOURCE_DIR_STRING_U, 2)
}

static void test_pack_PIMAGE_SECTION_HEADER(void)
{
    /* PIMAGE_SECTION_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_SECTION_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_SECTION_HEADER, 4)
}

static void test_pack_PIMAGE_SEPARATE_DEBUG_HEADER(void)
{
    /* PIMAGE_SEPARATE_DEBUG_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_SEPARATE_DEBUG_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_SEPARATE_DEBUG_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_SEPARATE_DEBUG_HEADER, 48)
    TEST_TARGET_ALIGN(PIMAGE_SEPARATE_DEBUG_HEADER, 4)
}

static void test_pack_PIMAGE_SYMBOL(void)
{
    /* PIMAGE_SYMBOL */
    TEST_TYPE_SIZE   (PIMAGE_SYMBOL, 4)
    TEST_TYPE_ALIGN  (PIMAGE_SYMBOL, 4)
}

static void test_pack_PIMAGE_THUNK_DATA(void)
{
    /* PIMAGE_THUNK_DATA */
    TEST_TYPE_SIZE   (PIMAGE_THUNK_DATA, 4)
    TEST_TYPE_ALIGN  (PIMAGE_THUNK_DATA, 4)
}

static void test_pack_PIMAGE_TLS_CALLBACK(void)
{
    /* PIMAGE_TLS_CALLBACK */
    TEST_TYPE_SIZE   (PIMAGE_TLS_CALLBACK, 4)
    TEST_TYPE_ALIGN  (PIMAGE_TLS_CALLBACK, 4)
}

static void test_pack_PIMAGE_TLS_DIRECTORY(void)
{
    /* PIMAGE_TLS_DIRECTORY */
    TEST_TYPE_SIZE   (PIMAGE_TLS_DIRECTORY, 4)
    TEST_TYPE_ALIGN  (PIMAGE_TLS_DIRECTORY, 4)
}

static void test_pack_PIMAGE_VXD_HEADER(void)
{
    /* PIMAGE_VXD_HEADER */
    TEST_TYPE_SIZE   (PIMAGE_VXD_HEADER, 4)
    TEST_TYPE_ALIGN  (PIMAGE_VXD_HEADER, 4)
    TEST_TARGET_SIZE (PIMAGE_VXD_HEADER, 196)
    TEST_TARGET_ALIGN(PIMAGE_VXD_HEADER, 2)
}

static void test_pack_PIO_COUNTERS(void)
{
    /* PIO_COUNTERS */
    TEST_TYPE_SIZE   (PIO_COUNTERS, 4)
    TEST_TYPE_ALIGN  (PIO_COUNTERS, 4)
    TEST_TARGET_SIZE (PIO_COUNTERS, 48)
    TEST_TARGET_ALIGN(PIO_COUNTERS, 8)
}

static void test_pack_PISECURITY_DESCRIPTOR(void)
{
    /* PISECURITY_DESCRIPTOR */
    TEST_TYPE_SIZE   (PISECURITY_DESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (PISECURITY_DESCRIPTOR, 4)
    TEST_TARGET_SIZE (PISECURITY_DESCRIPTOR, 20)
    TEST_TARGET_ALIGN(PISECURITY_DESCRIPTOR, 4)
}

static void test_pack_PISECURITY_DESCRIPTOR_RELATIVE(void)
{
    /* PISECURITY_DESCRIPTOR_RELATIVE */
    TEST_TYPE_SIZE   (PISECURITY_DESCRIPTOR_RELATIVE, 4)
    TEST_TYPE_ALIGN  (PISECURITY_DESCRIPTOR_RELATIVE, 4)
    TEST_TARGET_SIZE (PISECURITY_DESCRIPTOR_RELATIVE, 20)
    TEST_TARGET_ALIGN(PISECURITY_DESCRIPTOR_RELATIVE, 4)
}

static void test_pack_PISID(void)
{
    /* PISID */
    TEST_TYPE_SIZE   (PISID, 4)
    TEST_TYPE_ALIGN  (PISID, 4)
    TEST_TARGET_SIZE (PISID, 12)
    TEST_TARGET_ALIGN(PISID, 4)
}

static void test_pack_PLARGE_INTEGER(void)
{
    /* PLARGE_INTEGER */
    TEST_TYPE_SIZE   (PLARGE_INTEGER, 4)
    TEST_TYPE_ALIGN  (PLARGE_INTEGER, 4)
}

static void test_pack_PLIST_ENTRY(void)
{
    /* PLIST_ENTRY */
    TEST_TYPE_SIZE   (PLIST_ENTRY, 4)
    TEST_TYPE_ALIGN  (PLIST_ENTRY, 4)
    TEST_TARGET_SIZE (PLIST_ENTRY, 8)
    TEST_TARGET_ALIGN(PLIST_ENTRY, 4)
}

static void test_pack_PLUID(void)
{
    /* PLUID */
    TEST_TYPE_SIZE   (PLUID, 4)
    TEST_TYPE_ALIGN  (PLUID, 4)
    TEST_TARGET_SIZE (PLUID, 8)
    TEST_TARGET_ALIGN(PLUID, 4)
}

static void test_pack_PLUID_AND_ATTRIBUTES(void)
{
    /* PLUID_AND_ATTRIBUTES */
    TEST_TYPE_SIZE   (PLUID_AND_ATTRIBUTES, 4)
    TEST_TYPE_ALIGN  (PLUID_AND_ATTRIBUTES, 4)
    TEST_TARGET_SIZE (PLUID_AND_ATTRIBUTES, 12)
    TEST_TARGET_ALIGN(PLUID_AND_ATTRIBUTES, 4)
}

static void test_pack_PMEMORY_BASIC_INFORMATION(void)
{
    /* PMEMORY_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (PMEMORY_BASIC_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PMEMORY_BASIC_INFORMATION, 4)
    TEST_TARGET_SIZE (PMEMORY_BASIC_INFORMATION, 28)
    TEST_TARGET_ALIGN(PMEMORY_BASIC_INFORMATION, 4)
}

static void test_pack_PMESSAGE_RESOURCE_BLOCK(void)
{
    /* PMESSAGE_RESOURCE_BLOCK */
    TEST_TYPE_SIZE   (PMESSAGE_RESOURCE_BLOCK, 4)
    TEST_TYPE_ALIGN  (PMESSAGE_RESOURCE_BLOCK, 4)
    TEST_TARGET_SIZE (PMESSAGE_RESOURCE_BLOCK, 12)
    TEST_TARGET_ALIGN(PMESSAGE_RESOURCE_BLOCK, 4)
}

static void test_pack_PMESSAGE_RESOURCE_DATA(void)
{
    /* PMESSAGE_RESOURCE_DATA */
    TEST_TYPE_SIZE   (PMESSAGE_RESOURCE_DATA, 4)
    TEST_TYPE_ALIGN  (PMESSAGE_RESOURCE_DATA, 4)
    TEST_TARGET_SIZE (PMESSAGE_RESOURCE_DATA, 16)
    TEST_TARGET_ALIGN(PMESSAGE_RESOURCE_DATA, 4)
}

static void test_pack_PMESSAGE_RESOURCE_ENTRY(void)
{
    /* PMESSAGE_RESOURCE_ENTRY */
    TEST_TYPE_SIZE   (PMESSAGE_RESOURCE_ENTRY, 4)
    TEST_TYPE_ALIGN  (PMESSAGE_RESOURCE_ENTRY, 4)
    TEST_TARGET_SIZE (PMESSAGE_RESOURCE_ENTRY, 6)
    TEST_TARGET_ALIGN(PMESSAGE_RESOURCE_ENTRY, 2)
}

static void test_pack_PNT_TIB(void)
{
    /* PNT_TIB */
    TEST_TYPE_SIZE   (PNT_TIB, 4)
    TEST_TYPE_ALIGN  (PNT_TIB, 4)
}

static void test_pack_POBJECT_TYPE_LIST(void)
{
    /* POBJECT_TYPE_LIST */
    TEST_TYPE_SIZE   (POBJECT_TYPE_LIST, 4)
    TEST_TYPE_ALIGN  (POBJECT_TYPE_LIST, 4)
    TEST_TARGET_SIZE (POBJECT_TYPE_LIST, 8)
    TEST_TARGET_ALIGN(POBJECT_TYPE_LIST, 4)
}

static void test_pack_PPRIVILEGE_SET(void)
{
    /* PPRIVILEGE_SET */
    TEST_TYPE_SIZE   (PPRIVILEGE_SET, 4)
    TEST_TYPE_ALIGN  (PPRIVILEGE_SET, 4)
    TEST_TARGET_SIZE (PPRIVILEGE_SET, 20)
    TEST_TARGET_ALIGN(PPRIVILEGE_SET, 4)
}

static void test_pack_PRIVILEGE_SET(void)
{
    /* PRIVILEGE_SET */
    TEST_TYPE_SIZE   (PRIVILEGE_SET, 20)
    TEST_TYPE_ALIGN  (PRIVILEGE_SET, 4)
    TEST_FIELD_SIZE  (PRIVILEGE_SET, PrivilegeCount, 4)
    TEST_FIELD_ALIGN (PRIVILEGE_SET, PrivilegeCount, 4)
    TEST_FIELD_OFFSET(PRIVILEGE_SET, PrivilegeCount, 0)
    TEST_FIELD_SIZE  (PRIVILEGE_SET, Control, 4)
    TEST_FIELD_ALIGN (PRIVILEGE_SET, Control, 4)
    TEST_FIELD_OFFSET(PRIVILEGE_SET, Control, 4)
    TEST_FIELD_SIZE  (PRIVILEGE_SET, Privilege, 12)
    TEST_FIELD_ALIGN (PRIVILEGE_SET, Privilege, 4)
    TEST_FIELD_OFFSET(PRIVILEGE_SET, Privilege, 8)
}

static void test_pack_PRLIST_ENTRY(void)
{
    /* PRLIST_ENTRY */
    TEST_TYPE_SIZE   (PRLIST_ENTRY, 4)
    TEST_TYPE_ALIGN  (PRLIST_ENTRY, 4)
    TEST_TARGET_SIZE (PRLIST_ENTRY, 8)
    TEST_TARGET_ALIGN(PRLIST_ENTRY, 4)
}

static void test_pack_PRTL_CRITICAL_SECTION(void)
{
    /* PRTL_CRITICAL_SECTION */
    TEST_TYPE_SIZE   (PRTL_CRITICAL_SECTION, 4)
    TEST_TYPE_ALIGN  (PRTL_CRITICAL_SECTION, 4)
    TEST_TARGET_SIZE (PRTL_CRITICAL_SECTION, 24)
    TEST_TARGET_ALIGN(PRTL_CRITICAL_SECTION, 4)
}

static void test_pack_PRTL_CRITICAL_SECTION_DEBUG(void)
{
    /* PRTL_CRITICAL_SECTION_DEBUG */
    TEST_TYPE_SIZE   (PRTL_CRITICAL_SECTION_DEBUG, 4)
    TEST_TYPE_ALIGN  (PRTL_CRITICAL_SECTION_DEBUG, 4)
}

static void test_pack_PRTL_OSVERSIONINFOEXW(void)
{
    /* PRTL_OSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (PRTL_OSVERSIONINFOEXW, 4)
    TEST_TYPE_ALIGN  (PRTL_OSVERSIONINFOEXW, 4)
    TEST_TARGET_SIZE (PRTL_OSVERSIONINFOEXW, 284)
    TEST_TARGET_ALIGN(PRTL_OSVERSIONINFOEXW, 4)
}

static void test_pack_PRTL_OSVERSIONINFOW(void)
{
    /* PRTL_OSVERSIONINFOW */
    TEST_TYPE_SIZE   (PRTL_OSVERSIONINFOW, 4)
    TEST_TYPE_ALIGN  (PRTL_OSVERSIONINFOW, 4)
    TEST_TARGET_SIZE (PRTL_OSVERSIONINFOW, 276)
    TEST_TARGET_ALIGN(PRTL_OSVERSIONINFOW, 4)
}

static void test_pack_PRTL_RESOURCE_DEBUG(void)
{
    /* PRTL_RESOURCE_DEBUG */
    TEST_TYPE_SIZE   (PRTL_RESOURCE_DEBUG, 4)
    TEST_TYPE_ALIGN  (PRTL_RESOURCE_DEBUG, 4)
}

static void test_pack_PSECURITY_DESCRIPTOR(void)
{
    /* PSECURITY_DESCRIPTOR */
    TEST_TYPE_SIZE   (PSECURITY_DESCRIPTOR, 4)
    TEST_TYPE_ALIGN  (PSECURITY_DESCRIPTOR, 4)
}

static void test_pack_PSECURITY_QUALITY_OF_SERVICE(void)
{
    /* PSECURITY_QUALITY_OF_SERVICE */
    TEST_TYPE_SIZE   (PSECURITY_QUALITY_OF_SERVICE, 4)
    TEST_TYPE_ALIGN  (PSECURITY_QUALITY_OF_SERVICE, 4)
}

static void test_pack_PSID(void)
{
    /* PSID */
    TEST_TYPE_SIZE   (PSID, 4)
    TEST_TYPE_ALIGN  (PSID, 4)
}

static void test_pack_PSID_IDENTIFIER_AUTHORITY(void)
{
    /* PSID_IDENTIFIER_AUTHORITY */
    TEST_TYPE_SIZE   (PSID_IDENTIFIER_AUTHORITY, 4)
    TEST_TYPE_ALIGN  (PSID_IDENTIFIER_AUTHORITY, 4)
    TEST_TARGET_SIZE (PSID_IDENTIFIER_AUTHORITY, 6)
    TEST_TARGET_ALIGN(PSID_IDENTIFIER_AUTHORITY, 1)
}

static void test_pack_PSINGLE_LIST_ENTRY(void)
{
    /* PSINGLE_LIST_ENTRY */
    TEST_TYPE_SIZE   (PSINGLE_LIST_ENTRY, 4)
    TEST_TYPE_ALIGN  (PSINGLE_LIST_ENTRY, 4)
    TEST_TARGET_SIZE (PSINGLE_LIST_ENTRY, 4)
    TEST_TARGET_ALIGN(PSINGLE_LIST_ENTRY, 4)
}

static void test_pack_PSTR(void)
{
    /* PSTR */
    TEST_TYPE_SIZE   (PSTR, 4)
    TEST_TYPE_ALIGN  (PSTR, 4)
    TEST_TARGET_SIZE (PSTR, 1)
    TEST_TARGET_ALIGN(PSTR, 1)
}

static void test_pack_PSYSTEM_ALARM_ACE(void)
{
    /* PSYSTEM_ALARM_ACE */
    TEST_TYPE_SIZE   (PSYSTEM_ALARM_ACE, 4)
    TEST_TYPE_ALIGN  (PSYSTEM_ALARM_ACE, 4)
    TEST_TARGET_SIZE (PSYSTEM_ALARM_ACE, 12)
    TEST_TARGET_ALIGN(PSYSTEM_ALARM_ACE, 4)
}

static void test_pack_PSYSTEM_AUDIT_ACE(void)
{
    /* PSYSTEM_AUDIT_ACE */
    TEST_TYPE_SIZE   (PSYSTEM_AUDIT_ACE, 4)
    TEST_TYPE_ALIGN  (PSYSTEM_AUDIT_ACE, 4)
    TEST_TARGET_SIZE (PSYSTEM_AUDIT_ACE, 12)
    TEST_TARGET_ALIGN(PSYSTEM_AUDIT_ACE, 4)
}

static void test_pack_PTOKEN_GROUPS(void)
{
    /* PTOKEN_GROUPS */
    TEST_TYPE_SIZE   (PTOKEN_GROUPS, 4)
    TEST_TYPE_ALIGN  (PTOKEN_GROUPS, 4)
    TEST_TARGET_SIZE (PTOKEN_GROUPS, 12)
    TEST_TARGET_ALIGN(PTOKEN_GROUPS, 4)
}

static void test_pack_PTOKEN_PRIVILEGES(void)
{
    /* PTOKEN_PRIVILEGES */
    TEST_TYPE_SIZE   (PTOKEN_PRIVILEGES, 4)
    TEST_TYPE_ALIGN  (PTOKEN_PRIVILEGES, 4)
    TEST_TARGET_SIZE (PTOKEN_PRIVILEGES, 16)
    TEST_TARGET_ALIGN(PTOKEN_PRIVILEGES, 4)
}

static void test_pack_PTOKEN_USER(void)
{
    /* PTOKEN_USER */
    TEST_TYPE_SIZE   (PTOKEN_USER, 4)
    TEST_TYPE_ALIGN  (PTOKEN_USER, 4)
    TEST_TARGET_SIZE (PTOKEN_USER, 8)
    TEST_TARGET_ALIGN(PTOKEN_USER, 4)
}

static void test_pack_PULARGE_INTEGER(void)
{
    /* PULARGE_INTEGER */
    TEST_TYPE_SIZE   (PULARGE_INTEGER, 4)
    TEST_TYPE_ALIGN  (PULARGE_INTEGER, 4)
}

static void test_pack_PVECTORED_EXCEPTION_HANDLER(void)
{
    /* PVECTORED_EXCEPTION_HANDLER */
    TEST_TYPE_SIZE   (PVECTORED_EXCEPTION_HANDLER, 4)
    TEST_TYPE_ALIGN  (PVECTORED_EXCEPTION_HANDLER, 4)
}

static void test_pack_PVOID(void)
{
    /* PVOID */
    TEST_TYPE_SIZE   (PVOID, 4)
    TEST_TYPE_ALIGN  (PVOID, 4)
}

static void test_pack_PWCH(void)
{
    /* PWCH */
    TEST_TYPE_SIZE   (PWCH, 4)
    TEST_TYPE_ALIGN  (PWCH, 4)
    TEST_TARGET_SIZE (PWCH, 2)
    TEST_TARGET_ALIGN(PWCH, 2)
}

static void test_pack_PWSTR(void)
{
    /* PWSTR */
    TEST_TYPE_SIZE   (PWSTR, 4)
    TEST_TYPE_ALIGN  (PWSTR, 4)
    TEST_TARGET_SIZE (PWSTR, 2)
    TEST_TARGET_ALIGN(PWSTR, 2)
}

static void test_pack_RTL_CRITICAL_SECTION(void)
{
    /* RTL_CRITICAL_SECTION */
    TEST_TYPE_SIZE   (RTL_CRITICAL_SECTION, 24)
    TEST_TYPE_ALIGN  (RTL_CRITICAL_SECTION, 4)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, DebugInfo, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, DebugInfo, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, DebugInfo, 0)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, LockCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, LockCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, LockCount, 4)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, RecursionCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, RecursionCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, RecursionCount, 8)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, OwningThread, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, OwningThread, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, OwningThread, 12)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, LockSemaphore, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, LockSemaphore, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, LockSemaphore, 16)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION, SpinCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION, SpinCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION, SpinCount, 20)
}

static void test_pack_RTL_CRITICAL_SECTION_DEBUG(void)
{
    /* RTL_CRITICAL_SECTION_DEBUG */
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, Type, 2)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, Type, 2)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, Type, 0)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, CriticalSection, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, CriticalSection, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, CriticalSection, 4)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, ProcessLocksList, 8)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, ProcessLocksList, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, ProcessLocksList, 8)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, EntryCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, EntryCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, EntryCount, 16)
    TEST_FIELD_SIZE  (RTL_CRITICAL_SECTION_DEBUG, ContentionCount, 4)
    TEST_FIELD_ALIGN (RTL_CRITICAL_SECTION_DEBUG, ContentionCount, 4)
    TEST_FIELD_OFFSET(RTL_CRITICAL_SECTION_DEBUG, ContentionCount, 20)
}

static void test_pack_RTL_OSVERSIONINFOEXW(void)
{
    /* RTL_OSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (RTL_OSVERSIONINFOEXW, 284)
    TEST_TYPE_ALIGN  (RTL_OSVERSIONINFOEXW, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, szCSDVersion, 20)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wServicePackMajor, 276)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wServicePackMinor, 278)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wSuiteMask, 280)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wProductType, 282)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOEXW, wReserved, 283)
}

static void test_pack_RTL_OSVERSIONINFOW(void)
{
    /* RTL_OSVERSIONINFOW */
    TEST_TYPE_SIZE   (RTL_OSVERSIONINFOW, 276)
    TEST_TYPE_ALIGN  (RTL_OSVERSIONINFOW, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (RTL_OSVERSIONINFOW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (RTL_OSVERSIONINFOW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(RTL_OSVERSIONINFOW, szCSDVersion, 20)
}

static void test_pack_RTL_RESOURCE_DEBUG(void)
{
    /* RTL_RESOURCE_DEBUG */
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, Type, 2)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, Type, 2)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, Type, 0)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, CreatorBackTraceIndex, 2)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, CriticalSection, 4)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, CriticalSection, 4)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, CriticalSection, 4)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, ProcessLocksList, 8)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, ProcessLocksList, 4)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, ProcessLocksList, 8)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, EntryCount, 4)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, EntryCount, 4)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, EntryCount, 16)
    TEST_FIELD_SIZE  (RTL_RESOURCE_DEBUG, ContentionCount, 4)
    TEST_FIELD_ALIGN (RTL_RESOURCE_DEBUG, ContentionCount, 4)
    TEST_FIELD_OFFSET(RTL_RESOURCE_DEBUG, ContentionCount, 20)
}

static void test_pack_SECURITY_CONTEXT_TRACKING_MODE(void)
{
    /* SECURITY_CONTEXT_TRACKING_MODE */
    TEST_TYPE_SIZE   (SECURITY_CONTEXT_TRACKING_MODE, 1)
    TEST_TYPE_ALIGN  (SECURITY_CONTEXT_TRACKING_MODE, 1)
}

static void test_pack_SECURITY_DESCRIPTOR(void)
{
    /* SECURITY_DESCRIPTOR */
    TEST_TYPE_SIZE   (SECURITY_DESCRIPTOR, 20)
    TEST_TYPE_ALIGN  (SECURITY_DESCRIPTOR, 4)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Revision, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Revision, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Revision, 0)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Sbz1, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Sbz1, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Sbz1, 1)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Control, 2)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Control, 2)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Control, 2)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Owner, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Owner, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Owner, 4)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Group, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Group, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Group, 8)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Sacl, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Sacl, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Sacl, 12)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR, Dacl, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR, Dacl, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR, Dacl, 16)
}

static void test_pack_SECURITY_DESCRIPTOR_CONTROL(void)
{
    /* SECURITY_DESCRIPTOR_CONTROL */
    TEST_TYPE_SIZE   (SECURITY_DESCRIPTOR_CONTROL, 2)
    TEST_TYPE_ALIGN  (SECURITY_DESCRIPTOR_CONTROL, 2)
    TEST_TYPE_UNSIGNED(SECURITY_DESCRIPTOR_CONTROL)
}

static void test_pack_SECURITY_DESCRIPTOR_RELATIVE(void)
{
    /* SECURITY_DESCRIPTOR_RELATIVE */
    TEST_TYPE_SIZE   (SECURITY_DESCRIPTOR_RELATIVE, 20)
    TEST_TYPE_ALIGN  (SECURITY_DESCRIPTOR_RELATIVE, 4)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Revision, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Revision, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Revision, 0)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Sbz1, 1)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Sbz1, 1)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Sbz1, 1)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Control, 2)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Control, 2)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Control, 2)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Owner, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Owner, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Owner, 4)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Group, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Group, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Group, 8)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Sacl, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Sacl, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Sacl, 12)
    TEST_FIELD_SIZE  (SECURITY_DESCRIPTOR_RELATIVE, Dacl, 4)
    TEST_FIELD_ALIGN (SECURITY_DESCRIPTOR_RELATIVE, Dacl, 4)
    TEST_FIELD_OFFSET(SECURITY_DESCRIPTOR_RELATIVE, Dacl, 16)
}

static void test_pack_SECURITY_INFORMATION(void)
{
    /* SECURITY_INFORMATION */
    TEST_TYPE_SIZE   (SECURITY_INFORMATION, 4)
    TEST_TYPE_ALIGN  (SECURITY_INFORMATION, 4)
    TEST_TYPE_UNSIGNED(SECURITY_INFORMATION)
}

static void test_pack_SECURITY_QUALITY_OF_SERVICE(void)
{
    /* SECURITY_QUALITY_OF_SERVICE */
    TEST_FIELD_SIZE  (SECURITY_QUALITY_OF_SERVICE, Length, 4)
    TEST_FIELD_ALIGN (SECURITY_QUALITY_OF_SERVICE, Length, 4)
    TEST_FIELD_OFFSET(SECURITY_QUALITY_OF_SERVICE, Length, 0)
}

static void test_pack_SHORT(void)
{
    /* SHORT */
    TEST_TYPE_SIZE   (SHORT, 2)
    TEST_TYPE_ALIGN  (SHORT, 2)
    TEST_TYPE_SIGNED(SHORT)
}

static void test_pack_SID(void)
{
    /* SID */
    TEST_TYPE_SIZE   (SID, 12)
    TEST_TYPE_ALIGN  (SID, 4)
    TEST_FIELD_SIZE  (SID, Revision, 1)
    TEST_FIELD_ALIGN (SID, Revision, 1)
    TEST_FIELD_OFFSET(SID, Revision, 0)
    TEST_FIELD_SIZE  (SID, SubAuthorityCount, 1)
    TEST_FIELD_ALIGN (SID, SubAuthorityCount, 1)
    TEST_FIELD_OFFSET(SID, SubAuthorityCount, 1)
    TEST_FIELD_SIZE  (SID, IdentifierAuthority, 6)
    TEST_FIELD_ALIGN (SID, IdentifierAuthority, 1)
    TEST_FIELD_OFFSET(SID, IdentifierAuthority, 2)
    TEST_FIELD_SIZE  (SID, SubAuthority, 4)
    TEST_FIELD_ALIGN (SID, SubAuthority, 4)
    TEST_FIELD_OFFSET(SID, SubAuthority, 8)
}

static void test_pack_SID_AND_ATTRIBUTES(void)
{
    /* SID_AND_ATTRIBUTES */
    TEST_TYPE_SIZE   (SID_AND_ATTRIBUTES, 8)
    TEST_TYPE_ALIGN  (SID_AND_ATTRIBUTES, 4)
    TEST_FIELD_SIZE  (SID_AND_ATTRIBUTES, Sid, 4)
    TEST_FIELD_ALIGN (SID_AND_ATTRIBUTES, Sid, 4)
    TEST_FIELD_OFFSET(SID_AND_ATTRIBUTES, Sid, 0)
    TEST_FIELD_SIZE  (SID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_ALIGN (SID_AND_ATTRIBUTES, Attributes, 4)
    TEST_FIELD_OFFSET(SID_AND_ATTRIBUTES, Attributes, 4)
}

static void test_pack_SID_IDENTIFIER_AUTHORITY(void)
{
    /* SID_IDENTIFIER_AUTHORITY */
    TEST_TYPE_SIZE   (SID_IDENTIFIER_AUTHORITY, 6)
    TEST_TYPE_ALIGN  (SID_IDENTIFIER_AUTHORITY, 1)
    TEST_FIELD_SIZE  (SID_IDENTIFIER_AUTHORITY, Value, 6)
    TEST_FIELD_ALIGN (SID_IDENTIFIER_AUTHORITY, Value, 1)
    TEST_FIELD_OFFSET(SID_IDENTIFIER_AUTHORITY, Value, 0)
}

static void test_pack_SINGLE_LIST_ENTRY(void)
{
    /* SINGLE_LIST_ENTRY */
    TEST_TYPE_SIZE   (SINGLE_LIST_ENTRY, 4)
    TEST_TYPE_ALIGN  (SINGLE_LIST_ENTRY, 4)
    TEST_FIELD_SIZE  (SINGLE_LIST_ENTRY, Next, 4)
    TEST_FIELD_ALIGN (SINGLE_LIST_ENTRY, Next, 4)
    TEST_FIELD_OFFSET(SINGLE_LIST_ENTRY, Next, 0)
}

static void test_pack_SYSTEM_ALARM_ACE(void)
{
    /* SYSTEM_ALARM_ACE */
    TEST_TYPE_SIZE   (SYSTEM_ALARM_ACE, 12)
    TEST_TYPE_ALIGN  (SYSTEM_ALARM_ACE, 4)
    TEST_FIELD_SIZE  (SYSTEM_ALARM_ACE, Header, 4)
    TEST_FIELD_ALIGN (SYSTEM_ALARM_ACE, Header, 2)
    TEST_FIELD_OFFSET(SYSTEM_ALARM_ACE, Header, 0)
    TEST_FIELD_SIZE  (SYSTEM_ALARM_ACE, Mask, 4)
    TEST_FIELD_ALIGN (SYSTEM_ALARM_ACE, Mask, 4)
    TEST_FIELD_OFFSET(SYSTEM_ALARM_ACE, Mask, 4)
    TEST_FIELD_SIZE  (SYSTEM_ALARM_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (SYSTEM_ALARM_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(SYSTEM_ALARM_ACE, SidStart, 8)
}

static void test_pack_SYSTEM_AUDIT_ACE(void)
{
    /* SYSTEM_AUDIT_ACE */
    TEST_TYPE_SIZE   (SYSTEM_AUDIT_ACE, 12)
    TEST_TYPE_ALIGN  (SYSTEM_AUDIT_ACE, 4)
    TEST_FIELD_SIZE  (SYSTEM_AUDIT_ACE, Header, 4)
    TEST_FIELD_ALIGN (SYSTEM_AUDIT_ACE, Header, 2)
    TEST_FIELD_OFFSET(SYSTEM_AUDIT_ACE, Header, 0)
    TEST_FIELD_SIZE  (SYSTEM_AUDIT_ACE, Mask, 4)
    TEST_FIELD_ALIGN (SYSTEM_AUDIT_ACE, Mask, 4)
    TEST_FIELD_OFFSET(SYSTEM_AUDIT_ACE, Mask, 4)
    TEST_FIELD_SIZE  (SYSTEM_AUDIT_ACE, SidStart, 4)
    TEST_FIELD_ALIGN (SYSTEM_AUDIT_ACE, SidStart, 4)
    TEST_FIELD_OFFSET(SYSTEM_AUDIT_ACE, SidStart, 8)
}

static void test_pack_TOKEN_DEFAULT_DACL(void)
{
    /* TOKEN_DEFAULT_DACL */
    TEST_TYPE_SIZE   (TOKEN_DEFAULT_DACL, 4)
    TEST_TYPE_ALIGN  (TOKEN_DEFAULT_DACL, 4)
    TEST_FIELD_SIZE  (TOKEN_DEFAULT_DACL, DefaultDacl, 4)
    TEST_FIELD_ALIGN (TOKEN_DEFAULT_DACL, DefaultDacl, 4)
    TEST_FIELD_OFFSET(TOKEN_DEFAULT_DACL, DefaultDacl, 0)
}

static void test_pack_TOKEN_GROUPS(void)
{
    /* TOKEN_GROUPS */
    TEST_TYPE_SIZE   (TOKEN_GROUPS, 12)
    TEST_TYPE_ALIGN  (TOKEN_GROUPS, 4)
    TEST_FIELD_SIZE  (TOKEN_GROUPS, GroupCount, 4)
    TEST_FIELD_ALIGN (TOKEN_GROUPS, GroupCount, 4)
    TEST_FIELD_OFFSET(TOKEN_GROUPS, GroupCount, 0)
    TEST_FIELD_SIZE  (TOKEN_GROUPS, Groups, 8)
    TEST_FIELD_ALIGN (TOKEN_GROUPS, Groups, 4)
    TEST_FIELD_OFFSET(TOKEN_GROUPS, Groups, 4)
}

static void test_pack_TOKEN_OWNER(void)
{
    /* TOKEN_OWNER */
    TEST_TYPE_SIZE   (TOKEN_OWNER, 4)
    TEST_TYPE_ALIGN  (TOKEN_OWNER, 4)
    TEST_FIELD_SIZE  (TOKEN_OWNER, Owner, 4)
    TEST_FIELD_ALIGN (TOKEN_OWNER, Owner, 4)
    TEST_FIELD_OFFSET(TOKEN_OWNER, Owner, 0)
}

static void test_pack_TOKEN_PRIMARY_GROUP(void)
{
    /* TOKEN_PRIMARY_GROUP */
    TEST_TYPE_SIZE   (TOKEN_PRIMARY_GROUP, 4)
    TEST_TYPE_ALIGN  (TOKEN_PRIMARY_GROUP, 4)
    TEST_FIELD_SIZE  (TOKEN_PRIMARY_GROUP, PrimaryGroup, 4)
    TEST_FIELD_ALIGN (TOKEN_PRIMARY_GROUP, PrimaryGroup, 4)
    TEST_FIELD_OFFSET(TOKEN_PRIMARY_GROUP, PrimaryGroup, 0)
}

static void test_pack_TOKEN_PRIVILEGES(void)
{
    /* TOKEN_PRIVILEGES */
    TEST_TYPE_SIZE   (TOKEN_PRIVILEGES, 16)
    TEST_TYPE_ALIGN  (TOKEN_PRIVILEGES, 4)
    TEST_FIELD_SIZE  (TOKEN_PRIVILEGES, PrivilegeCount, 4)
    TEST_FIELD_ALIGN (TOKEN_PRIVILEGES, PrivilegeCount, 4)
    TEST_FIELD_OFFSET(TOKEN_PRIVILEGES, PrivilegeCount, 0)
    TEST_FIELD_SIZE  (TOKEN_PRIVILEGES, Privileges, 12)
    TEST_FIELD_ALIGN (TOKEN_PRIVILEGES, Privileges, 4)
    TEST_FIELD_OFFSET(TOKEN_PRIVILEGES, Privileges, 4)
}

static void test_pack_TOKEN_SOURCE(void)
{
    /* TOKEN_SOURCE */
    TEST_TYPE_SIZE   (TOKEN_SOURCE, 16)
    TEST_TYPE_ALIGN  (TOKEN_SOURCE, 4)
    TEST_FIELD_SIZE  (TOKEN_SOURCE, SourceName, 8)
    TEST_FIELD_ALIGN (TOKEN_SOURCE, SourceName, 1)
    TEST_FIELD_OFFSET(TOKEN_SOURCE, SourceName, 0)
    TEST_FIELD_SIZE  (TOKEN_SOURCE, SourceIdentifier, 8)
    TEST_FIELD_ALIGN (TOKEN_SOURCE, SourceIdentifier, 4)
    TEST_FIELD_OFFSET(TOKEN_SOURCE, SourceIdentifier, 8)
}

static void test_pack_TOKEN_STATISTICS(void)
{
    /* TOKEN_STATISTICS (pack 4) */
    TEST_FIELD_SIZE  (TOKEN_STATISTICS, TokenId, 8)
    TEST_FIELD_ALIGN (TOKEN_STATISTICS, TokenId, 4)
    TEST_FIELD_OFFSET(TOKEN_STATISTICS, TokenId, 0)
    TEST_FIELD_SIZE  (TOKEN_STATISTICS, AuthenticationId, 8)
    TEST_FIELD_ALIGN (TOKEN_STATISTICS, AuthenticationId, 4)
    TEST_FIELD_OFFSET(TOKEN_STATISTICS, AuthenticationId, 8)
    TEST_FIELD_SIZE  (TOKEN_STATISTICS, ExpirationTime, 8)
    TEST_FIELD_ALIGN (TOKEN_STATISTICS, ExpirationTime, 4)
    TEST_FIELD_OFFSET(TOKEN_STATISTICS, ExpirationTime, 16)
}

static void test_pack_TOKEN_USER(void)
{
    /* TOKEN_USER */
    TEST_TYPE_SIZE   (TOKEN_USER, 8)
    TEST_TYPE_ALIGN  (TOKEN_USER, 4)
    TEST_FIELD_SIZE  (TOKEN_USER, User, 8)
    TEST_FIELD_ALIGN (TOKEN_USER, User, 4)
    TEST_FIELD_OFFSET(TOKEN_USER, User, 0)
}

static void test_pack_ULARGE_INTEGER(void)
{
    /* ULARGE_INTEGER */
}

static void test_pack_ULONGLONG(void)
{
    /* ULONGLONG */
    TEST_TYPE_SIZE   (ULONGLONG, 8)
    TEST_TYPE_ALIGN  (ULONGLONG, 8)
    TEST_TYPE_UNSIGNED(ULONGLONG)
}

static void test_pack_WAITORTIMERCALLBACKFUNC(void)
{
    /* WAITORTIMERCALLBACKFUNC */
    TEST_TYPE_SIZE   (WAITORTIMERCALLBACKFUNC, 4)
    TEST_TYPE_ALIGN  (WAITORTIMERCALLBACKFUNC, 4)
}

static void test_pack_WCHAR(void)
{
    /* WCHAR */
    TEST_TYPE_SIZE   (WCHAR, 2)
    TEST_TYPE_ALIGN  (WCHAR, 2)
    TEST_TYPE_UNSIGNED(WCHAR)
}

static void test_pack_ATOM(void)
{
    /* ATOM */
    TEST_TYPE_SIZE   (ATOM, 2)
    TEST_TYPE_ALIGN  (ATOM, 2)
    TEST_TYPE_UNSIGNED(ATOM)
}

static void test_pack_BOOL(void)
{
    /* BOOL */
    TEST_TYPE_SIZE   (BOOL, 4)
    TEST_TYPE_ALIGN  (BOOL, 4)
    TEST_TYPE_SIGNED(BOOL)
}

static void test_pack_BYTE(void)
{
    /* BYTE */
    TEST_TYPE_SIZE   (BYTE, 1)
    TEST_TYPE_ALIGN  (BYTE, 1)
    TEST_TYPE_UNSIGNED(BYTE)
}

static void test_pack_COLORREF(void)
{
    /* COLORREF */
    TEST_TYPE_SIZE   (COLORREF, 4)
    TEST_TYPE_ALIGN  (COLORREF, 4)
    TEST_TYPE_UNSIGNED(COLORREF)
}

static void test_pack_DWORD(void)
{
    /* DWORD */
    TEST_TYPE_SIZE   (DWORD, 4)
    TEST_TYPE_ALIGN  (DWORD, 4)
    TEST_TYPE_UNSIGNED(DWORD)
}

static void test_pack_FARPROC(void)
{
    /* FARPROC */
    TEST_TYPE_SIZE   (FARPROC, 4)
    TEST_TYPE_ALIGN  (FARPROC, 4)
}

static void test_pack_FLOAT(void)
{
    /* FLOAT */
    TEST_TYPE_SIZE   (FLOAT, 4)
    TEST_TYPE_ALIGN  (FLOAT, 4)
}

static void test_pack_GLOBALHANDLE(void)
{
    /* GLOBALHANDLE */
    TEST_TYPE_SIZE   (GLOBALHANDLE, 4)
    TEST_TYPE_ALIGN  (GLOBALHANDLE, 4)
}

static void test_pack_HCURSOR(void)
{
    /* HCURSOR */
    TEST_TYPE_SIZE   (HCURSOR, 4)
    TEST_TYPE_ALIGN  (HCURSOR, 4)
}

static void test_pack_HFILE(void)
{
    /* HFILE */
    TEST_TYPE_SIZE   (HFILE, 4)
    TEST_TYPE_ALIGN  (HFILE, 4)
    TEST_TYPE_SIGNED(HFILE)
}

static void test_pack_HGDIOBJ(void)
{
    /* HGDIOBJ */
    TEST_TYPE_SIZE   (HGDIOBJ, 4)
    TEST_TYPE_ALIGN  (HGDIOBJ, 4)
}

static void test_pack_HGLOBAL(void)
{
    /* HGLOBAL */
    TEST_TYPE_SIZE   (HGLOBAL, 4)
    TEST_TYPE_ALIGN  (HGLOBAL, 4)
}

static void test_pack_HLOCAL(void)
{
    /* HLOCAL */
    TEST_TYPE_SIZE   (HLOCAL, 4)
    TEST_TYPE_ALIGN  (HLOCAL, 4)
}

static void test_pack_HMODULE(void)
{
    /* HMODULE */
    TEST_TYPE_SIZE   (HMODULE, 4)
    TEST_TYPE_ALIGN  (HMODULE, 4)
}

static void test_pack_INT(void)
{
    /* INT */
    TEST_TYPE_SIZE   (INT, 4)
    TEST_TYPE_ALIGN  (INT, 4)
    TEST_TYPE_SIGNED(INT)
}

static void test_pack_LOCALHANDLE(void)
{
    /* LOCALHANDLE */
    TEST_TYPE_SIZE   (LOCALHANDLE, 4)
    TEST_TYPE_ALIGN  (LOCALHANDLE, 4)
}

static void test_pack_LPARAM(void)
{
    /* LPARAM */
    TEST_TYPE_SIZE   (LPARAM, 4)
    TEST_TYPE_ALIGN  (LPARAM, 4)
}

static void test_pack_LPCRECT(void)
{
    /* LPCRECT */
    TEST_TYPE_SIZE   (LPCRECT, 4)
    TEST_TYPE_ALIGN  (LPCRECT, 4)
    TEST_TARGET_SIZE (LPCRECT, 16)
    TEST_TARGET_ALIGN(LPCRECT, 4)
}

static void test_pack_LPCRECTL(void)
{
    /* LPCRECTL */
    TEST_TYPE_SIZE   (LPCRECTL, 4)
    TEST_TYPE_ALIGN  (LPCRECTL, 4)
    TEST_TARGET_SIZE (LPCRECTL, 16)
    TEST_TARGET_ALIGN(LPCRECTL, 4)
}

static void test_pack_LPCVOID(void)
{
    /* LPCVOID */
    TEST_TYPE_SIZE   (LPCVOID, 4)
    TEST_TYPE_ALIGN  (LPCVOID, 4)
}

static void test_pack_LPPOINT(void)
{
    /* LPPOINT */
    TEST_TYPE_SIZE   (LPPOINT, 4)
    TEST_TYPE_ALIGN  (LPPOINT, 4)
    TEST_TARGET_SIZE (LPPOINT, 8)
    TEST_TARGET_ALIGN(LPPOINT, 4)
}

static void test_pack_LPRECT(void)
{
    /* LPRECT */
    TEST_TYPE_SIZE   (LPRECT, 4)
    TEST_TYPE_ALIGN  (LPRECT, 4)
    TEST_TARGET_SIZE (LPRECT, 16)
    TEST_TARGET_ALIGN(LPRECT, 4)
}

static void test_pack_LPRECTL(void)
{
    /* LPRECTL */
    TEST_TYPE_SIZE   (LPRECTL, 4)
    TEST_TYPE_ALIGN  (LPRECTL, 4)
    TEST_TARGET_SIZE (LPRECTL, 16)
    TEST_TARGET_ALIGN(LPRECTL, 4)
}

static void test_pack_LPSIZE(void)
{
    /* LPSIZE */
    TEST_TYPE_SIZE   (LPSIZE, 4)
    TEST_TYPE_ALIGN  (LPSIZE, 4)
    TEST_TARGET_SIZE (LPSIZE, 8)
    TEST_TARGET_ALIGN(LPSIZE, 4)
}

static void test_pack_LRESULT(void)
{
    /* LRESULT */
    TEST_TYPE_SIZE   (LRESULT, 4)
    TEST_TYPE_ALIGN  (LRESULT, 4)
}

static void test_pack_POINT(void)
{
    /* POINT */
    TEST_TYPE_SIZE   (POINT, 8)
    TEST_TYPE_ALIGN  (POINT, 4)
    TEST_FIELD_SIZE  (POINT, x, 4)
    TEST_FIELD_ALIGN (POINT, x, 4)
    TEST_FIELD_OFFSET(POINT, x, 0)
    TEST_FIELD_SIZE  (POINT, y, 4)
    TEST_FIELD_ALIGN (POINT, y, 4)
    TEST_FIELD_OFFSET(POINT, y, 4)
}

static void test_pack_POINTL(void)
{
    /* POINTL */
    TEST_TYPE_SIZE   (POINTL, 8)
    TEST_TYPE_ALIGN  (POINTL, 4)
    TEST_FIELD_SIZE  (POINTL, x, 4)
    TEST_FIELD_ALIGN (POINTL, x, 4)
    TEST_FIELD_OFFSET(POINTL, x, 0)
    TEST_FIELD_SIZE  (POINTL, y, 4)
    TEST_FIELD_ALIGN (POINTL, y, 4)
    TEST_FIELD_OFFSET(POINTL, y, 4)
}

static void test_pack_PPOINT(void)
{
    /* PPOINT */
    TEST_TYPE_SIZE   (PPOINT, 4)
    TEST_TYPE_ALIGN  (PPOINT, 4)
    TEST_TARGET_SIZE (PPOINT, 8)
    TEST_TARGET_ALIGN(PPOINT, 4)
}

static void test_pack_PPOINTL(void)
{
    /* PPOINTL */
    TEST_TYPE_SIZE   (PPOINTL, 4)
    TEST_TYPE_ALIGN  (PPOINTL, 4)
    TEST_TARGET_SIZE (PPOINTL, 8)
    TEST_TARGET_ALIGN(PPOINTL, 4)
}

static void test_pack_PRECT(void)
{
    /* PRECT */
    TEST_TYPE_SIZE   (PRECT, 4)
    TEST_TYPE_ALIGN  (PRECT, 4)
    TEST_TARGET_SIZE (PRECT, 16)
    TEST_TARGET_ALIGN(PRECT, 4)
}

static void test_pack_PRECTL(void)
{
    /* PRECTL */
    TEST_TYPE_SIZE   (PRECTL, 4)
    TEST_TYPE_ALIGN  (PRECTL, 4)
    TEST_TARGET_SIZE (PRECTL, 16)
    TEST_TARGET_ALIGN(PRECTL, 4)
}

static void test_pack_PROC(void)
{
    /* PROC */
    TEST_TYPE_SIZE   (PROC, 4)
    TEST_TYPE_ALIGN  (PROC, 4)
}

static void test_pack_PSIZE(void)
{
    /* PSIZE */
    TEST_TYPE_SIZE   (PSIZE, 4)
    TEST_TYPE_ALIGN  (PSIZE, 4)
    TEST_TARGET_SIZE (PSIZE, 8)
    TEST_TARGET_ALIGN(PSIZE, 4)
}

static void test_pack_PSZ(void)
{
    /* PSZ */
    TEST_TYPE_SIZE   (PSZ, 4)
    TEST_TYPE_ALIGN  (PSZ, 4)
}

static void test_pack_RECT(void)
{
    /* RECT */
    TEST_TYPE_SIZE   (RECT, 16)
    TEST_TYPE_ALIGN  (RECT, 4)
    TEST_FIELD_SIZE  (RECT, left, 4)
    TEST_FIELD_ALIGN (RECT, left, 4)
    TEST_FIELD_OFFSET(RECT, left, 0)
    TEST_FIELD_SIZE  (RECT, top, 4)
    TEST_FIELD_ALIGN (RECT, top, 4)
    TEST_FIELD_OFFSET(RECT, top, 4)
    TEST_FIELD_SIZE  (RECT, right, 4)
    TEST_FIELD_ALIGN (RECT, right, 4)
    TEST_FIELD_OFFSET(RECT, right, 8)
    TEST_FIELD_SIZE  (RECT, bottom, 4)
    TEST_FIELD_ALIGN (RECT, bottom, 4)
    TEST_FIELD_OFFSET(RECT, bottom, 12)
}

static void test_pack_RECTL(void)
{
    /* RECTL */
    TEST_TYPE_SIZE   (RECTL, 16)
    TEST_TYPE_ALIGN  (RECTL, 4)
    TEST_FIELD_SIZE  (RECTL, left, 4)
    TEST_FIELD_ALIGN (RECTL, left, 4)
    TEST_FIELD_OFFSET(RECTL, left, 0)
    TEST_FIELD_SIZE  (RECTL, top, 4)
    TEST_FIELD_ALIGN (RECTL, top, 4)
    TEST_FIELD_OFFSET(RECTL, top, 4)
    TEST_FIELD_SIZE  (RECTL, right, 4)
    TEST_FIELD_ALIGN (RECTL, right, 4)
    TEST_FIELD_OFFSET(RECTL, right, 8)
    TEST_FIELD_SIZE  (RECTL, bottom, 4)
    TEST_FIELD_ALIGN (RECTL, bottom, 4)
    TEST_FIELD_OFFSET(RECTL, bottom, 12)
}

static void test_pack_SIZE(void)
{
    /* SIZE */
    TEST_TYPE_SIZE   (SIZE, 8)
    TEST_TYPE_ALIGN  (SIZE, 4)
    TEST_FIELD_SIZE  (SIZE, cx, 4)
    TEST_FIELD_ALIGN (SIZE, cx, 4)
    TEST_FIELD_OFFSET(SIZE, cx, 0)
    TEST_FIELD_SIZE  (SIZE, cy, 4)
    TEST_FIELD_ALIGN (SIZE, cy, 4)
    TEST_FIELD_OFFSET(SIZE, cy, 4)
}

static void test_pack_SIZEL(void)
{
    /* SIZEL */
    TEST_TYPE_SIZE   (SIZEL, 8)
    TEST_TYPE_ALIGN  (SIZEL, 4)
}

static void test_pack_UCHAR(void)
{
    /* UCHAR */
    TEST_TYPE_SIZE   (UCHAR, 1)
    TEST_TYPE_ALIGN  (UCHAR, 1)
    TEST_TYPE_UNSIGNED(UCHAR)
}

static void test_pack_UINT(void)
{
    /* UINT */
    TEST_TYPE_SIZE   (UINT, 4)
    TEST_TYPE_ALIGN  (UINT, 4)
    TEST_TYPE_UNSIGNED(UINT)
}

static void test_pack_ULONG(void)
{
    /* ULONG */
    TEST_TYPE_SIZE   (ULONG, 4)
    TEST_TYPE_ALIGN  (ULONG, 4)
    TEST_TYPE_UNSIGNED(ULONG)
}

static void test_pack_USHORT(void)
{
    /* USHORT */
    TEST_TYPE_SIZE   (USHORT, 2)
    TEST_TYPE_ALIGN  (USHORT, 2)
    TEST_TYPE_UNSIGNED(USHORT)
}

static void test_pack_WORD(void)
{
    /* WORD */
    TEST_TYPE_SIZE   (WORD, 2)
    TEST_TYPE_ALIGN  (WORD, 2)
    TEST_TYPE_UNSIGNED(WORD)
}

static void test_pack_WPARAM(void)
{
    /* WPARAM */
    TEST_TYPE_SIZE   (WPARAM, 4)
    TEST_TYPE_ALIGN  (WPARAM, 4)
}

#endif /* _WIN64 */

static void test_pack(void)
{
    test_pack_ACCESS_ALLOWED_ACE();
    test_pack_ACCESS_DENIED_ACE();
    test_pack_ACCESS_MASK();
    test_pack_ACE_HEADER();
    test_pack_ACL();
    test_pack_ACL_REVISION_INFORMATION();
    test_pack_ACL_SIZE_INFORMATION();
    test_pack_ATOM();
    test_pack_BOOL();
    test_pack_BOOLEAN();
    test_pack_BYTE();
    test_pack_CCHAR();
    test_pack_CHAR();
    test_pack_COLORREF();
    test_pack_DWORD();
    test_pack_DWORD32();
    test_pack_DWORD64();
    test_pack_DWORDLONG();
    test_pack_DWORD_PTR();
    test_pack_EXCEPTION_POINTERS();
    test_pack_EXCEPTION_RECORD();
    test_pack_EXECUTION_STATE();
    test_pack_FARPROC();
    test_pack_FLOAT();
    test_pack_FPO_DATA();
    test_pack_GENERIC_MAPPING();
    test_pack_GLOBALHANDLE();
    test_pack_HALF_PTR();
    test_pack_HANDLE();
    test_pack_HCURSOR();
    test_pack_HFILE();
    test_pack_HGDIOBJ();
    test_pack_HGLOBAL();
    test_pack_HLOCAL();
    test_pack_HMODULE();
    test_pack_HRESULT();
    test_pack_IMAGE_ARCHIVE_MEMBER_HEADER();
    test_pack_IMAGE_AUX_SYMBOL();
    test_pack_IMAGE_BASE_RELOCATION();
    test_pack_IMAGE_BOUND_FORWARDER_REF();
    test_pack_IMAGE_BOUND_IMPORT_DESCRIPTOR();
    test_pack_IMAGE_COFF_SYMBOLS_HEADER();
    test_pack_IMAGE_DATA_DIRECTORY();
    test_pack_IMAGE_DEBUG_DIRECTORY();
    test_pack_IMAGE_DEBUG_MISC();
    test_pack_IMAGE_DOS_HEADER();
    test_pack_IMAGE_EXPORT_DIRECTORY();
    test_pack_IMAGE_FILE_HEADER();
    test_pack_IMAGE_FUNCTION_ENTRY();
    test_pack_IMAGE_IMPORT_BY_NAME();
    test_pack_IMAGE_IMPORT_DESCRIPTOR();
    test_pack_IMAGE_LINENUMBER();
    test_pack_IMAGE_LOAD_CONFIG_DIRECTORY();
    test_pack_IMAGE_NT_HEADERS();
    test_pack_IMAGE_NT_HEADERS32();
    test_pack_IMAGE_NT_HEADERS64();
    test_pack_IMAGE_OPTIONAL_HEADER();
    test_pack_IMAGE_OPTIONAL_HEADER32();
    test_pack_IMAGE_OPTIONAL_HEADER64();
    test_pack_IMAGE_OS2_HEADER();
    test_pack_IMAGE_RELOCATION();
    test_pack_IMAGE_RESOURCE_DATA_ENTRY();
    test_pack_IMAGE_RESOURCE_DIRECTORY();
    test_pack_IMAGE_RESOURCE_DIRECTORY_ENTRY();
    test_pack_IMAGE_RESOURCE_DIRECTORY_STRING();
    test_pack_IMAGE_RESOURCE_DIR_STRING_U();
    test_pack_IMAGE_SECTION_HEADER();
    test_pack_IMAGE_SEPARATE_DEBUG_HEADER();
    test_pack_IMAGE_SYMBOL();
    test_pack_IMAGE_THUNK_DATA();
    test_pack_IMAGE_TLS_DIRECTORY();
    test_pack_IMAGE_TLS_DIRECTORY32();
    test_pack_IMAGE_TLS_DIRECTORY64();
    test_pack_IMAGE_VXD_HEADER();
    test_pack_INT();
    test_pack_INT16();
    test_pack_INT32();
    test_pack_INT64();
    test_pack_INT8();
    test_pack_INT_PTR();
    test_pack_IO_COUNTERS();
    test_pack_LANGID();
    test_pack_LARGE_INTEGER();
    test_pack_LCID();
    test_pack_LIST_ENTRY();
    test_pack_LOCALHANDLE();
    test_pack_LONG();
    test_pack_LONG32();
    test_pack_LONG64();
    test_pack_LONGLONG();
    test_pack_LONG_PTR();
    test_pack_LPARAM();
    test_pack_LPCRECT();
    test_pack_LPCRECTL();
    test_pack_LPCVOID();
    test_pack_LPPOINT();
    test_pack_LPRECT();
    test_pack_LPRECTL();
    test_pack_LPSIZE();
    test_pack_LRESULT();
    test_pack_LUID();
    test_pack_LUID_AND_ATTRIBUTES();
    test_pack_MEMORY_BASIC_INFORMATION();
    test_pack_MESSAGE_RESOURCE_BLOCK();
    test_pack_MESSAGE_RESOURCE_DATA();
    test_pack_MESSAGE_RESOURCE_ENTRY();
    test_pack_NT_TIB();
    test_pack_OBJECT_TYPE_LIST();
    test_pack_PACCESS_ALLOWED_ACE();
    test_pack_PACCESS_DENIED_ACE();
    test_pack_PACCESS_TOKEN();
    test_pack_PACE_HEADER();
    test_pack_PACL();
    test_pack_PACL_REVISION_INFORMATION();
    test_pack_PACL_SIZE_INFORMATION();
    test_pack_PCCH();
    test_pack_PCH();
    test_pack_PCSTR();
    test_pack_PCWCH();
    test_pack_PCWSTR();
    test_pack_PEXCEPTION_POINTERS();
    test_pack_PEXCEPTION_RECORD();
    test_pack_PFPO_DATA();
    test_pack_PGENERIC_MAPPING();
    test_pack_PHANDLE();
    test_pack_PIMAGE_ARCHIVE_MEMBER_HEADER();
    test_pack_PIMAGE_AUX_SYMBOL();
    test_pack_PIMAGE_BASE_RELOCATION();
    test_pack_PIMAGE_BOUND_FORWARDER_REF();
    test_pack_PIMAGE_BOUND_IMPORT_DESCRIPTOR();
    test_pack_PIMAGE_COFF_SYMBOLS_HEADER();
    test_pack_PIMAGE_DATA_DIRECTORY();
    test_pack_PIMAGE_DEBUG_DIRECTORY();
    test_pack_PIMAGE_DEBUG_MISC();
    test_pack_PIMAGE_DOS_HEADER();
    test_pack_PIMAGE_EXPORT_DIRECTORY();
    test_pack_PIMAGE_FILE_HEADER();
    test_pack_PIMAGE_FUNCTION_ENTRY();
    test_pack_PIMAGE_IMPORT_BY_NAME();
    test_pack_PIMAGE_IMPORT_DESCRIPTOR();
    test_pack_PIMAGE_LINENUMBER();
    test_pack_PIMAGE_LOAD_CONFIG_DIRECTORY();
    test_pack_PIMAGE_NT_HEADERS();
    test_pack_PIMAGE_NT_HEADERS32();
    test_pack_PIMAGE_NT_HEADERS64();
    test_pack_PIMAGE_OPTIONAL_HEADER();
    test_pack_PIMAGE_OPTIONAL_HEADER32();
    test_pack_PIMAGE_OPTIONAL_HEADER64();
    test_pack_PIMAGE_OS2_HEADER();
    test_pack_PIMAGE_RELOCATION();
    test_pack_PIMAGE_RESOURCE_DATA_ENTRY();
    test_pack_PIMAGE_RESOURCE_DIRECTORY();
    test_pack_PIMAGE_RESOURCE_DIRECTORY_ENTRY();
    test_pack_PIMAGE_RESOURCE_DIRECTORY_STRING();
    test_pack_PIMAGE_RESOURCE_DIR_STRING_U();
    test_pack_PIMAGE_SECTION_HEADER();
    test_pack_PIMAGE_SEPARATE_DEBUG_HEADER();
    test_pack_PIMAGE_SYMBOL();
    test_pack_PIMAGE_THUNK_DATA();
    test_pack_PIMAGE_TLS_CALLBACK();
    test_pack_PIMAGE_TLS_DIRECTORY();
    test_pack_PIMAGE_VXD_HEADER();
    test_pack_PIO_COUNTERS();
    test_pack_PISECURITY_DESCRIPTOR();
    test_pack_PISECURITY_DESCRIPTOR_RELATIVE();
    test_pack_PISID();
    test_pack_PLARGE_INTEGER();
    test_pack_PLIST_ENTRY();
    test_pack_PLUID();
    test_pack_PLUID_AND_ATTRIBUTES();
    test_pack_PMEMORY_BASIC_INFORMATION();
    test_pack_PMESSAGE_RESOURCE_BLOCK();
    test_pack_PMESSAGE_RESOURCE_DATA();
    test_pack_PMESSAGE_RESOURCE_ENTRY();
    test_pack_PNT_TIB();
    test_pack_POBJECT_TYPE_LIST();
    test_pack_POINT();
    test_pack_POINTL();
    test_pack_PPOINT();
    test_pack_PPOINTL();
    test_pack_PPRIVILEGE_SET();
    test_pack_PRECT();
    test_pack_PRECTL();
    test_pack_PRIVILEGE_SET();
    test_pack_PRLIST_ENTRY();
    test_pack_PROC();
    test_pack_PRTL_CRITICAL_SECTION();
    test_pack_PRTL_CRITICAL_SECTION_DEBUG();
    test_pack_PRTL_OSVERSIONINFOEXW();
    test_pack_PRTL_OSVERSIONINFOW();
    test_pack_PRTL_RESOURCE_DEBUG();
    test_pack_PSECURITY_DESCRIPTOR();
    test_pack_PSECURITY_QUALITY_OF_SERVICE();
    test_pack_PSID();
    test_pack_PSID_IDENTIFIER_AUTHORITY();
    test_pack_PSINGLE_LIST_ENTRY();
    test_pack_PSIZE();
    test_pack_PSTR();
    test_pack_PSYSTEM_ALARM_ACE();
    test_pack_PSYSTEM_AUDIT_ACE();
    test_pack_PSZ();
    test_pack_PTOKEN_GROUPS();
    test_pack_PTOKEN_PRIVILEGES();
    test_pack_PTOKEN_USER();
    test_pack_PULARGE_INTEGER();
    test_pack_PVECTORED_EXCEPTION_HANDLER();
    test_pack_PVOID();
    test_pack_PWCH();
    test_pack_PWSTR();
    test_pack_RECT();
    test_pack_RECTL();
    test_pack_RTL_CRITICAL_SECTION();
    test_pack_RTL_CRITICAL_SECTION_DEBUG();
    test_pack_RTL_OSVERSIONINFOEXW();
    test_pack_RTL_OSVERSIONINFOW();
    test_pack_RTL_RESOURCE_DEBUG();
    test_pack_SECURITY_CONTEXT_TRACKING_MODE();
    test_pack_SECURITY_DESCRIPTOR();
    test_pack_SECURITY_DESCRIPTOR_CONTROL();
    test_pack_SECURITY_DESCRIPTOR_RELATIVE();
    test_pack_SECURITY_INFORMATION();
    test_pack_SECURITY_QUALITY_OF_SERVICE();
    test_pack_SHORT();
    test_pack_SID();
    test_pack_SID_AND_ATTRIBUTES();
    test_pack_SID_IDENTIFIER_AUTHORITY();
    test_pack_SINGLE_LIST_ENTRY();
    test_pack_SIZE();
    test_pack_SIZEL();
    test_pack_SIZE_T();
    test_pack_SSIZE_T();
    test_pack_SYSTEM_ALARM_ACE();
    test_pack_SYSTEM_AUDIT_ACE();
    test_pack_TOKEN_DEFAULT_DACL();
    test_pack_TOKEN_GROUPS();
    test_pack_TOKEN_OWNER();
    test_pack_TOKEN_PRIMARY_GROUP();
    test_pack_TOKEN_PRIVILEGES();
    test_pack_TOKEN_SOURCE();
    test_pack_TOKEN_STATISTICS();
    test_pack_TOKEN_USER();
    test_pack_UCHAR();
    test_pack_UHALF_PTR();
    test_pack_UINT();
    test_pack_UINT16();
    test_pack_UINT32();
    test_pack_UINT64();
    test_pack_UINT8();
    test_pack_UINT_PTR();
    test_pack_ULARGE_INTEGER();
    test_pack_ULONG();
    test_pack_ULONG32();
    test_pack_ULONG64();
    test_pack_ULONGLONG();
    test_pack_ULONG_PTR();
    test_pack_USHORT();
    test_pack_WAITORTIMERCALLBACKFUNC();
    test_pack_WCHAR();
    test_pack_WORD();
    test_pack_WPARAM();
}

START_TEST(generated)
{
    test_pack();
}
