/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLIOStreamManager {
    private InputStream xmlInputStream;
    private OutputStream xmlOutputStream;
    private String systemId;
    private SAXBuilder xmlBuilder = new SAXBuilder(false);
    private XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());

    public XMLIOStreamManager() {
    }

    public XMLIOStreamManager(InputStream inputStream, OutputStream outputStream) {
        this.setXMLInputStream(inputStream);
        this.setXMLOutputStream(outputStream);
    }

    public SAXBuilder getBuilder() {
        return this.xmlBuilder;
    }

    public void setXMLInputStream(InputStream inputStream) {
        this.xmlInputStream = inputStream;
    }

    public void setXMLInputStream(InputStream inputStream, String string) {
        this.xmlInputStream = inputStream;
        this.systemId = string;
    }

    public void setXMLOutputStream(OutputStream outputStream) {
        this.xmlOutputStream = outputStream;
    }

    public Element getRootElement() throws JDOMException, IOException {
        Document document = this.xmlBuilder.build(this.xmlInputStream, this.systemId);
        return document.getRootElement();
    }

    public void saveRootElement(Element element) throws IOException {
        this.saveRootElement(element, null);
    }

    public void saveRootElement(Element element, DocType docType) throws IOException {
        Document document = docType != null ? new Document(element, docType) : new Document(element);
        this.xmlOutputter.output(document, this.xmlOutputStream);
        this.xmlOutputStream.close();
    }
}

