/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.freehep.xml.io.XMLIOStreamManager;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XMLIOFileManager
extends XMLIOStreamManager {
    private File xmlFile;
    private boolean isZipped = false;

    public XMLIOFileManager(String string) {
        this.xmlFile = new File(string);
    }

    public Element getRootElement() throws JDOMException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(this.xmlFile));
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            inputStream = new FileInputStream(this.xmlFile);
        }
        super.setXMLInputStream(inputStream, "file:" + this.xmlFile.getAbsolutePath());
        return super.getRootElement();
    }

    public void saveRootElement(Element element, String string, String string2) throws IOException {
        if (this.isXMLFileZipped()) {
            super.setXMLOutputStream(new GZIPOutputStream(new FileOutputStream(this.xmlFile)));
        } else {
            super.setXMLOutputStream(new FileOutputStream(this.xmlFile));
        }
        if (!string.equals("") && !string2.equals("")) {
            super.saveRootElement(element, new DocType(string, string2));
        } else {
            super.saveRootElement(element);
        }
    }

    public void saveRootElement(Element element) throws IOException {
        this.saveRootElement(element, "", "");
    }

    public boolean isXMLFileZipped() {
        return this.isZipped;
    }

    public void setXMLFileZipped(boolean bl2) {
        this.isZipped = bl2;
    }
}

