/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.EncodingException;

public class Base64InputStream
extends InputStream {
    private int[] b = new int[3];
    private int bIndex;
    private int bLength;
    private boolean endReached;
    private int lineNo;
    private InputStream in;
    private static final int ILLEGAL = -1;
    private static final int LINEFEED = -3;
    private static final int CARRIAGERETURN = -4;
    private static final int EQUALS = -5;
    private static final byte[] base64toInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -3, -1, -1, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -5, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public Base64InputStream(InputStream inputStream) {
        this.in = inputStream;
        this.endReached = false;
        this.bIndex = 0;
        this.bLength = 0;
        this.lineNo = 1;
    }

    public int read() throws IOException {
        if (this.bIndex >= this.bLength) {
            if (this.endReached) {
                return -1;
            }
            this.bLength = this.readTuple();
            if (this.bLength <= 0) {
                return -1;
            }
            this.bIndex = 0;
        }
        int n2 = this.b[this.bIndex];
        ++this.bIndex;
        return n2;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private int readTuple() throws IOException, EncodingException {
        int n2;
        byte[] byArray = new byte[4];
        int n3 = 0;
        byte by = 0;
        byte by2 = 0;
        int n4 = 0;
        if (this.endReached) {
            return 0;
        }
        block11: while (n4 < byArray.length) {
            n2 = this.in.read();
            if (n2 < 0) {
                this.endReached = true;
                if (n3 == 0) {
                    return 0;
                }
                throw new EncodingException("Improperly padded Base64 Input.");
            }
            by2 = by;
            by = base64toInt[n2 & 0x7F];
            switch (by) {
                case -1: {
                    if (n2 < 0) {
                        throw new EncodingException("Illegal character in Base64 encoding '" + n2 + "'.");
                    }
                }
                case -5: {
                    ++n4;
                    continue block11;
                }
                case -4: {
                    ++this.lineNo;
                    continue block11;
                }
                case -3: {
                    if (by2 == -4) continue block11;
                    ++this.lineNo;
                    continue block11;
                }
            }
            byArray[n3] = (byte)(by & 0xFF);
            ++n3;
            ++n4;
        }
        switch (n3) {
            case 2: {
                n2 = byArray[0] << 18 | byArray[1] << 12;
                this.b[0] = n2 >>> 16;
                return 1;
            }
            case 3: {
                n2 = byArray[0] << 18 | byArray[1] << 12 | byArray[2] << 6;
                this.b[0] = n2 >>> 16;
                this.b[1] = n2 >>> 8;
                return 2;
            }
            case 4: {
                n2 = byArray[0] << 18 | byArray[1] << 12 | byArray[2] << 6 | byArray[3];
                this.b[0] = n2 >>> 16;
                this.b[1] = n2 >>> 8;
                this.b[2] = n2;
                return 3;
            }
        }
        throw new EncodingException("Base64InputStream: internal error.");
    }
}

