/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.AbstractPathConstructor;

public abstract class CubicToQuadPathConstructor
extends AbstractPathConstructor {
    private double resolutionSq;

    protected CubicToQuadPathConstructor(double d2) {
        this.resolutionSq = d2 * d2;
    }

    public void move(double d2, double d3) throws IOException {
        this.currentX = d2;
        this.currentY = d3;
    }

    public void line(double d2, double d3) throws IOException {
        this.currentX = d2;
        this.currentY = d3;
    }

    public void cubic(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        this.quadratify(new Point2D.Double(this.currentX, this.currentY), new Point2D.Double(d2, d3), new Point2D.Double(d4, d5), new Point2D.Double(d6, d7));
        this.currentX = d6;
        this.currentY = d7;
    }

    public void closePath(double d2, double d3) throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }

    public static Point2D intersect(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = point2D3.getX() - point2D4.getX();
        if (d2 == 0.0 && d3 == 0.0) {
            return null;
        }
        double d4 = point2D2.getY() - point2D.getY();
        double d5 = point2D3.getY() - point2D4.getY();
        if (d4 == 0.0 && d5 == 0.0) {
            return null;
        }
        double d6 = (point2D2.getY() - point2D.getY()) / d2;
        double d7 = (point2D3.getY() - point2D4.getY()) / d3;
        if (d2 == 0.0) {
            return new Point2D.Double(point2D.getX(), d7 * (point2D.getX() - point2D4.getX()) + point2D4.getY());
        }
        if (d3 == 0.0) {
            return new Point2D.Double(point2D4.getX(), d6 * (point2D4.getX() - point2D.getX()) + point2D.getY());
        }
        if (d6 == d7) {
            return null;
        }
        double d8 = (-d7 * point2D4.getX() + point2D4.getY() + d6 * point2D.getX() - point2D.getY()) / (d6 - d7);
        double d9 = d6 * (d8 - point2D.getX()) + point2D.getY();
        return new Point2D.Double(d8, d9);
    }

    public static Point2D midPoint(Point2D point2D, Point2D point2D2) {
        return new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
    }

    public void quadratify(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) throws IOException {
        double d2;
        Point2D point2D5 = CubicToQuadPathConstructor.intersect(point2D, point2D2, point2D3, point2D4);
        if (point2D5 == null) {
            return;
        }
        double d3 = (point2D.getX() + point2D4.getX() + point2D5.getX() * 4.0 - (point2D2.getX() + point2D3.getX()) * 3.0) * 0.125;
        if (d3 * d3 + (d2 = (point2D.getY() + point2D4.getY() + point2D5.getY() * 4.0 - (point2D2.getY() + point2D3.getY()) * 3.0) * 0.125) * d2 > this.resolutionSq) {
            Point2D point2D6 = CubicToQuadPathConstructor.midPoint(point2D, point2D2);
            Point2D point2D7 = CubicToQuadPathConstructor.midPoint(point2D2, point2D3);
            Point2D point2D8 = CubicToQuadPathConstructor.midPoint(point2D3, point2D4);
            Point2D point2D9 = CubicToQuadPathConstructor.midPoint(point2D6, point2D7);
            Point2D point2D10 = CubicToQuadPathConstructor.midPoint(point2D7, point2D8);
            Point2D point2D11 = CubicToQuadPathConstructor.midPoint(point2D9, point2D10);
            this.quadratify(point2D, point2D6, point2D9, point2D11);
            this.quadratify(point2D11, point2D10, point2D8, point2D4);
        } else {
            this.quad(point2D5.getX(), point2D5.getY(), point2D4.getX(), point2D4.getY());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Test test = new Test(0.5);
        test.move(20.0, 20.0);
        test.cubic(20.0, 40.0, 40.0, 60.0, 60.0, 60.0);
        test.move(20.0, 20.0);
        test.cubic(20.0, 40.0, 60.0, 60.0, 40.0, 60.0);
        test.move(183.0, 149.0);
        test.cubic(189.0, 291.0, 256.0, 347.0, 295.0, 244.0);
        test.cubic(334.0, 141.0, 286.0, 216.0, 214.0, 228.0);
        test.cubic(142.0, 240.0, 142.0, 256.0, 176.0, 284.0);
    }

    static class Test
    extends CubicToQuadPathConstructor {
        public Test(double d2) {
            super(d2);
        }

        public void quad(double d2, double d3, double d4, double d5) {
            System.out.println("Quad: (" + this.currentX + ", " + this.currentY + ") (" + d2 + ", " + d3 + ") (" + d4 + ", " + d5 + ")");
            this.currentX = d4;
            this.currentY = d5;
        }
    }
}

