/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.MainApplet;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Molecule {
    public static final int HEXPLICIT_UNKNOWN = -1;
    public static final int BONDTYPE_NORMAL = 0;
    public static final int BONDTYPE_INCLINED = 1;
    public static final int BONDTYPE_DECLINED = 2;
    public static final int BONDTYPE_UNKNOWN = 3;
    public static final String[] ELEMENTS = new String[]{null, "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr"};
    public static final double[] WEIGHTS = new double[]{0.0, 1.00794, 4.002602, 6.941, 9.01218, 10.811, 12.011, 14.00674, 15.9994, 18.998403, 20.1797, 22.989768, 24.305, 26.981539, 28.0855, 30.973762, 32.066, 35.4527, 39.948, 39.0983, 40.078, 44.95591, 47.88, 50.9415, 51.9961, 54.93805, 55.847, 58.9332, 58.6934, 63.546, 65.39, 69.723, 72.61, 74.92159, 78.96, 79.904, 83.8, 85.4678, 87.62, 88.90585, 91.224, 92.90638, 95.94, 97.9072, 101.07, 102.9055, 106.42, 107.8682, 112.411, 114.818, 118.71, 121.76, 127.6, 126.90447, 131.29, 132.90543, 137.327, 138.9055, 140.115, 140.90765, 144.24, 144.9127, 150.36, 151.965, 157.25, 158.92534, 162.5, 164.93032, 167.26, 168.93421, 173.04, 174.967, 178.49, 180.9479, 183.84, 186.207, 190.23, 192.22, 195.08, 196.96654, 200.59, 204.3833, 207.2, 208.98037, 208.9824, 209.9871, 222.0176, 223.0197, 226.0254, 227.0278, 232.0381, 231.03588, 238.0289, 237.048, 244.0642, 243.0614, 247.0703, 247.0703, 251.0796, 252.083, 257.0951, 258.1, 259.1009, 262.11};
    boolean invalMinMax = false;
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;
    ArrayList<Atom> atoms = new ArrayList();
    ArrayList<Bond> bonds = new ArrayList();
    int[][] graph = null;
    int[] ringID = null;
    int[] compID = null;
    int[] priority = null;
    ArrayList<Object> ring5 = null;
    ArrayList<Object> ring6 = null;
    ArrayList<Object> ring7 = null;
    public static final int STEREO_NONE = 0;
    public static final int STEREO_POS = 1;
    public static final int STEREO_NEG = 2;
    public static final int STEREO_UNKNOWN = 3;
    int[] chiral = null;
    int[] cistrans = null;
    static final String[] HYVALENCE_EL = new String[]{"C", "N", "O", "S", "P"};
    static final int[] HYVALENCE_VAL = new int[]{4, 3, 2, 2, 3};

    public Molecule Clone() {
        int n;
        Molecule mol = new Molecule();
        for (n = 1; n <= this.NumAtoms(); ++n) {
            Atom a = this.atoms.get(n - 1);
            int num = mol.AddAtom(a.Element, a.X, a.Y, a.Charge, a.Unpaired);
            mol.SetAtomHExplicit(num, this.AtomHExplicit(n));
            mol.SetAtomMapNum(num, this.AtomMapNum(n));
        }
        for (n = 1; n <= this.NumBonds(); ++n) {
            Bond b = this.bonds.get(n - 1);
            mol.AddBond(b.From, b.To, b.Order, b.Type);
        }
        return mol;
    }

    public int NumAtoms() {
        return this.atoms.size();
    }

    public int NumBonds() {
        return this.bonds.size();
    }

    public String AtomElement(int N) {
        return this.atoms.get((int)(N - 1)).Element;
    }

    public double AtomX(int N) {
        return this.atoms.get((int)(N - 1)).X;
    }

    public double AtomY(int N) {
        return this.atoms.get((int)(N - 1)).Y;
    }

    public int AtomCharge(int N) {
        return this.atoms.get((int)(N - 1)).Charge;
    }

    public int AtomUnpaired(int N) {
        return this.atoms.get((int)(N - 1)).Unpaired;
    }

    public int AtomHExplicit(int N) {
        return this.atoms.get((int)(N - 1)).HExplicit;
    }

    public int AtomMapNum(int N) {
        return this.atoms.get((int)(N - 1)).MapNum;
    }

    public int BondFrom(int N) {
        return this.bonds.get((int)(N - 1)).From;
    }

    public int BondTo(int N) {
        return this.bonds.get((int)(N - 1)).To;
    }

    public int BondOrder(int N) {
        return this.bonds.get((int)(N - 1)).Order;
    }

    public int BondType(int N) {
        return this.bonds.get((int)(N - 1)).Type;
    }

    public int AddAtom(String Element, double X, double Y) {
        return this.AddAtom(Element, X, Y, 0, 0);
    }

    public int AddAtom(String Element, double X, double Y, int Charge, int Unpaired) {
        if (X < this.minX || this.NumAtoms() == 0) {
            this.minX = X;
        }
        if (X > this.maxX || this.NumAtoms() == 0) {
            this.maxX = X;
        }
        if (Y < this.minY || this.NumAtoms() == 0) {
            this.minY = Y;
        }
        if (Y > this.maxY || this.NumAtoms() == 0) {
            this.maxY = Y;
        }
        Atom a = new Atom();
        a.Element = Element;
        a.X = X;
        a.Y = Y;
        a.Charge = Charge;
        a.Unpaired = Unpaired;
        a.HExplicit = -1;
        this.atoms.add(a);
        this.TrashGraph();
        return this.atoms.size();
    }

    public void SetAtomElement(int N, String Element) {
        this.atoms.get((int)(N - 1)).Element = Element;
        this.TrashPriority();
    }

    public void SetAtomPos(int N, double X, double Y) {
        this.atoms.get((int)(N - 1)).X = X;
        this.atoms.get((int)(N - 1)).Y = Y;
        this.invalMinMax = true;
        this.TrashStereo();
    }

    public void SetAtomCharge(int N, int Charge) {
        this.atoms.get((int)(N - 1)).Charge = Charge;
        this.TrashPriority();
    }

    public void SetAtomUnpaired(int N, int Unpaired) {
        this.atoms.get((int)(N - 1)).Unpaired = Unpaired;
        this.TrashPriority();
    }

    public void SetAtomHExplicit(int N, int HExplicit) {
        this.atoms.get((int)(N - 1)).HExplicit = HExplicit;
        this.TrashPriority();
    }

    public void SetAtomMapNum(int N, int MapNum) {
        this.atoms.get((int)(N - 1)).MapNum = MapNum;
    }

    public int AddBond(int From, int To, int Order) {
        return this.AddBond(From, To, Order, 0);
    }

    public int AddBond(int From, int To, int Order, int Type2) {
        Bond b = new Bond();
        b.From = From;
        b.To = To;
        b.Order = Order;
        b.Type = Type2;
        this.bonds.add(b);
        this.TrashGraph();
        return this.bonds.size();
    }

    public void SetBondFromTo(int N, int From, int To) {
        this.bonds.get((int)(N - 1)).From = From;
        this.bonds.get((int)(N - 1)).To = To;
        this.TrashGraph();
    }

    public void SetBondOrder(int N, int Order) {
        this.bonds.get((int)(N - 1)).Order = Order;
        this.TrashPriority();
    }

    public void SetBondType(int N, int Type2) {
        this.bonds.get((int)(N - 1)).Type = Type2;
        this.TrashStereo();
    }

    public void DeleteAtomAndBonds(int N) {
        int n = 0;
        while (n < this.NumBonds()) {
            Bond b = this.bonds.get(n);
            if (b.From == N || b.To == N) {
                this.bonds.remove(n);
                continue;
            }
            if (b.From > N) {
                --b.From;
            }
            if (b.To > N) {
                --b.To;
            }
            ++n;
        }
        this.atoms.remove(N - 1);
        this.invalMinMax = true;
        this.TrashGraph();
    }

    public void DeleteBond(int N) {
        this.bonds.remove(N - 1);
        this.TrashGraph();
    }

    public double MinX() {
        if (this.invalMinMax) {
            this.DetermineMinMax();
        }
        return this.minX;
    }

    public double MaxX() {
        if (this.invalMinMax) {
            this.DetermineMinMax();
        }
        return this.maxX;
    }

    public double MinY() {
        if (this.invalMinMax) {
            this.DetermineMinMax();
        }
        return this.minY;
    }

    public double MaxY() {
        if (this.invalMinMax) {
            this.DetermineMinMax();
        }
        return this.maxY;
    }

    public double RangeX() {
        return this.maxX - this.minX;
    }

    public double RangeY() {
        return this.maxY - this.minY;
    }

    public int FindBond(int A1, int A2) {
        for (int n = 1; n <= this.NumBonds(); ++n) {
            if (this.BondFrom(n) == A1 && this.BondTo(n) == A2) {
                return n;
            }
            if (this.BondTo(n) != A1 || this.BondFrom(n) != A2) continue;
            return n;
        }
        return 0;
    }

    public int BondOther(int N, int Ref) {
        if (this.BondFrom(N) == Ref) {
            return this.BondTo(N);
        }
        if (this.BondTo(N) == Ref) {
            return this.BondFrom(N);
        }
        return 0;
    }

    public boolean AtomExplicit(int N) {
        if (this.atoms.get((int)(N - 1)).Element.compareTo("C") != 0 || this.atoms.get((int)(N - 1)).Charge != 0 || this.atoms.get((int)(N - 1)).Unpaired != 0) {
            return true;
        }
        for (int n = 0; n < this.bonds.size(); ++n) {
            if (this.bonds.get((int)n).From != N && this.bonds.get((int)n).To != N) continue;
            return false;
        }
        return true;
    }

    public int AtomHydrogens(int N) {
        int hy = this.AtomHExplicit(N);
        if (hy != -1) {
            return hy;
        }
        for (int n = 0; n < HYVALENCE_EL.length; ++n) {
            if (HYVALENCE_EL[n].compareTo(this.AtomElement(N)) != 0) continue;
            hy = HYVALENCE_VAL[n];
            break;
        }
        if (hy == -1) {
            return 0;
        }
        int ch = this.AtomCharge(N);
        if (this.AtomElement(N).compareTo("C") == 0) {
            ch = -Math.abs(ch);
        }
        hy += ch - this.AtomUnpaired(N);
        for (int n = 1; n <= this.NumBonds(); ++n) {
            if (this.BondFrom(n) != N && this.BondTo(n) != N) continue;
            hy -= this.BondOrder(n);
        }
        return hy < 0 ? 0 : hy;
    }

    public int AtomRingBlock(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        if (this.ringID == null) {
            this.BuildRingID();
        }
        return this.ringID[N - 1];
    }

    public boolean BondInRing(int N) {
        int r1 = this.AtomRingBlock(this.BondFrom(N));
        int r2 = this.AtomRingBlock(this.BondTo(N));
        return r1 > 0 && r1 == r2;
    }

    public int AtomConnComp(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        if (this.compID == null) {
            this.BuildConnComp();
        }
        return this.compID[N - 1];
    }

    public int AtomAdjCount(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        return this.graph[N - 1].length;
    }

    public int[] AtomAdjList(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        int[] adj = (int[])this.graph[N - 1].clone();
        int n = 0;
        while (n < adj.length) {
            int n2 = n++;
            adj[n2] = adj[n2] + 1;
        }
        return adj;
    }

    public int AtomPriority(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        if (this.compID == null) {
            this.BuildConnComp();
        }
        if (this.priority == null) {
            this.BuildPriority();
        }
        return this.priority[N - 1];
    }

    public int AtomChirality(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        if (this.compID == null) {
            this.BuildConnComp();
        }
        if (this.priority == null) {
            this.BuildPriority();
        }
        if (this.chiral == null) {
            this.BuildChirality();
        }
        return this.chiral[N - 1];
    }

    public int BondStereo(int N) {
        if (this.graph == null) {
            this.BuildGraph();
        }
        if (this.compID == null) {
            this.BuildConnComp();
        }
        if (this.priority == null) {
            this.BuildPriority();
        }
        if (this.cistrans == null) {
            this.BuildCisTrans();
        }
        return this.cistrans[N - 1];
    }

    public int[][] FindRingSize(int Size) {
        ArrayList<Object> rings = null;
        if (Size == 5 && this.ring5 != null) {
            rings = this.ring5;
        }
        if (Size == 6 && this.ring6 != null) {
            rings = this.ring6;
        }
        if (Size == 7 && this.ring7 != null) {
            rings = this.ring7;
        }
        if (rings == null) {
            if (this.graph == null) {
                this.BuildGraph();
            }
            if (this.ringID == null) {
                this.BuildRingID();
            }
            rings = new ArrayList();
            for (int n = 1; n <= this.NumAtoms(); ++n) {
                if (this.ringID[n - 1] <= 0) continue;
                int[] path = new int[Size];
                path[0] = n;
                this.RecursiveRingFind(path, 1, Size, this.ringID[n - 1], rings);
            }
            if (Size == 5) {
                this.ring5 = rings;
            }
            if (Size == 6) {
                this.ring6 = rings;
            }
            if (Size == 7) {
                this.ring7 = rings;
            }
        }
        int[][] ret = new int[rings.size()][];
        for (int n = 0; n < rings.size(); ++n) {
            ret[n] = (int[])((int[])rings.get(n)).clone();
        }
        return ret;
    }

    public int CompareTo(Molecule Other) {
        int n;
        if (Other == null) {
            return this.NumAtoms() == 0 ? 0 : 1;
        }
        if (this.NumAtoms() < Other.NumAtoms()) {
            return -1;
        }
        if (this.NumAtoms() > Other.NumAtoms()) {
            return 1;
        }
        if (this.NumBonds() < Other.NumBonds()) {
            return -1;
        }
        if (this.NumBonds() > Other.NumBonds()) {
            return 1;
        }
        for (n = 1; n <= this.NumAtoms(); ++n) {
            int c = this.AtomElement(n).compareTo(Other.AtomElement(n));
            if (c != 0) {
                return c;
            }
            if (this.AtomX(n) < Other.AtomX(n)) {
                return -1;
            }
            if (this.AtomX(n) > Other.AtomX(n)) {
                return 1;
            }
            if (this.AtomY(n) < Other.AtomY(n)) {
                return -1;
            }
            if (this.AtomY(n) > Other.AtomY(n)) {
                return 1;
            }
            if (this.AtomCharge(n) < Other.AtomCharge(n)) {
                return -1;
            }
            if (this.AtomCharge(n) > Other.AtomCharge(n)) {
                return 1;
            }
            if (this.AtomUnpaired(n) < Other.AtomUnpaired(n)) {
                return -1;
            }
            if (this.AtomUnpaired(n) > Other.AtomUnpaired(n)) {
                return 1;
            }
            if (this.AtomHExplicit(n) < Other.AtomHExplicit(n)) {
                return -1;
            }
            if (this.AtomHExplicit(n) <= Other.AtomHExplicit(n)) continue;
            return 1;
        }
        for (n = 1; n <= this.NumBonds(); ++n) {
            if (this.BondFrom(n) < Other.BondFrom(n)) {
                return -1;
            }
            if (this.BondFrom(n) > Other.BondFrom(n)) {
                return 1;
            }
            if (this.BondTo(n) < Other.BondTo(n)) {
                return -1;
            }
            if (this.BondTo(n) > Other.BondTo(n)) {
                return 1;
            }
            if (this.BondOrder(n) < Other.BondOrder(n)) {
                return -1;
            }
            if (this.BondOrder(n) > Other.BondOrder(n)) {
                return 1;
            }
            if (this.BondType(n) < Other.BondType(n)) {
                return -1;
            }
            if (this.BondType(n) <= Other.BondType(n)) continue;
            return 1;
        }
        return 0;
    }

    int AtomicNumber(int N) {
        return this.AtomicNumber(this.AtomElement(N));
    }

    int AtomicNumber(String El) {
        for (int n = 1; n < ELEMENTS.length; ++n) {
            if (ELEMENTS[n].compareTo(El) != 0) continue;
            return n;
        }
        return 0;
    }

    public void Append(Molecule Frag) {
        int n;
        int base = this.NumAtoms();
        for (n = 1; n <= Frag.NumAtoms(); ++n) {
            int num = this.AddAtom(Frag.AtomElement(n), Frag.AtomX(n), Frag.AtomY(n), Frag.AtomCharge(n), Frag.AtomUnpaired(n));
            this.SetAtomHExplicit(num, Frag.AtomHExplicit(n));
            this.SetAtomMapNum(num, Frag.AtomMapNum(n));
        }
        for (n = 1; n <= Frag.NumBonds(); ++n) {
            this.AddBond(Frag.BondFrom(n) + base, Frag.BondTo(n) + base, Frag.BondOrder(n), Frag.BondType(n));
        }
    }

    public Molecule Subgraph(boolean[] Mask) {
        int n;
        int[] invidx = new int[this.NumAtoms()];
        int sum = 0;
        for (int n2 = 0; n2 < this.NumAtoms(); ++n2) {
            invidx[n2] = Mask[n2] ? ++sum : 0;
        }
        if (sum == 0) {
            return new Molecule();
        }
        if (sum == this.NumAtoms()) {
            return this.Clone();
        }
        Molecule frag = new Molecule();
        for (n = 1; n <= this.NumAtoms(); ++n) {
            if (!Mask[n - 1]) continue;
            int num = frag.AddAtom(this.AtomElement(n), this.AtomX(n), this.AtomY(n), this.AtomCharge(n), this.AtomUnpaired(n));
            frag.SetAtomHExplicit(num, this.AtomHExplicit(n));
            frag.SetAtomMapNum(num, this.AtomMapNum(n));
        }
        for (n = 1; n <= this.NumBonds(); ++n) {
            int from = invidx[this.BondFrom(n) - 1];
            int to = invidx[this.BondTo(n) - 1];
            if (from <= 0 || to <= 0) continue;
            frag.AddBond(from, to, this.BondOrder(n), this.BondType(n));
        }
        return frag;
    }

    public void Dump() {
        int n;
        System.out.println("#Atoms=" + this.NumAtoms() + " #Bonds=" + this.NumBonds());
        for (n = 0; n < this.NumAtoms(); ++n) {
            Atom a = this.atoms.get(n);
            System.out.println(" A" + (n + 1) + ": " + a.Element + "=" + a.X + "," + a.Y + ";" + a.Charge + "," + a.Unpaired);
        }
        for (n = 0; n < this.NumBonds(); ++n) {
            Bond b = this.bonds.get(n);
            System.out.println(" B" + (n + 1) + ": " + b.From + "-" + b.To + "=" + b.Order + "," + b.Type);
        }
    }

    void TrashGraph() {
        this.graph = null;
        this.ringID = null;
        this.ring5 = null;
        this.ring6 = null;
        this.ring7 = null;
        this.compID = null;
        this.TrashPriority();
    }

    void TrashPriority() {
        this.priority = null;
        this.TrashStereo();
    }

    void TrashStereo() {
        this.chiral = null;
        this.cistrans = null;
    }

    void DetermineMinMax() {
        this.invalMinMax = false;
        if (this.NumAtoms() == 0) {
            this.maxY = 0.0;
            this.minY = 0.0;
            this.maxX = 0.0;
            this.minX = 0.0;
            return;
        }
        this.minX = this.maxX = this.AtomX(1);
        this.minY = this.maxY = this.AtomY(1);
        for (int n = 2; n <= this.NumAtoms(); ++n) {
            double x = this.AtomX(n);
            double y = this.AtomY(n);
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);
            this.minY = Math.min(this.minY, y);
            this.maxY = Math.max(this.maxY, y);
        }
    }

    void BuildGraph() {
        int n;
        this.graph = new int[this.NumAtoms()][];
        for (n = 1; n <= this.NumBonds(); ++n) {
            int i;
            int bt;
            int bf = this.BondFrom(n) - 1;
            if (bf == (bt = this.BondTo(n) - 1)) continue;
            int lf = this.graph[bf] == null ? 0 : this.graph[bf].length;
            int lt = this.graph[bt] == null ? 0 : this.graph[bt].length;
            int[] bl = new int[lf + 1];
            for (i = 0; i < lf; ++i) {
                bl[i] = this.graph[bf][i];
            }
            bl[lf] = bt;
            this.graph[bf] = bl;
            bl = new int[lt + 1];
            for (i = 0; i < lt; ++i) {
                bl[i] = this.graph[bt][i];
            }
            bl[lt] = bf;
            this.graph[bt] = bl;
        }
        for (n = 0; n < this.NumAtoms(); ++n) {
            if (this.graph[n] != null) continue;
            this.graph[n] = new int[0];
        }
    }

    /*
     * Unable to fully structure code
     */
    void BuildConnComp() {
        this.compID = new int[this.NumAtoms()];
        for (n = 0; n < this.NumAtoms(); ++n) {
            this.compID[n] = 0;
        }
        this.compID[0] = comp = 1;
        block1: do lbl-1000:
        // 3 sources

        {
            anything = false;
            for (n = 0; n < this.NumAtoms(); ++n) {
                if (this.compID[n] <= 0) continue;
                for (i = 0; i < this.graph[n].length; ++i) {
                    if (this.compID[this.graph[n][i]] != 0) continue;
                    this.compID[this.graph[n][i]] = comp;
                    anything = true;
                }
            }
            if (anything) ** GOTO lbl-1000
            for (n = 0; n < this.NumAtoms(); ++n) {
                if (this.compID[n] != 0) continue;
                this.compID[n] = ++comp;
                anything = true;
                continue block1;
            }
        } while (anything);
    }

    void BuildPriority() {
        boolean repartitioned;
        int i;
        int n;
        int[][] cipgr = new int[this.NumAtoms()][];
        for (n = 0; n < this.NumAtoms(); ++n) {
            if (cipgr[n] != null) continue;
            cipgr[n] = new int[this.AtomHydrogens(n + 1)];
            for (int i2 = 0; i2 < cipgr[n].length; ++i2) {
                cipgr[n][i2] = -1;
            }
        }
        for (n = 1; n <= this.NumBonds(); ++n) {
            int bf = this.BondFrom(n) - 1;
            int bt = this.BondTo(n) - 1;
            int bo = this.BondOrder(n);
            if (bf == bt || bo == 0) continue;
            int lf = cipgr[bf].length;
            int lt = cipgr[bt].length;
            int[] bl = new int[lf + bo];
            for (i = 0; i < lf; ++i) {
                bl[i] = cipgr[bf][i];
            }
            for (i = 0; i < bo; ++i) {
                bl[lf++] = bt;
            }
            cipgr[bf] = bl;
            bl = new int[lt + bo];
            for (i = 0; i < lt; ++i) {
                bl[i] = cipgr[bt][i];
            }
            for (i = 0; i < bo; ++i) {
                bl[lt++] = bf;
            }
            cipgr[bt] = bl;
        }
        this.priority = new int[this.NumAtoms()];
        boolean anyActualH = false;
        for (int n2 = 0; n2 < this.NumAtoms(); ++n2) {
            this.priority[n2] = this.AtomicNumber(n2 + 1);
            if (this.priority[n2] != 1) continue;
            anyActualH = true;
        }
        int[][] prigr = new int[this.NumAtoms()][];
        do {
            for (int n3 = 0; n3 < this.NumAtoms(); ++n3) {
                prigr[n3] = new int[cipgr[n3].length];
                for (int i3 = 0; i3 < prigr[n3].length; ++i3) {
                    prigr[n3][i3] = cipgr[n3][i3] < 0 ? 1 : this.priority[cipgr[n3][i3]];
                }
                int p = 0;
                while (p < prigr[n3].length - 1) {
                    if (prigr[n3][p] < prigr[n3][p + 1]) {
                        int i4 = prigr[n3][p];
                        prigr[n3][p] = prigr[n3][p + 1];
                        prigr[n3][p + 1] = i4;
                        if (p <= 0) continue;
                        --p;
                        continue;
                    }
                    ++p;
                }
            }
            int[][] groups = Molecule.SortAndGroup(this.priority);
            int nextpri = anyActualH ? 0 : 1;
            repartitioned = false;
            for (int n4 = 0; n4 < groups.length; ++n4) {
                int p = 0;
                while (p < groups[n4].length - 1) {
                    int i1 = groups[n4][p];
                    int i2 = groups[n4][p + 1];
                    int cmp = 0;
                    int sz = Math.max(prigr[i1].length, prigr[i2].length);
                    for (int i5 = 0; i5 < sz; ++i5) {
                        int v2;
                        int v1 = i5 < prigr[i1].length ? prigr[i1][i5] : 0;
                        int n5 = v2 = i5 < prigr[i2].length ? prigr[i2][i5] : 0;
                        if (v1 < v2) {
                            cmp = -1;
                            break;
                        }
                        if (v1 <= v2) continue;
                        cmp = 1;
                        break;
                    }
                    if (cmp > 0) {
                        groups[n4][p] = i2;
                        groups[n4][p + 1] = i1;
                        if (p <= 0) continue;
                        --p;
                        continue;
                    }
                    ++p;
                }
                for (i = 0; i < groups[n4].length; ++i) {
                    if (i != 0) {
                        if (prigr[groups[n4][i]].length != prigr[groups[n4][i - 1]].length) {
                            ++nextpri;
                            repartitioned = true;
                        } else {
                            for (int j = 0; j < prigr[groups[n4][i]].length; ++j) {
                                if (prigr[groups[n4][i]][j] == prigr[groups[n4][i - 1]][j]) continue;
                                ++nextpri;
                                repartitioned = true;
                                break;
                            }
                        }
                    }
                    this.priority[groups[n4][i]] = ++nextpri;
                }
            }
        } while (repartitioned);
    }

    void BuildChirality() {
        int n;
        this.chiral = new int[this.NumAtoms()];
        boolean[] haswedge = new boolean[this.NumAtoms()];
        for (n = 0; n < this.NumAtoms(); ++n) {
            haswedge[n] = false;
        }
        for (n = 1; n <= this.NumBonds(); ++n) {
            if (this.BondType(n) != 1 && this.BondType(n) != 2) continue;
            haswedge[this.BondFrom((int)n) - 1] = true;
        }
        int[] pri = new int[4];
        double[] x = new double[4];
        double[] y = new double[4];
        double[] z = new double[4];
        for (int n2 = 0; n2 < this.NumAtoms(); ++n2) {
            this.chiral[n2] = 0;
            if (this.graph[n2].length != 4 && (this.graph[n2].length != 3 || this.AtomHydrogens(n2 + 1) != 1)) continue;
            block3: for (int i = 0; i < this.graph[n2].length; ++i) {
                pri[i] = this.priority[this.graph[n2][i]];
                x[i] = this.AtomX(this.graph[n2][i] + 1) - this.AtomX(n2 + 1);
                y[i] = this.AtomY(this.graph[n2][i] + 1) - this.AtomY(n2 + 1);
                z[i] = 0.0;
                if (!haswedge[n2]) continue;
                for (int j = 1; j <= this.NumBonds(); ++j) {
                    if (this.BondFrom(j) != n2 + 1 || this.BondTo(j) != this.graph[n2][i] + 1) continue;
                    if (this.BondType(j) == 1) {
                        z[i] = 1.0;
                    }
                    if (this.BondType(j) != 2) continue block3;
                    z[i] = -1.0;
                    continue block3;
                }
            }
            if (this.graph[n2].length == 3) {
                pri[3] = 0;
                x[3] = 0.0;
                y[3] = 0.0;
                z[3] = 0.0;
            }
            int p = 0;
            while (p < 3) {
                if (pri[p] > pri[p + 1]) {
                    int i = pri[p];
                    pri[p] = pri[p + 1];
                    pri[p + 1] = i;
                    double d = x[p];
                    x[p] = x[p + 1];
                    x[p + 1] = d;
                    d = y[p];
                    y[p] = y[p + 1];
                    y[p + 1] = d;
                    d = z[p];
                    z[p] = z[p + 1];
                    z[p + 1] = d;
                    if (p <= 0) continue;
                    --p;
                    continue;
                }
                ++p;
            }
            if (pri[0] == 0 && pri[1] == 1 || pri[0] == pri[1] || pri[1] == pri[2] || pri[2] == pri[3]) continue;
            this.chiral[n2] = 3;
            if (z[0] == 0.0 && z[1] == 0.0 && z[2] == 0.0 && z[3] == 0.0) continue;
            boolean sane = true;
            for (int i = 0; i < 4; ++i) {
                if (pri[0] == 0) continue;
                double r = x[i] * x[i] + y[i] * y[i] + z[i] * z[i];
                if (r < 1.0E-4) {
                    sane = false;
                    break;
                }
                r = 1.0 / Math.sqrt(r);
                x[i] = x[i] * r;
                y[i] = y[i] * r;
                z[i] = z[i] * r;
            }
            if (!sane) continue;
            if (pri[0] == 0) {
                x[0] = -(x[1] + x[2] + x[3]);
                y[0] = -(y[1] + y[2] + y[3]);
                z[0] = -(z[1] + z[2] + z[3]);
                double r = x[0] * x[0] + y[0] * y[0] + z[0] * z[0];
                if (r < 1.0E-4) {
                    sane = false;
                    break;
                }
                r = 1.0 / Math.sqrt(r);
                x[0] = x[0] * r;
                y[0] = y[0] * r;
                z[0] = z[0] * r;
            }
            if (!sane) continue;
            double R = 0.0;
            double S = 0.0;
            for (int i = 1; i <= 6; ++i) {
                int a = 0;
                int b = 0;
                if (i == 1) {
                    a = 1;
                    b = 2;
                } else if (i == 2) {
                    a = 2;
                    b = 3;
                } else if (i == 3) {
                    a = 3;
                    b = 1;
                } else if (i == 4) {
                    a = 2;
                    b = 1;
                } else if (i == 5) {
                    a = 3;
                    b = 2;
                } else if (i == 6) {
                    a = 1;
                    b = 3;
                }
                double xx = y[a] * z[b] - y[b] * z[a] - x[0];
                double yy = z[a] * x[b] - z[b] * x[a] - y[0];
                double zz = x[a] * y[b] - x[b] * y[a] - z[0];
                if (i <= 3) {
                    R += xx * xx + yy * yy + zz * zz;
                    continue;
                }
                S += xx * xx + yy * yy + zz * zz;
            }
            this.chiral[n2] = R > S ? 1 : 2;
        }
    }

    void BuildCisTrans() {
        this.cistrans = new int[this.NumBonds()];
        int[] sf = new int[2];
        int[] st = new int[2];
        for (int n = 0; n < this.NumBonds(); ++n) {
            int i;
            this.cistrans[n] = 0;
            int bf = this.BondFrom(n + 1) - 1;
            int bt = this.BondTo(n + 1) - 1;
            if (this.BondOrder(n + 1) != 2 || this.graph[bf].length <= 1 || this.graph[bt].length <= 1 || this.graph[bf].length > 3 || this.graph[bt].length > 3) continue;
            int nf = 0;
            int nt = 0;
            for (i = 0; i < this.graph[bf].length; ++i) {
                if (this.graph[bf][i] == bt) continue;
                sf[nf++] = this.graph[bf][i];
            }
            for (i = 0; i < this.graph[bt].length; ++i) {
                if (this.graph[bt][i] == bf) continue;
                st[nt++] = this.graph[bt][i];
            }
            if (nf == 1) {
                if (this.AtomHydrogens(bf + 1) != 1 || this.priority[sf[0]] == 1) {
                    continue;
                }
            } else {
                if (this.priority[sf[0]] == this.priority[sf[1]]) continue;
                if (this.priority[sf[0]] < this.priority[sf[1]]) {
                    i = sf[0];
                    sf[0] = sf[1];
                    sf[1] = i;
                }
            }
            if (nt == 1) {
                if (this.AtomHydrogens(bt + 1) != 1 || this.priority[st[0]] == 1) {
                    continue;
                }
            } else {
                if (this.priority[st[0]] == this.priority[st[1]]) continue;
                if (this.priority[st[0]] < this.priority[st[1]]) {
                    i = st[0];
                    st[0] = st[1];
                    st[1] = i;
                }
            }
            this.cistrans[n] = 3;
            double xa = this.AtomX(bf + 1);
            double ya = this.AtomY(bf + 1);
            double xb = this.AtomX(bt + 1);
            double yb = this.AtomY(bt + 1);
            double tha0 = Math.atan2(yb - ya, xb - xa);
            double thb0 = Math.PI + tha0;
            double tha1 = Math.atan2(this.AtomY(sf[0] + 1) - ya, this.AtomX(sf[0] + 1) - xa);
            double tha2 = nf == 2 ? Math.atan2(this.AtomY(sf[1] + 1) - ya, this.AtomX(sf[1] + 1) - xa) : this.ThetaObtuse(tha0, tha1);
            double thb1 = Math.atan2(this.AtomY(st[0] + 1) - yb, this.AtomX(st[0] + 1) - xb);
            double thb2 = nt == 2 ? Math.atan2(this.AtomY(st[1] + 1) - yb, this.AtomX(st[1] + 1) - xb) : this.ThetaObtuse(thb0, thb1);
            tha2 -= tha0;
            thb1 -= thb0;
            thb2 -= thb0;
            tha1 += ((tha1 -= tha0) < -Math.PI ? Math.PI * 2 : 0.0) + (tha1 > Math.PI ? Math.PI * -2 : 0.0);
            tha2 += (tha2 < -Math.PI ? Math.PI * 2 : 0.0) + (tha2 > Math.PI ? Math.PI * -2 : 0.0);
            thb1 += (thb1 < -Math.PI ? Math.PI * 2 : 0.0) + (thb1 > Math.PI ? Math.PI * -2 : 0.0);
            thb2 += (thb2 < -Math.PI ? Math.PI * 2 : 0.0) + (thb2 > Math.PI ? Math.PI * -2 : 0.0);
            double SMALL = 0.08726646259971647;
            if (Math.abs(tha1) < 0.08726646259971647 || Math.abs(tha2) < 0.08726646259971647 || Math.abs(thb1) < 0.08726646259971647 || Math.abs(thb2) < 0.08726646259971647 || Math.abs(tha1) > 3.0543261909900767 || Math.abs(tha2) > 3.0543261909900767 || Math.abs(thb1) > 3.0543261909900767 || Math.abs(thb2) > 3.0543261909900767) continue;
            tha1 = Math.signum(tha1);
            tha2 = Math.signum(tha2);
            thb1 = Math.signum(thb1);
            thb2 = Math.signum(thb2);
            if (tha1 == tha2 || thb1 == thb2) continue;
            if (tha1 * thb1 < 0.0) {
                this.cistrans[n] = 1;
            }
            if (!(tha1 * thb1 > 0.0)) continue;
            this.cistrans[n] = 2;
        }
    }

    public static int[][] SortAndGroup(int[] Val) {
        ArrayList<Integer> unique = new ArrayList<Integer>();
        for (int n = 0; n < Val.length; ++n) {
            unique.add(Val[n]);
        }
        Collections.sort(unique);
        int p = 0;
        while (p < unique.size() - 1) {
            if (unique.get(p) == unique.get(p + 1)) {
                unique.remove(p);
                continue;
            }
            ++p;
        }
        int[][] ret = new int[unique.size()][];
        int n = 0;
        while (n < Val.length) {
            int grp = unique.indexOf(Val[n]);
            int[] cnt = new int[ret[grp] == null ? 1 : ret[grp].length + 1];
            for (int i = 0; i < cnt.length - 1; ++i) {
                cnt[i] = ret[grp][i];
            }
            cnt[cnt.length - 1] = n++;
            ret[grp] = cnt;
        }
        return ret;
    }

    void BuildRingID() {
        int i;
        this.ringID = new int[this.NumAtoms()];
        if (this.NumAtoms() == 0) {
            return;
        }
        boolean[] visited = new boolean[this.NumAtoms()];
        for (int n = 0; n < this.NumAtoms(); ++n) {
            this.ringID[n] = 0;
            visited[n] = false;
        }
        int[] path = new int[this.NumAtoms() + 1];
        int plen = 0;
        int numVisited = 0;
        boolean rewound = false;
        do {
            int current;
            int last;
            if (plen == 0) {
                last = -1;
                current = 0;
                while (visited[current]) {
                    ++current;
                }
            } else {
                last = path[plen - 1];
                current = -1;
                for (int n = 0; n < this.graph[last].length; ++n) {
                    if (visited[this.graph[last][n]]) continue;
                    current = this.graph[last][n];
                    break;
                }
            }
            if (current >= 0 && plen >= 2) {
                int back = path[plen - 1];
                for (int n = 0; n < this.graph[current].length; ++n) {
                    int join = this.graph[current][n];
                    if (join == back || !visited[join]) continue;
                    path[plen] = current;
                    for (int i2 = plen; i2 == plen || path[i2 + 1] != join; --i2) {
                        int id = this.ringID[path[i2]];
                        if (id == 0) {
                            this.ringID[path[i2]] = last;
                            continue;
                        }
                        if (id == last) continue;
                        for (int j = 0; j < this.NumAtoms(); ++j) {
                            if (this.ringID[j] != id) continue;
                            this.ringID[j] = last;
                        }
                    }
                }
            }
            if (current >= 0) {
                visited[current] = true;
                path[plen++] = current;
                ++numVisited;
                rewound = false;
                continue;
            }
            --plen;
            rewound = true;
        } while (numVisited != this.NumAtoms());
        int nextID = 0;
        for (i = 0; i < this.NumAtoms(); ++i) {
            if (this.ringID[i] <= 0) continue;
            --nextID;
            for (int j = this.NumAtoms() - 1; j >= i; --j) {
                if (this.ringID[j] != this.ringID[i]) continue;
                this.ringID[j] = nextID;
            }
        }
        for (i = 0; i < this.NumAtoms(); ++i) {
            this.ringID[i] = -this.ringID[i];
        }
    }

    void RecursiveRingFind(int[] Path2, int PSize, int Capacity, int RBlk, ArrayList<Object> Rings) {
        boolean flip;
        if (PSize < Capacity) {
            int last = Path2[PSize - 1];
            for (int n = 0; n < this.graph[last - 1].length; ++n) {
                int adj = this.graph[last - 1][n] + 1;
                if (this.ringID[adj - 1] != RBlk) continue;
                boolean fnd = false;
                for (int i = 0; i < PSize; ++i) {
                    if (Path2[i] != adj) continue;
                    fnd = true;
                    break;
                }
                if (fnd) continue;
                int[] newPath = (int[])Path2.clone();
                newPath[PSize] = adj;
                this.RecursiveRingFind(newPath, PSize + 1, Capacity, RBlk, Rings);
            }
            return;
        }
        int last = Path2[PSize - 1];
        boolean fnd = false;
        for (int n = 0; n < this.graph[last - 1].length; ++n) {
            if (this.graph[last - 1][n] + 1 != Path2[0]) continue;
            fnd = true;
            break;
        }
        if (!fnd) {
            return;
        }
        int first = 0;
        for (int n = 1; n < PSize; ++n) {
            if (Path2[n] >= Path2[first]) continue;
            first = n;
        }
        int fm = (first - 1 + PSize) % PSize;
        int fp = (first + 1) % PSize;
        boolean bl = flip = Path2[fm] < Path2[fp];
        if (first != 0 || flip) {
            int[] newPath = new int[PSize];
            for (int n = 0; n < PSize; ++n) {
                newPath[n] = Path2[(first + (flip ? PSize - n : n)) % PSize];
            }
            Path2 = newPath;
        }
        for (int n = 0; n < Rings.size(); ++n) {
            int[] look = (int[])Rings.get(n);
            boolean same = true;
            for (int i = 0; i < PSize; ++i) {
                if (look[i] == Path2[i]) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return;
        }
        Rings.add(Path2);
    }

    double ThetaObtuse(double Th1, double Th2) {
        double dth;
        for (dth = Th2 - Th1; dth < -Math.PI; dth += Math.PI * 2) {
        }
        while (dth > Math.PI) {
            dth -= Math.PI * 2;
        }
        return dth > 0.0 ? Th1 - 0.5 * (Math.PI * 2 - dth) : Th1 + 0.5 * (Math.PI * 2 + dth);
    }

    public void RotateMolecule(double Degrees) {
        Degrees = MainApplet.rotation;
        System.out.println("rotating..." + Degrees + " degrees");
        double radians = Degrees * Math.PI / 180.0;
        System.out.println("num atoms= " + this.NumAtoms());
        for (int n = 1; n <= this.NumAtoms(); ++n) {
            double dx = this.AtomX(n);
            double dy = this.AtomY(n);
            double dist = Math.sqrt(dx * dx + dy * dy);
            double theta = Math.atan2(dy, dx);
            try {
                this.SetAtomPos(n, dist * Math.cos(theta + radians), dist * Math.sin(theta + radians));
                continue;
            }
            catch (Exception e) {
                System.out.println("problem with rotation " + e);
            }
        }
    }

    class Bond {
        int From;
        int To;
        int Order;
        int Type;

        Bond() {
        }
    }

    class Atom {
        String Element;
        double X;
        double Y;
        int Charge;
        int Unpaired;
        int HExplicit;
        int MapNum;

        Atom() {
        }
    }
}

