#!/bin/sh
# set -x
VER=`sh ../../batch/getversion.sh`
VERSION=white_dune-$VER
VERSION_DEBIAN=`awk -v ver=$VERSION 'BEGIN {gsub("_","",ver);print ver}'`
VERSION_ORIG=$VERSION_DEBIAN.orig

rm -rf /tmp/$VERSION_DEBIAN /tmp/$VERSION_ORIG

(cd ../../.. && cp -r $VERSION /tmp/$VERSION_DEBIAN) &&
(cd ../../.. && cp -r $VERSION /tmp/$VERSION_ORIG) &&
(cd .. && tar -cf - debian) | (cd /tmp/$VERSION_DEBIAN && tar -xf -)

chmod a+x /tmp/$VERSION_DEBIAN/debian/rules

cat << EOT > /tmp/$VERSION_DEBIAN/debian/changelog
whitedune ($VER-1) experimental; urgency=low

  * Version $VER debian package
    For details see the README file of the source package

EOT

DATE=`date -R`
echo ' -- J. "MUFTI" Scheurich <mufti@csv.ica.uni-stuttgart.de>  '$DATE >> /tmp/$VERSION_DEBIAN/debian/changelog

cat changelog >> /tmp/$VERSION_DEBIAN/debian/changelog

rm /tmp/$VERSION_DEBIAN/debian/mkdeb.sh

cp Makefile /tmp/$VERSION_DEBIAN/Makefile

#dpkg-buildpackage -us -uc -sa -rfakeroot
# us = unsigned uc= unsigned changes
(cd /tmp/$VERSION_DEBIAN && dpkg-buildpackage -us -uc -rfakeroot) &&
cp /tmp/$VERSION_DEBIAN/debian/changelog .
echo use\"dpkg -i `echo /tmp/$VERSION_DEBIAN*.deb`\" to install
