/*
 * selftest.cpp
 *
 * Copyright (C) 1999 Stephen F. White, 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "swt.h"

#include "DuneApp.h"
#include "MainWindow.h"
#include "MoveCommand.h"
#include "xerrorhandler.h"
#include "Field.h"
#include "Types.h"

#define errorprintf fprintf   

void printFirstPart()
{
    printf("#include <stdio.h>\n");
    printf("#include \"stdafx.h\"\n");
    printf("\n");
    printf("#include \"swt.h\"\n");
    printf("\n");
    printf("#include \"DuneApp.h\"\n");
    printf("#include \"MainWindow.h\"\n");
    printf("#include \"MoveCommand.h\"\n");
    printf("#include \"xerrorhandler.h\"\n");
    printf("#include \"Field.h\"\n");
    printf("#include \"AllNodes.h\"\n");
    printf("\n");
    printf("#define errorprintf fprintf   \n");
    printf("\n");
    printf("int main(int argc, char *argv[])\n");
    printf("{\n");
    printf("    TheApp = new DuneApp();\n");
    printf("    Scene* scene = new Scene();\n");
}

void printLastPart()
{
    printf("    scene->write(STDOUT_FILENO,\"\",true);\n");
    printf("    delete TheApp;\n");
    printf("    return 0;\n");
    printf("}\n");
}


int main(int argc, char *argv[])
{
    TheApp = new DuneApp();
    int i;
    bool fileflag=false;
    Scene* scene = new Scene();
    for (i=1;i<argc;i++) {
        fileflag=true;
        if (!TheApp->ImportFile(argv[i], scene)) {
            delete scene;
            perror(argv[i]);
            return(1);
        }
    }
    if (fileflag == false) {
       StringArray *names = scene->getAllNodeNames();
       printFirstPart();
       for (i=0; i < names->size(); i++) {
           Node* node = scene->createNode(names->get(i)); 
           const char *str = names->get(i);
           // skip comment node
           if (strcmp(str,"#") == 0)
               continue;
           printf("    Node%s* node%s = (Node%s*)scene->createNode(\"%s\"); \n",
                  str,str,str,str);
           for (int j = 0; j < node->getProto()->getNumFields(); j++) {
               Field *field = node->getProto()->getField(j);
               printf("    node%s->%s(new %s());\n", str,
                        (const char *)field->getName(),
                        typeEnumToString(field->getType()));
           }
           printf("    scene->execute(new MoveCommand(node%s, NULL, -1, scene->getRoot(), \n",
                  str);
           printf("                                   scene->getRootIndex()));\n");
       }
       printLastPart();
    }
    delete TheApp;
    return 0;
}

