/*
 * FieldViewItem.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include "stdafx.h"

#include "FieldViewItem.h"
#include "swt.h"

#include "EulerAngles.h"
#include "Field.h"
#include "FieldView.h"
#include "FieldValue.h"
#include "FieldCommand.h"
#include "Node.h"
#include "Path.h"
#include "Proto.h"
#include "SFMFTypes.h"
#include "SFMFTypesItem.h"
#include "Scene.h"
#include "URL.h"
#include "DuneApp.h"

FieldViewItem::FieldViewItem(FieldView *view)
{
    _view = view;
    _value = NULL;
    _parent = NULL;
    _state = FVIS_COLLAPSED;
    _field = NULL;
    _index = -1;
}

FieldViewItem::~FieldViewItem()
{
    if (_value) _value->unref();
}

void
FieldViewItem::SetValue(FieldValue *value)
{
    if (value == NULL) 
        return;
    _value = value;
    _value->ref();
    UpdateControl();
}

FieldViewItem *
FieldViewItem::CreateItem(const Field *field, FieldView *view)
{
    FieldViewItem	*r;

    switch(field->getType()) {
      case SFBOOL:
	r = new SFBoolItem(view); break;
      case SFCOLOR:
	r = new SFColorItem(view); break;
      case SFINT32:
	r = new SFInt32Item(view); break;
      case SFFLOAT:
	r = new SFFloatItem(view); break;
      case SFNODE:
	r = new SFNodeItem(view); break;
      case SFROTATION:
	r = new SFRotationItem(view); break;
      case SFSTRING:
	r = new SFStringItem(view); break;
      case SFTIME:
	r = new SFTimeItem(view); break;
      case SFVEC2F:
	r = new SFVec2fItem(view); break;
      case SFVEC3F:
	r = new SFVec3fItem(view); break;
      case MFCOLOR:
	r = new MFColorItem(view); break;
      case MFFLOAT:
	r = new MFFloatItem(view); break;
      case MFINT32:
	r = new MFInt32Item(view); break;
      case MFNODE:
	r = new MFNodeItem(view); break;
      case MFROTATION:
	r = new MFRotationItem(view); break;
      case MFSTRING:
	r = new MFStringItem(view); break;
      case MFTIME:
	r = new MFTimeItem(view); break;
      case MFVEC2F:
	r = new MFVec2fItem(view); break;
      case MFVEC3F:
	r = new MFVec3fItem(view); break;
      default:
	r = new FieldViewItem(view); break;
    }
    r->SetField(field);
    return r;
}

void 
FieldViewItem::DrawFloats(const float *floats, int len, const char *labels, 
                          SDC dc, int x, int y, int width)
{
    for (int i = 0; i < len; i++) {
	char		buf[30];
	sprintf(buf, "%c: %5.2f", labels[i], floats[i]);
	swDrawText(dc, x + i * width, y, buf);
    }
}

MFieldViewItem::MFieldViewItem(FieldView *view) : FieldViewItem(view)
{
}

void
MFieldViewItem::InitIndexValue(int index, FieldValue *value)
{
    MFieldValue *v = (MFieldValue *) value;
    _children[index] = CreateSFItem();
    _children[index]->SetParent(this);
    _children[index]->SetField(_field);
    _children[index]->SetIndex(index);
    _children[index]->SetValue(v->getSFValue(index));
}

void
MFieldViewItem::SetValue(FieldValue *value)
{
    MFieldValue *v = (MFieldValue *) value;
    int		i;
    int		n = _children.size();

//    for (i = 0; i < n; i++) {
//	delete _children[i];
//    }

    _children.resize(v->getSFSize());

    for (i = 0; i < v->getSFSize(); i++)
        InitIndexValue(i, value);

    FieldViewItem::SetValue(value);
}

MFieldViewItem::~MFieldViewItem()
{
    int		n = _children.size();
    for (int i = 0; i < n; i++) {
	delete _children[i];
    }
}

