/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_NETWORK_H
#define _WF_NETWORK_H

#include <string>

#include "wfhost_base.h"
#include "wfipaddr.h"

/**
 * network: defined by 2 elements: network address and netmask.
 */
class wf_network : public wf_host_base {
 public:
  wf_network();
  wf_network(const string& str);
  wf_network(const string& str, int bitmask);
  wf_network(const wf_ipaddr& ipaddr, int bitmask);
  virtual ~wf_network() {}
  // wf_network(const wf_network& networkold) {} implicit copy constructor
  virtual wf_host_base* VClone() const;

  bool set(const string& str, int bitmask);
  bool set(const wf_ipaddr& ipaddr, int bitmask);

  bool network_set(const char* str); // remove ALL@@5
  bool network_set(const string& str);

  bool netmask_set(const char* str); // remove ALL@@5
  bool netmask_set(const string& str);
  bool netmask_set(int bitmask);

  bool setnull();

  int netmask_tobitmask() const;
  bool netmask_check() const;
  bool isnull() const;
  bool ishost() const;
  bool belong(const wf_ipaddr& ipaddr) const;
  wf_ipaddr broadcast() const;

  bool isdefined() const;

  string tostr() const;
  string tostr_value() const;

  virtual enum metahost_elem_type gettype() const { return WF_METAHOST_NETWORK; }
  virtual ostream& print(ostream& os) const;
  ostream& print_value(ostream& os) const;
  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const;
  ostream& debugprint(ostream& os) const;

  friend ostream& operator<<(ostream& os, const wf_network& network);
  friend bool operator==(const wf_network& network1,
			 const wf_network& network2);

 public:
  string name;
  string comment;
  wf_ipaddr network;
  wf_ipaddr netmask;
};

int wf_netmask_tobitmask(int netmask);
bool wf_bitmask_check(int bitmask);
bool wf_bitmask_tonetmask(int bitmask, int& netmask);
bool wf_network_tonetmask(int network, int* netmask);

inline wf_host_base*
wf_network::VClone() const {
  return new wf_network(*this);
}

#endif
