/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_IFACE_H
#define _WF_IFACE_H

#include <iostream>
#include <string>
#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#include <sys/types.h>
#include <sys/socket.h>
#include <ifaddrs.h> /* for struct ifaddrs */
#else
#include <net/if.h> /* for struct ifreq */
#endif
#include <inttypes.h>

#include "wfipaddr.h"
#include "wfnetwork.h"
#include "wfmacaddr.h"

enum wf_ip_statdyn {
  WF_IP_STATDYN_UNKNOWN, WF_IP_STATIC, WF_IP_DYNAMIC
};

enum wf_ip_guess {
  WF_IP_GUESS_UNKNOWN, /* let output module choose what is best */
  WF_IP_GUESS_NONE, /* do not guess IP address */
  WF_IP_GUESS_COMPILETIME, /* guess IP address at compile time (wfconvert) */
  WF_IP_GUESS_RUNTIME /* guess IP address at runtime (if supported by
			 firewalling tool) */
};

/**
 * iface: interface defined by an IP address, and an associated network.
 */
class wf_iface {
 public:
  wf_iface();
  virtual ~wf_iface();
  // wf_iface(const wf_iface& iface);

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
  bool guess(struct ifaddrs* ifa, bool skip_useless = false);
#else
  bool guess(struct ifreq* ifr, int sock, bool skip_useless = false);
#endif
  bool guess(const string& name, bool skip_useless = false);

  wf_ipaddr broadcast_get() const ;
  bool complete(bool guess = 0);

  bool check() const;

  ostream& debugprint(ostream& os) const;

  friend bool operator==(const wf_iface& iface1, const wf_iface& iface2);

 public:
  string name;
  string comment;
  wf_macaddr macaddr;
  wf_ipaddr ipaddr;
  wf_network network;
  wf_ipaddr broadcast;
  uint16_t flags;
  enum wf_ip_statdyn statdyn;
  enum wf_ip_guess ipguess;
};

#endif
