/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include "wfmetaport.h"
#include "wfindent.h"
#include "defs.h"


wf_metaport_elem::wf_metaport_elem() :
  port_base(NULL)
{}

wf_metaport_elem::~wf_metaport_elem() {
  if (port_base != NULL)
    delete port_base;
}

wf_metaport_elem::wf_metaport_elem(const wf_metaport_elem& metaport_elem) {
  port_base = metaport_elem.port_base->VClone();
}

wf_metaport_elem&
wf_metaport_elem::operator=(const wf_metaport_elem& metaport_elem) {
  if (this != &metaport_elem)
    port_base = metaport_elem.port_base->VClone();
  return *this;
}

wf_metaport_elem::wf_metaport_elem(const wf_metaport& metaport) {
  set(metaport);
}

wf_metaport_elem::wf_metaport_elem(const wf_port& port) {
  set(port);
}

wf_metaport_elem::wf_metaport_elem(const wf_port_range& port_range) {
  set(port_range);
}

bool
wf_metaport_elem::set(const wf_metaport& metaport) {
  port_base = new wf_metaport(metaport);
  return true;
}

bool
wf_metaport_elem::set(const wf_port& port) {
  port_base = new wf_port(port);
  return true;
}

bool
wf_metaport_elem::set(const wf_port_range& port_range) {
  port_base = new wf_port_range(port_range);
  return true;
}

ostream&
wf_metaport_elem::print(ostream& os) const {
  if (port_base != NULL)
    os << port_base;
  else
    os << "(NULL)"; // RV@@6
  return os;
}

ostream&
wf_metaport_elem::output_xml(ostream& os, unsigned int indent_level) const {
  if (port_base != NULL)
    port_base->output_xml(os, indent_level);
  return os;
}

ostream&
wf_metaport_elem::debugprint(ostream& os) const {
  return os << _("Metaport elem:\t") << *this << endl;
}


ostream&
operator<<(ostream& os, const wf_metaport_elem& elem) {
  return elem.print(os);
}

bool
operator==(const wf_metaport_elem& elem1, const wf_metaport_elem& elem2) {
  return elem1.port_base == elem2.port_base;
}
