/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_IPADDR_H
#define _WF_IPADDR_H

#include <iostream>
#include <string>
#include <inttypes.h>

#include "wfhost_base.h"

/**
 * ipaddr: IP address class.
 */
class wf_ipaddr : public wf_host_base {
 public:
  wf_ipaddr();
  wf_ipaddr(uint32_t address); /* in network byte order */
  wf_ipaddr(const string& str);
  virtual ~wf_ipaddr() {}
  // wf_ipaddr(const wf_ipaddr&) {} implicit copy constructor
  virtual wf_host_base* VClone() const;

  bool set(uint32_t address); /* in network byte order */
  bool set(const string& address);
  uint32_t get() const; /* in network byte order */

  bool isdefined() const;

  string tostr() const;
  bool isnull() const;
  bool isloopback() const;
  bool isroutable() const;
  
  bool dnsname(string& name) const;

  virtual enum metahost_elem_type gettype() const { return WF_METAHOST_IPADDR; }
  virtual ostream& print(ostream& os) const;
  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const;
  ostream& debugprint(ostream& os) const;

  friend ostream& operator<<(ostream& os, const wf_ipaddr& ipaddr);
  friend bool operator==(const wf_ipaddr& ipaddr1, const wf_ipaddr& ipaddr2);
  friend bool operator!=(const wf_ipaddr& ipaddr1, const wf_ipaddr& ipaddr2);
  friend bool operator<(const wf_ipaddr& ipaddr1, const wf_ipaddr& ipaddr2);
  friend bool operator>(const wf_ipaddr& ipaddr1, const wf_ipaddr& ipaddr2);

  static bool check(const string& str);
 private: 
  static bool check(const char* str); // remove this function ALL@@4

 private:
  int _addr;  /* in network byte order */
  bool _defined;
};

inline wf_host_base*
wf_ipaddr::VClone() const {
  return new wf_ipaddr(*this);
}

#endif
