/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_SORT_H
#define _WF_SORT_H

#include <string>
#include <iostream>
#include <list>
#include <algorithm> /* for sort() */


inline int
cmp_integer(int a, int b) {
  if (a < b)
    return -1;
  if (a > b)
    return 1;
  return 0;
}

inline int
cmp_string(const string& a, const string& b) {
  return a.compare(b);
}

struct wf_sort_availspecs {
  const string spec; /* criteria name */
  /* three-way lexicographical comparison function */
  int (* const cmpfunc)(const void* P, const void* Q);
};


/**
 * 
 */
class wf_sort_criteria {
 public:
  wf_sort_criteria(int (*cmpfunc)(const void* a, const void* b),
	 bool reverse = false);
  virtual ~wf_sort_criteria() {}
  // wf_sort_criteria(const wf_sort_criteria&) {} default copy constructor RV@@9

  friend class wf_sort;

 private:
  /* three-way lexicographical comparison function */
  int (*_cmpfunc)(const void* a, const void* b);
  bool _reverse;
};

/**
 * 
 */
class wf_sort {
 public:
  wf_sort();
  virtual ~wf_sort() {}
  // wf_sort(const wf_sort&) {} default copy constructor


  bool available_set(const struct wf_sort_availspecs available[], int count);
  ostream& available_print(ostream& os) const;

  void criteria_add(const wf_sort_criteria& criteria);
  bool criteria_add(const char* spec);
  const char* parse(const char* sort_arg);
  void criterias_clear();

  bool operator()(const void* a, const void* b) const;

 private:
  list<wf_sort_criteria> criterias;
  const struct wf_sort_availspecs* _available;
  int _available_count;
};

#endif
