#
# utils.rb -- Miscellaneous utilities
#
# Author: IPR -- Internet Programming with Ruby -- writers
# Copyright (C) 2001 TAKAHASHI Masayoshi, GOTOU Yuuzou
#
# $IPR: utils.rb,v 1.2 2002/02/05 20:20:32 gotoyuzo Exp $

require 'socket'
begin
  require 'etc'
rescue LoadError
end

module WEBrick
  module Utils

    def su(user, group=nil)
      if defined?(Etc)
        pw = Etc.getpwnam(user)
        gr = group ? Etc.getgrnam(group) : pw
        Process::gid = gr.gid
        Process::egid = gr.gid
        Process::uid = pw.uid
        Process::euid = pw.uid
      end 
    end   
    module_function :su

    def getservername
      host = Socket::gethostname
      begin
        ai = Socket::getaddrinfo(host, nil,
               Socket::AF_UNSPEC, Socket::SOCK_STREAM)
        ret = ai[0][2]
      rescue
        ret = host
      end
      ret
    end
    module_function :getservername

  end
end
