#!/usr/local/bin/perl

local $format;
local $out;

require "./time-lib.pl";
require 'timelocal.pl';

&ReadParse();

$in{ 'year' } = substr( $in{ 'year' }, 2, length( $in{ 'year' } ) );

if (!$in{'action'}) {
	# user probably hit return in the time server field
	$in{'action'} = $text{ 'action_timeserver_sys' };
	}

if( $in{ 'action' } eq $text{ 'action_apply' } )
{
  &error( $text{ 'acl_nosys' } ) if( $access{ 'sysdate' } );
  $in{ 'date' } = "0". $in{ 'date' } if( $in{ 'date' } <= 9 );
  if ($config{'seconds'} == 2) {
	$format = $in{'year'}.$in{'month'}.$in{'date'}.$in{'hour'}.$in{'minute'}.".".$in{'second'};
	}
  elsif ($config{'seconds'} == 1) {
	  $format = $in{ 'month' }. $in{ 'date' }. $in{ 'hour' }. $in{ 'minute' }. $in{ 'year' }. ".". $in{ 'second' };
	  }
  else {
	  $format = $in{ 'month' }. $in{ 'date' }. $in{ 'hour' }. $in{ 'minute' }. substr($in{ 'year' }, -2);
	}
  &backquote_logged("echo yes | date $format");
  &webmin_log("set", "date", time(), \%in);

} elsif ( $in{ 'action' } eq $text{ 'action_save' } ) {
  &error( $text{ 'acl_nohw' } ) if( $access{ 'hwdate' } );
  $format = "--set --date=\"". $in{ 'month' }. "/". $in{ 'date' }. "/". $in{ 'year' }. " ". $in{ 'hour' }. ":". $in{ 'minute' }. ":". $in{ 'second' }. "\"";
  $out = &backquote_logged("hwclock $format");
  &error( &text( 'error_hw', $out ) ) if( $out ne "" );
  local $hwtime = timelocal($in{'second'}, $in{'minute'}, $in{'hour'},
			    $in{'date'}, $in{'month'}-1, $in{'year'} < 200 ?
			    $in{'year'} : $in{'year'}-1900);
  &webmin_log("set", "hwclock", $hwtime, \%in);

} elsif( $in{ 'action' } eq $text{ 'action_sync' } ) {
  &error( $text{ 'acl_nosys' } ) if( $access{ 'sysdate' } );
  $out = &backquote_logged("hwclock --hctosys");
  &error( &text( 'error_sync', $out ) ) if( $out ne "" );
  &webmin_log("sync");

} elsif( $in{ 'action' } eq $text{ 'action_sync_s' } ) {
  &error( $text{ 'acl_nohw' } ) if( $access{ 'hwdate' } );
  $out = &backquote_logged("hwclock --systohc");
  &error( &text( 'error_sync', $out ) ) if( $out ne "" );
  &webmin_log("sync_s");

} elsif( $in{ 'action' } eq $text{ 'action_timeserver_sys' } ||
	 $in{ 'action' } eq "$text{ 'action_timeserver_sys' } / $text{ 'action_timeserver_hw' }" ) {
#
#	First try ntp. If ntp fails use timeserver on port 37
#
  $out = &backquote_logged("ntpdate -u  $in{ 'timeserver' } > /dev/null 2>&1");
  if ($?) {
#	error using ntp. use timeservice
  	&open_socket( $in{ 'timeserver' }, 37, SOCK);
  	read(SOCK, $rawtime, 4);
  	close(SOCK);
  	$rawtime = unpack("N", $rawtime);
  	$rawtime -= (17 * 366 + 53 * 365) * 24 * 60 * 60;
  	@tm = localtime($rawtime);
	if ($config{'seconds'} == 2) {
		$format = sprintf "%4.4d%2.2d%2.2d%2.2d%2.2d.%2.2d",
			$tm[5]+1900, $tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[0];
		}
	elsif ($config{'seconds'} == 1) {
		$format = sprintf "%2.2d%2.2d%2.2d%2.2d%4.4d.%2.2d",
			$tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[5]+1900, $tm[0];
		}
	else {
		$format = sprintf "%2.2d%2.2d%2.2d%2.2d%2.2d",
			$tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[5]%100;
		}
	&system_logged("echo yes | date $format >/dev/null 2>&1");
  } # endif
  else {
	$rawtime = time();
  } # endelse

  @tm = localtime($rawtime);

  if ($in{ 'action' } ne $text{ 'action_timeserver_sys' } ) {
	# Set hardware clock time
	$format = sprintf "%d/%d/%d %d:%d:%d",
			$tm[4]+1, $tm[3], $tm[5]+1900, $tm[2], $tm[1], $tm[0];
	&system_logged("hwclock --set \"--date=$format\" >/dev/null 2>&1");
	}
  &lock_file("$module_config_directory/config");
  $config{'timeserver'} = $in{'timeserver'};
  &write_file("$module_config_directory/config", \%config);
  &unlock_file("$module_config_directory/config");
  &webmin_log("remote", $in{'action'} eq $text{'action_timeserver_sys'} ?  "date" : "hwclock", $rawtime, \%in);
}

&redirect("");

