# apache-monitor.pl
# Monitor the apache server on this host

# Check the PID file to see if apache is running
sub get_apache_status
{
&foreign_require($_[1], "apache-lib.pl");
return { 'up' => -1 } if (!&foreign_check($_[1]));
local %aconfig = &foreign_config($_[1]);
return { 'up' => -1 } if (!-x $aconfig{'httpd_path'});
local $conf = &foreign_call($_[1], "get_config");
local $str = &foreign_call($_[1], "find_directive_struct", "PidFile", $conf);
local $file = $str ? $str->{'words'}->[0] : "logs/httpd.pid";
$file = &foreign_call($_[1], "server_root", $file, $conf);
if (open(PID, $file) && <PID> =~ /(\d+)/ && kill(0, $1)) {
	close(PID);
	local @st = stat($file);
	return { 'up' => 1,
		 'desc' => &text('up_since', scalar(localtime($st[9]))) };
	}
else {
	return { 'up' => 0 };
	}
}

sub parse_apache_dialog
{
&depends_check($_[0], "apache");
}

1;

