#!/usr/local/bin/perl
# run.cgi
# Run some command with the given parameters

require './custom-lib.pl';
$theme_no_table = 1;
&foreign_require("proc", "proc-lib.pl");
&ReadParse();
$| = 1;
&error_setup($text{'run_err'});
@cmds = &list_commands();
$cmd = $cmds[$in{'idx'}];
&can_run_command($cmd) || &error($text{'run_ecannot'});

# substitute parameters into command
$str = $displaystr = $cmd->{'cmd'};
foreach $a (@{$cmd->{'args'}}) {
	$n = $a->{'name'};
	if ($a->{'type'} == 0 || $a->{'type'} == 5 ||
	    $a->{'type'} == 6 || $a->{'type'} == 8) {
		$rv = $in{$n};
		}
	elsif ($a->{'type'} == 1 || $a->{'type'} == 2) {
		(@u = getpwnam($in{$n})) || &error($text{'run_euser'});
		$rv = $a->{'type'} == 1 ? $in{$n} : $u[2];
		}
	elsif ($a->{'type'} == 3 || $a->{'type'} == 4) {
		(@g = getgrnam($in{$n})) || &error($text{'run_egroup'});
		$rv = $a->{'type'} == 3 ? $in{$n} : $g[2];
		}
	elsif ($a->{'type'} == 7) {
		$rv = $in{$n} ? $a->{'opts'} : "";
		}
	$ENV{$n} = $rv;
	$env .= "$n='$rv'\n";
	$export .= " $n";
	if ($a->{'quote'}) {
		$str =~ s/\$$n/"\$$n"/g;
		$displaystr =~ s/\$$n/"$rv"/g;
		}
	else {
		$displaystr =~ s/\$$n/$rv/g;
		}
	}

# Run and display output
$| = 1;
&header($text{'run_title'}, "", "run");
print "<center><font size=+2>$cmd->{'desc'}</font></center>\n";
print "<hr>\n";
print "<p>",&text('run_out', "<tt>".&html_escape($displaystr)."</tt>"),"\n";
print "<pre>" if (!$cmd->{'raw'});
if ($cmd->{'su'}) {
	$temp = &tempname();
	open(TEMP, ">$temp");
	print TEMP "#!/bin/sh\n";
	print TEMP $env;
	print TEMP "export $export\n" if ($export);
	print TEMP "$str\n";
	close(TEMP);
	chmod(0755, $temp);
	$got = &foreign_call("proc", "safe_process_exec",
	   		     "su - $cmd->{'user'} -c $temp", 0, 0,
			     STDOUT, undef, !$cmd->{'raw'});
	unlink($temp);
	}
else {
	@u = getpwnam($cmd->{'user'});
	$got = &foreign_call("proc", "safe_process_exec", $str,
			     $u[2], undef, STDOUT, undef, !$cmd->{'raw'});
	}
&additional_log('exec', undef, $displaystr);
if (!$got) { print "<i>$text{'run_noout'}</i>\n"; }
print "</pre>\n" if (!$cmd->{'raw'});
%cmdin = ( %$cmd, %in );
&webmin_log("exec", "command", $cmd->{'id'}, \%cmdin);
print "<hr>\n";
&footer("", $text{'index_return'});

