#!/usr/local/bin/perl
# start_apache.cgi
# Start apache with the server root from the config files

require './virtual-server-lib.pl';
$access{'stop'} || &error($text{'start_ecannot'});
&require_apache();
&ReadParse();
&error_setup($apache::text{'start_err'});

&clean_environment();

if ($apache::config{'start_cmd'}) {
	# use the configured start command
	if ($apache::config{'stop_cmd'}) {
		# execute the stop command to clear lock files
		&system_logged("( $apache::config{'stop_cmd'} ) >/dev/null 2>&1");
		}
	$out = &backquote_logged("( $apache::config{'start_cmd'} ) 2>&1");
	&reset_environment();
	if ($?) {
		&error("<pre>$out</pre>");
		}
	}
elsif (-x $apache::config{'apachectl_path'}) {
	# use the apachectl program
	$out = &backquote_logged("( $apache::config{'apachectl_path'} start ) 2>&1");
	&reset_environment();
	if ($out =~ /\S/ && $out !~ /httpd started/) {
		&error("<pre>$out</pre>");
		}
	}
else {
	# start manually
	$cmd = "$apache::config{'httpd_path'} -d $apache::config{'httpd_dir'}";
	if ($apache::config{'httpd_conf'}) { $cmd .= " -f $apache::config{'httpd_conf'}"; }
	$temp = &tempname();
	$rv = &system_logged("( $cmd ) >$temp 2>&1 </dev/null");
	$out = `cat $temp`;
	unlink($temp);
	&reset_environment();
	if ($out =~ /\S/ && $out !~ /httpd started/) {
		&error("<pre>$cmd :\n$out</pre>");
		}
	}

# check if startup was successful. Later apache version return no
# error code, but instead fail to start and write the reason to
# the error log file!
sleep(3);
$conf = &apache::get_config();
$pid = &get_apache_pid();
if (!$pid || !kill(0, $pid)) {
	# Not running..  find out why
	$errorlogstr = &apache::find_directive_struct("ErrorLog", $conf);
	$errorlog = $errorlogstr ? $errorlogstr->{'words'}->[0]
				 : "logs/error_log";
	if ($out =~ /\S/) {
		&error("<pre>$out</pre>");
		}
	elsif ($errorlog eq 'syslog' || $errorlog =~ /^\|/) {
		&error($apache::text{'start_eunknown'});
		}
	else {
		$errorlog = &apache::server_root($errorlog, $conf);
		$out = `tail -5 $errorlog`;
		&error("<pre>$out</pre>");
		}
	}
&webmin_log("start", "web");
&redirect("");


