#!/usr/local/bin/perl
# Show all MySQL and PostgreSQL databases owned by this domain

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
&can_edit_domain($d) || &error($text{'edit_ecannot'});

&ui_print_header(&domain_in($d), $text{'databases_title'}, "");

# Build and show DB list
@dbs = &domain_databases($d);
if (@dbs) {
	print &ui_columns_start([ $text{'databases_db'},
				  $text{'databases_type'} ]);
	foreach $db (@dbs) {
		print &ui_columns_row([
			"<a href='edit_database.cgi?dom=$in{'dom'}&name=$db->{'name'}&type=$db->{'type'}'>$db->{'name'}</a>",
			$text{'databases_'.$db->{'type'}}
				]);
		}
	print &ui_columns_end();
	}
else {
	print "<b>$text{'databases_none'}</b><p>\n";
	}
if (!$d->{'dbslimit'} || @dbs < $d->{'dbslimit'}) {
	print "<a href='edit_database.cgi?dom=$in{'dom'}&new=1'>",
	      $text{'databases_add'},"</a><br>\n";
	}

if (&master_admin()) {
	# Show database import form, if there are any not owned by any user
	foreach $dd (&list_domains()) {
		foreach $db (&domain_databases($dd)) {
			$inuse{$db->{'type'},$db->{'name'}}++;
			}
		}
	@avail = grep { !$inuse{$_->{'type'},$_->{'name'}} &&
		        !$_->{'special'} } &all_databases();
	if (@avail) {
		print "<hr>\n";
		print &ui_form_start("import_database.cgi", "post");
		print &ui_hidden("dom", $in{'dom'}),"\n";
		print &ui_table_start($text{'databases_iheader'}, undef, 2);

		print &ui_table_row($text{'databases_ilist'},
			&ui_select("import", [ ],
			    [ map { [ "$_->{'type'} $_->{'name'}",
				      $_->{'name'}.
				      " (".$text{'databases_'.$_->{'type'}}.")"
				    ] } @avail ], 5, 1));

		print &ui_table_end();
		print &ui_form_end([ [ "ok", $text{'databases_import'} ] ]);
		}
	}

&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		 "", $text{'index_return'});

