
$default_web_port = $config{'web_port'} || 80;

sub require_apache
{
return if ($require_apache++);
&foreign_require("apache", "apache-lib.pl");
}

# setup_web(&domain)
# Setup a virtual website for some domain
sub setup_web
{
local $tmpl = &get_template($_[0]->{'template'});
local $web_port = $tmpl->{'web_port'} || 80;
if ($_[0]->{'alias'} && $tmpl->{'web_alias'}) {
	&$first_print($text{'setup_webalias'});
	}
else {
	&$first_print($text{'setup_web'});
	}
&require_apache();
local $conf = &apache::get_config();
local $f;
if ($apache::config{'virt_file'}) {
	$f = -d $apache::config{'virt_file'} ?
		"$apache::config{'virt_file'}/www.$_[0]->{'dom'}.conf" :
		$apache::config{'virt_file'};
	}
else {
	$vconf = &apache::get_virtual_config();
	$f = $vconf->[0]->{'file'};
	}
&lock_file($f);

# add NameVirtualHost if needed
local $nvstar;
if ($_[0]->{'name'}) {
	local ($found, $found_no_port);
	local @nv = &apache::find_directive("NameVirtualHost", $conf);
	foreach $nv (@nv) {
		$found++ if ( #$nv eq $_[0]->{'ip'} ||
			     $nv =~ /^(\S+):(\S+)/ && $1 eq $_[0]->{'ip'} ||
			     $nv eq '*');
		$found_no_port++ if $nv eq $_[0]->{'ip'};
		$nvstar++ if ($nv eq "*");
		}
	if (!$found) {
		@nv = grep { $_ ne $_[0]->{'ip'} } @nv if $found_no_port;
		&apache::save_directive("NameVirtualHost",
					[ @nv, "$_[0]->{'ip'}:$web_port" ],
					$conf, $conf);
		&flush_file_lines();
		}
	}

local @dirs = &apache_template($tmpl->{'web'}, $_[0], $tmpl->{'web_suexec'});
if ($_[0]->{'alias'} && $tmpl->{'web_alias'}) {
	# Update the parent virtual host
	local $alias = &get_domain($_[0]->{'alias'});
	local ($pvirt, $pconf) = &get_apache_virtual($alias->{'dom'},
						     $alias->{'web_port'});
	if (!$pvirt) {
		&$second_print($text{'setup_ewebalias'});
		return 0;
		}
	&lock_file($pvirt->{'file'});
	local @sa = &apache::find_directive("ServerAlias", $pconf);
	local $d;
	foreach $d (@dirs) {
		if ($d =~ /^\s*Server(Name|Alias)\s+(.*)/) {
			push(@sa, $2);
			}
		}
	&apache::save_directive("ServerAlias", \@sa, $pconf, $conf);
	&flush_file_lines();
	&unlock_file($pvirt->{'file'});
	$_[0]->{'alias_mode'} = $tmpl->{'web_alias'};
	}
else {
	# Add the actual <VirtualHost>
	local $vip = $_[0]->{'name'} && $apache::httpd_modules{'core'} >= 1.312 &&
		     $nvstar ? "*" : $_[0]->{'ip'};
	local $lref = &read_file_lines($f);
	push(@$lref, "<VirtualHost $vip:$web_port>");
	if ($_[0]->{'alias'}) {
		# Because this is just an alias to an existing virtual server,
		# create a ProxyPass or Redirect
		@dirs = grep { /^\s*Server(Name|Alias)\s/i } @dirs;
		local $aliasdom = &get_domain($_[0]->{'alias'});
		local $port = $aliasdom->{'web_port'} == 80 ? "" :
				":$aliasdom->{'web_port'}";
		local $url = "http://www.$aliasdom->{'dom'}$port/";
		if ($apache::httpd_modules{'mod_proxy'}) {
			push(@dirs, "ProxyPass / $url",
				    "ProxyPassReverse / $url");
			}
		else {
			push(@dirs, "Redirect / $url");
			}
		}
	push(@$lref, @dirs);
	push(@$lref, "</VirtualHost>");
	&flush_file_lines();
	$_[0]->{'web_port'} = $web_port;
	}
&unlock_file($f);
undef(@apache::get_config_cache);
&create_framefwd_file($_[0]);
&$second_print($text{'setup_done'});
&register_post_action(\&restart_apache);

if ($tmpl->{'web_user'} && !$_[0]->{'alias'}) {
	# Add the Apache user to the group for this virtual server, if missing
	&require_useradmin();
	local @groups = &list_all_groups();
	local ($group) = grep { $_->{'group'} eq $_[0]->{'group'} } @groups;
	if ($group) {
		local @mems = split(/,/, $group->{'members'});
		if (&indexof($tmpl->{'web_user'}, @mems) < 0) {
			# Need to add him
			&$first_print(&text('setup_webuser',
					    $tmpl->{'web_user'}));
			$group->{'members'} =
				join(",", @mems, $tmpl->{'web_user'});
			&foreign_call($usermodule, "set_group_envs", $group, 'MODIFY_GROUP');
			&foreign_call($usermodule, "making_changes");
			&foreign_call($usermodule, "modify_group", $group, $group);
			&foreign_call($usermodule, "made_changes");
			&$second_print($text{'setup_done'});
			}
		}
	}

# Make the web directory accessible under SElinux Apache
if (&has_command("chcon")) {
	local $hdir = &public_html_dir($_[0]);
	system("chcon -R -t httpd_sys_content_t ".quotemeta($hdir).
	       ">/dev/null 2>&1");
	local $cgidir = "$_[0]->{'home'}/cgi-bin";
	system("chcon -R -t httpd_sys_script_exec_t ".quotemeta($cgidir).
	       ">/dev/null 2>&1");
	local $logdir = "$_[0]->{'home'}/logs";
	system("chcon -R -t httpd_log_t ".quotemeta($logdir).
	       ">/dev/null 2>&1");
	}
}

# delete_web(&domain)
# Delete the virtual server from the Apache config
sub delete_web
{
&require_apache();
local $conf = &apache::get_config();
if ($_[0]->{'alias_mode'}) {
	# Just delete ServerAlias directives from parent
	&$first_print($text{'delete_apachealias'});
	local $alias = &get_domain($_[0]->{'alias'});
	local ($pvirt, $pconf) = &get_apache_virtual($alias->{'dom'},
						     $alias->{'web_port'});
	if (!$pvirt) {
		&$second_print($text{'setup_ewebalias'});
		return 0;
		}
	&lock_file($pvirt->{'file'});
	local @sa = &apache::find_directive("ServerAlias", $pconf);
	@sa = grep { !/\Q$_[0]->{'dom'}\E$/ } @sa;
	&apache::save_directive("ServerAlias", \@sa, $pconf, $conf);
	&flush_file_lines();
	&unlock_file($pvirt->{'file'});
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_apache);
	}
elsif ($config{'delete_indom'}) {
	# Delete all matching virtual servers
	&$first_print($text{'delete_apache'});
	local @virt = reverse(&apache::find_directive_struct("VirtualHost",
							     $conf));
	foreach $v (@virt) {
		local $sn = &apache::find_directive("ServerName",
						    $v->{'members'});
		if ($sn =~ /\Q$_[0]->{'dom'}\E$/) {
			&delete_virtual_server($v);
			}
		}
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_apache);
	}
else {
	# Just delete one virtual server
	&$first_print($text{'delete_apache'});
	local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
						    $_[0]->{'web_port'});
	if ($virt) {
		&delete_virtual_server($virt);
		&$second_print($text{'setup_done'});
		&register_post_action(\&restart_apache);
		}
	else {
		&$second_print($text{'delete_noapache'});
		}
	}
undef(@apache::get_config_cache);
}

# delete_virtual_server(&vhost)
# Delete a single virtual server from the Apache config
sub delete_virtual_server
{
&require_apache();
&lock_file($_[0]->{'file'});
local $lref = &read_file_lines($_[0]->{'file'});
splice(@$lref, $_[0]->{'line'}, $_[0]->{'eline'} - $_[0]->{'line'} + 1);
&flush_file_lines();
if (&is_empty($lref)) {
	# Don't keep around empty web files
	unlink($_[0]->{'file'});
	}
&unlock_file($_[0]->{'file'});
}

# is_empty(&lref)
sub is_empty
{
local $l;
foreach $l (@{$_[0]}) {
	if ($l =~ /\S/) {
		return 0;
		}
	}
return 1;
}

# modify_web(&domain, &olddomain, [&alias, &oldalias])
# If this server has changed from name-based to IP-based hosting, update
# the Apache configuration
sub modify_web
{
local $rv = 0;
&require_apache();
local $conf = &apache::get_config();
if ($_[0]->{'alias'} && $_[0]->{'alias_mode'}) {
	# Possibly just updating parent virtual server
	if ($_[0]->{'dom'} ne $_[1]->{'dom'}) {
		&$first_print($text{'save_apache5'});
		local $alias = &get_domain($_[0]->{'alias'});
		local ($pvirt, $pconf) = &get_apache_virtual($alias->{'dom'},
						     $alias->{'web_port'});
		if (!$pvirt) {
			&$second_print($text{'setup_ewebalias'});
			}
		else {
			&lock_file($pvirt->{'file'});
			local @sa = &apache::find_directive("ServerAlias", $pconf);
			local $s;
			foreach $s (@sa) {
				$s =~ s/\Q$_[1]->{'dom'}\E($|\s)/$_[0]->{'dom'}$1/g;
				}
			&apache::save_directive("ServerAlias", \@sa, $pconf,
						$conf);
			&flush_file_lines();
			&unlock_file($pvirt->{'file'});
			&$second_print($text{'setup_done'});
			$rv++;
			}
		}
	}
else {
	# Update an actual virtual server
	local ($virt, $vconf) = &get_apache_virtual($_[1]->{'dom'},
						    $_[1]->{'web_port'});
	&lock_file($virt->{'file'});
	if ($_[0]->{'name'} != $_[1]->{'name'} ||
	    $_[0]->{'ip'} ne $_[1]->{'ip'} ||
	    $_[0]->{'ssl'} != $_[1]->{'ssl'}) {
		# Name-based hosting mode or IP has changed
		&$first_print($text{'save_apache'});
		local $lref = &read_file_lines($virt->{'file'});
		$lref->[$virt->{'line'}] =
			$_[0]->{'name'} ? "<VirtualHost *>" :
				"<VirtualHost $_[0]->{'ip'}:$_[1]->{'web_port'}>";
		&flush_file_lines();
		$rv++;
		&$second_print($text{'setup_done'});
		}
	if ($_[0]->{'home'} ne $_[1]->{'home'}) {
		# Home directory has changed .. update any directives that
		# referred to the old directory
		&$first_print($text{'save_apache3'});
		local $lref = &read_file_lines($virt->{'file'});
		for($i=$virt->{'line'}; $i<=$virt->{'eline'}; $i++) {
			$lref->[$i] =~ s/$_[1]->{'home'}/$_[0]->{'home'}/g;
			}
		&flush_file_lines();
		$rv++;
		&$second_print($text{'setup_done'});
		}
	if ($_[0]->{'alias'} && $_[2] && $_[2]->{'dom'} ne $_[3]->{'dom'}) {
		# This is an alias, and the domain it is aliased to has changed.
		# update all Proxy* and Redirect directives
		&$first_print($text{'save_apache4'});
		local $lref = &read_file_lines($virt->{'file'});
		for($i=$virt->{'line'}; $i<=$virt->{'eline'}; $i++) {
			if ($lref->[$i] =~ /^\s*(Proxy|Redirect\s)/) {
				$lref->[$i] =~ s/$_[3]->{'dom'}/$_[2]->{'dom'}/g;
				}
			}
		&flush_file_lines();
		$rv++;
		&$second_print($text{'setup_done'});
		}
	if ($_[0]->{'proxy_pass_mode'} == 1 && 
	    $_[0]->{'proxy_pass'} ne $_[1]->{'proxy_pass'}) {
		# This is a proxying forwarding website and the URL has
		# changed - update all Proxy* directives
		&$first_print($text{'save_apache6'});
		local $lref = &read_file_lines($virt->{'file'});
		for($i=$virt->{'line'}; $i<=$virt->{'eline'}; $i++) {
			if ($lref->[$i] =~ /^\s*ProxyPass(Reverse)?\s/) {
				$lref->[$i] =~ s/$_[1]->{'proxy_pass'}/$_[0]->{'proxy_pass'}/g;
				}
			}
		&flush_file_lines();
		$rv++;
		&$second_print($text{'setup_done'});
		}
	if ($_[0]->{'user'} ne $_[1]->{'user'}) {
		# Username has changed .. update SuexecUserGroup and User
		local $suexec = &apache::find_directive_struct(
			"SuexecUserGroup", $vconf);
		if ($suexec && $suexec->{'words'}->[0] eq $_[1]->{'user'}) {
			&$first_print($text{'save_apache7'});
			&apache::save_directive("SuexecUserGroup",
					[ "$_[0]->{'user'} $_[0]->{'ugroup'}" ],
					$vconf, $conf);
			&flush_file_lines();
			$rv++;
			&$second_print($text{'setup_done'});
			}
		local $user = &apache::find_directive_struct(
			"User", $vconf);
		if ($user && $user->{'words'}->[0] eq $_[1]->{'user'}) {
			&$first_print($text{'save_apache7'});
			&apache::save_directive("User",
					[ $_[0]->{'user'} ],
					$vconf, $conf);
			&flush_file_lines();
			$rv++;
			&$second_print($text{'setup_done'});
			}
		}
	if ($_[0]->{'dom'} ne $_[1]->{'dom'}) {
		# Domain name has changed .. update ServerName and ServerAlias
		&$first_print($text{'save_apache2'});
		&apache::save_directive("ServerName", [ $_[0]->{'dom'} ],
					$vconf, $conf);
		local @sa = map { s/$_[1]->{'dom'}/$_[0]->{'dom'}/g; $_ }
				&apache::find_directive("ServerAlias", $vconf);
		&apache::save_directive("ServerAlias", \@sa, $vconf, $conf);
		&flush_file_lines();
		$rv++;
		if ($virt->{'file'} =~ /$_[1]->{'dom'}/) {
			# Filename contains domain name .. need to re-name
			&unlock_file($virt->{'file'});
			local $nfn = $virt->{'file'};
			$nfn =~ s/$_[1]->{'dom'}/$_[0]->{'dom'}/;
			&rename_logged($virt->{'file'}, $nfn);
			}
		&$second_print($text{'setup_done'});
		}
	&unlock_file($virt->{'file'});
	if ($rv) {
		undef(@apache::get_config_cache);
		}
	&create_framefwd_file($_[0]);
	if (!$_[0]->{'ssl'}) {
		# Only re-start here if we won't re-start later after
		# changing SSL
		&register_post_action(\&restart_apache, 1) if ($rv);
		}
	}
return $rv;
}

$disabled_website = "$module_config_directory/disabled.html";

# disable_web(&domain)
# Adds a directive to force all requests to show an error page
sub disable_web
{
&$first_print($text{'disable_apache'});
&require_apache();
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
if ($virt) {
	&create_disable_directives($virt, $vconf);
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_apache);
	}
else {
	&$second_print($text{'delete_noapache'});
	}
}

# create_disable_directives(&virt, &vconf)
sub create_disable_directives
{
local ($virt, $vconf) = @_;
&lock_file($virt->{'file'});
local @am = &apache::find_directive("AliasMatch", $vconf);
local $conf = &apache::get_config();
&apache::save_directive("AliasMatch",
			[ @am, "^/.*\$ $disabled_website" ],
			$vconf, $conf);
&flush_file_lines();
if (!-r $disabled_website) {
	open(DISABLED, ">$disabled_website");
	print DISABLED "<h1>Website Disabled</h1>\n";
	close(DISABLED);
	chmod(0644, $disabled_website);
	}
&unlock_file($virt->{'file'});
}

# enable_web(&domain)
# Deletes the special error page directive
sub enable_web
{
&$first_print($text{'enable_apache'});
&require_apache();
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
if ($virt) {
	&remove_disable_directives($virt, $vconf);
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_apache);
	}
else {
	&$second_print($text{'delete_noapache'});
	}
}

# remove_disable_directives(&virt, &vconf)
sub remove_disable_directives
{
local ($virt, $vconf) = @_;
&lock_file($virt->{'file'});
local @am = &apache::find_directive("AliasMatch", $vconf);
@am = grep { $_ ne "^/.*\$ $disabled_website" } @am;
local $conf = &apache::get_config();
&apache::save_directive("AliasMatch", \@am, $vconf, $conf);
&flush_file_lines();
&unlock_file($virt->{'file'});
}

# check_web_clash(&domain, [field])
# Returns 1 if an Apache webserver already exists for some domain
sub check_web_clash
{
if ($_[1] || $_[1] eq 'dom') {
	local $tmpl = &get_template($_[0]->{'template'});
	local $web_port = $tmpl->{'web_port'} || 80;
	local ($cvirt, $cconf) = &get_apache_virtual($_[0]->{'dom'}, $web_port);
	return $cvirt ? 1 : 0;
	}
return 0;
}

# restart_apache([restart])
# Tell Apache to re-read its config file
sub restart_apache
{
&$first_print($_[0] ? $text{'setup_webpid2'} : $text{'setup_webpid'});
local $pid = &get_apache_pid();
if (!$pid || !kill(0, $pid)) {
	&$second_print($text{'setup_notrun'});
	return 0;
	}
if ($_[0]) {
	# Totally stop and start
	if ($apache::config{'stop_cmd'}) {
		&system_logged("$apache::config{'stop_cmd'} >/dev/null 2>&1");
		}
	else {
		&system_logged("$apache::config{'apachectl_path'} stop >/dev/null 2>&1");
		}
	sleep(5);
	if ($apache::config{'start_cmd'}) {
		&system_logged("$apache::config{'start_cmd'} >/dev/null 2>&1");
		}
	else {
		&system_logged("$apache::config{'apachectl_path'} start >/dev/null 2>&1");
		}
	&$second_print($text{'setup_done'});
	return 1;
	}
else {
	# Just signal a re-load
	if ($apache::config{'apply_cmd'}) {
		# use the configured start command
		&system_logged("($apache::config{'apply_cmd'}) >/dev/null 2>&1");
		}
	elsif (-x $apache::config{'apachectl_path'}) {
		# Use apachectl
		&system_logged("$apache::config{'apachectl_path'} restart >/dev/null 2>&1");
		}
	else {
		# Just signal the process
		&kill_logged('HUP', $pid);
		}
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# get_apache_log(domain, [port], [errorlog])
# Given a domain name, returns the path to its log file
sub get_apache_log
{
&require_apache();
local ($virt, $vconf) = &get_apache_virtual($_[0], $_[1]);
if ($virt) {
	local $log;
	if ($_[2]) {
		# Looking for error log
		$log = &apache::find_directive("ErrorLog", $vconf, 1);
		}
	else {
		# Looking for normal log
		$log = &apache::find_directive("TransferLog", $vconf, 1) ||
		       &apache::find_directive("CustomLog", $vconf, 1);
		}
	return $log;
	}
else {
	return undef;
	}
}

# get_apache_virtual(domain, [port])
# Returns the list of configuration directives and the directive for the
# virtual domain itself for some domain
sub get_apache_virtual
{
&require_apache();
local $conf = &apache::get_config();
local $v;
local $sp = $_[1] || $default_web_port;
foreach $v (&apache::find_directive_struct("VirtualHost", $conf)) {
	local $vp = $v->{'words'}->[0] =~ /:(\d+)$/ ? $1 : $default_web_port;
	next if ($vp != $sp);
        local $sn = &apache::find_directive("ServerName", $v->{'members'});
	return ($v, $v->{'members'}) if ($sn eq $_[0] ||
					 $sn eq "www.$_[0]");
	local $n;
	foreach $n (&apache::find_directive_struct(
			"ServerAlias", $v->{'members'})) {
		return ($v, $v->{'members'})
			if (&indexof($_[0], @{$n->{'words'}}) >= 0 ||
			    &indexof("www.$_[0]", @{$n->{'words'}}) >= 0);
		}
        }
return ();
}

# get_apache_pid()
sub get_apache_pid
{
&require_apache();
local $pidfile = &apache::get_pid_file();
open(PID, $pidfile) || return undef;
chop($pid = <PID>);
close(PID);
return $pid;
}

# apache_template(text, &domain, suexec)
# Returns a suitably substituted Apache template
sub apache_template
{
local $dirs = $_[0];
$dirs =~ s/\t/\n/g;
$dirs = &substitute_template($dirs, $_[1]);
local @dirs = split(/\n/, $dirs);
local ($sudir, $ppdir);
foreach (@dirs) {
	$sudir++ if (/^\s*SuexecUserGroup\s/i || /^\s*User\s/i);
	$ppdir++ if (/^\s*ProxyPass\s/);
	}
if (!$sudir && $_[2] && $_[1]->{'unix'}) {
	# Automatically add suexec directives if missing
	if ($apache::httpd_modules{'core'} >= 2.0) {
		if ($apache::httpd_modules{'mod_suexec'}) {
			unshift(@dirs, "SuexecUserGroup \"#$_[1]->{'uid'}\" ".
				       "\"#$_[1]->{'ugid'}\"");
			}
		}
	else {
		unshift(@dirs, "User \"#$_[1]->{'uid'}\"",
			       "Group \"#$_[1]->{'ugid'}\"");
		}
	}
if (!$ppdir && $_[1]->{'proxy_pass'}) {
	if ($_[1]->{'proxy_pass_mode'} == 1) {
		# Proxy to another server
		push(@dirs, "ProxyPass / $_[1]->{'proxy_pass'}",
			    "ProxyPassReverse / $_[1]->{'proxy_pass'}");
		}
	else {
		# Redirect to /framefwd.html
		local $ff = &framefwd_file($_[1]);
		push(@dirs, "AliasMatch ^/.*\$ $ff");
		}
	}
return @dirs;
}

# backup_web(&domain, file)
# Save the virtual server's Apache config as a separate file
sub backup_web
{
return 1 if ($_[0]->{'alias'} && $_[0]->{'alias_mode'});
&$first_print($text{'backup_apachecp'});
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
local $lref = &read_file_lines($virt->{'file'});
local $l;
open(FILE, ">$_[1]");
foreach $l (@$lref[$virt->{'line'} .. $virt->{'eline'}]) {
	print FILE "$l\n";
	}
close(FILE);
&$second_print($text{'setup_done'});
return 1;
}

# restore_web(&domain, file, &options)
# Update the virtual server's Apache configuration from a file. Does not
# change the actual <Virtualhost> lines!
sub restore_web
{
return 1 if ($_[0]->{'alias'} && $_[0]->{'alias_mode'});
&$first_print($text{'restore_apachecp'});
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
local $srclref = &read_file_lines($_[1]);
local $dstlref = &read_file_lines($virt->{'file'});
&lock_file($virt->{'file'});
splice(@$dstlref, $virt->{'line'}+1, $virt->{'eline'}-$virt->{'line'}-1,
       @$srclref[1 .. @$srclref-2]);
if ($_[2]->{'fixip'}) {
	# Fix IP address in <Virtualhost> section (if needed)
	if ($dstlref->[$virt->{'line'}] =~
	    /^(.*<Virtualhost\s+)([0-9\.]+)(.*)$/i) {
		$dstlref->[$virt->{'line'}] = $1.$_[0]->{'ip'}.$3;
		}
	}
&flush_file_lines();
&unlock_file($virt->{'file'});
&$second_print($text{'setup_done'});

&register_post_action(\&restart_apache);
return 1;
}

%apache_mmap = ( 'jan' => 0, 'feb' => 1, 'mar' => 2, 'apr' => 3,
	  	 'may' => 4, 'jun' => 5, 'jul' => 6, 'aug' => 7,
	  	 'sep' => 8, 'oct' => 9, 'nov' => 10, 'dec' => 11 );

# bandwidth_web(&domain, start, &bw-hash)
# Searches through log files for records after some date, and updates the
# day counters in the given hash
sub bandwidth_web
{
require 'timelocal.pl';
local @logs = ( &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'}),
		&get_apache_log($_[0]->{'dom'}, $_[0]->{'web_sslport'}) );
local $l;
local $max_ltime = $_[1];
foreach $l (&unique(@logs)) {
	local $f;
	foreach $f (&all_log_files($l)) {
		if ($f =~ /\.gz$/i) {
			open(LOG, "gunzip -c ".quotemeta($f)." |");
			}
		elsif ($f =~ /\.Z$/i) {
			open(LOG, "uncompress -c ".quotemeta($f)." |");
			}
		else {
			open(LOG, $f);
			}
		while(<LOG>) {
			if (/^(\S+)\s+(\S+)\s+(\S+)\s+\[(\d+)\/(\S+)\/(\d+):(\d+):(\d+):(\d+)\s+(\S+)\]\s+"([^"]*)"\s+(\S+)\s+(\S+)/) {
				# Valid-looking log line .. work out the time
				local $ltime = timelocal($9, $8, $7, $4, $apache_mmap{lc($5)}, $6-1900);
				if ($ltime > $_[1]) {
					local $day = int($ltime / (24*60*60));
					$_[2]->{$day} += $13;
					}
				$max_ltime = $ltime if ($ltime > $max_ltime);
				}
			}
		close(LOG);
		}
	}
return $max_ltime;
}

# all_log_files(file)
sub all_log_files
{
$_[0] =~ /^(.*)\/([^\/]+)$/;
local $dir = $1;
local $base = $2;
local ($f, @rv);
opendir(DIR, $dir);
foreach $f (readdir(DIR)) {
	if ($f =~ /^\Q$base\E/ && -f "$dir/$f") {
		push(@rv, "$dir/$f");
		}
	}
closedir(DIR);
return @rv;
}

# create_framefwd_file(&domain)
# Create a framefwd.html file for a server, if needed
sub create_framefwd_file
{
if ($_[0]->{'proxy_pass_mode'} == 2) {
	local $template = &get_template($_[0]->{'template'});
	local $ff = &framefwd_file($_[0]);
	unlink($ff);
	local $text = $template->{'frame'};
	open(FRAME, ">$ff");
	local %subs = %{$_[0]};
	$subs{'proxy_title'} ||= $tmpl{'owner'};
	$subs{'proxy_meta'} ||= "";
	$subs{'proxy_meta'} = join("\n", split(/\t/, $subs{'proxy_meta'}));
	print FRAME &substitute_template($text, \%subs);
	close(FRAME);
	if ($_[0]->{'unix'}) {
		chown($_[0]->{'uid'}, $_[0]->{'gid'}, $ff);
		}

	# Create a blank HTML page too, used in the frameset
	local $bl = &frameblank_file($_[0]);
	unlink($bl);
	open(BLANK, ">$bl");
	print BLANK "<body bgcolor=#ffffff></body>\n";
	close(BLANK);
	if ($_[0]->{'unix'}) {
		chown($_[0]->{'uid'}, $_[0]->{'gid'}, $bl);
		}
	}
}

# public_html_dir(&domain, [relative])
sub public_html_dir
{
local $tmpl = &get_template($_[0]->{'template'});
local ($hdir) = ($tmpl->{'web_html_dir'} || 'public_html');
$hdir = &substitute_template($hdir, $_[0]);
return $_[1] ? $hdir : "$_[0]->{'home'}/$hdir";
}

# framefwd_file(&domain)
sub framefwd_file
{
local $hdir = &public_html_dir($_[0]);
return "$hdir/framefwd.html";
}

# frameblank_file(&domain)
sub frameblank_file
{
local $hdir = &public_html_dir($_[0]);
return "$hdir/frameblank.html";
}

# check_depends_web(&dom)
# Ensure that a website has a Unix user, if not proxying
sub check_depends_web
{
if ($_[0]->{'alias'}) {
	# If this is an alias domain, then no home is needed
	return undef;
	}
elsif ($_[0]->{'proxy_pass'} == 2) {
	# If proxying using frame forwarding, a home is needed
	return $_[0]->{'dir'} ? undef : $text{'setup_edepframe'};
	}
elsif ($_[0]->{'proxy_pass'} == 1) {
	# If proxying using ProxyPass, no home is needed
	return undef;
	}
else {
	# For a normal website, we need a home
	return $_[0]->{'dir'} ? undef : $text{'setup_edepweb'};
	}
}

sub frame_fwd_input
{
local $rv;
if ($config{'proxy_pass'} == 1) {
	$rv .= "<tr> <td><b>".&hlink($text{'form_proxy'},
				    "proxypass")."</b></td>\n";
	}
else {
	$rv .= "<tr> <td><b>".&hlink($text{'form_framefwd'},
				    "framefwd")."</b></td>\n";
	}
$rv .= "<td colspan=3>";
$rv .= sprintf "<input type=radio name=proxy_def value=1 %s> %s\n",
      $_[0] ? "" : "checked", $text{'form_plocal'};
$rv .= sprintf "<input type=radio name=proxy_def value=0 %s> %s\n",
      $_[0] ? "checked" : "", $text{'form_purl'};
$rv .= "<input name=proxy size=40 value='$_[0]'></td> </tr>\n";
return $rv;
}

# show_restore_web(&options)
# Returns HTML for website restore option inputs
sub show_restore_web
{
# Offer to update IP
return sprintf
	"(<input type=checkbox name=web_fixip value=1 %s> %s)",
	$opts{'fixip'} ? "checked" : "", $text{'restore_webfixip'};
}

# parse_restore_web(&in)
# Parses the inputs for website restore options
sub parse_restore_web
{
local %in = %{$_[0]};
return { 'fixip' => $in{'web_fixip'} };
}

1;

