# Functions for managing a domain's Unix user

$feature_depends{'unix'} = [ 'dir' ];

# setup_unix(&domain)
# Creates the Unix user and group for a domain
sub setup_unix
{
local $tmpl = &get_template($_[0]->{'template'});
&require_useradmin();
local (%uinfo, %ginfo);

# Create the group
&$first_print(&text('setup_group', $_[0]->{'group'}));
&foreign_call($usermodule, "lock_user_files");
%ginfo = ( 'group', $_[0]->{'group'},
	   'gid', $_[0]->{'gid'} );
&foreign_call($usermodule, "set_group_envs", \%ginfo, 'CREATE_GROUP');
&foreign_call($usermodule, "making_changes");
&foreign_call($usermodule, "create_group", \%ginfo);
&foreign_call($usermodule, "made_changes");
if (!defined(getgrnam($_[0]->{'group'}))) {
	&$second_print($text{'setup_ecrgroup'});
	exit;
	}
&$second_print($text{'setup_done'});

# Then the user
&$first_print(&text('setup_user', $_[0]->{'user'}));
%uinfo = ( 'user', $_[0]->{'user'},
	   'uid', $_[0]->{'uid'},
	   'gid', $_[0]->{'ugid'},
	   'pass', &foreign_call($usermodule, "encrypt_password", $_[0]->{'pass'}),
	   'real', $_[0]->{'owner'},
	   'home', $_[0]->{'home'},
	   'shell', $config{'unix_shell'},
	   'mailbox', $_[0]->{'user'},
	   'dom', $_[0]->{'dom'},
	   'dom_prefix', substr($_[0]->{'dom'}, 0, 1),
	 );
&set_pass_change(\%user);
&foreign_call($usermodule, "set_user_envs", \%uinfo, 'CREATE_USER', $_[0]->{'pass'}, [ ]);
&foreign_call($usermodule, "making_changes");
&foreign_call($usermodule, "create_user", \%uinfo);
&foreign_call($usermodule, "made_changes");
&foreign_call($usermodule, "unlock_user_files");
if ($config{'other_doms'}) {
	&foreign_call($usermodule, "other_modules", "useradmin_create_user",
		      \%uinfo);
	}
if (!defined(getpwnam($_[0]->{'user'}))) {
	&$second_print($text{'setup_ecruser'});
	exit;
	}
&$second_print($text{'setup_done'});

# Set the user's quota
if ($config{'home_quotas'}) {
	&set_server_quotas($_[0]);
	}

&create_mail_file(\%user);
}

# modify_unix(&domain, &olddomain)
# Change the password and real name for a domain unix user
sub modify_unix
{
if (!$_[0]->{'parent'}) {
	&require_useradmin();
	local @allusers = &list_domain_users($_[1]);
	local ($uinfo) = grep { $_->{'user'} eq $_[1]->{'user'} } @allusers;
	if ($uinfo) {
		&foreign_call($usermodule, "lock_user_files");
		local %old = %$uinfo;
		&$first_print($text{'save_user'});
		$uinfo->{'real'} = $_[0]->{'owner'};
		if ($_[0]->{'pass_set'}) {
			# Update the Unix user's password
			local $enc = &foreign_call($usermodule,
				"encrypt_password", $_[0]->{'pass'});
			if ($d->{'disabled'}) {
				# Just keep for later use when enabling
				$d->{'disabled_oldpass'} = $enc;
				}
			else {
				# Set password now
				$uinfo->{'pass'} = $enc;
				}
			$uinfo->{'plainpass'} = $_[0]->{'pass'};
			&set_pass_change($uinfo);
			}

		if ($_[0]->{'user'} ne $_[1]->{'user'}) {
			# Unix user was re-named
			$uinfo->{'olduser'} = $_[1]->{'user'};
			$uinfo->{'user'} = $_[0]->{'user'};
			&rename_mail_file($uinfo, \%old);
			}

		if ($_[0]->{'home'} ne $_[1]->{'home'}) {
			# Home directory was changed
			$uinfo->{'home'} = $_[0]->{'home'};
			}

		&modify_user($uinfo, \%old, undef);

		if ($config{'other_doms'}) {
			&foreign_call($usermodule, "other_modules",
				      "useradmin_modify_user", $uinfo, \%old);
			}

		&$second_print($text{'setup_done'});
		&foreign_call($usermodule, "unlock_user_files");
		}

	if ($config{'home_quotas'} && $access{'edit'} == 1) {
		# Update his quotas (if changed)
		if ($_[0]->{'quota'} != $_[1]->{'quota'} ||
		    $_[0]->{'uquota'} != $_[1]->{'uquota'}) {
			&$first_print($text{'save_quota'});
			&set_server_quotas($_[0]);
			&$second_print($text{'setup_done'});
			}
		}
	}
}

# delete_unix(&domain)
# Delete the unix user and group for a domain
sub delete_unix
{
&require_useradmin();
local @allusers = &foreign_call($usermodule, "list_users");
local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;

if (!$_[0]->{'parent'}) {
	# Delete unix user
	&foreign_call($usermodule, "lock_user_files");
	if ($uinfo) {
		&$first_print($text{'delete_user'});
		&delete_user($uinfo, $_[0]);
		if ($config{'other_doms'}) {
			&foreign_call($usermodule, "other_modules",
				      "useradmin_delete_user", $uinfo);
			}
		&$second_print($text{'setup_done'});
		}

	# Delete unix group
	local @allgroups = &foreign_call($usermodule, "list_groups");
	local ($ginfo) = grep { $_->{'group'} eq $_[0]->{'group'} } @allgroups;
	if ($ginfo) {
		&$first_print($text{'delete_group'});
		&foreign_call($usermodule, "set_group_envs", $ginfo, 'DELETE_GROUP');
		&foreign_call($usermodule, "making_changes");
		&foreign_call($usermodule, "delete_group", $ginfo);
		&foreign_call($usermodule, "made_changes");
		&$second_print($text{'setup_done'});
		}
	&foreign_call($usermodule, "unlock_user_files");
	}
}

# check_unix_clash(&domain, [field])
sub check_unix_clash
{
return 0 if ($_[0]->{'parent'});	# user already exists!
if (!$_[1] || $_[1] eq 'user') {
	return 1 if (defined(getpwnam($_[0]->{'user'})));
	}
if (!$_[1] || $_[1] eq 'group') {
	return 1 if (defined(getgrnam($_[0]->{'group'})));
	}
return 0;
}

# disable_unix(&domain)
# Lock out the password of this domain's Unix user
sub disable_unix
{
if (!$_[0]->{'parent'}) {
	&require_useradmin();
	&foreign_call($usermodule, "lock_user_files");
	local @allusers = &foreign_call($usermodule, "list_users");
	local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
	if ($uinfo) {
		&$first_print($text{'disable_unix'});
		&foreign_call($usermodule, "set_user_envs", $uinfo, 'MODIFY_USER', "");
		&foreign_call($usermodule, "making_changes");
		$_[0]->{'disabled_oldpass'} = $uinfo->{'pass'};
		$uinfo->{'pass'} = $uconfig{'lock_string'};
		&foreign_call($usermodule, "modify_user", $uinfo, $uinfo);
		&foreign_call($usermodule, "made_changes");
		&$second_print($text{'setup_done'});
		}
	&foreign_call($usermodule, "unlock_user_files");
	}
}

# enable_unix(&domain)
# Re-enable this domain's Unix user
sub enable_unix
{
if (!$_[0]->{'parent'}) {
	&require_useradmin();
	&foreign_call($usermodule, "lock_user_files");
	local @allusers = &foreign_call($usermodule, "list_users");
	local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
	if ($uinfo) {
		&$first_print($text{'enable_unix'});
		&foreign_call($usermodule, "set_user_envs", $uinfo, 'MODIFY_USER', "");
		&foreign_call($usermodule, "making_changes");
		$uinfo->{'pass'} = $_[0]->{'disabled_oldpass'};
		delete($_[0]->{'disabled_oldpass'});
		&foreign_call($usermodule, "modify_user", $uinfo, $uinfo);
		&foreign_call($usermodule, "made_changes");
		&$second_print($text{'setup_done'});
		}
	&foreign_call($usermodule, "unlock_user_files");
	}
}

# backup_unix(&domain, file)
# Does nothing, since the domain's unix user details are already known
sub backup_unix
{
return 1;
}

# restore_unix(&domain, file, &options)
# Extracts the given tar file into a user's home directory
sub restore_unix
{
&$first_print($text{'restore_unixuser'});

# Also re-set quotas
if ($config{'home_quotas'}) {
	&set_server_quotas($_[0]);
	}

# And update password and description
&require_useradmin();
local @allusers = &foreign_call($usermodule, "list_users");
local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
if ($uinfo && !$_[0]->{'parent'}) {
	&foreign_call($usermodule, "lock_user_files");
	$uinfo->{'real'} = $_[0]->{'owner'};
	local $enc = &foreign_call($usermodule, "encrypt_password",
			$_[0]->{'pass'});
	$uinfo->{'pass'} = $enc;
	&set_pass_change($uinfo);
	&foreign_call($usermodule, "set_user_envs",
		$uinfo, 'MODIFY_USER', $_[0]->{'pass'});
	&foreign_call($usermodule, "making_changes");
	&foreign_call($usermodule, "modify_user", $uinfo, $uinfo);
	&foreign_call($usermodule, "made_changes");
	&foreign_call($usermodule, "lock_user_files");
	}
&$second_print($text{'setup_done'});

return 1;
}

1;

