#!/usr/local/bin/perl
# edit_newbw.cgi
# Display current bandwidth usage graphs, and allow enabling of scheduled
# checking

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newbw_ecannot'});
&ui_print_header(undef, $text{'newbw_title'}, "");

$job = &find_bandwidth_job();
print "<form action=save_newbw.cgi method=post>\n";
print "$text{'newbw_desc'}<br>\n";
print "<table>\n";

# Show active field
print "<tr> <td><b>$text{'newbw_active'}</b></td> <td>\n";
printf "<input type=radio name=bw_active value=1 %s> %s\n",
	$job && $config{'bw_active'} ? "checked" : "", $text{'yes'};
printf "<input type=radio name=bw_active value=0 %s> %s</td> </tr>\n",
	$job && $config{'bw_active'} ? "" : "checked", $text{'no'};

# Show field for monitoring period
print "<tr> <td><b>$text{'newbw_period'}</b></td> <td>\n";
foreach $p ('week', 'month', 'year', '') {
	printf "<input type=radio name=bw_past value='%s' %s> %s\n",
		$p, $config{'bw_past'} eq $p ? "checked" : "",
		$text{'newbw_past_'.$p};
	}
printf "<input name=bw_period size=4 value='%s'> %s</td> </tr>\n",
	$config{'bw_period'}, $text{'newbw_days'};

# Show email to owner field
print "<tr> <td><b>$text{'newbw_owner'}</b></td> <td>\n";
printf "<input type=radio name=bw_owner value=1 %s> %s\n",
	$config{'bw_owner'} ? "checked" : "", $text{'yes'};
printf "<input type=radio name=bw_owner value=0 %s> %s</td> </tr>\n",
	$config{'bw_owner'} ? "" : "checked", $text{'no'};

# Show email to other address
print "<tr> <td><b>$text{'newbw_email'}</b></td> <td>\n";
printf "<input name=bw_email size=30 value='%s'></td> </tr>\n",
	$config{'bw_email'};

# Show field for notification period
print "<tr> <td><b>$text{'newbw_notify'}</b></td> <td>\n";
printf "<input name=bw_notify size=4 value='%s'> %s</td> </tr>\n",
	$config{'bw_notify'}, $text{'newbw_hours'};

# Show field for disable option
print "<tr> <td><b>$text{'newbw_disable'}</b></td> <td>\n";
printf "<input type=radio name=bw_disable value=1 %s> %s\n",
	$config{'bw_disable'} ? "checked" : "", $text{'yes'};
printf "<input type=radio name=bw_disable value=0 %s> %s</td> </tr>\n",
	$config{'bw_disable'} ? "" : "checked", $text{'no'};

# Show email for domains over limit
$file = $config{'bw_template'};
$file = "$module_config_directory/bw-template" if ($file eq "default");
print "<tr> <td valign=top><b>$text{'newbw_template'}</b></td> <td>\n";
print "<textarea name=bw_template rows=5 cols=70>";
open(FILE, $file);
while(<FILE>) {
	print &html_escape($_);
	}
close(FILE);
print "</textarea></td> </tr>\n";

# Show field for warning percentage
print "<tr> <td><b>$text{'newbw_warn'}</b></td> <td>\n";
printf "<input type=radio name=bw_warn value=1 %s> %s\n",
	$config{'bw_warn'} ? "checked" : "",
	&text('newbw_warnyes',
	"<input name=bw_warnlevel size=4 value='$config{'bw_warn'}'>");
printf "<input type=radio name=bw_warn value=0 %s> %s</td> </tr>\n",
	$config{'bw_warn'} ? "" : "checked", $text{'no'};

# Show email for domains over limit
$file = $config{'warnbw_template'};
$file = "$module_config_directory/warnbw-template" if ($file eq "default");
print "<tr> <td valign=top><b>$text{'newbw_warntemplate'}</b></td> <td>\n";
print "<textarea name=warnbw_template rows=5 cols=70>";
open(FILE, $file);
while(<FILE>) {
	print &html_escape($_);
	}
close(FILE);
print "</textarea></td> </tr>\n";

print "</table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

# Button to show graph
print "<hr>\n";
print &ui_buttons_start();
print &ui_buttons_row("bwgraph.cgi", $text{'newbw_graphbutton'},
				     $text{'newbw_graphdesc'});
print &ui_buttons_end();

&ui_print_footer("", $text{'index_return'});

