#!/usr/local/bin/perl
# create-user.pl
# Adds a new mailbox, based on command-line parameters

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/create-user.pl";
require './virtual-server-lib.pl';
$< == 0 || die "create-user.pl must be run as root";

$user = &create_initial_user();

# Parse command-line args
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--domain") {
		$domain = shift(@ARGV);
		}
	elsif ($a eq "--user") {
		$username = lc(shift(@ARGV));
		}
	elsif ($a eq "--pass") {
		$pass = shift(@ARGV);
		}
	elsif ($a eq "--real") {
		$real = shift(@ARGV);
		}
	elsif ($a eq "--ftp") {
		$ftp = 1;
		}
	elsif ($a eq "--jailed-ftp") {
		$config{'jail_shell'} || usage();
		$ftp = 2;
		}
	elsif ($a eq "--noemail") {
		$noemail++;
		}
	elsif ($a eq "--extra") {
		local $extra = shift(@ARGV);
		push(@extra, $extra);
		}
	elsif ($a eq "--quota") {
		$quota = shift(@ARGV);
		}
	elsif ($a eq "--mail-quota") {
		$mquota = shift(@ARGV);
		}
	elsif ($a eq "--qmail-quota") {
		$qquota = shift(@ARGV);
		}
	}

# Make sure all needed args are set
$domain && $username && $pass || &usage();
if ($user->{'unix'}) {
	if ($config{'home_quotas'}) {
		$quota =~ /^\d+$/ || &usage();
		}
	if ($config{'mail_quotas'} && $config{'home_quotas'} ne $config{'mail_quotas'}) {
		$mquota =~ /^\d+$/ || &usage();
		}
	}
if ($user->{'mailquota'}) {
	!$qquota || $qquota =~ /^\d+$/ || usage();
	}
$d = &get_domain_by("dom", $domain);
$d || die("Virtual server $domain does not exist");
$username =~ /^[^ \t:]+$/ || die($text{'user_euser'});
if ($user->{'person'}) {
	$real =~ /^[^:]*$/ || die($text{'user_ereal'});
	}
foreach $e (@extra) {
	$e = lc($e);
	if ($e =~ /^([^\@ \t]+$)$/) {
		$e = "$e\@$d->{'dom'}";
		}
	if ($e !~ /^(\S+)\@(\S+)$/) {
		die(&text('user_eextra1', $e));
		}
	local ($eu, $ed) = ($1, $2);
	local $edom = &get_domain_by("dom", $ed);
	$edom && $edom->{'mail'} || die(&text('user_eextra2', $ed));
	}

# Build taken lists
&build_taken(\%taken, \%utaken);

# Construct user object
if ($user->{'unix'}) {
	$user->{'uid'} = &allocate_uid(\%taken);
	}
else {
	$user->{'uid'} = $d->{'uid'};
	}
$user->{'gid'} = $d->{'gid'};
if ($user->{'person'}) {
	$user->{'real'} = $real;
	}
if ($user->{'unix'}) {
	$user->{'shell'} = $ftp == 1 ? $config{'ftp_shell'} :
			   $ftp == 2 ? $config{'jail_shell'} :
				       $config{'shell'};
	}
if (!$user->{'fixedhome'}) {
	$user->{'home'} = "$d->{'home'}/$config{'homes_dir'}/$username";
	}
$user->{'passmode'} = 3;
$user->{'plainpass'} = $pass;
$user->{'pass'} = &foreign_call($usermodule, "encrypt_password", $pass);
$user->{'extraemail'} = \@extra;
if (($utaken{$username} || $config{'append'}) && !$user->{'noappend'}) {
	$user->{'user'} = &userdom_name($username, $d);
	}
else {
	$user->{'user'} = $username;
	}
$user->{'email'} = "$username\@$d->{'dom'}" if (!$noemail);
if ($user->{'mailquota'}) {
	$user->{'qquota'} = $qquota;
	}

if ($user->{'unix'}) {
	# Check for a Unix clash
	if ($utaken{$user->{'user'}} ||
	    &check_clash($username, $d->{'dom'})) {
		die($text{'user_eclash'});
		}
	}

# Check for clash within this domain
($clash) = grep { $_->{'user'} eq $username &&
		  $_->{'unix'} == $user->{'unix'} } @users;
$clash && &error($text{'user_eclash2'});

# Check if any extras clash
foreach $e (@extra) {
	$e =~ /^(\S+)\@(\S+)$/;
	if (&check_clash($1, $2)) {
		die(&text('user_eextra4', $e));
		}
	}

# Check if the name is too long
if ($lerr = &too_long($user->{'user'})) {
	die($lerr);
	}

# Create the user and virtusers and alias
&create_user($user, $d);

if ($user->{'home'}) {
	# Create his homedir
	system("mkdir -p '$user->{'home'}'");
	system("chown $user->{'uid'}:$user->{'gid'} '$user->{'home'}'");
	system("chmod 755 '$user->{'home'}'");

	# Copy files into homedir
	&copy_skel_files($config{'mail_skel'}, $user, $user->{'home'});
	}

# Create an empty mail file
&create_mail_file($user);

# Send an email upon creation
@erv = &send_user_email($d, $user);

if ($user->{'unix'}) {
	# Set quotas
	if ($config{'home_quotas'}) {
		&set_quota($user->{'user'}, $config{'home_quotas'}, $quota);
		}
	if ($config{'mail_quotas'} && $config{'home_quotas'} ne $config{'mail_quotas'}) {
		&set_quota($user->{'user'}, $config{'mail_quotas'}, $quota);
		}
	}

print "User $user->{'user'} created successfully\n";

sub usage
{
print "Adds a new mailbox user to an existing Virtualmin domain.\n";
print "\n";
print "usage: create-user.pl    --domain domain.name\n";
print "                         --user new-username\n";
print "                         --pass password-for-new-user\n";
if ($user->{'unix'}) {
	if ($config{'home_quotas'}) {
		print "                         --quota quota-in-blocks\n";
		}
	if ($config{'mail_quotas'} &&
	    $config{'mail_quotas'} ne $config{'home_quotas'}) {
		print "                         --mail-quota quota-in-blocks\n";
		}
	}
if ($user->{'mailquota'}) {
	print "                         --qmail-quota quota-in-bytes\n";
	}
if ($user->{'person'}) {
	print "                        [--real real-name-for-new-user]\n";
	}
if ($user->{'unix'}) {
	print "                        [--ftp]\n";
	if ($config{'jail_ftp'}) {
		print "                        [--jail-ftp]\n";
		}
	}
print "                        [--noemail]\n";
print "                        [--extra email.address\@some.domain]\n";
exit(1);
}
