#!/usr/local/bin/perl
# search.cgi
# Display domains matching some search

require './virtual-server-lib.pl';
&ReadParse();

# If search is by parent, look it up
$oldwhat = $in{'what'};
if (($in{'field'} eq "parent" || $in{'field'} eq "alias") &&
    $in{'what'} !~ /^\d+$/) {
	$pd = &get_domain_by("dom", $in{'what'});
	$in{'what'} = $pd->{'id'} if ($pd);
	}

# Do the search
foreach $d (&list_domains()) {
	next if (!&can_edit_domain($d));
	if ($d->{$in{'field'}} =~ /\Q$in{'what'}\E/i) {
		push(@doms, $d);
		}
	}

&ui_print_header(undef, $text{'search_title'}, "");

if (!@doms) {
	print "<b>",&text('search_none', "<tt>$oldwhat</tt>"),"</b><p>\n";
	}
else {
	print "<b>",&text('search_results', "<tt>$oldwhat</tt>",
			  scalar(@doms)),"</b><p>\n";
	&domains_table(\@doms);
	print "<p>\n";
	}

&ui_print_footer("", $text{'index_return'});

