#!/usr/local/bin/perl
# save_newbw.cgi
# Update bandwidth limit settings

require './virtual-server-lib.pl';
&ReadParse();
&master_admin() || &error($text{'newbw_ecannot'});
&error_setup($text{'newbw_err'});

# Validate inputs
!$in{'bw_past'} || $in{'bw_period'} =~ /^\d+$/ && $in{'bw_period'} > 0 || 
	&error($text{'newbw_eperiod'});
$in{'bw_notify'} =~ /^\d+$/ && $in{'bw_notify'} > 0 || 
	&error($text{'newbw_enotify'});
!$in{'bw_warn'} || ($in{'bw_warnlevel'} > 0 && $in{'bw_warnlevel'} <= 100) ||
	&error($text{'newbw_ewarn'});

# Save configuration and create cron job
$config{'bw_active'} = $in{'bw_active'};
$config{'bw_past'} = $in{'bw_past'};
$config{'bw_period'} = $in{'bw_period'};
$config{'bw_notify'} = $in{'bw_notify'};
$config{'bw_owner'} = $in{'bw_owner'};
$config{'bw_email'} = $in{'bw_email'};
$config{'bw_disable'} = $in{'bw_disable'};
$config{'bw_warn'} = $in{'bw_warn'} ? $in{'bw_warnlevel'} : undef;
&lock_file($module_config_file);
$config{'last_check'} = time()+1;	# no need for check.cgi to be run
&write_file($module_config_file, \%config);
&unlock_file($module_config_file);

# Save main template
$file = $config{'bw_template'};
$file = "$module_config_directory/bw-template" if ($file eq 'default');
$in{'bw_template'} =~ s/\r//g;
&lock_file($file);
open(FILE, ">$file") || &error(&text('efilewrite', $file, $!));
print FILE $in{'bw_template'};
close(FILE);
&unlock_file($file);

# Save warning template
$file = $config{'warnbw_template'};
$file = "$module_config_directory/warnbw-template" if ($file eq 'default');
$in{'warnbw_template'} =~ s/\r//g;
&lock_file($file);
open(FILE, ">$file") || &error(&text('efilewrite', $file, $!));
print FILE $in{'warnbw_template'};
close(FILE);
&unlock_file($file);

$job = &find_bandwidth_job();
if ($job) {
	&lock_file(&cron::cron_file($job));
	&cron::delete_cron_job($job);
	}
if ($in{'bw_active'}) {
	$job = { 'user' => 'root',
		 'command' => $bw_cron_cmd,
		 'active' => 1,
		 'mins' => '0',
		 'hours' => '*',
		 'days' => '*',
		 'weekdays' => '*',
		 'months' => '*' };
	&lock_file(&cron::cron_file($job));
	&cron::create_wrapper($bw_cron_cmd, $module_name, "bw.pl");
	&cron::create_cron_job($job);
	}
&unlock_all_files();

&webmin_log("newbw");
&redirect("");

