#!/usr/local/bin/perl
# cert_form.cgi
# Show a form for requesting a CSR, or installing a cert

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
&foreign_require("webmin", "webmin-lib.pl");
&ui_print_header(&domain_in($d), $text{'cert_title'}, "");

# Details of current cert
print "$text{'cert_desc2'}<p>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'cert_header2'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
$info = &cert_info($d);
foreach $i ('cn', 'o', 'issuer_cn', 'issuer_o', 'notafter', 'type') {
	if ($info->{$i}) {
		print "<tr>\n" if ($j%2 == 0);
		print "<td><b>",$text{'cert_'.$i},"</b></td>\n";
		print "<td>",$info->{$i},"</td>\n";
		print "</tr>\n" if ($j++%2 == 1);
		}
	}
print "</table></td></tr></table>\n";

print "<hr>\n";

# CSR generation form
print "$text{'cert_desc1'}<p>\n";

print "<form action=csr.cgi>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'cert_header1'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$webmin::text{'ssl_cn'}</b></td>\n";
printf "<td><input name=commonName size=30 value='%s'></td> </tr>\n",
	"www.$d->{'dom'}";

print "<tr> <td><b>$webmin::text{'ca_email'}</b></td>\n";
printf "<td><input name=emailAddress size=30 value='%s'></td> </tr>\n",
	$d->{'email'} || $d->{'user'}.'@'.$d->{'dom'};

print "<tr> <td><b>$webmin::text{'ca_ou'}</b></td>\n";
print "<td><input name=organizationalUnitName size=30></td> </tr>\n";

print "<tr> <td><b>$webmin::text{'ca_o'}</b></td>\n";
printf "<td><input name=organizationName size=30 value='%s'></td> </tr>\n",
	$d->{'owner'};

print "<tr> <td><b>$webmin::text{'ca_sp'}</b></td>\n";
print "<td><input name=stateOrProvinceName size=15></td> </tr>\n";

print "<tr> <td><b>$webmin::text{'ca_c'}</b></td>\n";
print "<td><input name=countryName size=2></td> </tr>\n";

print "<tr> <td><b>$webmin::text{'ssl_size'}</b></td>\n";
print "<td><input type=radio name=size_def value=1 checked> ",
      "$text{'default'} ($webmin::default_key_size)\n";
print "<input type=radio name=size_def value=0> ",
      "$text{'ssl_custom'}\n";
print "<input name=size size=6> $text{'ssl_bits'}</td> </tr>\n";

print "<tr> <td><b>$webmin::text{'ssl_days'}</b></td>\n";
print "<td><input name=days size=8 value='1825'></td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'cert_csrok'}'></form>\n";

print "<hr>\n";

# New key and cert form
print "$text{'cert_desc3'}<p>\n";

print "<form action=newkey.cgi method=post>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'cert_header3'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td valign=top><b>$text{'cert_cert'}</b></td>\n";
print "<td><textarea name=cert rows=8 cols=70></textarea></td> </tr>\n";

if (-r $d->{'ssl_newkey'}) {
	$newkey = `cat $d->{'ssl_newkey'}`;
	}
print "<tr> <td valign=top><b>$text{'cert_newkey'}</b></td>\n";
print "<td><textarea name=newkey rows=8 cols=70>$newkey</textarea></td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'cert_newok'}'></form>\n";

&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});

