#!/usr/local/bin/perl
# list_users.cgi
# Display all users in the database

require './postgresql-lib.pl';
$access{'users'} || &error($text{'user_ecannot'});
&ui_print_header(undef, $text{'user_title'}, "", "list_users");

$s = &execute_sql($config{'basedb'}, "select * from pg_shadow");
print "<a href='edit_user.cgi?new=1'>$text{'user_add'}</a><br>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'user_name'}</b></td> ",
      "<td><b>$text{'user_pass'}</b></td> ",
      "<td><b>$text{'user_db'}</b></td> ",
      "<td><b>$text{'user_other'}</b></td> ",
      "<td><b>$text{'user_until'}</b></td> </tr>\n";
foreach $u (@{$s->{'data'}}) {
	print "<tr $cb>\n";
	print "<td><a href='edit_user.cgi?user=$u->[0]'>",
	      &html_escape($u->[0]),"</a></td>\n";
	print "<td>",$u->[5] ? $text{'yes'} : $text{'no'},"</td>\n";
	print "<td>",$u->[2] =~ /t|1/ ? $text{'yes'} : $text{'no'},"</td>\n";
	print "<td>",$u->[4] =~ /t|1/ ? $text{'yes'} : $text{'no'},"</td>\n";
	print "<td>",$u->[7] ? &html_escape($u->[7])
			     : $text{'user_forever'},"</td>\n";
	print "</tr>\n";
	}
print "</table>\n";
print "<a href='edit_user.cgi?new=1'>$text{'user_add'}</a><p>\n";

if (&get_postgresql_version() >= 7) {
	print "<hr>\n";
	print "<form action=save_sync.cgi>\n";
	print "$text{'user_sync'}<br>\n";
	print "<table><tr><td valign=top>\n";
	printf "<input type=checkbox name=sync_create value=1 %s> %s<br>\n",
		$config{'sync_create'} ? "checked" : "",
		$text{'user_sync_create'};
	printf "<input type=checkbox name=sync_modify value=1 %s> %s<br>\n",
		$config{'sync_modify'} ? "checked" : "",
		$text{'user_sync_modify'};
	printf "<input type=checkbox name=sync_delete value=1 %s> %s<br>\n",
		$config{'sync_delete'} ? "checked" : "",
		$text{'user_sync_delete'};
	}

print "</td> </tr></table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

&ui_print_footer("", $text{'index_return'});

