#!/usr/local/bin/perl
# Add needed firewall rules and syslog entry, and apply configurations

require './bandwidth-lib.pl';
&ReadParse();
$access{'setup'} || &error($text{'setup_ecannot'});

# Add missing firewall rules
local $main::error_must_die = 1;
eval { @tables = &firewall::get_iptables_save(); };
$main::error_must_die = 0;
if ($@) {
	# Firewall setup is bogus! Zap it ..
	unlink($firewall::iptables_save_file);
	@tables = &firewall::get_iptables_save();
	}

($filter) = grep { $_->{'name'} eq 'filter' } @tables;
$filter ||= { 'name' => 'filter',
	      'defaults' => { 'INPUT' => 'ACCEPT',
			      'OUTPUT' => 'ACCEPT',
			      'FORWARD' => 'ACCEPT' },
	      'rules' => [ ],
	    };
$inrule = &find_rule($filter, "INPUT", $config{'iface'}, "i");
$outrule = &find_rule($filter, "OUTPUT", $config{'iface'}, "o");
$fwdinrule = &find_rule($filter, "FORWARD", $config{'iface'}, "i");
$fwdoutrule = &find_rule($filter, "FORWARD", $config{'iface'}, "o");
$missingrule = !$inrule || !$outrule || !$fwdinrule || !$fwdoutrule;
if (!$inrule) {
	splice(@{$filter->{'rules'}}, 0, 0,
	       { 'chain' => 'INPUT',
		 'j' => [ undef, 'LOG' ],
		 'i' => [ undef, $in{'iface'} ],
		 'args' => "--log-level 7 --log-prefix BANDWIDTH_IN:" });
	}
if (!$outrule) {
	splice(@{$filter->{'rules'}}, 0, 0,
	       { 'chain' => 'OUTPUT',
		 'j' => [ undef, 'LOG' ],
		 'o' => [ undef, $in{'iface'} ],
		 'args' => "--log-level 7 --log-prefix BANDWIDTH_OUT:" });
	}
if (!$fwdinrule) {
	splice(@{$filter->{'rules'}}, 0, 0,
	       { 'chain' => 'FORWARD',
		 'j' => [ undef, 'LOG' ],
		 'i' => [ undef, $in{'iface'} ],
		 'args' => "--log-level 7 --log-prefix BANDWIDTH_IN:" });
	}
if (!$fwdoutrule) {
	splice(@{$filter->{'rules'}}, 0, 0,
	       { 'chain' => 'FORWARD',
		 'j' => [ undef, 'LOG' ],
		 'o' => [ undef, $in{'iface'} ],
		 'args' => "--log-level 7 --log-prefix BANDWIDTH_OUT:" });
	}
if ($missingrule) {
	# Save and apply
	&lock_file($firewall::iptables_save_file);
	&firewall::run_before_command();
	&firewall::save_table($filter);
	&firewall::run_after_command();
	&unlock_file($firewall::iptables_save_file);
	if (defined(&firewall::apply_iptables)) {
		$err = &firewall::apply_iptables();
		}
	else {
		$err = &firewall::iptables_restore();
		}
	&error($err) if ($err);
	}

# Add syslog entry
$conf = &syslog::get_config();
$sysconf = &find_sysconf($conf);
if (!$sysconf) {
	&lock_file($syslog::config{'syslog_conf'});
	&syslog::create_log({ 'file' => $bandwidth_log,
			      'active' => 1,
			      'sel' => [ "kern.=debug" ] });
	&unlock_file($syslog::config{'syslog_conf'});
	$err = &syslog::restart_syslog();
	&error($err) if ($err);
	}

# Save the interface
&lock_file($module_config_file);
$config{'iface'} = $in{'iface'};
&save_module_config();
&unlock_file($module_config_file);

# Setup the rotation cron job
$job = &find_cron_job();
if (!$job) {
	&cron::create_wrapper($cron_cmd, $module_name, "rotate.pl");
	$job = { 'user' => 'root',
		 'active' => 1,
		 'command' => $cron_cmd,
		 'mins' => '0',
		 'hours' => '*',
		 'days' => '*',
		 'months' => '*',
		 'weekdays' => '*',
		};
	&lock_file(&cron::cron_file($job));
	&cron::create_cron_job($job);
	&unlock_file(&cron::cron_file($job));
	}

&webmin_log("setup", undef, $in{'iface'});
&redirect("");

