#!/usr/local/bin/perl
# restart.cgi
# Send a SIGHUP to apache

require './apache-lib.pl';
&ReadParse();
&error_setup($text{'restart_err'});

$access{'apply'} || &error($text{'restart_ecannot'});
$conf = &get_config();
$pidfile = &get_pid_file();

if ($config{'test_config'}) {
	$err = &test_config();
	&error("<pre>$err</pre>") if ($err);
	}
$err = &restart_apache();
&error($err) if ($err);

# Check if restart was successful.. some config file error may have caused it
# to silently fail
sleep(1);
if (!open(PID, $pidfile) || <PID> !~ /(\d+)/ || !kill(0, $1)) {
	# Not running..  find out why
	$errorlogstr = &find_directive_struct("ErrorLog", $conf);
	$errorlog = $errorlogstr ? $errorlogstr->{'words'}->[0]
				 : "logs/error_log";
	if ($errorlog eq 'syslog' || $errorlog =~ /^\|/) {
		&error($text{'restart_eunknown'});
		}
	else {
		$errorlog = &server_root($errorlog, $conf);
		$out = `tail -5 $errorlog`;
		&error("<pre>$out</pre>");
		}
	}
&webmin_log("apply");
&redirect($in{'redir'});

