#!/usr/local/bin/perl
# mailq_search.cgi
# Display some messages from the mail queue

require './sendmail-lib.pl';
require './boxes-lib.pl';
&ReadParse();
$access{'mailq'} || &error($text{'mailq_ecannot'});
&ui_print_header(undef, $text{'searchq_title'}, "");

# Get all of the queued messages that this user can see
$conf = &get_sendmailcf();
foreach $mqueue (&mailq_dir($conf)) {
	opendir(QDIR, $mqueue);
	push(@qfiles, map { "$mqueue/$_" } grep { /^qf/ } readdir(QDIR));
	closedir(QDIR);
	}
@qmails = grep { &can_view_qfile($_) }
	       map { $qf = $_;
		     ($df = $qf) =~ s/\/qf/\/df/;
		     &mail_from_queue($qf, $df) } @qfiles;

# Do the search
$fields = [ [ $in{'field'}, $in{'match'} ] ];
@qmails = grep { &mail_matches($fields, 1, $_) } @qmails;
print "<p><b>",&text($in{'field'} =~ /^\!/ ? 'search_results3' :
	  'search_results2', scalar(@qmails), "<tt>$in{'match'}</tt>"),"</b><p>\n";

if (@qmails) {
	print "<form action=del_mailqs.cgi method=post>\n";
	if ($config{'top_buttons'}) {
		if ($access{'mailq'} == 2) {
			print "<input type=submit value='$text{'mailq_delete'}'>\n";
			print "<input type=checkbox name=locked value=1> $text{'mailq_locked'}<p>\n";
			}
		print &select_all_link("file", 0, $text{'mail_all'}),"&nbsp;\n";
		print &select_invert_link("file", 0, $text{'mail_invert'}),"<br>\n";
		}
	print "<table border width=100%>\n";
	print "<tr $tb> ";
	if ($access{'mailq'} == 2) {
		print "<td><br></td> ";
		}
	foreach $s (split(/,/, $config{'mailq_show'})) {
		$show{$s}++;
		}
	print "<td><b>$text{'mailq_id'}</b></td>\n";
	print "<td><b>$text{'mailq_sent'}</b></td>\n" if ($show{'Date'});
	print "<td><b>$text{'mailq_from'}</b></td>\n" if ($show{'From'});
        print "<td><b>$text{'mailq_to'}</b></td>\n" if ($show{'To'});
        print "<td><b>$text{'mailq_cc'}</b></td>\n" if ($show{'Cc'});
        print "<td><b>$text{'mailq_subject'}</b></td>\n" if ($show{'Subject'});
        print "<td><b>$text{'mailq_size'}</b></td>\n" if ($show{'Size'});
	print "<td><b>$text{'mailq_status'}</b></td>\n" if ($show{'Status'});
	print "</tr>\n";
	foreach $mail (@qmails) {
		local $f = $mail->{'file'};
		($n = $f) =~ s/^.*\///;
		$mail->{'header'}->{'from'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'to'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'date'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'subject'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'cc'} ||= "&nbsp;";
		$mail->{'status'} ||= $text{'mailq_sending'};

		$mail->{'header'}->{'from'} =
			&html_escape($mail->{'header'}->{'from'});
		$mail->{'header'}->{'to'} =
			&html_escape($mail->{'header'}->{'to'});
		$mail->{'header'}->{'date'} =~ s/\+.*//g;

		($d = $f) =~ s/\/qf/\/df/;
		if ($mail->{'size'} > 1000000) {
			$size = int($mail->{'size'} / 1000000)." MB";
			}
		elsif ($mail->{'size'} > 1000) {
			$size = int($mail->{'size'} / 1000)." kB";
			}
		else {
			$size = "$mail->{'size'} b";
			}
		print "<tr $cb>\n";
		if ($access{'mailq'} == 2) {
			print "<td><input type=checkbox name=file ",
			      "value=$f></td>\n";
			print "<td><a href=\"view_mailq.cgi?",
			      "file=$f\">$n</a></td>\n";
			}
		else {
			print "<td><font size=1>$n</font></td>\n";
			}
		print "<td><font size=1>$mail->{'header'}->{'date'}</font></td>\n" if ($show{'Date'});
		print "<td><font size=1>$mail->{'header'}->{'from'}</font></td>\n" if ($show{'From'});
		print "<td><font size=1>$mail->{'header'}->{'to'}</font></td>\n" if ($show{'To'});
		print "<td><font size=1>$mail->{'header'}->{'cc'}</font></td>\n" if ($show{'Cc'});
		print "<td><font size=1>$mail->{'header'}->{'subject'}</font></td>\n" if ($show{'Subject'});
		print "<td><font size=1>$size</font></td>\n" if ($show{'Size'});
		print "<td><font size=1>$mail->{'status'}</font></td>\n" if ($show{'Status'});
		print "</tr>\n";
		}
	print "</table>\n";
	print &select_all_link("file", 0, $text{'mail_all'}),"&nbsp;\n";
	print &select_invert_link("file", 0, $text{'mail_invert'}),"<p>\n";
	if ($access{'mailq'} == 2) {
		print "<input type=submit value='$text{'mailq_delete'}'>\n";
		print "<input type=checkbox name=locked value=1> $text{'mailq_locked'}<p>\n";
		}
	print "</form>\n";
	}
else {
	print "<b>$text{'searchq_none'}</b> <p>\n";
	}

&ui_print_footer("list_mailq.cgi", $text{'mailq_return'},
	"", $text{'index_return'});

