/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef NOTIFYDIALOG_H
#define NOTIFYDIALOG_H

#include "commanddialog.h"

/**
* Dialog for executing the <tt>NOTIFY FOLDER</tt> and <tt>NOTIFY ISSUE</tt>
* commands.
*/
class NotifyDialog : public CommandDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    NotifyDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~NotifyDialog();

public:
    /**
    * Execute the command for a single folder.
    *
    * @param folderId The identifier of the folder.
    *
    * @param notify @c true to enable, @c false to disable notification.
    *
    * @return @c true if command was initiated.
    */
    bool notifyFolder( int folderId, bool notify );

    /**
    * Execute the command for a single issue.
    *
    * @param issueId The identifier of the issue.
    *
    * @param notify @c true to enable, @c false to disable notification.
    *
    * @return @c true if command was initiated.
    */
    bool notifyIssue( int issueId, bool notify );

public:
    /**
    * Make sure that notification preferences are valid.
    *
    * @param parent Widget used as parent for the error message.
    *
    * @return @c true if preferences are valid or user accepted the warning.
    */
    static bool checkPreferences( QWidget* parent );

public: // overrides
    void accept();
};

#endif
