/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "notifybatch.h"

#include "commands/command.h"
#include "commands/commandmanager.h"
#include "datamanager.h"

NotifyBatch::NotifyBatch() : AbstractBatch( 0 ),
    m_update( false )
{
}

NotifyBatch::~NotifyBatch()
{
}

void NotifyBatch::notifyFolder( int folderId, bool notify )
{
    Job job( &NotifyBatch::notifyFolderJob );
    job.addArg( folderId );
    job.addArg( notify ? 1 : 0 );
    m_queue.addJob( job );
}

void NotifyBatch::notifyIssue( int issueId, bool notify )
{
    Job job( &NotifyBatch::notifyIssueJob );
    job.addArg( issueId );
    job.addArg( notify ? 1 : 0 );
    m_queue.addJob( job );
}

Command* NotifyBatch::fetchNext()
{
    if ( m_queue.moreJobs() )
        return m_queue.callJob( this );

    if ( m_update ) {
        m_update = false;
        return dataManager->updateNotifications();
    }

    return NULL;
}

Command* NotifyBatch::notifyFolderJob( const Job& job )
{
    Command* command = new Command();

    command->setKeyword( "NOTIFY FOLDER" );
    command->addArg( job.argInt( 0 ) );
    command->addArg( job.argInt( 1 ) );

    command->setAcceptNullReply( true );
    command->addRule( "OK", ReplyRule::One );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( setUpdate() ) );

    return command;
}

Command* NotifyBatch::notifyIssueJob( const Job& job )
{
    Command* command = new Command();

    command->setKeyword( "NOTIFY ISSUE" );
    command->addArg( job.argInt( 0 ) );
    command->addArg( job.argInt( 1 ) );

    command->setAcceptNullReply( true );
    command->addRule( "OK", ReplyRule::One );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( setUpdate() ) );

    return command;
}

void NotifyBatch::setUpdate()
{
    m_update = true;
}
