/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef METADATADIALOGS_H
#define METADATADIALOGS_H

#include "metadatadialogbase.h"

class QButtonGroup;
class QSpinBox;
class QLineEdit;

class EditListBox;

/**
* Dialog for editing <tt>TEXT</tt> attribute definition metadata.
*/
class TextMetadataDialog : public MetadataDialogBase
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    TextMetadataDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~TextMetadataDialog();

protected: // overrides
    void updateWidgets( const DefinitionInfo& info );

    bool updateMetadata( DefinitionInfo& info );

private:
    QButtonGroup* m_lengthGroup;
    QSpinBox* m_lengthSpin;
};

/**
* Dialog for editing <tt>ENUM</tt> attribute definition metadata.
*/
class EnumMetadataDialog : public MetadataDialogBase
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    EnumMetadataDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~EnumMetadataDialog();

protected: // overrides
    void updateWidgets( const DefinitionInfo& info );

    bool updateMetadata( DefinitionInfo& info );

private:
    QButtonGroup* m_editableGroup;

    EditListBox* m_itemsListBox;
};

/**
* Dialog for editing <tt>NUMERIC</tt> attribute definition metadata.
*/
class NumericMetadataDialog : public MetadataDialogBase
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    NumericMetadataDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~NumericMetadataDialog();

protected: // overrides
    void updateWidgets( const DefinitionInfo& info );

    bool updateMetadata( DefinitionInfo& info );

private:
    QSpinBox* m_decimalSpin;

    QButtonGroup* m_minGroup;
    QLineEdit* m_minEdit;

    QButtonGroup* m_maxGroup;
    QLineEdit* m_maxEdit;
};

/**
* Dialog for editing <tt>DATETIME</tt> attribute definition metadata.
*/
class DateTimeMetadataDialog : public MetadataDialogBase
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    DateTimeMetadataDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~DateTimeMetadataDialog();

protected: // overrides
    void updateWidgets( const DefinitionInfo& info );

    bool updateMetadata( DefinitionInfo& info );

private:
    QButtonGroup* m_timeGroup;
};

/**
* Dialog for editing <tt>USER</tt> attribute definition metadata.
*/
class UserMetadataDialog : public MetadataDialogBase
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    UserMetadataDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~UserMetadataDialog();

protected: // overrides
    void updateWidgets( const DefinitionInfo& info );

    bool updateMetadata( DefinitionInfo& info );

private:
    QButtonGroup* m_membersGroup;
};

#endif
