/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SSLCERTIFICATESDIALOG_H
#define SSLCERTIFICATESDIALOG_H

#if defined( HAVE_OPENSSL )

#include <QDialog>
#include <QSslCertificate>

class QListWidget;

class PropertyPanel;

/**
* Dialog for showing SSL connection certificates.
*/
class SslCertificatesDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    SslCertificatesDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~SslCertificatesDialog();

public:
    /**
    * Set the list of certificates to display.
    */
    void setCertificates( const QList<QSslCertificate>& certificates );

private slots:
    void showCertificate( int index );

private:
    QString formatDate( const QDateTime& dateTime );
    QString formatBinary( const QByteArray& binary );

private:
    QList<QSslCertificate> m_certificates;

    QListWidget* m_list;

    PropertyPanel* m_subjectPanel;
    PropertyPanel* m_issuerPanel;
    PropertyPanel* m_detailsPanel;
};

#endif // defined( HAVE_OPENSSL )

#endif
