/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef STARTPAGE_H
#define STARTPAGE_H

#include <QWidget>

#include "models/bookmarksettings.h"

class QLabel;
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QMenu;

namespace WebIssues
{

/**
* Page displayed in the main window in disconnected state.
*/
class StartPage : public QWidget
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    StartPage( QWidget* parent );

    /**
    * Destructor.
    */
    ~StartPage();

public:
    /**
    * Switch between connecting and regular mode.
    */
    void setConnecting( bool connecting );

signals:
    /**
    * Emitted when the Open Connection option is selected.
    */
    void openConnection( const Bookmark& bookmark );

    /**
    * Emitted when the Edit Connection option is selected.
    */
    void editConnection( const Bookmark& bookmark );

    /**
    * Emitted when the New Connection button is clicked.
    */
    void newConnection();

    /**
    * Emitted when the Abort button is clicked.
    */
    void abort();

private:
    void populateList();

private slots:
    void itemActivated( QListWidgetItem* item );
    void listContextMenu( const QPoint& pos );

    void open();
    void edit();
    void remove();

private:
    BookmarkSettings m_settings;

    QListWidget* m_list;

    QPushButton* m_newButton;
    QPushButton* m_abortButton;

    QMenu* m_menu;
};

}

#endif
