/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef HTMLWATCHWRITER_H
#define HTMLWATCHWRITER_H

#include "data/staterows.h"

class QTextBrowser;

namespace WebIssues
{

/**
* Class for writing the watches dashboard in HTML format.
*
* This class is responsible for creating the style sheet, adding HTML markup and writing
* the watches dashboard into a QTextBrowser.
*/
class HTMLWatchWriter
{
public:
    /**
    * Constuctor.
    *
    * @param browser The text browser to output the dashboard to.
    */
    HTMLWatchWriter( QTextBrowser* browser );

    /**
    * Destructor.
    */
    ~HTMLWatchWriter();

public:
    /**
    * Begin the document.
    */
    void begin();

    /**
    * End the document.
    */
    void end();

    /**
    * Write a project header.
    */
    void writeProjectHeader( const QString& name );

    /**
    * Write a folder header.
    */
    void writeFolderHeader( const QString& name );

    /**
    * Write a table row with watch status.
    */
    void writeWatchRow( const QString& linkCell, const QString& totalCell, const QString& newCell, const QString& updatedCell );

public:
    /**
    * Add HTML markup to a project or folder name.
    */
    static QString name( const QString& text );

    /**
    * Format a cell with link to a folder watch.
    */
    static QString linkCell( int folderId, const QString& watch, const QString& name );

    /**
    * Format a cell with watch status.
    */
    static QString watchCell( const QString& text, WatchState state, int count );

private:
    QTextBrowser* m_browser;

    QString m_html;
};

}

#endif
