/**************************************************************************
* Generic, native, relational database
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef TABLEDATA_H
#define TABLEDATA_H

#include "rowbase.h"

namespace RDB
{

class TableData
{
private:
    struct Bucket;
    struct Link;

public:
    TableData();
    ~TableData();

public:
    void initialize( uint dim, uint size );

    void clear();

    Bucket* allocBucket( uint dims );
    void freeBucket( Bucket* bucket );

    void linkBucket( Bucket* bucket );
    void unlinkBucket( Bucket* bucket );

    Bucket* findBucket( int key ) const;
    Bucket* findBucket( int key, uint otherDim, int otherKey ) const;

    Row* find( int key ) const;
    Row* find( int key, uint otherDim, int otherKey ) const;

private:
    struct Bucket;

    struct Link
    {
        Bucket* m_prev;
        Bucket* m_next;
    };

    struct Bucket
    {
        Row* m_row;
        Link m_links[ 1 ];
    };

    uint m_dim;
    uint m_size;
    Bucket** m_buckets;

    friend class TableCore;
    friend class IndexIteratorCore;
    friend class ForeignIteratorCore;
};

}

#endif
