#!/bin/sh
#
# Script to generate $C_FILE
#

ECHO=/usr/bin/printf

#MINUS_e=X`$ECHO -n -e`
#if [ $MINUS_e != "X" ] ; then
#	MINUS_e=""
#else
#	MINUS_e="-e"
#fi

#MINUS_E=X`$ECHO -n -E`
#if [ $MINUS_E != "X" ] ; then
#	MINUS_E=""
#else
#	MINUS_E="-E"
#fi


CUR_DIR=`pwd`
C_FILE="$CUR_DIR/modules_init.c"
H_FILE="$CUR_DIR/modules_init.h"
MOD_FILE="$CUR_DIR/Make_modules"
SRC_FILE="$CUR_DIR/Make_sources"
U_FILE="$CUR_DIR/modules_upgrade.c"

/usr/bin/printf "Scanning extension modules for entry points.\n"

rm -f $C_FILE $H_FILE

# server lifetime:
START_FUNCS=`grep ServerStartModule_ *.c |sed "s;.*:;;" |sort -u`
INIT_FUNCS=`grep InitModule_ *.c |sed "s;.*:;;" |sort -u`
INIT2_FUNCS=`grep InitModule2_ *.c |sed "s;.*:;;" |sort -u`
FINALIZE_FUNCS=`grep FinalizeModule_ *.c |sed "s;.*:;;" |sort -u`
SHUTDOWN_FUNCS=`grep ServerShutdownModule_ *.c |sed "s;.*:;;" |sort -u`

# session hooks:
SESS_NEW_FUNCS=`grep SessionNewModule_ *.c |sed "s;.*:;;" |sort -u`
SESS_ATTACH_FUNCS=`grep SessionAttachModule_ *.c |sed "s;.*:;;" |sort -u`
SESS_DETACH_FUNCS=`grep SessionDetachModule_ *.c |sed "s;.*:;;" |sort -u`
SESS_DESTROY_FUNCS=`grep SessionDestroyModule_ *.c |sed "s;.*:;;" |sort -u`

HTTP_NEW_FUNCS=`grep HttpNewModule_ *.c |sed "s;.*:;;" |sort -u`
HTTP_DETACH_FUNCS=`grep HttpDetachModule_ *.c |sed "s;.*:;;" |sort -u`
HTTP_DESTROY_FUNCS=`grep HttpDestroyModule_ *.c |sed "s;.*:;;" |sort -u`


#SESS_NEW_FUNCS=`grep SessionNewModule_ *.c |sed "s;.*:;;" |sort -u`


#start the header file
cat <<EOF > $H_FILE
/* 
 * $H_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */


#ifndef MODULES_INIT_H
#define MODULES_INIT_H
extern size_t nSizErrmsg;


/* 
 * server lifetime: 
 */
void initialise_modules (void);
void initialise2_modules (void);
void start_modules (void);
void shutdown_modules (void);


/*
 * Session lifetime:
 */
void session_new_modules (wcsession *sess);
void session_attach_modules (wcsession *sess);
void session_detach_modules (wcsession *sess);
void session_destroy_modules (wcsession **sess);

void http_new_modules (ParsedHttpHdrs *httpreq);
void http_detach_modules (ParsedHttpHdrs *httpreq);
void http_destroy_modules (ParsedHttpHdrs *httpreq);



/*
 * forwards...
 */

EOF


#start of the files which inturn removes any existing file
#

# start the Makefile included file for $SERV_MODULES
cat <<EOF  >$MOD_FILE
#
# Make_modules
# This file is to be included by Makefile to dynamically add modules to the build process
# THIS FILE WAS AUTO GENERATED BY mk_modules_init.sh DO NOT EDIT THIS FILE
#

EOF

# start the Makefile included file for $SOURCES
cat <<EOF  >$SRC_FILE
#
# Make_sources
# This file is to be included by Makefile to dynamically add modules to the build process
# THIS FILE WAS AUTO GENERATED BY mk_modules_init.sh DO NOT EDIT THIS FILE
#

EOF

# start the c file
cat <<EOF  >$C_FILE
/*
 * $C_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */



#include "sysdep.h"
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <libcitadel.h>
#include "webcit.h"
#include "modules_init.h"
#include "webserver.h"

void LogPrintMessages(long err);
extern long DetailErrorFlags;

void start_modules (void)
{
EOF
#********************************************************************************
# server  ******** start ********  module logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Server Start Hooks: */
EOF
for HOOK in $START_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;ServerStartModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Starting $HOOKNAME\n");
#endif
	$HOOK();
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(void);
EOF
done


#********************************************************************************
# server module  ******** initialisation ********  logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Server Init Hooks: */
EOF

cat <<EOF  >>$C_FILE
}


void initialise_modules (void)
{

EOF
for HOOK in $INIT_FUNCS; do
    HOOKNAME=`echo $HOOK |sed "s;InitModule_;;"`
# Add this entry point to the .c file
    cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Initializing $HOOKNAME\n");
#endif
	$HOOK();
EOF
# Add this entry point to the .h file
    cat <<EOF >> $H_FILE
extern void $HOOK(void);
EOF
done

#********************************************************************************
# server module  ******** initialisation ********  second stage.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Server Init Hooks: */
EOF

cat <<EOF  >>$C_FILE
}


void initialise2_modules (void)
{

EOF
for HOOK in $INIT2_FUNCS; do
    HOOKNAME=`echo $HOOK |sed "s;InitModule2_;;"`
# Add this entry point to the .c file
    cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Initializing $HOOKNAME\n");
#endif
	$HOOK();
EOF
# Add this entry point to the .h file
    cat <<EOF >> $H_FILE
extern void $HOOK(void);
EOF
done



#********************************************************************************
# server module    ***** shutdown *****  logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Server shutdown Hooks: */
EOF
cat <<EOF  >>$C_FILE
}


void shutdown_modules (void)
{

EOF
for HOOK in $SHUTDOWN_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;ServerShutdownModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Shutting down $HOOKNAME\n");
#endif
	$HOOK();
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(void);
EOF
done




#********************************************************************************
# NEW-session module logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Session New Hooks: */
EOF
cat <<EOF  >>$C_FILE
}


void session_new_modules (wcsession *sess)
{

EOF
for HOOK in $SESS_NEW_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;SessionNewModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Initializing $HOOKNAME\n");
#endif
	$HOOK(sess);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(wcsession *sess);
EOF
done



#********************************************************************************
# ATTACH-Session module logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Session Attach Hooks: */
EOF
cat <<EOF  >>$C_FILE
}


void session_attach_modules (wcsession *sess)
{

EOF
for HOOK in $SESS_ATTACH_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;SessionAttachModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Attaching Session; $HOOKNAME\n");
#endif
	$HOOK(sess);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(wcsession *sess);
EOF
done



#********************************************************************************
# DETACH-Session module logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Session detach Hooks: */
EOF
cat <<EOF  >>$C_FILE
}


void session_detach_modules (wcsession *sess)
{

EOF
for HOOK in $SESS_DETACH_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;SessionDetachModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Initializing $HOOKNAME\n");
#endif
	$HOOK(sess);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(wcsession *sess);
EOF
done




#********************************************************************************
# DESTROY-Session module logic.
#********************************************************************************
cat <<EOF >> $H_FILE

/* Session destroy Hooks: */
EOF
cat <<EOF  >>$C_FILE
}


void session_destroy_modules (wcsession **sess)
{

EOF
for HOOK in $SESS_DESTROY_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;SessionDestroyModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Initializing $HOOKNAME\n");
#endif
	$HOOK(*sess);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(wcsession *sess);
EOF
done


cat <<EOF  >>$C_FILE
	free((*sess));
	(*sess) = NULL;
}


EOF





#********************************************************************************
# NEW-Httprequest module logic.
#********************************************************************************
cat <<EOF >> $C_FILE

void http_new_modules (ParsedHttpHdrs *httpreq)
{
EOF

for HOOK in $HTTP_NEW_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;HttpNewModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "NEW $HOOKNAME\n");
#endif
	$HOOK(httpreq);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(ParsedHttpHdrs *httpreq);
EOF
done

cat <<EOF  >>$C_FILE
}
EOF

#********************************************************************************
# DETACH-Httprequest module logic.
#********************************************************************************
cat <<EOF >> $C_FILE

void http_detach_modules (ParsedHttpHdrs *httpreq)
{
EOF

for HOOK in $HTTP_DETACH_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;HttpDetachModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Detaching $HOOKNAME\n");
#endif
	$HOOK(httpreq);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(ParsedHttpHdrs *httpreq);
EOF
done

cat <<EOF  >>$C_FILE
}
EOF


#********************************************************************************
# DESTROY-Httprequest module logic.
#********************************************************************************
cat <<EOF >> $C_FILE

void http_destroy_modules (ParsedHttpHdrs *httpreq)
{
EOF

for HOOK in $HTTP_DESTROY_FUNCS; do
HOOKNAME=`echo $HOOK |sed "s;HttpDestroyModule_;;"`
# Add this entry point to the .c file
cat <<EOF >> $C_FILE
#ifdef DBG_PRINNT_HOOKS_AT_START
	syslog(CTDL_INFO, "Destructing $HOOKNAME\n");
#endif
	$HOOK(httpreq);
EOF
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
extern void $HOOK(ParsedHttpHdrs *httpreq);
EOF
done

cat <<EOF  >>$C_FILE
}
EOF







cat <<EOF  >> $H_FILE

#endif /* MODULES_INIT_H */

EOF
