#!/usr/bin/env runhaskell
arch-tag: Main setup script

> import Distribution.Simple
> import Distribution.Simple.Configure
> import Distribution.Setup
> import Distribution.PackageDescription
> import IO
> import System
> import System.Directory

> main = defaultMainWithHooks myUserHooks

> myUserHooks = 
>   defaultUserHooks 
>     { instHook = myInstaller
>     }
> 
> -- myInstaller :: PackageDescription -> LocalBuildInfo -> Int -> Bool -> IO ()
> myInstaller pdesc lbi verbose isUser =
>   do instHook defaultUserHooks pdesc lbi verbose isUser
>      myPostInstaller pdesc (isUser, verbose) lbi
> 
> -- | Build and install the shell script to invoke the Haskell compiler with 
> -- the correct flags
> myPostInstaller :: PackageDescription -> InstallFlags -> LocalBuildInfo -> IO ()
> myPostInstaller pdesc instFlags localBuildInfo =
>   let hc = compiler localBuildInfo
>	bindir = prefix localBuildInfo ++ "/bin"
>	generated = bindir ++ "/washc"
>	pid = showPackageId (package pdesc)
>   in
>   do h <- openFile generated WriteMode
>      hPutStrLn h "#!/bin/sh"
>      hPutStr h (compilerPath hc)
>      hPutStr h " -pgmF "
>      hPutStr h bindir
>      hPutStr h "/wash2hs"
>      hPutStr h " -F -package "
>      hPutStr h pid
>      hPutStrLn h " $@"
>      hClose h
>      perms <- getPermissions generated
>      setPermissions generated perms { executable = True, readable = True }

